/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.io.util;

import java.io.File;
import java.util.ArrayList;
import net.thevpc.nuts.runtime.standalone.xtra.expr.StringTokenizerUtils;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.text.NText;
import net.thevpc.nuts.text.NTextBuilder;
import net.thevpc.nuts.text.NTextStyle;
import net.thevpc.nuts.text.NTexts;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NIllegalArgumentException;
import net.thevpc.nuts.util.NUnsupportedEnumException;

public class NPathParts {
    private final Type type;
    private final String protocol;
    private final String authority;
    private final String location;
    private final String ref;
    private final String query;

    public NPathParts(Type type, String protocol, String authority, String location, String query, String ref) {
        switch (type.ordinal()) {
            case 4: {
                this.type = type;
                this.protocol = NPathParts.ensureNull(protocol, "protocol");
                this.authority = NPathParts.ensureNull(authority, "authority");
                this.location = NPathParts.ensureNull(location, "location");
                this.query = NPathParts.ensureNull(query, "query");
                this.ref = NPathParts.ensureNonNull(ref, "ref");
                break;
            }
            case 1: {
                this.type = type;
                this.protocol = NPathParts.ensureNull(protocol, "protocol");
                this.authority = NPathParts.ensureNull(authority, "authority");
                this.location = NPathParts.ensureNonNull(location, "location");
                this.query = NPathParts.ensureNull(query, "query");
                this.ref = NPathParts.ensureNull(ref, "ref");
                break;
            }
            case 2: {
                if (!"file".equals(protocol)) {
                    throw new IllegalArgumentException("protocol must not be 'file'");
                }
                this.type = type;
                this.protocol = NPathParts.ensureTrimmed(protocol, "protocol");
                this.authority = NPathParts.ensureNull(authority, "authority");
                this.location = NPathParts.ensureNonNull(location, "location");
                this.query = NPathParts.ensureNull(query, "query");
                this.ref = NPathParts.ensureNull(ref, "ref");
                break;
            }
            case 0: {
                this.type = type;
                this.protocol = NPathParts.ensureNull(protocol, "protocol");
                this.authority = NPathParts.ensureNull(authority, "authority");
                this.location = NPathParts.ensureNull(location, "location");
                this.query = NPathParts.ensureNull(query, "query");
                this.ref = NPathParts.ensureNull(ref, "ref");
                break;
            }
            case 3: {
                String p = NPathParts.ensureNonNull(protocol, "protocol");
                if (p.equals("file")) {
                    this.type = Type.FILE_URL;
                    this.protocol = NPathParts.ensureTrimmed(protocol, "protocol");
                    this.authority = NPathParts.ensureNull(authority, "authority");
                    this.location = NPathParts.ensureNonNull(location, "location");
                    this.query = NPathParts.ensureNull(query, "query");
                    this.ref = NPathParts.ensureNull(ref, "ref");
                    break;
                }
                if (p.equals("jar") || p.equals("zip")) {
                    this.type = type;
                    this.protocol = NPathParts.ensureTrimmed(protocol, "protocol");
                    this.authority = NPathParts.ensureNull(authority, "authority");
                    this.location = NPathParts.ensureNonNull(location, "location");
                    this.query = NPathParts.ensureNull(query, "query");
                    this.ref = NPathParts.ensureNull(ref, "ref");
                    break;
                }
                this.type = type;
                this.protocol = p;
                this.authority = NPathParts.ensureOk(authority, "authority");
                this.location = NPathParts.ensureOk(location, "location");
                this.query = NPathParts.ensureOk(query, "query");
                this.ref = NPathParts.ensureOk(ref, "ref");
                break;
            }
            default: {
                throw new NIllegalArgumentException(NMsg.ofPlain("unsupported NutsPathParts"));
            }
        }
    }

    public NPathParts(String path) {
        if (path == null || path.trim().isEmpty()) {
            this.type = Type.EMPTY;
            this.protocol = "";
            this.authority = "";
            this.location = "";
            this.query = "";
            this.ref = "";
        } else {
            boolean wiredProtocol;
            int wiredProtocolIndex = path.indexOf("://");
            int wiredProtocolIndex2 = wiredProtocolIndex > 0 ? wiredProtocolIndex + 3 : -1;
            String protocolToBe = wiredProtocolIndex2 < 0 ? null : path.substring(0, wiredProtocolIndex);
            boolean bl = wiredProtocol = protocolToBe != null && protocolToBe.matches("[a-zA-Z]+");
            if (wiredProtocol) {
                this.type = Type.URL;
                this.protocol = protocolToBe;
                int firstInterr = path.indexOf(63, wiredProtocolIndex2);
                int firstSlash = path.indexOf(47, wiredProtocolIndex2);
                int firstSharp = path.indexOf(35, wiredProtocolIndex2);
                if (firstSharp >= 0 && firstInterr >= 0 && firstInterr > firstSharp) {
                    firstInterr = -1;
                }
                if (firstSlash >= 0) {
                    if (firstInterr >= 0 && firstSlash > firstInterr) {
                        firstSlash = -1;
                    } else if (firstSharp >= 0 && firstSlash > firstSharp) {
                        firstSlash = -1;
                    }
                }
                if (firstSlash >= 0) {
                    this.authority = path.substring(wiredProtocolIndex2, firstSlash);
                    if (firstInterr >= 0) {
                        this.location = path.substring(firstSlash, firstInterr);
                        if (firstSharp >= 0) {
                            this.query = path.substring(firstInterr + 1, firstSharp);
                            this.ref = path.substring(firstSharp + 1);
                        } else {
                            this.query = path.substring(firstInterr + 1);
                            this.ref = "";
                        }
                    } else if (firstSharp >= 0) {
                        this.location = path.substring(firstSlash, firstSharp);
                        this.query = "";
                        this.ref = path.substring(firstSharp + 1);
                    } else {
                        this.location = path.substring(firstSlash);
                        this.query = "";
                        this.ref = "";
                    }
                } else if (firstInterr >= 0) {
                    this.authority = path.substring(wiredProtocolIndex2, firstInterr);
                    this.location = "";
                    if (firstSharp >= 0) {
                        this.query = path.substring(firstInterr + 1, firstSharp);
                        this.ref = path.substring(firstSharp + 1);
                    } else {
                        this.query = path.substring(firstInterr + 1);
                        this.ref = "";
                    }
                } else if (firstSharp >= 0) {
                    this.authority = path.substring(wiredProtocolIndex2, firstSharp);
                    this.location = "";
                    this.query = "";
                    this.ref = path.substring(firstSharp + 1);
                } else {
                    this.authority = path.substring(wiredProtocolIndex2);
                    this.location = "";
                    this.query = "";
                    this.ref = "";
                }
            } else if (path.startsWith("#")) {
                this.type = Type.REF;
                this.protocol = "";
                this.location = "";
                this.authority = "";
                this.query = "";
                this.ref = path.substring(1);
            } else if (path.startsWith("file:")) {
                this.type = Type.FILE_URL;
                this.protocol = path.substring(0, 4);
                this.location = path.substring(5);
                this.authority = "";
                this.query = "";
                this.ref = "";
            } else {
                this.type = Type.FILE;
                this.location = path;
                this.authority = "";
                this.protocol = "";
                this.query = "";
                this.ref = "";
            }
        }
    }

    public static String compressLocalPath(String path) {
        return NPathParts.compressLocalPath(path, 2, 2);
    }

    public static String compressLocalPath(String path, int left, int right) {
        String p = System.getProperty("user.home");
        if (path.startsWith(p + File.separator) || path.startsWith(p + "/") || path.startsWith(p + "\\")) {
            path = "~" + path.substring(p.length());
        }
        ArrayList<String> a = new ArrayList<String>(StringTokenizerUtils.splitFileSlash(path));
        int min = left + right + 1;
        if (a.size() > 0 && ((String)a.get(0)).equals("")) {
            ++left;
            ++min;
        }
        if (a.size() > min) {
            a.add(left, "...");
            int len = a.size() - right - left - 1;
            for (int i = 0; i < len; ++i) {
                a.remove(left + 1);
            }
        }
        return String.join((CharSequence)"/", a);
    }

    public Type getType() {
        return this.type;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getAuthority() {
        return this.authority;
    }

    public String getFile() {
        return this.location;
    }

    public String getName() {
        if (this.location == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(this.location);
        while (sb.length() > 0 && (sb.charAt(sb.length() - 1) == '/' || sb.charAt(sb.length() - 1) == '\\')) {
            sb.delete(sb.length() - 1, sb.length());
        }
        if (sb.length() == 0) {
            return "";
        }
        if (sb.length() == 1) {
            return sb.toString();
        }
        int x = sb.length() - 1;
        while (x - 1 > 0 && sb.charAt(x - 1) != '/' && sb.charAt(x - 1) != '\\') {
            --x;
        }
        return sb.substring(x);
    }

    public String getQuery() {
        return this.query;
    }

    public String getRef() {
        return this.ref;
    }

    public String toString() {
        int len = this.protocol.length() + 1;
        if (this.authority != null && this.authority.length() > 0) {
            len += 2 + this.authority.length();
        }
        if (this.location != null) {
            len += this.location.length();
        }
        if (this.query != null) {
            len += 1 + this.query.length();
        }
        if (this.ref != null) {
            len += 1 + this.ref.length();
        }
        StringBuilder result = new StringBuilder(len);
        result.append(this.protocol);
        result.append(":");
        if (this.authority != null && this.authority.length() > 0) {
            result.append("//");
            result.append(this.authority);
        }
        if (this.location != null) {
            result.append(this.location);
        }
        if (this.query != null) {
            result.append(this.query);
        }
        if (this.ref != null) {
            result.append(this.ref);
        }
        return result.toString();
    }

    public static NText toNutsString(NText protocol, NText authority, NText path, NText query, NText ref) {
        NTexts txt = NTexts.of();
        NTextBuilder result = txt.ofBuilder();
        result.append(protocol);
        if (authority != null && authority.length() > 0) {
            result.append((Object)"://", NTextStyle.path());
            result.append(authority);
        } else {
            result.append((Object)":", NTextStyle.path());
        }
        if (path != null) {
            result.append(path);
        }
        if (query != null) {
            result.append(query);
        }
        if (ref != null) {
            result.append(ref);
        }
        return result.build();
    }

    private static String ensureNonNull(String s, String name) {
        if (s == null || s.trim().length() == 0) {
            throw new IllegalArgumentException(name + " must not be null");
        }
        return s.trim();
    }

    private static String ensureTrimmed(String s, String name) {
        if (s == null) {
            return "";
        }
        return s.trim();
    }

    private static String ensureOk(String s, String name) {
        if (s == null) {
            return "";
        }
        return s.trim();
    }

    private static String ensureNull(String s, String name) {
        if (s != null && s.length() != 0) {
            throw new IllegalArgumentException(name + " must be null or empty");
        }
        return "";
    }

    public static NText compressPath(String path) {
        return NPathParts.compressPath(path, 2, 2);
    }

    public static NText compressPath(String path, int left, int right) {
        NTexts txt = NTexts.of();
        NPathParts p = new NPathParts(path);
        switch (p.getType().ordinal()) {
            case 2: 
            case 3: {
                return NPathParts.toNutsString(txt.ofStyled(p.getProtocol(), NTextStyle.path()), NBlankable.isBlank(p.getAuthority()) ? null : txt.ofStyled(p.getAuthority(), NTextStyle.path()), NBlankable.isBlank(p.getFile()) ? null : txt.ofStyled(NPathParts.compressLocalPath(p.getFile(), 0, 2), NTextStyle.path()), NBlankable.isBlank(p.getQuery()) ? null : txt.ofStyled("...", NTextStyle.path()), NBlankable.isBlank(p.getRef()) ? null : txt.ofStyled("...", NTextStyle.path()));
            }
            case 4: {
                return NBlankable.isBlank(p.getRef()) ? null : txt.ofStyled("...", NTextStyle.path());
            }
            case 1: {
                return txt.ofStyled(NPathParts.compressLocalPath(p.getFile(), 2, 2), NTextStyle.path());
            }
            case 0: {
                return txt.ofBlank();
            }
        }
        throw new NUnsupportedEnumException(p.getType());
    }

    public static enum Type {
        EMPTY,
        FILE,
        FILE_URL,
        URL,
        REF;

    }
}

