/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.io.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.thevpc.nuts.io.NContentMetadata;
import net.thevpc.nuts.io.NContentMetadataProvider;
import net.thevpc.nuts.io.NIOException;
import net.thevpc.nuts.io.NInterruptException;
import net.thevpc.nuts.io.NInterruptible;
import net.thevpc.nuts.runtime.standalone.io.util.CoreIOUtils;
import net.thevpc.nuts.text.NMsg;

public class InputStreamTee
extends InputStream
implements NInterruptible<InputStream>,
NContentMetadataProvider {
    private final InputStream in;
    private final OutputStream out;
    private final Runnable onClose;
    private boolean interrupted;
    private NContentMetadata metadata;

    public InputStreamTee(InputStream in, OutputStream out, Runnable onClose, NContentMetadata metadata) {
        this.in = in;
        this.out = out;
        this.onClose = onClose;
        this.metadata = CoreIOUtils.createContentMetadata(metadata, in);
    }

    @Override
    public InputStream base() {
        return this;
    }

    @Override
    public NContentMetadata getMetaData() {
        return this.metadata;
    }

    @Override
    public void interrupt() throws NInterruptException {
        this.interrupted = true;
    }

    @Override
    public int read() throws IOException {
        this.checkInterrupted();
        int x = this.in.read();
        if (x >= 0) {
            this.out.write(x);
        }
        return x;
    }

    @Override
    public int read(byte[] b) throws IOException {
        this.checkInterrupted();
        int p = this.in.read(b);
        if (p > 0) {
            this.out.write(b, 0, p);
        }
        return p;
    }

    @Override
    public long skip(long n) throws IOException {
        long c = 0L;
        byte[] bytes = new byte[1024];
        while (c < n) {
            this.checkInterrupted();
            int p = this.in.read(bytes, 0, Math.min((int)(n - c), bytes.length));
            if (p <= 0) break;
            this.out.write(bytes, 0, p);
        }
        return c;
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.checkMark();
        super.mark(readlimit);
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public synchronized void reset() throws IOException {
        this.checkMark();
        this.in.reset();
    }

    @Override
    public void close() throws IOException {
        this.in.close();
        this.out.close();
        if (this.onClose != null) {
            this.onClose.run();
        }
    }

    @Override
    public int available() throws IOException {
        this.checkInterrupted();
        return this.in.available();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.checkInterrupted();
        int p = this.in.read(b, off, len);
        if (p > 0) {
            this.out.write(b, off, p);
        }
        return p;
    }

    private void checkInterrupted() {
        if (this.interrupted) {
            throw new NIOException(NMsg.ofPlain("stream is interrupted"));
        }
    }

    private void checkMark() {
        throw new NIOException(NMsg.ofPlain("unsupported mark"));
    }
}

