/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.io.util;

import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import net.thevpc.nuts.runtime.standalone.xtra.digest.NDigestUtils;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.util.NException;
import net.thevpc.nuts.util.NHex;
import net.thevpc.nuts.util.NIllegalArgumentException;

public class CoreSecurityUtils {
    public static final String ENV_KEY_PASSPHRASE = "passphrase";
    public static final String DEFAULT_PASSPHRASE = NHex.fromBytes("It's completely nuts!!".getBytes());
    public String cypherAlgo = "DES/CBC/PKCS5Padding";
    public String digestAlgo = "SHA-256";
    private int hashSize;
    public static final CoreSecurityUtils INSTANCE = new CoreSecurityUtils().detectBestAlgo();

    public CoreSecurityUtils() {
        this.setComplexity(32);
    }

    public CoreSecurityUtils detectBestAlgo() {
        try {
            this.setComplexity(32);
            this.encryptString("a", "a");
            return this;
        }
        catch (Exception exception) {
            try {
                this.setComplexity(16);
                this.encryptString("a", "a");
                return this;
            }
            catch (Exception exception2) {
                this.encryptString("a", "a");
                return this;
            }
        }
    }

    private void setComplexity(int c) {
        switch (c) {
            case 16: {
                this.hashSize = 16;
                this.cypherAlgo = "AES/ECB/PKCS5Padding";
                this.digestAlgo = "MD5";
                return;
            }
            case 32: {
                this.hashSize = 32;
                this.cypherAlgo = "AES/ECB/PKCS5Padding";
                this.digestAlgo = "SHA-256";
                return;
            }
        }
        throw new IllegalArgumentException("invalid complexity ");
    }

    public char[] defaultDecryptChars(char[] data, String passphrase) {
        return this.decryptString(new String(data), passphrase).toCharArray();
    }

    public char[] defaultEncryptChars(char[] data, String passphrase) {
        return this.encryptString(new String(data), passphrase).toCharArray();
    }

    public char[] defaultHashChars(char[] data, String passphrase) {
        return this.defaultEncryptChars(NDigestUtils.evalSHA1(data), passphrase);
    }

    private String encryptString(String strToEncrypt, String secret) {
        try {
            byte[] bytes = strToEncrypt.getBytes(StandardCharsets.UTF_8);
            int v = bytes.length;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            out.write(v >>> 24 & 0xFF);
            out.write(v >>> 16 & 0xFF);
            out.write(v >>> 8 & 0xFF);
            out.write(v >>> 0 & 0xFF);
            out.write(bytes);
            int s = v + 4;
            while (s % 16 != 0) {
                out.write(0);
                ++s;
            }
            bytes = out.toByteArray();
            KeyInfo k = this.createKeyInfo(secret);
            Cipher cipher = Cipher.getInstance(this.cypherAlgo);
            cipher.init(1, k.secretKey);
            return Base64.getEncoder().encodeToString(cipher.doFinal(bytes));
        }
        catch (NException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new NIllegalArgumentException(NMsg.ofPlain("encryption failed"), (Throwable)ex);
        }
    }

    private String decryptString(String strToDecrypt, String secret) {
        try {
            KeyInfo k = this.createKeyInfo(secret);
            Cipher cipher = Cipher.getInstance(this.cypherAlgo);
            cipher.init(2, k.secretKey);
            byte[] bytes = cipher.doFinal(Base64.getDecoder().decode(strToDecrypt));
            int ch1 = bytes[0] & 0xFF;
            int ch2 = bytes[1] & 0xFF;
            int ch3 = bytes[2] & 0xFF;
            int ch4 = bytes[3] & 0xFF;
            if ((ch1 | ch2 | ch3 | ch4) < 0) {
                throw new EOFException();
            }
            int v = (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + (ch4 << 0);
            bytes = Arrays.copyOfRange(bytes, 4, 4 + v);
            return new String(bytes);
        }
        catch (NException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new NIllegalArgumentException(NMsg.ofPlain("decryption failed"), (Throwable)ex);
        }
    }

    private KeyInfo createKeyInfo(String password) {
        if (password == null || password.length() == 0) {
            password = "password";
        }
        MessageDigest sha = null;
        KeyInfo k = new KeyInfo();
        try {
            k.key = password.getBytes(StandardCharsets.UTF_8);
            sha = MessageDigest.getInstance(this.digestAlgo);
            k.key = sha.digest(k.key);
            k.secretKey = new SecretKeySpec(k.key, "AES");
        }
        catch (NoSuchAlgorithmException ex) {
            throw new NIllegalArgumentException(NMsg.ofPlain("encryption key building failed"), (Throwable)ex);
        }
        return k;
    }

    private static class KeyInfo {
        SecretKeySpec secretKey;
        byte[] key;

        private KeyInfo() {
        }
    }
}

