/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.io.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.thevpc.nuts.io.NIOException;
import net.thevpc.nuts.io.NIOUtils;
import net.thevpc.nuts.io.NInputSource;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NHex;
import net.thevpc.nuts.util.NStream;

public abstract class AbstractNInputSource
implements NInputSource {
    @Override
    public String getName() {
        return this.getMetaData().getName().orNull();
    }

    @Override
    public String getContentType() {
        return this.getMetaData().getContentType().orNull();
    }

    @Override
    public String getCharset() {
        return this.getMetaData().getCharset().orNull();
    }

    @Override
    public NStream<String> lines() {
        return this.lines(null);
    }

    @Override
    public String readString() {
        return new String(this.readBytes());
    }

    @Override
    public byte[] readBytes() {
        byte[] byArray;
        block8: {
            InputStream in = this.getInputStream();
            try {
                byArray = NIOUtils.readBytes(in);
                if (in == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new NIOException(e);
                }
            }
            in.close();
        }
        return byArray;
    }

    @Override
    public BufferedReader getBufferedReader() {
        return this.getBufferedReader(null);
    }

    @Override
    public BufferedReader getBufferedReader(Charset cs) {
        Reader r = this.getReader(cs);
        if (r instanceof BufferedReader) {
            return (BufferedReader)r;
        }
        return new BufferedReader(r);
    }

    @Override
    public List<String> tail(int count, Charset cs) {
        try (NStream<String> rl = this.reversedLines();){
            List<String> list = rl.limit(count).collect(Collectors.toList());
            Collections.reverse(list);
            List<String> list2 = list;
            return list2;
        }
    }

    @Override
    public List<String> head(int count) {
        return this.head(count, null);
    }

    @Override
    public List<String> head(int count, Charset cs) {
        return this.lines(cs).limit(count).collect(Collectors.toList());
    }

    @Override
    public List<String> tail(int count) {
        return this.tail(count, null);
    }

    @Override
    public NStream<String> reversedLines() {
        return this.reversedLines(null);
    }

    @Override
    public NStream<String> reversedLines(Charset cs) {
        NStream<String> s = this.lines(cs);
        List list = s.collect(Collectors.toCollection(ArrayList::new));
        Collections.reverse(list);
        return NStream.ofStream(list.stream());
    }

    @Override
    public NStream<String> lines(Charset cs) {
        BufferedReader br = this.getBufferedReader(cs);
        try {
            return NStream.ofStream((Stream)br.lines().onClose(() -> {
                try {
                    br.close();
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }));
        }
        catch (Error | RuntimeException e) {
            try {
                br.close();
            }
            catch (IOException ex) {
                try {
                    e.addSuppressed(ex);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            throw e;
        }
    }

    @Override
    public Reader getReader() {
        return this.getReader(null);
    }

    @Override
    public Reader getReader(Charset cs) {
        CharsetDecoder decoder = this.nonNullCharset(cs).newDecoder();
        InputStreamReader reader = new InputStreamReader(this.getInputStream(), decoder);
        return new BufferedReader(reader);
    }

    protected Charset nonNullCharset(Charset c) {
        if (c == null) {
            return StandardCharsets.UTF_8;
        }
        return c;
    }

    @Override
    public String getDigestString() {
        return NHex.fromBytes(this.getDigest());
    }

    @Override
    public String getDigestString(String algo) {
        return NHex.fromBytes(this.getDigest(algo));
    }

    @Override
    public byte[] getDigest() {
        return this.getDigest(null);
    }

    @Override
    public byte[] getDigest(String algo) {
        byte[] byArray;
        block14: {
            if (NBlankable.isBlank(algo)) {
                algo = "SHA-1";
            }
            InputStream input = this.getInputStream();
            try {
                MessageDigest sha1 = null;
                try {
                    sha1 = MessageDigest.getInstance(algo);
                }
                catch (NoSuchAlgorithmException ex) {
                    throw new NIOException(ex);
                }
                byte[] buffer = new byte[8192];
                int len = 0;
                try {
                    len = input.read(buffer);
                    while (len != -1) {
                        sha1.update(buffer, 0, len);
                        len = input.read(buffer);
                    }
                }
                catch (IOException e) {
                    throw new NIOException(e);
                }
                byArray = sha1.digest();
                if (input == null) break block14;
            }
            catch (Throwable throwable) {
                try {
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new NIOException(e);
                }
            }
            input.close();
        }
        return byArray;
    }
}

