/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.io.urlpart;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.function.Predicate;
import net.thevpc.nuts.io.NIOException;
import net.thevpc.nuts.io.NIOUtils;
import net.thevpc.nuts.runtime.standalone.io.urlpart.URLPart;
import net.thevpc.nuts.runtime.standalone.io.urlpart.URLPartHelper;
import net.thevpc.nuts.runtime.standalone.io.urlpart.URLPartJar;
import net.thevpc.nuts.runtime.standalone.io.util.CoreIOUtils;
import net.thevpc.nuts.runtime.standalone.io.util.ZipUtils;
import net.thevpc.nuts.runtime.standalone.xtra.web.DefaultNWebCli;
import net.thevpc.nuts.text.NVisitResult;

class URLPartSpringJarNested
extends URLPart {
    private URLPart base0;
    private String base1;

    public URLPartSpringJarNested(String path, URL obj, URLPart base0, String base1) {
        super(null, URLPart.Type.FS_FILE, !path.startsWith("/") ? "/" + path : path, obj);
        this.base0 = base0;
        this.base1 = base1;
    }

    @Override
    public URLPart rootSibling(String path) {
        if (path.startsWith("/META-INF/") || path.equals("/META-INF")) {
            return new URLPartJar(path, null, this.base0);
        }
        if (path.startsWith("META-INF/") || path.equals("META-INF")) {
            return new URLPartJar(path, null, this.base0);
        }
        return new URLPartSpringJarNested(path, null, this.base0, path.substring(1));
    }

    @Override
    public InputStream getInputStream() {
        ArrayList found = new ArrayList();
        if (this.obj instanceof URL) {
            try {
                return DefaultNWebCli.prepareGlobalOpenStream((URL)this.obj);
            }
            catch (IOException e) {
                throw new NIOException(e);
            }
        }
        URLPart pp = this.base0;
        String path1 = CoreIOUtils.concatPath(this.base1, this.path);
        ZipUtils.visitZipStream(pp.getInputStream(), (path, inputStream) -> {
            if (path.equals(path1)) {
                found.add(new ByteArrayInputStream(NIOUtils.readBytes(inputStream)));
                return NVisitResult.TERMINATE;
            }
            return NVisitResult.CONTINUE;
        });
        if (found.isEmpty()) {
            return null;
        }
        return (InputStream)found.get(0);
    }

    @Override
    public URLPart[] getChildren(boolean includeFolders, boolean deep, Predicate<URLPart> filter) {
        URLPart[] uRLPartArray;
        block8: {
            InputStream is = this.base0.getInputStream();
            try {
                uRLPartArray = URLPartHelper.searchStream(is, s -> {
                    if (s.startsWith(this.base1 + "/")) {
                        URLPartSpringJarNested urlPartSpringJarNested = new URLPartSpringJarNested(s.substring(this.base1.length()), null, this.base0, this.base1);
                        InputStream inputStream = urlPartSpringJarNested.getInputStream();
                        if (inputStream == null) {
                            inputStream = urlPartSpringJarNested.getInputStream();
                            throw new IllegalArgumentException("Error");
                        }
                        return urlPartSpringJarNested;
                    }
                    return null;
                }, includeFolders, deep, filter);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new NIOException(e);
                }
            }
            is.close();
        }
        return uRLPartArray;
    }

    @Override
    public String toString() {
        return "jar:nested:" + this.base0 + "!" + this.base1 + "!" + this.path;
    }
}

