/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.io.urlpart;

import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Paths;
import java.util.function.Predicate;
import net.thevpc.nuts.runtime.standalone.io.path.spi.URLPath;
import net.thevpc.nuts.runtime.standalone.io.urlpart.URLPartFile;
import net.thevpc.nuts.runtime.standalone.io.urlpart.URLPartJar;
import net.thevpc.nuts.runtime.standalone.io.urlpart.URLPartSpringJarNested;
import net.thevpc.nuts.runtime.standalone.io.urlpart.URLPartWeb;
import net.thevpc.nuts.runtime.standalone.io.util.CoreIOUtils;
import net.thevpc.nuts.util.NOptional;

public abstract class URLPart {
    protected URLPart parent;
    protected Type type;
    protected String path;
    protected Object obj;

    public static URLPart of(URL r) {
        return URLPart.of(r.toString(), r);
    }

    public static URLPart of(File r) {
        return new URLPartFile(null, r.getPath(), r);
    }

    public static URLPart of(String r) {
        return URLPart.of(r, r);
    }

    public static URLPart of(String r, Object obj) {
        if (r.startsWith("file:")) {
            try {
                File file = Paths.get(new URI(r)).toFile();
                return new URLPartFile(null, file.getPath(), file);
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
        if (r.startsWith("http:") || r.startsWith("https:") || r.startsWith("ftp:")) {
            return new URLPartWeb(null, r, obj);
        }
        if (r.startsWith("jar:nested:")) {
            int x;
            String r2 = r.substring("jar:nested:".length());
            String j = r2.substring(0, x = r2.indexOf(33));
            if (j.endsWith("/")) {
                j = j.substring(0, j.length() - 1);
            }
            String base0 = j;
            j = r2.substring(x + 1);
            if (j.startsWith("BOOT-INF/classes/!/")) {
                return new URLPartSpringJarNested(j.substring("BOOT-INF/classes/!/".length()), obj instanceof URL ? (URL)obj : null, URLPart.of(base0), "BOOT-INF/classes");
            }
            return new URLPartJar(j, obj, URLPart.of(base0));
        }
        if (r.startsWith("jar:")) {
            String r2 = r.substring(4);
            int x = r2.indexOf(33);
            return new URLPartJar(r2.substring(x + 1), obj, URLPart.of(r2.substring(0, x)));
        }
        if (r.startsWith("/") || r.length() >= 2 && Character.isAlphabetic(r.charAt(0)) && r.charAt(1) == ':') {
            return new URLPartFile(null, r, new File(r));
        }
        throw new UnsupportedOperationException("unsupported protocol " + r);
    }

    public URLPart(URLPart parent, Type type, String path, Object obj) {
        this.type = type;
        this.path = path;
        this.parent = parent;
        this.obj = obj;
    }

    public int len() {
        if (this.parent == null) {
            return 1;
        }
        return 1 + this.parent.len();
    }

    public URLPart root() {
        if (this.parent == null) {
            return null;
        }
        if (this.parent.parent == null) {
            return this.parent;
        }
        return this.parent.root();
    }

    public abstract URLPart rootSibling(String var1);

    public URLPart parent() {
        return this.parent;
    }

    public String getName() {
        String n = this.path;
        int p = n.replace('\\', '/').lastIndexOf(47);
        if (p > 0) {
            n = this.path.substring(p + 1);
        }
        return n;
    }

    public Type getType() {
        return this.type;
    }

    public NOptional<File> getFile() {
        block7: {
            String path = this.getPath();
            if (this.getType() == Type.FS_FILE) {
                return NOptional.of(new File(path));
            }
            if (this.getType() != Type.URL_FILE) break block7;
            try {
                if (path.startsWith("file:")) {
                    return NOptional.of(URLPath._toFile(CoreIOUtils.urlOf(path)));
                }
                return NOptional.of(new File(path));
            }
            catch (Exception e) {
                try {
                    return NOptional.ofNamedEmpty("Not a file " + this);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return NOptional.ofNamedEmpty("Not a file " + this);
    }

    public String getPath() {
        return this.path;
    }

    public String toString() {
        return "URLPart{type=" + (Object)((Object)this.type) + ", path=" + this.path + '}';
    }

    public abstract URLPart[] getChildren(boolean var1, boolean var2, Predicate<URLPart> var3);

    public abstract InputStream getInputStream();

    public static enum Type {
        WEB,
        FS_FILE,
        URL_FILE,
        URL,
        JAR,
        SUB_PATH;

    }
}

