/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.io.terminal;

import java.io.InputStream;
import java.util.Scanner;
import net.thevpc.nuts.boot.NWorkspaceTerminalOptions;
import net.thevpc.nuts.cmdline.NCmdLineAutoCompleteResolver;
import net.thevpc.nuts.cmdline.NCmdLineHistory;
import net.thevpc.nuts.core.NBootOptions;
import net.thevpc.nuts.io.NAnsiTermHelper;
import net.thevpc.nuts.io.NIO;
import net.thevpc.nuts.io.NPrintStream;
import net.thevpc.nuts.io.NTerminalMode;
import net.thevpc.nuts.io.NonClosableInputStream;
import net.thevpc.nuts.io.NonClosablePrintStream;
import net.thevpc.nuts.runtime.standalone.boot.DefaultNBootModel;
import net.thevpc.nuts.runtime.standalone.io.printstream.NPrintStreamSystem;
import net.thevpc.nuts.spi.NComponentScope;
import net.thevpc.nuts.spi.NScopeType;
import net.thevpc.nuts.spi.NSystemTerminalBase;
import net.thevpc.nuts.spi.NSystemTerminalBaseImpl;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.text.NTerminalCmd;
import net.thevpc.nuts.text.NTextStyles;
import net.thevpc.nuts.util.NScorableContext;

@NComponentScope(value=NScopeType.PROTOTYPE)
public class DefaultNSystemTerminalBaseBoot
extends NSystemTerminalBaseImpl {
    private final Scanner scanner;
    private final NPrintStream out;
    private final NPrintStream err;
    private final InputStream in;
    private NCmdLineHistory history;
    private String commandHighlighter;
    private NCmdLineAutoCompleteResolver commandAutoCompleteResolver;

    public DefaultNSystemTerminalBaseBoot(DefaultNBootModel bootModel) {
        NBootOptions bo = bootModel.getBootUserOptions();
        NWorkspaceTerminalOptions bootStdFd = new NWorkspaceTerminalOptions(new NonClosableInputStream(bo.getStdin().orElse(System.in)), new NonClosablePrintStream(bo.getStdout().orElse(System.out)), new NonClosablePrintStream(bo.getStderr().orElse(System.err)), bootModel.getBootTerminal().getFlags().toArray(new String[0]));
        NTerminalMode terminalMode = bootModel.getBootUserOptions().getTerminalMode().orElse(NTerminalMode.DEFAULT);
        boolean bootStdFdAnsi = bootStdFd.getFlags().contains("ansi");
        if (terminalMode == NTerminalMode.DEFAULT) {
            terminalMode = bootModel.getBootUserOptions().getBot().orElse(false).booleanValue() ? NTerminalMode.FILTERED : (bootStdFdAnsi ? NTerminalMode.FORMATTED : NTerminalMode.FILTERED);
        } else if (terminalMode == NTerminalMode.ANSI) {
            terminalMode = NTerminalMode.FORMATTED;
        }
        this.out = new NPrintStreamSystem(bootStdFd.getOut(), null, null, bootStdFdAnsi, this).setTerminalMode(terminalMode);
        this.err = new NPrintStreamSystem(bootStdFd.getErr(), null, null, bootStdFdAnsi, this).setTerminalMode(terminalMode);
        this.in = bootStdFd.getIn();
        this.scanner = new Scanner(this.in);
    }

    @Override
    public int getScore(NScorableContext criteria) {
        return 10;
    }

    @Override
    public String readLine(NPrintStream out, NMsg message) {
        if (out == null) {
            out = this.getOut();
        }
        if (out == null) {
            out = NIO.of().stdout();
        }
        if (message != null) {
            out.print(message);
            out.flush();
        }
        return this.scanner.nextLine();
    }

    @Override
    public char[] readPassword(NPrintStream out, NMsg message) {
        if (out == null) {
            out = this.getOut();
        }
        if (out == null) {
            out = NIO.of().stdout();
        }
        if (message != null) {
            out.print(message);
            out.flush();
        }
        return this.scanner.nextLine().toCharArray();
    }

    @Override
    public InputStream getIn() {
        return this.in;
    }

    @Override
    public NPrintStream getOut() {
        return this.out;
    }

    @Override
    public NPrintStream getErr() {
        return this.err;
    }

    @Override
    public NCmdLineAutoCompleteResolver getAutoCompleteResolver() {
        return this.commandAutoCompleteResolver;
    }

    @Override
    public boolean isAutoCompleteSupported() {
        return false;
    }

    @Override
    public NSystemTerminalBase setCommandAutoCompleteResolver(NCmdLineAutoCompleteResolver autoCompleteResolver) {
        this.commandAutoCompleteResolver = autoCompleteResolver;
        return this;
    }

    @Override
    public NCmdLineHistory getCommandHistory() {
        return this.history;
    }

    @Override
    public NSystemTerminalBase setCommandHistory(NCmdLineHistory history) {
        this.history = history;
        return this;
    }

    @Override
    public String getCommandHighlighter() {
        return this.commandHighlighter;
    }

    @Override
    public NSystemTerminalBase setCommandHighlighter(String commandHighlighter) {
        this.commandHighlighter = commandHighlighter;
        return this;
    }

    @Override
    public Object run(NTerminalCmd command, NPrintStream printStream) {
        return null;
    }

    @Override
    public NSystemTerminalBase.Cursor getTerminalCursor() {
        return (NSystemTerminalBase.Cursor)this.run(NTerminalCmd.GET_CURSOR, this.getOut());
    }

    @Override
    public NSystemTerminalBase.Size getTerminalSize() {
        return (NSystemTerminalBase.Size)this.run(NTerminalCmd.GET_SIZE, this.getOut());
    }

    @Override
    public void setStyles(NTextStyles styles, NPrintStream printStream) {
        String s = NAnsiTermHelper.of().styled(styles);
        if (s != null) {
            byte[] bytes = s.getBytes();
            printStream.writeRaw(bytes, 0, bytes.length);
        }
    }
}

