/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.io.terminal;

import java.io.InputStream;
import net.thevpc.nuts.cmdline.NCmdLineAutoCompleteResolver;
import net.thevpc.nuts.cmdline.NCmdLineHistory;
import net.thevpc.nuts.core.NSession;
import net.thevpc.nuts.io.NPrintStream;
import net.thevpc.nuts.io.NSystemTerminal;
import net.thevpc.nuts.runtime.standalone.xtra.time.CProgressBar;
import net.thevpc.nuts.spi.NSystemTerminalBase;
import net.thevpc.nuts.spi.NSystemTerminalBaseImpl;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.text.NTerminalCmd;
import net.thevpc.nuts.text.NText;
import net.thevpc.nuts.text.NTextStyles;
import net.thevpc.nuts.util.NScorableContext;

public abstract class AbstractSystemTerminalAdapter
extends NSystemTerminalBaseImpl
implements NSystemTerminal {
    protected CProgressBar progressBar;
    private String commandHighlighter;

    @Override
    public NCmdLineAutoCompleteResolver getAutoCompleteResolver() {
        NSystemTerminalBase p = this.getBase();
        if (p != null) {
            return p.getAutoCompleteResolver();
        }
        return null;
    }

    @Override
    public boolean isAutoCompleteSupported() {
        return this.getBase().isAutoCompleteSupported();
    }

    @Override
    public NSystemTerminalBase setCommandAutoCompleteResolver(NCmdLineAutoCompleteResolver autoCompleteResolver) {
        NSystemTerminalBase p = this.getBase();
        if (p != null) {
            p.setCommandAutoCompleteResolver(autoCompleteResolver);
        }
        return this;
    }

    @Override
    public NSystemTerminalBase setCommandHistory(NCmdLineHistory history) {
        this.getBase().setCommandHistory(history);
        return this;
    }

    @Override
    public NCmdLineHistory getCommandHistory() {
        return this.getBase().getCommandHistory();
    }

    @Override
    public String readLine(NMsg message) {
        NSystemTerminalBase p = this.getBase();
        if (p instanceof NSystemTerminal) {
            return ((NSystemTerminal)p).readLine(message);
        }
        return this.getBase().readLine(this.out(), message);
    }

    @Override
    public char[] readPassword(NMsg message) {
        NSystemTerminalBase p = this.getBase();
        if (p instanceof NSystemTerminal) {
            return ((NSystemTerminal)p).readPassword(message);
        }
        return p.readPassword(this.out(), message);
    }

    @Override
    public InputStream in() {
        return this.getIn();
    }

    @Override
    public NPrintStream out() {
        return this.getOut();
    }

    @Override
    public NPrintStream err() {
        return this.getErr();
    }

    @Override
    public NSystemTerminal printProgress(float progress, NMsg message) {
        NSession session = NSession.of();
        if (session.isProgress()) {
            if (this.getBase() instanceof NSystemTerminal) {
                ((NSystemTerminal)this.getBase()).printProgress(progress, message);
            } else {
                this.getProgressBar().printProgress(Float.isNaN(progress) ? -1 : (int)(progress * 100.0f), NText.of(message), this.err());
            }
        }
        return this;
    }

    private CProgressBar getProgressBar() {
        if (this.progressBar == null) {
            this.progressBar = CProgressBar.of();
        }
        return this.progressBar;
    }

    @Override
    public int getScore(NScorableContext criteria) {
        return 10;
    }

    @Override
    public String readLine(NPrintStream out, NMsg message) {
        return this.getBase().readLine(out, message);
    }

    @Override
    public char[] readPassword(NPrintStream out, NMsg message) {
        return this.getBase().readPassword(out, message);
    }

    @Override
    public InputStream getIn() {
        return this.getBase().getIn();
    }

    @Override
    public NPrintStream getOut() {
        return this.getBase().getOut();
    }

    @Override
    public NPrintStream getErr() {
        return this.getBase().getErr();
    }

    @Override
    public abstract NSystemTerminalBase getBase();

    @Override
    public String getCommandHighlighter() {
        return this.commandHighlighter;
    }

    @Override
    public NSystemTerminal setCommandHighlighter(String commandHighlighter) {
        this.commandHighlighter = commandHighlighter;
        return this;
    }

    @Override
    public Object run(NTerminalCmd command, NPrintStream printStream) {
        return this.getBase().run(command, printStream);
    }

    @Override
    public void setStyles(NTextStyles styles, NPrintStream printStream) {
        this.getBase().setStyles(styles, printStream);
    }
}

