/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.io.printstream;

import net.thevpc.nuts.io.NPrintStream;
import net.thevpc.nuts.io.NTerminalMode;
import net.thevpc.nuts.runtime.standalone.io.printstream.NPrintStreamBase;
import net.thevpc.nuts.runtime.standalone.io.printstream.NPrintStreamFiltered;
import net.thevpc.nuts.runtime.standalone.text.FormatOutputStreamSupport;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.text.NText;
import net.thevpc.nuts.text.NTextStyled;
import net.thevpc.nuts.util.NIllegalArgumentException;

public abstract class NPrintStreamRendered
extends NPrintStreamBase {
    protected FormatOutputStreamSupport support;
    protected NPrintStreamBase base;

    public NPrintStreamRendered(NPrintStreamBase base, NTerminalMode mode, NPrintStreamBase.Bindings bindings) {
        super(true, mode, bindings, base.getTerminal());
        this.base = base;
        this.support = new FormatOutputStreamSupport(base, base.getTerminal(), mode != NTerminalMode.ANSI && mode != NTerminalMode.FORMATTED);
    }

    public NPrintStreamBase getBase() {
        return this.base;
    }

    @Override
    public NPrintStream writeRaw(byte[] buf, int off, int len) {
        this.support.writeRaw(buf, off, len);
        return this;
    }

    @Override
    public NPrintStream flush() {
        this.support.flush();
        this.base.flush();
        return this;
    }

    @Override
    public void close() {
        this.flush();
        this.base.close();
    }

    @Override
    public NPrintStream write(int b) {
        this.support.processByte(b);
        return this;
    }

    @Override
    public NPrintStream write(byte[] buf, int off, int len) {
        this.support.processBytes(buf, off, len);
        return this;
    }

    @Override
    public NPrintStream write(char[] buf, int off, int len) {
        this.support.processChars(buf, off, len);
        return this;
    }

    @Override
    protected NPrintStream printParsed(NText b) {
        if (this.isNtf()) {
            this.support.pushNode(b);
        } else {
            switch (b.type()) {
                case PLAIN: {
                    this.support.pushNode(b);
                    break;
                }
                case COMMAND: {
                    break;
                }
                case STYLED: {
                    this.printParsed(((NTextStyled)b).getChild());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("not supported");
                }
            }
        }
        return this;
    }

    @Override
    protected NPrintStream convertImpl(NTerminalMode other) {
        switch (other) {
            case FILTERED: {
                return new NPrintStreamFiltered(this.base, this.bindings);
            }
        }
        throw new NIllegalArgumentException(NMsg.ofC("unsupported %s -> %s", this.getTerminalMode(), other));
    }
}

