/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.io.printstream;

import java.io.OutputStream;
import net.thevpc.nuts.io.NPrintStream;
import net.thevpc.nuts.io.NTerminalMode;
import net.thevpc.nuts.runtime.standalone.io.printstream.NPrintStreamBase;
import net.thevpc.nuts.runtime.standalone.io.printstream.NPrintStreamFiltered;
import net.thevpc.nuts.runtime.standalone.io.printstream.NPrintStreamRendered;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.text.NTerminalCmd;
import net.thevpc.nuts.text.NText;
import net.thevpc.nuts.util.NIllegalArgumentException;

public class NPrintStreamFormatted
extends NPrintStreamRendered {
    public NPrintStreamFormatted(NPrintStreamBase base, NPrintStreamBase.Bindings bindings) {
        super(base, NTerminalMode.FORMATTED, bindings);
        this.getMetaData().setMessage(NMsg.ofStyledPath("<formatted-stream>"));
    }

    @Override
    protected NPrintStream convertImpl(NTerminalMode other) {
        switch (other) {
            case FILTERED: {
                return new NPrintStreamFiltered(this.base, this.bindings);
            }
        }
        throw new NIllegalArgumentException(NMsg.ofC("unsupported %s -> %s", this.getTerminalMode(), other));
    }

    @Override
    public NPrintStream run(NTerminalCmd command) {
        this.flush();
        this.print(NText.ofCommand(command));
        this.flush();
        return this;
    }

    @Override
    public OutputStream getOutputStream() {
        return this.asOutputStream();
    }
}

