/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.io.printstream;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import net.thevpc.nuts.core.NWorkspace;
import net.thevpc.nuts.io.NContentMetadata;
import net.thevpc.nuts.io.NInputSource;
import net.thevpc.nuts.io.NMemoryPrintStream;
import net.thevpc.nuts.io.NPrintStream;
import net.thevpc.nuts.io.NTerminalMode;
import net.thevpc.nuts.runtime.standalone.io.printstream.NPrintStreamBase;
import net.thevpc.nuts.runtime.standalone.io.printstream.NPrintStreamRaw;
import net.thevpc.nuts.runtime.standalone.io.util.AbstractMultiReadNInputSource;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.text.NText;
import net.thevpc.nuts.text.NTextTransformConfig;
import net.thevpc.nuts.util.NAssert;

public class NByteArrayPrintStream
extends NPrintStreamRaw
implements NMemoryPrintStream {
    private static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;

    public NByteArrayPrintStream(NTerminalMode mode, NWorkspace workspace) {
        super(new ByteArrayOutputStream2(), mode, null, null, new NPrintStreamBase.Bindings(), null);
        this.getMetaData().setMessage(NMsg.ofNtf(NText.ofStyledPath("<memory-buffer>")));
    }

    protected NByteArrayPrintStream(NTerminalMode mode, ByteArrayOutputStream2 bos, NWorkspace workspace) {
        super(bos, mode, null, null, new NPrintStreamBase.Bindings(), null);
        this.getMetaData().setMessage(NMsg.ofNtf(NText.ofStyledPath("<memory-buffer>")));
    }

    @Override
    protected NPrintStream printParsed(NText b) {
        switch (this.getTerminalMode()) {
            case FILTERED: {
                NText transformed = this.txt().transform(b, new NTextTransformConfig().setFiltered(true).setNormalize(true).setFlatten(true));
                this.print(transformed.toString());
                return this;
            }
        }
        this.print(b.toString());
        return this;
    }

    @Override
    public byte[] getBytes() {
        this.flush();
        return this.out2().toByteArray();
    }

    private ByteArrayOutputStream2 out2() {
        return (ByteArrayOutputStream2)this.out;
    }

    @Override
    public String toString() {
        this.flush();
        return this.out2().toString();
    }

    @Override
    public OutputStream getOutputStream() {
        return this.asOutputStream();
    }

    @Override
    public NInputSource asInputSource() {
        return new MyAbstractMultiReadNInputSource(this);
    }

    private static int hugeCapacity(int minCapacity) {
        if (minCapacity < 0) {
            throw new OutOfMemoryError();
        }
        return minCapacity > 0x7FFFFFF7 ? Integer.MAX_VALUE : 0x7FFFFFF7;
    }

    public static class ByteArrayOutputStream2
    extends OutputStream {
        protected byte[] buf;
        protected int count;

        public ByteArrayOutputStream2() {
            this(32);
        }

        public ByteArrayOutputStream2(int size) {
            if (size < 0) {
                throw new IllegalArgumentException("Negative initial size: " + size);
            }
            this.buf = new byte[size];
        }

        public InputStream asInputStream() {
            return new InputStreamFromByteArrayOutputStream2(this);
        }

        private void ensureCapacity(int minCapacity) {
            if (minCapacity - this.buf.length > 0) {
                this.grow(minCapacity);
            }
        }

        private void grow(int minCapacity) {
            int oldCapacity = this.buf.length;
            int newCapacity = oldCapacity << 1;
            if (newCapacity - minCapacity < 0) {
                newCapacity = minCapacity;
            }
            if (newCapacity - 0x7FFFFFF7 > 0) {
                newCapacity = NByteArrayPrintStream.hugeCapacity(minCapacity);
            }
            this.buf = Arrays.copyOf(this.buf, newCapacity);
        }

        @Override
        public synchronized void write(int b) {
            this.ensureCapacity(this.count + 1);
            this.buf[this.count] = (byte)b;
            ++this.count;
        }

        @Override
        public synchronized void write(byte[] b, int off, int len) {
            if (off < 0 || off > b.length || len < 0 || off + len - b.length > 0) {
                throw new IndexOutOfBoundsException();
            }
            this.ensureCapacity(this.count + len);
            System.arraycopy(b, off, this.buf, this.count, len);
            this.count += len;
        }

        public synchronized void writeTo(OutputStream out) throws IOException {
            out.write(this.buf, 0, this.count);
        }

        public synchronized void reset() {
            this.count = 0;
        }

        public synchronized byte[] toByteArray() {
            return Arrays.copyOf(this.buf, this.count);
        }

        public synchronized int size() {
            return this.count;
        }

        public synchronized String toString() {
            return new String(this.buf, 0, this.count);
        }

        public synchronized String toString(String charsetName) throws UnsupportedEncodingException {
            return new String(this.buf, 0, this.count, charsetName);
        }

        @Override
        public void close() {
        }

        public synchronized int available(int from) {
            int i = this.count - from;
            return i >= 0 ? i : 0;
        }

        public synchronized int read(int pointer) {
            if (pointer >= 0 && pointer < this.count) {
                return this.buf[pointer];
            }
            return -1;
        }

        public synchronized int read(byte[] buffer, int off, int len, int pointer) {
            NAssert.requireNonNull(buffer, "buffer");
            if (off < 0 || len < 0 || len > buffer.length - off) {
                throw new IndexOutOfBoundsException();
            }
            if (pointer >= this.count) {
                return -1;
            }
            int avail = this.count - pointer;
            if (len > avail) {
                len = avail;
            }
            if (len <= 0) {
                return 0;
            }
            System.arraycopy(this.buf, pointer, buffer, off, len);
            return len;
        }
    }

    public static class MyAbstractMultiReadNInputSource
    extends AbstractMultiReadNInputSource {
        private NByteArrayPrintStream value;

        public MyAbstractMultiReadNInputSource(NByteArrayPrintStream value) {
            this.value = value;
        }

        public NByteArrayPrintStream getValue() {
            return this.value;
        }

        @Override
        public InputStream getInputStream() {
            return this.value.out2().asInputStream();
        }

        @Override
        public NContentMetadata getMetaData() {
            return this.value.getMetaData();
        }

        @Override
        public boolean isKnownContentLength() {
            return true;
        }

        @Override
        public long getContentLength() {
            return this.value.out2().size();
        }
    }

    public static class InputStreamFromByteArrayOutputStream2
    extends InputStream {
        protected ByteArrayOutputStream2 buf;
        protected int pos;
        protected int mark = 0;

        public InputStreamFromByteArrayOutputStream2(ByteArrayOutputStream2 buf) {
            this.buf = buf;
            this.pos = 0;
        }

        @Override
        public synchronized int read() {
            if (this.pos < this.buf.size()) {
                return this.buf.read(this.pos++) & 0xFF;
            }
            return -1;
        }

        @Override
        public synchronized int read(byte[] b, int off, int len) {
            int r = this.buf.read(b, off, len, this.pos);
            if (r > 0) {
                this.pos += r;
            }
            return r;
        }

        @Override
        public synchronized long skip(long n) {
            int count = this.buf.size();
            long k = count - this.pos;
            if (n < k) {
                k = n < 0L ? 0L : n;
            }
            this.pos = (int)((long)this.pos + k);
            return k;
        }

        @Override
        public synchronized int available() {
            int count = this.buf.size();
            return count - this.pos;
        }

        @Override
        public boolean markSupported() {
            return true;
        }

        @Override
        public void mark(int readAheadLimit) {
            this.mark = this.pos;
        }

        @Override
        public synchronized void reset() {
            this.pos = this.mark;
        }

        @Override
        public void close() {
        }
    }
}

