/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.io.path.spi.htmlfs;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.thevpc.nuts.concurrent.NScoredCallable;
import net.thevpc.nuts.runtime.standalone.io.path.spi.htmlfs.AbstractHtmlfsParser;
import net.thevpc.nuts.runtime.standalone.util.XmlEscaper;
import net.thevpc.nuts.text.NMsg;

public class TomcatWebServerHtmlfsParser
extends AbstractHtmlfsParser {
    @Override
    public NScoredCallable<List<String>> parseHtmlTomcat(byte[] bytes) {
        boolean expectDirListing = false;
        boolean expectTomcat = false;
        try (BufferedReader br2 = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(bytes)));){
            String line = null;
            while ((line = br2.readLine()) != null) {
                String trimmedLine = line.trim();
                if (!expectTomcat) {
                    if (trimmedLine.matches("<hr class=\"line\"><h3>[^<>]+</h3></body>")) {
                        expectTomcat = true;
                    }
                    if (trimmedLine.matches("<hr class=\"line\">")) {
                        expectTomcat = true;
                    }
                    if (trimmedLine.matches("<th [^<>]+Filename[^<>]+</th>")) {
                        expectTomcat = true;
                    }
                }
                if (expectDirListing || !trimmedLine.matches("<title>Directory Listing For.*")) continue;
                expectDirListing = true;
            }
        }
        catch (Exception br2) {
            // empty catch block
        }
        if (!expectTomcat || !expectDirListing) {
            Supplier<NMsg> msg = () -> NMsg.ofInvalidValue("tomcat repo");
            return NScoredCallable.ofInvalid(msg);
        }
        Pattern pattern = Pattern.compile("<a href=\"(?<href>[^\"]+)\"><tt>(?<title>[^<]+)</tt></a></td>");
        ArrayList<String> found = new ArrayList<String>();
        try (BufferedReader br = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(bytes)));){
            String line = null;
            while ((line = br.readLine()) != null) {
                Matcher m = pattern.matcher(line = line.trim());
                if (!m.find()) continue;
                found.add(XmlEscaper.escapeToUnicode(m.group("title")));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.toSupported(5, found);
    }
}

