/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.io.path.spi.htmlfs;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.thevpc.nuts.cmdline.NCmdLine;
import net.thevpc.nuts.concurrent.NScoredCallable;
import net.thevpc.nuts.io.NCp;
import net.thevpc.nuts.io.NIOException;
import net.thevpc.nuts.io.NPath;
import net.thevpc.nuts.io.NPathType;
import net.thevpc.nuts.io.NPrintStream;
import net.thevpc.nuts.log.NLog;
import net.thevpc.nuts.runtime.standalone.io.path.spi.AbstractPathSPIAdapter;
import net.thevpc.nuts.runtime.standalone.io.path.spi.htmlfs.ApacheReposHtmlfsParser;
import net.thevpc.nuts.runtime.standalone.io.path.spi.htmlfs.HtmlfsParser;
import net.thevpc.nuts.runtime.standalone.io.path.spi.htmlfs.JettyWebServerHtmlfsParser;
import net.thevpc.nuts.runtime.standalone.io.path.spi.htmlfs.MavenCentralHtmlfsParser;
import net.thevpc.nuts.runtime.standalone.io.path.spi.htmlfs.TomcatWebServerHtmlfsParser;
import net.thevpc.nuts.spi.NFormatSPI;
import net.thevpc.nuts.spi.NPathFactorySPI;
import net.thevpc.nuts.spi.NPathSPI;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.text.NText;
import net.thevpc.nuts.text.NTextBuilder;
import net.thevpc.nuts.text.NTextStyle;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NScorable;
import net.thevpc.nuts.util.NScorableContext;
import net.thevpc.nuts.util.NStream;
import net.thevpc.nuts.util.NUnsupportedArgumentException;

public class HtmlfsPath
extends AbstractPathSPIAdapter {
    public static final String PROTOCOL = "htmlfs";
    public static final String PREFIX = "htmlfs+";
    private static final HtmlfsParser[] PARSERS = new HtmlfsParser[]{new MavenCentralHtmlfsParser(), new ApacheReposHtmlfsParser(), new TomcatWebServerHtmlfsParser(), new JettyWebServerHtmlfsParser()};
    private String url;

    public HtmlfsPath(String url) {
        super(NPath.of(url.substring(PREFIX.length())));
        if (!url.startsWith(PREFIX)) {
            throw new NUnsupportedArgumentException(NMsg.ofC("expected prefix '%s'", PREFIX));
        }
        this.url = url;
    }

    @Override
    public int hashCode() {
        return Objects.hash(PROTOCOL, super.hashCode());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    public String toString() {
        return PREFIX + this.ref.toString();
    }

    @Override
    public NStream<NPath> list(NPath basePath) {
        NStream<NPath> nStream;
        block8: {
            InputStream q = this.ref.getInputStream();
            try {
                nStream = NStream.ofStream(this.parseHtml(q).stream().map(x -> {
                    if (x.endsWith("/")) {
                        String a = PREFIX + this.ref.resolve((String)x);
                        if (!a.endsWith("/")) {
                            a = a + "/";
                        }
                        return NPath.of(new HtmlfsPath(a));
                    }
                    return this.ref.resolve((String)x);
                }));
                if (q == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (q != null) {
                        try {
                            q.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | UncheckedIOException | NIOException e) {
                    return NStream.ofEmpty();
                }
            }
            q.close();
        }
        return nStream;
    }

    @Override
    public NFormatSPI formatter(NPath basePath) {
        return new MyPathFormat(this);
    }

    @Override
    public String getProtocol(NPath basePath) {
        return PROTOCOL;
    }

    @Override
    public NPath resolve(NPath basePath, String path) {
        if (NBlankable.isBlank(path)) {
            return basePath;
        }
        if (!path.endsWith("/")) {
            return this.ref.resolve(path);
        }
        return NPath.of(PREFIX + this.ref.resolve(path));
    }

    @Override
    public NPath resolveSibling(NPath basePath, String path) {
        if (NBlankable.isBlank(path)) {
            return basePath;
        }
        if (!path.endsWith("/")) {
            return this.ref.resolveSibling(path);
        }
        return NPath.of(PREFIX + this.ref.resolveSibling(path));
    }

    @Override
    public NPathType getType(NPath basePath) {
        if (NBlankable.isBlank(basePath.getLocation()) || basePath.getLocation().endsWith("/") || this.url.endsWith("/")) {
            return NPathType.DIRECTORY;
        }
        String t = this.getContentType(basePath);
        if (t != null) {
            if (t.endsWith("text/html")) {
                return NPathType.DIRECTORY;
            }
            if (t.startsWith("text/html;")) {
                return NPathType.DIRECTORY;
            }
            return NPathType.FILE;
        }
        return NPathType.OTHER;
    }

    @Override
    public boolean exists(NPath basePath) {
        String t = this.getContentType(basePath);
        return "text/html".equals(t);
    }

    @Override
    public NPath getParent(NPath basePath) {
        NPath p = this.ref.getParent();
        if (p == null) {
            return null;
        }
        return NPath.of(PREFIX + p);
    }

    @Override
    public NPath toAbsolute(NPath basePath, NPath rootPath) {
        if (this.isAbsolute(basePath)) {
            return basePath;
        }
        return NPath.of(PREFIX + basePath.toAbsolute(rootPath));
    }

    @Override
    public NPath normalize(NPath basePath) {
        return NPath.of(PREFIX + this.ref.normalize());
    }

    @Override
    public Boolean isName(NPath basePath) {
        return false;
    }

    @Override
    public NPath getRoot(NPath basePath) {
        if (this.isRoot(basePath).booleanValue()) {
            return basePath;
        }
        return NPath.of(PREFIX + this.ref.getRoot());
    }

    public List<String> parseHtml(InputStream html) {
        byte[] bytes = NCp.of().from(html).getByteArrayResult();
        return NScorable.query().withName(NMsg.ofC("html parser")).fromStream(Arrays.stream(PARSERS).map(p -> {
            try {
                return p.parseHtmlTomcat(bytes);
            }
            catch (Exception ex) {
                NLog.of(HtmlfsPath.class).log(NMsg.ofC("failed to parse using %s", p.getClass().getSimpleName()).asFinestFail(ex));
                return null;
            }
        })).getBest().map(NScoredCallable::call).orElse(Collections.emptyList());
    }

    @Override
    public boolean isLocal(NPath basePath) {
        return this.ref.isLocal();
    }

    private static class MyPathFormat
    implements NFormatSPI {
        private final HtmlfsPath p;

        public MyPathFormat(HtmlfsPath p) {
            this.p = p;
        }

        @Override
        public String getName() {
            return "path";
        }

        public NText asFormattedString() {
            NTextBuilder sb = NTextBuilder.of();
            sb.append((Object)HtmlfsPath.PROTOCOL, NTextStyle.primary1());
            sb.append((Object)":", NTextStyle.separator());
            sb.append(this.p.ref);
            return sb.build();
        }

        @Override
        public void print(NPrintStream out) {
            out.print(this.asFormattedString());
        }

        @Override
        public boolean configureFirst(NCmdLine cmdLine) {
            return false;
        }
    }

    public static class HtmlfsFactory
    implements NPathFactorySPI {
        @Override
        public NScoredCallable<NPathSPI> createPath(String path, String protocol, ClassLoader classLoader) {
            if (path.startsWith(HtmlfsPath.PREFIX)) {
                return NScoredCallable.of(10, () -> new HtmlfsPath(path));
            }
            return null;
        }

        @Override
        public int getScore(NScorableContext context) {
            String path = (String)context.getCriteria();
            try {
                if (path.startsWith(HtmlfsPath.PREFIX)) {
                    return 10;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return -1;
        }
    }
}

