/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.io.path.spi;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Instant;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.regex.Pattern;
import net.thevpc.nuts.cmdline.NCmdLine;
import net.thevpc.nuts.concurrent.NCachedValue;
import net.thevpc.nuts.concurrent.NScoredCallable;
import net.thevpc.nuts.ext.NExtensions;
import net.thevpc.nuts.io.NIO;
import net.thevpc.nuts.io.NIOException;
import net.thevpc.nuts.io.NPath;
import net.thevpc.nuts.io.NPathOption;
import net.thevpc.nuts.io.NPathPermission;
import net.thevpc.nuts.io.NPathType;
import net.thevpc.nuts.io.NPrintStream;
import net.thevpc.nuts.log.NLog;
import net.thevpc.nuts.log.NMsgIntent;
import net.thevpc.nuts.net.NWebCli;
import net.thevpc.nuts.runtime.standalone.io.util.CoreIOUtils;
import net.thevpc.nuts.runtime.standalone.io.util.NPathParts;
import net.thevpc.nuts.runtime.standalone.xtra.web.DefaultNWebCli;
import net.thevpc.nuts.spi.NFormatSPI;
import net.thevpc.nuts.spi.NPathFactorySPI;
import net.thevpc.nuts.spi.NPathSPI;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.text.NText;
import net.thevpc.nuts.time.NChronometer;
import net.thevpc.nuts.time.NDuration;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NLRUMap;
import net.thevpc.nuts.util.NOptional;
import net.thevpc.nuts.util.NScorableContext;
import net.thevpc.nuts.util.NStream;

public class URLPath
implements NPathSPI {
    public static final Pattern MOSTLY_URL_PATTERN = Pattern.compile("([a-zA-Z][a-zA-Z0-9_-]+):.*");
    protected URL url;
    protected static final NLRUMap<URL, NCachedValue<CacheInfo>> cacheManager = new NLRUMap(1024);

    public URLPath(URL url) {
        this(url, false);
    }

    protected URLPath(URL url, boolean acceptNull) {
        if (url == null && !acceptNull) {
            throw new IllegalArgumentException("invalid url");
        }
        this.url = url;
    }

    private NCachedValue<CacheInfo> cachedHeader() {
        NCachedValue<CacheInfo> o = (NCachedValue<CacheInfo>)cacheManager.get(this.url);
        if (o == null) {
            o = NCachedValue.of(() -> URLPath.loadCacheInfo(this.url)).setExpiry(NDuration.ofMillis(5000L));
            cacheManager.put(this.url, o);
        }
        return o;
    }

    public static String getURLParentPath(String ppath) {
        if (ppath == null) {
            return null;
        }
        while (ppath.endsWith("/")) {
            ppath = ppath.substring(0, ppath.length() - 1);
        }
        if (ppath.isEmpty()) {
            return null;
        }
        int i = ppath.lastIndexOf(47);
        ppath = i <= 0 ? "/" : ppath.substring(0, i + 1);
        return ppath;
    }

    public static String getURLName(String path) {
        int index = path.lastIndexOf(47);
        String name = index < 0 ? path : path.substring(index + 1);
        index = name.indexOf(63);
        if (index >= 0) {
            name = name.substring(0, index);
        }
        name = name.trim();
        return name;
    }

    public static File _toFile(URL url) {
        if (url == null) {
            return null;
        }
        if ("file".equals(url.getProtocol())) {
            try {
                return Paths.get(url.toURI()).toFile();
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return null;
    }

    public int hashCode() {
        return Objects.hash(this.url);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        URLPath urlPath = (URLPath)o;
        return Objects.equals(this.url, urlPath.url);
    }

    @Override
    public String toString() {
        return this.url == null ? "broken-url" : this.url.toString();
    }

    @Override
    public NStream<NPath> list(NPath basePath) {
        NPath f = this.asFilePath(basePath);
        if (f != null) {
            return f.stream();
        }
        return NStream.ofEmpty();
    }

    @Override
    public NFormatSPI formatter(NPath basePath) {
        return new MyPathFormat(this);
    }

    @Override
    public String getName(NPath basePath) {
        return new NPathParts(this.toString()).getName();
    }

    @Override
    public String getProtocol(NPath basePath) {
        return this.url == null ? null : this.url.getProtocol();
    }

    @Override
    public NPath resolve(NPath basePath, String path) {
        if (this.url == null) {
            NPathParts p = new NPathParts(this.toString());
            String spath = path.toString().replace("\\", "/");
            String u = p.getFile();
            if (!u.endsWith("/") && !spath.startsWith("/")) {
                u = u + "/";
            }
            u = u + spath;
            return this.rebuildURLPath(this.rebuildURLString(p.getProtocol(), p.getAuthority(), u, p.getRef()));
        }
        String spath = path.toString().replace("\\", "/");
        String u = this.url.getFile();
        if (!u.endsWith("/") && !spath.startsWith("/")) {
            u = u + "/";
        }
        u = u + spath;
        return this.rebuildURLPath(this.rebuildURLString(this.url.getProtocol(), this.url.getAuthority(), u, this.url.getRef()));
    }

    @Override
    public NPath resolveSibling(NPath basePath, String path) {
        if (this.url == null) {
            NPathParts p = new NPathParts(this.toString());
            String u = this._parent(p.getFile());
            String spath = path.replace("\\", "/");
            if (u == null || u.isEmpty()) {
                u = spath;
            } else {
                if (!u.endsWith("/") && !spath.startsWith("/")) {
                    u = u + "/";
                }
                u = u + spath;
            }
            return this.rebuildURLPath(this.rebuildURLString(p.getProtocol(), p.getAuthority(), u, p.getRef()));
        }
        String u = this._parent(this.url.getFile());
        String spath = path.replace("\\", "/");
        if (u == null || u.isEmpty()) {
            u = spath;
        } else {
            if (!u.endsWith("/") && !spath.startsWith("/")) {
                u = u + "/";
            }
            u = u + spath;
        }
        return this.rebuildURLPath(this.rebuildURLString(this.url.getProtocol(), this.url.getAuthority(), u, this.url.getRef()));
    }

    @Override
    public NPath toCompressedForm(NPath basePath) {
        return null;
    }

    @Override
    public NOptional<URL> toURL(NPath basePath) {
        if (this.url == null) {
            return NOptional.ofEmpty(() -> NMsg.ofC("unable to resolve url %s", this.toString()));
        }
        return NOptional.of(this.url);
    }

    @Override
    public NOptional<Path> toPath(NPath basePath) {
        return this.toURL(basePath).flatMap(x -> {
            File f = URLPath._toFile(x);
            if (f != null) {
                return NOptional.of(f.toPath());
            }
            return NOptional.ofEmpty(() -> NMsg.ofC("unable to resolve url %s", this.toString()));
        });
    }

    @Override
    public NPathType getType(NPath basePath) {
        if (this.toString().endsWith("/")) {
            return NPathType.DIRECTORY;
        }
        NPath f = this.asFilePath(basePath);
        if (f != null) {
            return f.type();
        }
        if (this.exists(basePath)) {
            return NPathType.FILE;
        }
        return NPathType.NOT_FOUND;
    }

    @Override
    public boolean isLocal(NPath basePath) {
        NPath f;
        String urlString = this.url.toString();
        int x = urlString.indexOf(58);
        if (x >= 0) {
            switch (urlString.substring(0, x)) {
                case "file": 
                case "classpath": 
                case "resource": 
                case "jar": {
                    return true;
                }
                case "http": 
                case "https": 
                case "ftp": 
                case "ftps": 
                case "sftp": 
                case "ssh": {
                    return false;
                }
            }
        }
        return (f = this.asFilePath(basePath)) != null && f.isLocal();
    }

    @Override
    public boolean exists(NPath basePath) {
        boolean bl;
        block13: {
            if (this.url == null) {
                return false;
            }
            NPath f = this.asFilePath(basePath);
            if (f != null) {
                return f.exists();
            }
            try {
                CacheInfo a = this.cachedHeader().get();
                if (a != null) {
                    int r = a.responseCode;
                    return r >= 200 && r < 300;
                }
            }
            catch (Exception a) {
                // empty catch block
            }
            InputStream is = DefaultNWebCli.prepareGlobalOpenStream(this.url);
            try {
                bl = true;
                if (is == null) break block13;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return false;
                }
            }
            is.close();
        }
        return bl;
    }

    @Override
    public long getContentLength(NPath basePath) {
        if (this.url == null) {
            return -1L;
        }
        NPath f = this.asFilePath(basePath);
        if (f != null) {
            return f.getContentLength();
        }
        try {
            CacheInfo a = this.cachedHeader().get();
            if (a != null) {
                return a.contentLength;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return -1L;
    }

    @Override
    public String getContentEncoding(NPath basePath) {
        try {
            CacheInfo a = this.cachedHeader().get();
            if (a != null) {
                return a.contentEncoding;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    @Override
    public String getContentType(NPath basePath) {
        if (this.url == null) {
            return null;
        }
        NPath f = this.asFilePath(basePath);
        if (f != null) {
            return f.getContentType();
        }
        try {
            CacheInfo a = this.cachedHeader().get();
            if (a != null) {
                return a.contentType;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return NIO.of().probeContentType(basePath);
    }

    @Override
    public String getCharset(NPath basePath) {
        if (this.url == null) {
            return null;
        }
        NPath f = this.asFilePath(basePath);
        if (f != null) {
            return f.getContentType();
        }
        try {
            CacheInfo a = this.cachedHeader().get();
            if (a != null) {
                return a.contentEncoding;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return NIO.of().probeCharset(basePath);
    }

    @Override
    public String getLocation(NPath basePath) {
        return this.url == null ? null : this.url.getFile();
    }

    @Override
    public InputStream getInputStream(NPath basePath, NPathOption ... options) {
        if (this.url == null) {
            throw new NIOException(NMsg.ofC("unable to resolve input stream %s", this.toString()));
        }
        if ("file".equals(this.url.getProtocol())) {
            try {
                return Files.newInputStream(CoreIOUtils.resolveLocalPathFromURL(this.url), new OpenOption[0]);
            }
            catch (IOException e) {
                throw new NIOException(NMsg.ofC("unable to resolve input stream %s", this.toString()));
            }
        }
        if ("http".equals(this.url.getProtocol()) || "https".equals(this.url.getProtocol())) {
            NWebCli best = NExtensions.of().createComponent(NWebCli.class, this.url).get();
            return best.req().GET().setUrl(this.url.toString()).run().getContent().getInputStream();
        }
        try {
            return DefaultNWebCli.prepareGlobalOpenStream(this.url);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public OutputStream getOutputStream(NPath basePath, NPathOption ... options) {
        try {
            if (this.url == null) {
                throw new NIOException(NMsg.ofC("unable to resolve output stream %s", this.toString()));
            }
            URLConnection c = this.url.openConnection();
            DefaultNWebCli.prepareGlobalConnection(c);
            return c.getOutputStream();
        }
        catch (IOException e) {
            throw new NIOException(e);
        }
    }

    @Override
    public void delete(NPath basePath, boolean recurse) {
        NPath f;
        if (this.url != null && (f = this.asFilePath(basePath)) != null) {
            f.delete(recurse);
            return;
        }
        throw new NIOException(NMsg.ofC("unable to delete %s", this.toString()));
    }

    @Override
    public void mkdir(boolean parents, NPath basePath) {
        NPath f;
        if (this.url != null && (f = this.asFilePath(basePath)) != null) {
            f.mkdir(parents);
            return;
        }
        throw new NIOException(NMsg.ofC("unable to mkdir %s", this.toString()));
    }

    @Override
    public Instant getLastModifiedInstant(NPath basePath) {
        if (this.url == null) {
            return null;
        }
        NPath f = this.asFilePath(basePath);
        if (f != null) {
            return f.getLastModifiedInstant();
        }
        try {
            CacheInfo a = this.cachedHeader().get();
            if (a != null) {
                return a.lastModified;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    @Override
    public Instant getLastAccessInstant(NPath basePath) {
        NPath f = this.asFilePath(basePath);
        return f != null ? f.getLastAccessInstant() : null;
    }

    @Override
    public Instant getCreationInstant(NPath basePath) {
        NPath f = this.asFilePath(basePath);
        return f != null ? f.getCreationInstant() : null;
    }

    @Override
    public NPath getParent(NPath basePath) {
        if (this.url == null) {
            return null;
        }
        NPath f = this.asFilePath(basePath);
        if (f != null) {
            return f.getParent();
        }
        try {
            String ppath = URLPath.getURLParentPath(this.url.getPath());
            if (ppath == null) {
                return null;
            }
            URL url = CoreIOUtils.urlOf(new NPathParts(NPathParts.Type.URL, this.url.getProtocol(), this.url.getAuthority(), ppath, this.url.getQuery(), this.url.getRef()).toString());
            return NPath.of(url);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public NPath toAbsolute(NPath basePath, NPath rootPath) {
        return basePath;
    }

    @Override
    public NPath normalize(NPath basePath) {
        NPath f = this.asFilePath(basePath);
        if (f != null) {
            return f.normalize();
        }
        return basePath;
    }

    @Override
    public boolean isAbsolute(NPath basePath) {
        return true;
    }

    @Override
    public String getOwner(NPath basePath) {
        NPath f = this.asFilePath(basePath);
        return f != null ? f.owner() : null;
    }

    @Override
    public String getGroup(NPath basePath) {
        NPath f = this.asFilePath(basePath);
        return f != null ? f.group() : null;
    }

    @Override
    public Set<NPathPermission> getPermissions(NPath basePath) {
        NPath f = this.asFilePath(basePath);
        return f != null ? f.getPermissions() : Collections.emptySet();
    }

    @Override
    public void setPermissions(NPath basePath, NPathPermission ... permissions) {
        NPath f = this.asFilePath(basePath);
        if (f != null) {
            f.setPermissions(permissions);
        }
    }

    @Override
    public void addPermissions(NPath basePath, NPathPermission ... permissions) {
        NPath f = this.asFilePath(basePath);
        if (f != null) {
            f.addPermissions(permissions);
        }
    }

    @Override
    public void removePermissions(NPath basePath, NPathPermission ... permissions) {
        NPath f = this.asFilePath(basePath);
        if (f != null) {
            f.removePermissions(permissions);
        }
    }

    @Override
    public Boolean isName(NPath basePath) {
        return false;
    }

    @Override
    public Integer getNameCount(NPath basePath) {
        String location = this.getLocation(basePath);
        if (NBlankable.isBlank(location)) {
            return 0;
        }
        return NPath.of(location).getNameCount();
    }

    @Override
    public Boolean isRoot(NPath basePath) {
        String loc = this.getLocation(basePath);
        if (NBlankable.isBlank(loc)) {
            return false;
        }
        switch (loc) {
            case "/": 
            case "\\\\": {
                return true;
            }
        }
        return NPath.of(loc).isRoot();
    }

    @Override
    public NPath getRoot(NPath basePath) {
        if (this.isRoot(basePath).booleanValue()) {
            return basePath;
        }
        return basePath.getParent().getRoot();
    }

    @Override
    public NStream<NPath> walk(NPath basePath, int maxDepth, NPathOption[] options) {
        NPath f = this.asFilePath(basePath);
        if (f != null) {
            return f.walk(maxDepth, options);
        }
        return null;
    }

    @Override
    public NPath subpath(NPath basePath, int beginIndex, int endIndex) {
        return this.rebuildURLPath(NPath.of(this.getLocation(basePath)).subpath(beginIndex, endIndex).toString());
    }

    @Override
    public List<String> getNames(NPath basePath) {
        return NPath.of(this.getLocation(basePath)).getNames();
    }

    @Override
    public boolean moveTo(NPath basePath, NPath other, NPathOption ... options) {
        throw new NIOException(NMsg.ofC("unable to move %s", this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static CacheInfo loadCacheInfo(URL url) {
        CacheInfo cacheInfo;
        NChronometer chrono = NChronometer.startNow();
        boolean success = true;
        try {
            URLConnection c = url.openConnection();
            DefaultNWebCli.prepareGlobalConnection(c);
            c.setDoOutput(false);
            CacheInfo cc = new CacheInfo();
            if (c instanceof HttpURLConnection) {
                HttpURLConnection hc = (HttpURLConnection)c;
                hc.setRequestMethod("HEAD");
                cc.responseCode = hc.getResponseCode();
            } else {
                cc.responseCode = 200;
            }
            cc.contentLength = c.getContentLengthLong();
            cc.contentEncoding = c.getContentEncoding();
            cc.contentType = c.getContentType();
            long z = c.getLastModified();
            if (z > 0L) {
                cc.lastModified = Instant.ofEpochMilli(z);
            }
            success = cc.responseCode >= 200 && cc.responseCode < 300;
            cacheInfo = cc;
        }
        catch (Exception ex) {
            try {
                success = false;
            }
            catch (Throwable throwable) {
                NLog.of(URLPath.class).log(NMsg.ofC("load url info %s", url).withLevel(Level.FINEST).withIntent(success ? NMsgIntent.SUCCESS : NMsgIntent.FAIL).withDurationMillis(chrono.stop().getDurationMs()));
                throw throwable;
            }
            NLog.of(URLPath.class).log(NMsg.ofC("load url info %s", url).withLevel(Level.FINEST).withIntent(success ? NMsgIntent.SUCCESS : NMsgIntent.FAIL).withDurationMillis(chrono.stop().getDurationMs()));
            return null;
        }
        NLog.of(URLPath.class).log(NMsg.ofC("load url info %s", url).withLevel(Level.FINEST).withIntent(success ? NMsgIntent.SUCCESS : NMsgIntent.FAIL).withDurationMillis(chrono.stop().getDurationMs()));
        return cacheInfo;
    }

    private String _parent(String p) {
        while (p.endsWith("/") || p.endsWith("\\")) {
            p = p.substring(0, p.length() - 1);
        }
        if (p.isEmpty()) {
            return null;
        }
        int x = p.lastIndexOf(47);
        int y = p.lastIndexOf(92);
        if (x < 0) {
            x = y;
        } else if (y >= 0 && y > x) {
            x = y;
        }
        if (x < 0) {
            return "";
        }
        return p.substring(0, x);
    }

    protected NPath rebuildURLPath(String other) {
        return NPath.of(other);
    }

    protected String rebuildURLString(String protocol, String authority, String file, String ref) {
        int len = protocol.length() + 1;
        if (authority != null && authority.length() > 0) {
            len += 2 + authority.length();
        }
        if (file != null) {
            len += file.length();
        }
        if (ref != null) {
            len += 1 + ref.length();
        }
        StringBuilder result = new StringBuilder(len);
        result.append(protocol);
        result.append(":");
        if (authority != null && authority.length() > 0) {
            result.append("//");
            result.append(authority);
        }
        if (file != null) {
            result.append(file);
        }
        if (ref != null) {
            result.append("#");
            result.append(ref);
        }
        return result.toString();
    }

    public NPath asFilePath(NPath basePath) {
        return (NPath)this.toURL(basePath).flatMap(x -> {
            File f = URLPath._toFile(x);
            if (f != null) {
                return NOptional.of(NPath.of(f));
            }
            return NOptional.ofEmpty(() -> NMsg.ofC("not a local file %s", this.toString()));
        }).orNull();
    }

    private static class MyPathFormat
    implements NFormatSPI {
        private final URLPath p;

        public MyPathFormat(URLPath p) {
            this.p = p;
        }

        @Override
        public String getName() {
            return "path";
        }

        public NText asFormattedString() {
            if (this.p.url == null) {
                return NText.ofBlank();
            }
            return NText.of(this.p.url);
        }

        @Override
        public void print(NPrintStream out) {
            out.print(this.asFormattedString());
        }

        @Override
        public boolean configureFirst(NCmdLine cmdLine) {
            return false;
        }
    }

    private static class CacheInfo {
        long contentLength;
        String contentEncoding;
        String contentType;
        int responseCode;
        Instant lastModified;

        private CacheInfo() {
        }
    }

    public static class URLPathFactory
    implements NPathFactorySPI {
        @Override
        public NScoredCallable<NPathSPI> createPath(String path, String protocol, ClassLoader classLoader) {
            try {
                char s;
                if (path != null && path.length() > 0 && Character.isAlphabetic(s = path.charAt(0))) {
                    URL url = CoreIOUtils.urlOf(path);
                    return NScoredCallable.of(5, () -> new URLPath(url));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }

        @Override
        public int getScore(NScorableContext context) {
            char s;
            String path;
            Object c = context.getCriteria();
            if (c instanceof String && (path = (String)c).length() > 0 && Character.isAlphabetic(s = path.charAt(0))) {
                try {
                    URL url = CoreIOUtils.urlOf(path);
                    return 6;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return -1;
        }
    }
}

