/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.io.path.spi;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.thevpc.nuts.cmdline.NCmdLine;
import net.thevpc.nuts.concurrent.NScoredCallable;
import net.thevpc.nuts.core.NWorkspace;
import net.thevpc.nuts.io.NIOException;
import net.thevpc.nuts.io.NPath;
import net.thevpc.nuts.io.NPathOption;
import net.thevpc.nuts.io.NPathPermission;
import net.thevpc.nuts.io.NPathType;
import net.thevpc.nuts.io.NPrintStream;
import net.thevpc.nuts.platform.NOsFamily;
import net.thevpc.nuts.runtime.standalone.io.path.NPathFromSPI;
import net.thevpc.nuts.runtime.standalone.io.path.spi.NPathPart;
import net.thevpc.nuts.runtime.standalone.io.path.spi.NPathPartList;
import net.thevpc.nuts.runtime.standalone.io.path.spi.NPathPartParser;
import net.thevpc.nuts.runtime.standalone.io.path.spi.URLPath;
import net.thevpc.nuts.runtime.standalone.io.util.CoreIOUtils;
import net.thevpc.nuts.spi.NFormatSPI;
import net.thevpc.nuts.spi.NPathFactorySPI;
import net.thevpc.nuts.spi.NPathSPI;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.text.NText;
import net.thevpc.nuts.util.NOptional;
import net.thevpc.nuts.util.NScorableContext;
import net.thevpc.nuts.util.NStream;

public class GenericFilePath
implements NPathSPI {
    private final String value;
    private final NPathPartList parts;

    public GenericFilePath(String value) {
        this.value = value == null ? "" : value;
        this.parts = NPathPartParser.parseParts(this.value);
    }

    @Override
    public NStream<NPath> list(NPath basePath) {
        return NStream.ofEmpty();
    }

    @Override
    public NFormatSPI formatter(NPath basePath) {
        return new MyPathFormat(this);
    }

    @Override
    public String getName(NPath basePath) {
        if (this.parts.isEmpty()) {
            return "";
        }
        if (this.parts.size() == 1) {
            return this.parts.first().getName();
        }
        if (this.parts.last().isTrailingSeparator()) {
            return this.parts.get(-2).getName();
        }
        return this.parts.last().getName();
    }

    @Override
    public String getProtocol(NPath basePath) {
        return "";
    }

    @Override
    public NPath resolve(NPath basePath, String path) {
        NPathPartList newParts = NPathPartParser.parseParts(path);
        if (newParts.isEmpty()) {
            return basePath;
        }
        if (this.parts.isEmpty() || newParts.get(0).getSeparator().length() > 0) {
            return NPath.of(path);
        }
        return this.partsToPath(this.parts.concat(newParts));
    }

    @Override
    public NPath resolveSibling(NPath basePath, String path) {
        if (path == null || path.isEmpty()) {
            return this.getParent(basePath);
        }
        if (this.isRoot(basePath).booleanValue()) {
            ArrayList<NPathPart> a = new ArrayList<NPathPart>();
            if (this.parts.size() > 0) {
                a.add(new NPathPart(this.parts.get(0).getSeparator(), ""));
            } else {
                a.add(new NPathPart(File.separator, ""));
            }
            return this.partsToPath(new NPathPartList(a).concat(NPathPartParser.parseParts(path)));
        }
        return this.getParent(basePath).resolve(path);
    }

    @Override
    public NPath toCompressedForm(NPath basePath) {
        return null;
    }

    @Override
    public NOptional<URL> toURL(NPath basePath) {
        try {
            if (URLPath.MOSTLY_URL_PATTERN.matcher(this.value).matches()) {
                return NOptional.of(CoreIOUtils.urlOf(this.value));
            }
            return NOptional.of(CoreIOUtils.urlOf("file:" + this.value));
        }
        catch (Exception e) {
            return NOptional.ofNamedError(NMsg.ofC("not an url %s", this.value));
        }
    }

    @Override
    public NOptional<Path> toPath(NPath basePath) {
        try {
            return NOptional.of(Paths.get(this.value, new String[0]));
        }
        catch (Exception ex) {
            return NOptional.ofNamedError(NMsg.ofC("not a path %s", this.value));
        }
    }

    @Override
    public NPathType getType(NPath basePath) {
        return NPathType.NOT_FOUND;
    }

    @Override
    public boolean exists(NPath basePath) {
        return false;
    }

    @Override
    public long getContentLength(NPath basePath) {
        return -1L;
    }

    @Override
    public String getContentEncoding(NPath basePath) {
        return null;
    }

    @Override
    public String getContentType(NPath basePath) {
        return null;
    }

    @Override
    public String getCharset(NPath basePath) {
        return null;
    }

    @Override
    public String getLocation(NPath basePath) {
        return this.value;
    }

    @Override
    public InputStream getInputStream(NPath basePath, NPathOption ... options) {
        throw new NIOException(NMsg.ofC("path not found %s", this));
    }

    @Override
    public OutputStream getOutputStream(NPath basePath, NPathOption ... options) {
        throw new NIOException(NMsg.ofC("path not found %s", this));
    }

    @Override
    public void delete(NPath basePath, boolean recurse) {
        throw new NIOException(NMsg.ofC("unable to delete path %s", this));
    }

    @Override
    public void mkdir(boolean parents, NPath basePath) {
        throw new NIOException(NMsg.ofC("unable to create folder %s", this));
    }

    @Override
    public Instant getLastModifiedInstant(NPath basePath) {
        return null;
    }

    @Override
    public Instant getLastAccessInstant(NPath basePath) {
        return null;
    }

    @Override
    public Instant getCreationInstant(NPath basePath) {
        return null;
    }

    @Override
    public NPath getParent(NPath basePath) {
        if (this.isRoot(basePath).booleanValue()) {
            return null;
        }
        if (this.parts.isEmpty()) {
            return null;
        }
        if (this.parts.size() == 1) {
            NPathPart p = this.parts.get(0);
            if (p.isTrailingSeparator()) {
                return null;
            }
            if (p.isName()) {
                return null;
            }
            return this.partsToPath(new NPathPartList(Arrays.asList(new NPathPart(p.getSeparator(), ""))));
        }
        if (this.parts.get(this.parts.size() - 1).isTrailingSeparator()) {
            return this.partsToPath(this.parts.subList(0, this.parts.size() - 2));
        }
        return this.partsToPath(this.parts.subList(0, this.parts.size() - 1));
    }

    @Override
    public NPath toAbsolute(NPath basePath, NPath rootPath) {
        if (this.isAbsolute(basePath)) {
            return basePath;
        }
        if (rootPath == null) {
            return this.partsToPath(NPathPartParser.parseParts(System.getProperty("user.dir")).concat(this.parts));
        }
        return rootPath.toAbsolute().resolve(this.toString());
    }

    @Override
    public NPath normalize(NPath basePath) {
        ArrayList<NPathPart> p2 = new ArrayList<NPathPart>();
        for (NPathPart part : this.parts) {
            NPathPart p = part;
            if (p.isSeparated() && !p.getSeparator().equals(File.separator)) {
                p = new NPathPart(File.separator, p.getName());
            }
            if (p.isTrailingSeparator() && p2.size() > 0) continue;
            if (p.getName().equals(".")) {
                if (p2.size() > 0 || p.getSeparator().isEmpty()) continue;
                p = new NPathPart(p.getSeparator(), "");
                p2.add(p);
                continue;
            }
            if (p.getName().equals("..")) {
                if (p2.size() == 0) {
                    if (p.getSeparator().isEmpty()) {
                        p2.add(p);
                    } else {
                        p = new NPathPart(p.getSeparator(), "");
                        p2.add(p);
                    }
                }
                if (p2.size() == 1) {
                    NPathPart r = (NPathPart)p2.get(0);
                    if (r.isTrailingSeparator()) continue;
                    p = new NPathPart(p.getSeparator(), "");
                    p2.add(p);
                    continue;
                }
                p2.remove(p2.size() - 1);
                continue;
            }
            p2.add(p);
        }
        return this.partsToPath(new NPathPartList(p2));
    }

    private NPath partsToPath(NPathPartList p2) {
        return NPath.of(p2.toString());
    }

    @Override
    public boolean isAbsolute(NPath basePath) {
        if (this.parts.size() != 0) {
            char c;
            String n;
            NPathPart f = this.parts.first();
            if (f.getSeparator().length() > 0) {
                return true;
            }
            if (NWorkspace.of().getOsFamily() == NOsFamily.WINDOWS && (n = f.getName()).length() == 2 && n.charAt(1) == ':' && ((c = n.charAt(0)) >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z')) {
                return true;
            }
        }
        return false;
    }

    @Override
    public String getOwner(NPath basePath) {
        return null;
    }

    @Override
    public String getGroup(NPath basePath) {
        return null;
    }

    @Override
    public Set<NPathPermission> getPermissions(NPath basePath) {
        LinkedHashSet p = new LinkedHashSet();
        return Collections.unmodifiableSet(p);
    }

    @Override
    public void setPermissions(NPath basePath, NPathPermission ... permissions) {
    }

    @Override
    public void addPermissions(NPath basePath, NPathPermission ... permissions) {
    }

    @Override
    public void removePermissions(NPath basePath, NPathPermission ... permissions) {
    }

    @Override
    public Boolean isName(NPath basePath) {
        if (this.parts.size() == 0) {
            return true;
        }
        if (this.parts.size() > 1) {
            return false;
        }
        NPathPart v = this.parts.get(0);
        if (!v.getSeparator().isEmpty()) {
            return false;
        }
        switch (v.getName()) {
            case "/": 
            case "\\": 
            case ".": 
            case "..": {
                return false;
            }
        }
        return true;
    }

    @Override
    public Integer getNameCount(NPath basePath) {
        if (this.parts.isEmpty()) {
            return 1;
        }
        if (this.parts.size() == 1 && this.parts.get(0).isTrailingSeparator()) {
            return 1;
        }
        if (this.parts.get(this.parts.size() - 1).isTrailingSeparator()) {
            return this.parts.size() - 1;
        }
        return this.parts.size();
    }

    @Override
    public Boolean isRoot(NPath basePath) {
        if (this.parts.isEmpty()) {
            return true;
        }
        if (this.parts.size() == 1 && this.parts.get(0).isTrailingSeparator()) {
            return true;
        }
        return false;
    }

    @Override
    public NPath subpath(NPath basePath, int beginIndex, int endIndex) {
        NPathPartList parts = this.parts.subList(beginIndex, endIndex);
        return this.partsToPath(parts);
    }

    @Override
    public List<String> getNames(NPath basePath) {
        NPathPartList parts = this.parts;
        if (parts.isEmpty()) {
            return Collections.emptyList();
        }
        if (parts.size() == 1 && parts.get(0).isTrailingSeparator()) {
            return Arrays.asList("");
        }
        if (parts.get(parts.size() - 1).isTrailingSeparator()) {
            return parts.subList(0, parts.size() - 1).toStringList();
        }
        return parts.subList(0, parts.size()).toStringList();
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GenericFilePath urlPath = (GenericFilePath)o;
        return Objects.equals(this.value, urlPath.value);
    }

    @Override
    public String toString() {
        return this.value;
    }

    @Override
    public boolean moveTo(NPath basePath, NPath other, NPathOption ... options) {
        throw new NIOException(NMsg.ofC("unable to move %s", this));
    }

    @Override
    public NPath getRoot(NPath basePath) {
        if (this.isRoot(basePath).booleanValue()) {
            return basePath;
        }
        return new NPathFromSPI(new GenericFilePath(""));
    }

    @Override
    public boolean isLocal(NPath basePath) {
        return true;
    }

    private static class MyPathFormat
    implements NFormatSPI {
        private final GenericFilePath p;

        @Override
        public String getName() {
            return "path";
        }

        public MyPathFormat(GenericFilePath p) {
            this.p = p;
        }

        public NText asFormattedString() {
            return NText.of(this.p.value);
        }

        @Override
        public void print(NPrintStream out) {
            out.print(this.asFormattedString());
        }

        @Override
        public boolean configureFirst(NCmdLine cmdLine) {
            return false;
        }
    }

    public static class GenericPathFactory
    implements NPathFactorySPI {
        @Override
        public NScoredCallable<NPathSPI> createPath(String path, String protocol, ClassLoader classLoader) {
            if (path != null && path.trim().length() > 0) {
                for (char c : path.toCharArray()) {
                    if (c >= ' ') continue;
                    return null;
                }
                return NScoredCallable.of(1, () -> new GenericFilePath(path));
            }
            return null;
        }

        @Override
        public int getScore(NScorableContext context) {
            String path = (String)context.getCriteria();
            try {
                if (path != null && path.trim().length() > 0) {
                    for (char c : path.toCharArray()) {
                        if (c >= ' ') continue;
                        return -1;
                    }
                    return 1;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return -1;
        }
    }
}

