/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.io.path.spi;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.thevpc.nuts.artifact.NVersion;
import net.thevpc.nuts.cmdline.NCmdLine;
import net.thevpc.nuts.concurrent.NScoredCallable;
import net.thevpc.nuts.core.NSession;
import net.thevpc.nuts.io.NIOException;
import net.thevpc.nuts.io.NIOUtils;
import net.thevpc.nuts.io.NInputStreamMonitor;
import net.thevpc.nuts.io.NPath;
import net.thevpc.nuts.io.NPathType;
import net.thevpc.nuts.io.NPrintStream;
import net.thevpc.nuts.log.NLog;
import net.thevpc.nuts.runtime.standalone.io.path.spi.AbstractPathSPIAdapter;
import net.thevpc.nuts.runtime.standalone.util.NCoreLogUtils;
import net.thevpc.nuts.runtime.standalone.xtra.expr.StringTokenizerUtils;
import net.thevpc.nuts.spi.NFormatSPI;
import net.thevpc.nuts.spi.NPathFactorySPI;
import net.thevpc.nuts.spi.NPathSPI;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.text.NText;
import net.thevpc.nuts.text.NTextBuilder;
import net.thevpc.nuts.text.NTextStyle;
import net.thevpc.nuts.time.NChronometer;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NScorableContext;
import net.thevpc.nuts.util.NStream;
import net.thevpc.nuts.util.NStringUtils;
import net.thevpc.nuts.util.NUnsupportedArgumentException;

public class DotfilefsPath
extends AbstractPathSPIAdapter {
    public static final String PROTOCOL = "dotfilefs";
    public static final String PREFIX = "dotfilefs+";

    public DotfilefsPath(String url) {
        super(NPath.of(url.substring(PREFIX.length())));
        if (!url.startsWith(PREFIX)) {
            throw new NUnsupportedArgumentException(NMsg.ofC("expected prefix '%s'", PREFIX));
        }
    }

    @Override
    public int hashCode() {
        return Objects.hash(PROTOCOL, super.hashCode());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    public String toString() {
        return PREFIX + this.ref.toString();
    }

    @Override
    public NStream<NPath> list(NPath basePath) {
        return NStream.ofStream(this.parseHtml(this.ref.toString()).stream().map(x -> {
            if (x.endsWith("/")) {
                return NPath.of(PREFIX + this.ref.resolve((String)x));
            }
            return this.ref.resolve((String)x);
        }));
    }

    @Override
    public NFormatSPI formatter(NPath basePath) {
        return new MyPathFormat(this);
    }

    @Override
    public String getProtocol(NPath basePath) {
        return PROTOCOL;
    }

    @Override
    public NPath resolve(NPath basePath, String path) {
        return NPath.of(PREFIX + this.ref.resolve(path));
    }

    @Override
    public NPath resolveSibling(NPath basePath, String path) {
        return NPath.of(PREFIX + this.ref.resolveSibling(path));
    }

    @Override
    public NPathType getType(NPath basePath) {
        if (NBlankable.isBlank(basePath.getLocation()) || basePath.getLocation().endsWith("/")) {
            return NPathType.DIRECTORY;
        }
        String t = this.getContentType(basePath);
        if (t != null) {
            if (t.endsWith("text/html")) {
                return NPathType.DIRECTORY;
            }
            if (t.startsWith("text/html;")) {
                return NPathType.DIRECTORY;
            }
            return NPathType.FILE;
        }
        return NPathType.NOT_FOUND;
    }

    @Override
    public boolean exists(NPath basePath) {
        return this.ref.exists();
    }

    @Override
    public NPath getParent(NPath basePath) {
        NPath p = this.ref.getParent();
        if (p == null) {
            return null;
        }
        return NPath.of(PREFIX + p);
    }

    @Override
    public NPath toAbsolute(NPath basePath, NPath rootPath) {
        if (this.isAbsolute(basePath)) {
            return basePath;
        }
        return NPath.of(PREFIX + basePath.toAbsolute(rootPath));
    }

    @Override
    public NPath normalize(NPath basePath) {
        return NPath.of(PREFIX + this.ref.normalize());
    }

    @Override
    public Boolean isName(NPath basePath) {
        return false;
    }

    @Override
    public NPath getRoot(NPath basePath) {
        if (this.isRoot(basePath).booleanValue()) {
            return basePath;
        }
        return NPath.of(PREFIX + this.ref.getRoot());
    }

    private List<String> parseHtml(String baseUrl) {
        boolean folders = false;
        boolean files = true;
        ArrayList<String> all = new ArrayList<String>();
        NChronometer c = NChronometer.startNow();
        String dotFilesContent = null;
        String dotFilesUrl = NStringUtils.pjoin("/", baseUrl, ".files");
        NSession session = NSession.of();
        NVersion versionString = NVersion.get("0.5.5").get();
        try (InputStream foldersFileStream = NInputStreamMonitor.of().setSource(NPath.of(dotFilesUrl)).create();){
            session.getTerminal().printProgress(NMsg.ofC("%-8s %s", "browse", NCoreLogUtils.forProgress(NPath.of(baseUrl))));
            dotFilesContent = NIOUtils.loadString(foldersFileStream, false);
        }
        catch (IOException | UncheckedIOException | NIOException e) {
            session.getTerminal().printProgress(NMsg.ofC("%-8s %s", "not found", NCoreLogUtils.forProgress(NPath.of(baseUrl))));
        }
        if (dotFilesContent != null) {
            try {
                List<String> splitted = StringTokenizerUtils.splitNewLine(dotFilesContent);
                for (String s : splitted) {
                    if ((s = s.trim()).isEmpty()) continue;
                    if (s.startsWith("#")) {
                        if (!all.isEmpty() || !(s = s.substring(1).trim()).startsWith("version=")) continue;
                        versionString = NVersion.get(s.substring("version=".length()).trim()).get();
                        continue;
                    }
                    if (versionString.compareTo("0.5.7") < 0) {
                        if (files) {
                            all.add(s);
                            continue;
                        }
                        break;
                    }
                    all.add(s);
                }
            }
            catch (UncheckedIOException | NIOException ex) {
                NLog.of(DotfilefsPath.class).log(NMsg.ofC("unable to navigate : %s", dotFilesUrl).asFineFail().withDurationMillis(c.stop().getDurationMs()));
            }
        }
        if (versionString.compareTo("0.5.7") < 0 && folders) {
            String[] dotFoldersContent = null;
            String dotFolderUrl = NStringUtils.pjoin("/", baseUrl, ".folder");
            c = NChronometer.startNow();
            try (InputStream stream = NInputStreamMonitor.of().setSource(NPath.of(dotFolderUrl)).create();){
                dotFoldersContent = (String[])StringTokenizerUtils.splitNewLine(NIOUtils.loadString(stream, true)).stream().map(x -> x.trim()).filter(x -> !x.isEmpty()).toArray(String[]::new);
            }
            catch (IOException | UncheckedIOException | NIOException ex) {
                NLog.of(DotfilefsPath.class).log(NMsg.ofC("unable to navigate : file not found %s", dotFolderUrl).asFineFail().withDurationMillis(c.stop().getDurationMs()));
            }
            if (dotFoldersContent != null) {
                for (String folder : dotFoldersContent) {
                    if (!folder.endsWith("/")) {
                        folder = folder + "/";
                    }
                    all.add(folder);
                }
            }
        }
        return all;
    }

    @Override
    public boolean isLocal(NPath basePath) {
        return this.ref.isLocal();
    }

    private static class MyPathFormat
    implements NFormatSPI {
        private final DotfilefsPath p;

        public MyPathFormat(DotfilefsPath p) {
            this.p = p;
        }

        public NText asFormattedString() {
            NTextBuilder sb = NTextBuilder.of();
            sb.append((Object)"html", NTextStyle.primary1());
            sb.append((Object)":", NTextStyle.separator());
            sb.append(this.p.ref);
            return sb.build();
        }

        @Override
        public String getName() {
            return "path";
        }

        @Override
        public void print(NPrintStream out) {
            out.print(this.asFormattedString());
        }

        @Override
        public boolean configureFirst(NCmdLine cmdLine) {
            return false;
        }
    }

    public static class DotfilefsFactory
    implements NPathFactorySPI {
        @Override
        public NScoredCallable<NPathSPI> createPath(String path, String protocol, ClassLoader classLoader) {
            if (path.startsWith(DotfilefsPath.PREFIX)) {
                return NScoredCallable.of(10, () -> new DotfilefsPath(path));
            }
            return null;
        }

        @Override
        public int getScore(NScorableContext context) {
            String path = (String)context.getCriteria();
            if (path.startsWith(DotfilefsPath.PREFIX)) {
                return 10;
            }
            return -1;
        }
    }
}

