/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.io.path.spi;

import java.util.Objects;
import net.thevpc.nuts.concurrent.NScoredCallable;
import net.thevpc.nuts.io.NIOException;
import net.thevpc.nuts.io.NPath;
import net.thevpc.nuts.runtime.standalone.io.path.spi.URLPath;
import net.thevpc.nuts.spi.NPathFactorySPI;
import net.thevpc.nuts.spi.NPathSPI;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.util.NScorableContext;

public class ClassLoaderPath
extends URLPath {
    private final String path;
    private final String effectivePath;
    private final ClassLoader loader;

    private static String fileOf(String path, boolean check) {
        if (path != null && path.startsWith("classpath:")) {
            String p = path;
            p = p.substring("classpath:".length());
            while (p.startsWith("/")) {
                p = p.substring(1);
            }
            return p;
        }
        if (check) {
            throw new NIOException(NMsg.ofC("invalid class path file : %s", path));
        }
        return null;
    }

    public ClassLoaderPath(String path, ClassLoader loader) {
        super(loader.getResource(ClassLoaderPath.fileOf(path, true)), true);
        this.path = path;
        this.effectivePath = ClassLoaderPath.fileOf(path, false);
        this.loader = loader;
    }

    @Override
    public String toString() {
        return "classpath:" + this.effectivePath;
    }

    @Override
    public String getName(NPath basePath) {
        return URLPath.getURLName(this.effectivePath);
    }

    @Override
    public String getLocation(NPath basePath) {
        if (this.url != null) {
            return super.getLocation(basePath);
        }
        return this.effectivePath;
    }

    @Override
    public String getProtocol(NPath basePath) {
        return "classpath";
    }

    @Override
    protected NPath rebuildURLPath(String other) {
        return NPath.of(new ClassLoaderPath(other, this.loader));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClassLoaderPath that = (ClassLoaderPath)o;
        return Objects.equals(this.effectivePath, that.effectivePath) && Objects.equals(this.loader, that.loader);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.effectivePath, this.loader);
    }

    public static class ClasspathFactory
    implements NPathFactorySPI {
        @Override
        public NScoredCallable<NPathSPI> createPath(String path, String protocol, ClassLoader classLoader) {
            try {
                if (path.startsWith("classpath:")) {
                    return NScoredCallable.of(10, () -> new ClassLoaderPath(path, classLoader));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }

        @Override
        public int getScore(NScorableContext context) {
            String path = (String)context.getCriteria();
            if (path.startsWith("classpath:")) {
                return 10;
            }
            return -1;
        }
    }
}

