/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.io.path.spi;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Path;
import java.time.Instant;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.thevpc.nuts.cmdline.NCmdLine;
import net.thevpc.nuts.io.NPath;
import net.thevpc.nuts.io.NPathOption;
import net.thevpc.nuts.io.NPathPermission;
import net.thevpc.nuts.io.NPathType;
import net.thevpc.nuts.io.NPrintStream;
import net.thevpc.nuts.spi.NFormatSPI;
import net.thevpc.nuts.spi.NPathSPI;
import net.thevpc.nuts.text.NText;
import net.thevpc.nuts.text.NTextBuilder;
import net.thevpc.nuts.text.NTreeVisitor;
import net.thevpc.nuts.util.NOptional;
import net.thevpc.nuts.util.NStream;

public abstract class AbstractPathSPIAdapter
implements NPathSPI {
    protected NPath ref;

    protected AbstractPathSPIAdapter(NPath ref) {
        this.ref = ref;
    }

    public int hashCode() {
        return this.ref.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractPathSPIAdapter urlPath = (AbstractPathSPIAdapter)o;
        return Objects.equals(this.ref, urlPath.ref);
    }

    @Override
    public String toString() {
        return this.ref.toString();
    }

    @Override
    public NStream<NPath> list(NPath basePath) {
        return this.ref.stream();
    }

    @Override
    public NFormatSPI formatter(NPath basePath) {
        return new MyPathFormat(this);
    }

    @Override
    public String getName(NPath basePath) {
        return this.ref.getName();
    }

    @Override
    public String getProtocol(NPath basePath) {
        return this.ref.getProtocol();
    }

    @Override
    public NPath resolve(NPath basePath, String path) {
        return this.ref.resolve(path);
    }

    @Override
    public NPath resolveSibling(NPath basePath, String path) {
        return this.ref.resolveSibling(path);
    }

    @Override
    public NPath toCompressedForm(NPath basePath) {
        return null;
    }

    @Override
    public NOptional<URL> toURL(NPath basePath) {
        return this.ref.toURL();
    }

    @Override
    public NOptional<Path> toPath(NPath basePath) {
        return this.ref.toPath();
    }

    @Override
    public NPathType getType(NPath basePath) {
        return this.ref.type();
    }

    @Override
    public boolean exists(NPath basePath) {
        return this.ref.exists();
    }

    @Override
    public long getContentLength(NPath basePath) {
        return this.ref.getContentLength();
    }

    @Override
    public String getContentEncoding(NPath basePath) {
        return this.ref.contentEncoding();
    }

    @Override
    public String getContentType(NPath basePath) {
        return this.ref.getContentType();
    }

    @Override
    public String getCharset(NPath basePath) {
        return this.ref.getCharset();
    }

    @Override
    public String getLocation(NPath basePath) {
        return this.ref.getLocation();
    }

    @Override
    public InputStream getInputStream(NPath basePath, NPathOption ... options) {
        return this.ref.getInputStream(options);
    }

    @Override
    public OutputStream getOutputStream(NPath basePath, NPathOption ... options) {
        return this.ref.getOutputStream(options);
    }

    @Override
    public void delete(NPath basePath, boolean recurse) {
        this.ref.delete(recurse);
    }

    @Override
    public void mkdir(boolean parents, NPath basePath) {
        this.ref.delete(parents);
    }

    @Override
    public Instant getLastModifiedInstant(NPath basePath) {
        return this.ref.getLastModifiedInstant();
    }

    @Override
    public Instant getLastAccessInstant(NPath basePath) {
        return this.ref.getLastAccessInstant();
    }

    @Override
    public Instant getCreationInstant(NPath basePath) {
        return this.ref.getCreationInstant();
    }

    @Override
    public NPath getParent(NPath basePath) {
        return this.ref.getParent();
    }

    @Override
    public NPath toAbsolute(NPath basePath, NPath rootPath) {
        if (this.isAbsolute(basePath)) {
            return basePath;
        }
        return basePath.toAbsolute();
    }

    @Override
    public NPath normalize(NPath basePath) {
        return basePath.normalize();
    }

    @Override
    public boolean isAbsolute(NPath basePath) {
        return this.ref.isAbsolute();
    }

    @Override
    public String getOwner(NPath basePath) {
        return this.ref.owner();
    }

    @Override
    public String getGroup(NPath basePath) {
        return this.ref.group();
    }

    @Override
    public Set<NPathPermission> getPermissions(NPath basePath) {
        return this.ref.getPermissions();
    }

    @Override
    public void setPermissions(NPath basePath, NPathPermission ... permissions) {
        this.ref.setPermissions(permissions);
    }

    @Override
    public void addPermissions(NPath basePath, NPathPermission ... permissions) {
        this.ref.addPermissions(permissions);
    }

    @Override
    public void removePermissions(NPath basePath, NPathPermission ... permissions) {
        this.ref.removePermissions(permissions);
    }

    @Override
    public Boolean isName(NPath basePath) {
        return this.ref.isName();
    }

    @Override
    public Integer getNameCount(NPath basePath) {
        return this.ref.getNameCount();
    }

    @Override
    public Boolean isRoot(NPath basePath) {
        return this.ref.isRoot();
    }

    @Override
    public boolean isLocal(NPath basePath) {
        return this.ref.isLocal();
    }

    @Override
    public NPath getRoot(NPath basePath) {
        if (this.isRoot(basePath).booleanValue()) {
            return basePath;
        }
        return this.ref.getRoot();
    }

    @Override
    public NStream<NPath> walk(NPath basePath, int maxDepth, NPathOption[] options) {
        return null;
    }

    @Override
    public NPath subpath(NPath basePath, int beginIndex, int endIndex) {
        return this.ref.subpath(beginIndex, endIndex);
    }

    @Override
    public List<String> getNames(NPath basePath) {
        return this.ref.getNames();
    }

    @Override
    public boolean moveTo(NPath basePath, NPath other, NPathOption ... options) {
        this.ref.moveTo(other, new NPathOption[0]);
        return true;
    }

    @Override
    public boolean copyTo(NPath basePath, NPath other, NPathOption ... options) {
        this.ref.copyTo(other, new NPathOption[0]);
        return true;
    }

    @Override
    public boolean walkDfs(NPath basePath, NTreeVisitor<NPath> visitor, int maxDepth, NPathOption ... options) {
        return false;
    }

    @Override
    public byte[] getDigest(NPath basePath, String algo) {
        return this.ref.getDigest();
    }

    @Override
    public Integer compareTo(NPath basePath, NPath other) {
        return this.ref.compareTo(other);
    }

    private static class MyPathFormat
    implements NFormatSPI {
        private final AbstractPathSPIAdapter p;

        public MyPathFormat(AbstractPathSPIAdapter p) {
            this.p = p;
        }

        public NText asFormattedString() {
            NTextBuilder sb = NTextBuilder.of();
            sb.append(this.p.ref);
            return sb.build();
        }

        @Override
        public String getName() {
            return "path";
        }

        @Override
        public void print(NPrintStream out) {
            out.print(this.asFormattedString());
        }

        @Override
        public boolean configureFirst(NCmdLine cmdLine) {
            return false;
        }
    }
}

