/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.io.path;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.Stack;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.thevpc.nuts.core.NWorkspace;
import net.thevpc.nuts.io.DefaultNPathInfo;
import net.thevpc.nuts.io.NCp;
import net.thevpc.nuts.io.NIOException;
import net.thevpc.nuts.io.NIOUtils;
import net.thevpc.nuts.io.NInputSourceBuilder;
import net.thevpc.nuts.io.NOutputStreamBuilder;
import net.thevpc.nuts.io.NPath;
import net.thevpc.nuts.io.NPathChildDigestInfo;
import net.thevpc.nuts.io.NPathChildStringDigestInfo;
import net.thevpc.nuts.io.NPathInfo;
import net.thevpc.nuts.io.NPathOption;
import net.thevpc.nuts.io.NPathPermission;
import net.thevpc.nuts.io.NPathType;
import net.thevpc.nuts.platform.NStoreType;
import net.thevpc.nuts.runtime.standalone.io.path.DefaultNCompressedPathHelper;
import net.thevpc.nuts.runtime.standalone.io.path.DirectoryScanner;
import net.thevpc.nuts.runtime.standalone.io.path.NCompressedPath;
import net.thevpc.nuts.runtime.standalone.io.path.NPathBase;
import net.thevpc.nuts.runtime.standalone.io.path.spi.NPathSPIHelper;
import net.thevpc.nuts.runtime.standalone.io.path.spi.URLPath;
import net.thevpc.nuts.runtime.standalone.reflect.NUseDefaultUtils;
import net.thevpc.nuts.runtime.standalone.workspace.NWorkspaceVarExpansionFunction;
import net.thevpc.nuts.runtime.standalone.xtra.expr.StringPlaceHolderParser;
import net.thevpc.nuts.spi.NPathSPI;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.text.NTreeVisitor;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NHex;
import net.thevpc.nuts.util.NOptional;
import net.thevpc.nuts.util.NStream;
import net.thevpc.nuts.util.NStringUtils;

public class NPathFromSPI
extends NPathBase {
    private final NPathSPI base;
    private List<String> items;

    public NPathFromSPI(NPathSPI base) {
        this.base = base;
    }

    @Override
    public NPathSPI spi() {
        return this.base;
    }

    public NPathSPI getBase() {
        return this.base;
    }

    @Override
    public NStream<String> reversedLines(Charset cs) {
        NStream<String> rl = this.spi().reversedLines(this, cs);
        if (rl == null) {
            return super.reversedLines(cs);
        }
        return rl;
    }

    @Override
    public NStream<String> lines(Charset cs) {
        return super.lines(cs);
    }

    @Override
    public NPath copy() {
        return new NPathFromSPI(this.base).copyExtraFrom(this);
    }

    @Override
    public String contentEncoding() {
        return this.base.getContentEncoding(this);
    }

    @Override
    public String getContentType() {
        return this.base.getContentType(this);
    }

    @Override
    public String getCharset() {
        return this.base.getCharset(this);
    }

    @Override
    public String getName() {
        String n = this.base.getName(this);
        if (n == null) {
            String loc = this.getLocation();
            return loc == null ? "" : URLPath.getURLName(loc);
        }
        return n;
    }

    @Override
    public String getLocation() {
        String ss;
        String p = this.base.getLocation(this);
        if (p != null) {
            return p;
        }
        String str = this.toString();
        int u = str.indexOf(58);
        if (u > 0 && (ss = str.substring(0, u)).matches("[a-zA-Z][a-zA-Z-_0-9]*")) {
            String a = str.substring(u + 1);
            if (a.startsWith("//")) {
                return a.substring(1);
            }
            return a;
        }
        return str;
    }

    @Override
    public NPath resolve(String other) {
        if (NBlankable.isBlank(other)) {
            return this;
        }
        NPath p = this.base.resolve(this, other);
        if (p != null) {
            return p;
        }
        String old = this.toString();
        return NPath.of(NStringUtils.pjoin("/", old, other));
    }

    @Override
    public NPath resolveChild(String other) {
        if (NBlankable.isBlank(other)) {
            return this;
        }
        while (other.startsWith("/") || other.startsWith("\\")) {
            other = other.substring(1);
        }
        if (NBlankable.isBlank(other)) {
            return this;
        }
        return this.resolve(other);
    }

    @Override
    public NPath resolveChild(NPath other) {
        String loc = other.getLocation();
        while (loc.startsWith("/") || loc.startsWith("\\")) {
            loc = loc.substring(1);
        }
        NPath p = this.base.resolve(this, loc);
        if (p != null) {
            return p;
        }
        String old = this.toString();
        return NPath.of(NStringUtils.pjoin("/", old, loc));
    }

    @Override
    public NPath resolve(NPath other) {
        NPath p = this.base.resolve(this, other.getLocation());
        if (p != null) {
            return p;
        }
        String old = this.toString();
        return NPath.of(NStringUtils.pjoin("/", old, other.getLocation()));
    }

    @Override
    public NPath resolveSibling(String other) {
        if (NBlankable.isBlank(other)) {
            return this.getParent();
        }
        NPath p = this.base.resolveSibling(this, other);
        if (p != null) {
            return p;
        }
        NPath parent = this.getParent();
        return parent.resolve(other);
    }

    @Override
    public NPath resolveSibling(NPath other) {
        if (NBlankable.isBlank(other)) {
            return this.getParent();
        }
        NPath p = this.base.resolveSibling(this, other.getLocation());
        if (p != null) {
            return p;
        }
        NPath parent = this.getParent();
        return parent.resolve(other);
    }

    @Override
    public byte[] readBytes(NPathOption ... options) {
        byte[] byArray;
        block23: {
            long len = this.getContentLength();
            int readSize = 1024;
            if (len < 0L) {
                byte[] byArray2;
                block22: {
                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                    byte[] buffer = new byte[readSize];
                    InputStream is = this.getInputStream(options);
                    try {
                        int count = 0;
                        boolean offset = false;
                        while ((count = is.read(buffer, 0, readSize)) > 0) {
                            bos.write(buffer, 0, count);
                        }
                        byArray2 = bos.toByteArray();
                        if (is == null) break block22;
                    }
                    catch (Throwable count) {
                        try {
                            if (is != null) {
                                try {
                                    is.close();
                                }
                                catch (Throwable offset) {
                                    count.addSuppressed(offset);
                                }
                            }
                            throw count;
                        }
                        catch (IOException e) {
                            throw new NIOException(NMsg.ofC("unable to read file %s", this), (Throwable)e);
                        }
                    }
                    is.close();
                }
                return byArray2;
            }
            int ilen = (int)len;
            if (len > 0x7FFFFFF7L) {
                throw new NIOException(NMsg.ofC("file is too large %s", this));
            }
            byte[] buffer = new byte[ilen];
            InputStream is = this.getInputStream(options);
            try {
                int count = 0;
                int offset = 0;
                while ((count = is.read(buffer, offset, ilen - offset)) > 0) {
                    offset += count;
                }
                if (offset < ilen) {
                    throw new NIOException(NMsg.ofC("premature read stop %s", this));
                }
                if (is.read() >= 0) {
                    throw new NIOException(NMsg.ofC("invalid %s", this));
                }
                byArray = buffer;
                if (is == null) break block23;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new NIOException(NMsg.ofC("unable to read file %s", this), (Throwable)e);
                }
            }
            is.close();
        }
        return byArray;
    }

    @Override
    public NPath writeBytes(byte[] bytes, NPathOption ... options) {
        try (OutputStream os = this.getOutputStream();){
            os.write(bytes);
        }
        catch (IOException ex) {
            throw new NIOException(NMsg.ofC("unable to write to %s", this));
        }
        return this;
    }

    @Override
    public String getProtocol() {
        String n = this.base.getProtocol(this);
        if (n == null) {
            String ts = this.base.toString();
            int i = ts.indexOf(58);
            if (i >= 0) {
                return ts.substring(0, i);
            }
            return null;
        }
        return n;
    }

    @Override
    public NPath toCompressedForm() {
        NPath n = this.base.toCompressedForm(this);
        if (n == null) {
            return new NCompressedPath(this, new DefaultNCompressedPathHelper());
        }
        return n;
    }

    @Override
    public NOptional<URL> toURL() {
        return this.base.toURL(this);
    }

    @Override
    public NOptional<Path> toPath() {
        return this.base.toPath(this);
    }

    @Override
    public NOptional<File> toFile() {
        return this.base.toPath(this).map(Path::toFile);
    }

    @Override
    public NStream<NPath> stream() {
        NStream<NPath> p = this.base.list(this);
        if (p != null) {
            return p;
        }
        return NStream.ofEmpty();
    }

    @Override
    public InputStream getInputStream(NPathOption ... options) {
        return NInputSourceBuilder.of(this.base.getInputStream(this, options)).setMetadata(this.getMetaData()).createInputStream();
    }

    @Override
    public OutputStream getOutputStream(NPathOption ... options) {
        return NOutputStreamBuilder.of(this.base.getOutputStream(this, options)).setMetadata(this.getMetaData()).createOutputStream();
    }

    @Override
    public NPath deleteTree() {
        this.base.delete(this, true);
        return this;
    }

    @Override
    public NPath ensureEmptyDirectory() {
        if (this.exists()) {
            if (this.isDirectory()) {
                try (NStream<NPath> stream = this.stream();){
                    stream.forEach(x -> x.deleteTree());
                }
            } else {
                this.deleteTree();
                this.mkdirs();
            }
        } else {
            this.mkdir(true);
        }
        return this;
    }

    @Override
    public NPath ensureEmptyFile() {
        this.mkParentDirs();
        if (this.exists() && !this.isRegularFile()) {
            this.deleteTree();
        }
        this.writeBytes(new byte[0], new NPathOption[0]);
        return this;
    }

    @Override
    public NPath delete(boolean recurse) {
        this.base.delete(this, recurse);
        return this;
    }

    @Override
    public NPath mkdir(boolean parents) {
        this.base.mkdir(parents, this);
        return this;
    }

    @Override
    public NPath mkdirs() {
        this.base.mkdir(true, this);
        return this;
    }

    @Override
    public NPath mkdir() {
        this.base.mkdir(false, this);
        return this;
    }

    @Override
    public NPath expandPath(Function<String, String> resolver) {
        resolver = new EffectiveResolver(resolver);
        String s = StringPlaceHolderParser.replaceDollarPlaceHolders(this.toString(), resolver);
        if (s.length() > 0 && s.startsWith("~")) {
            if (s.equals("~~")) {
                NWorkspace workspace = NWorkspace.of();
                NPath nutsHome = workspace.getHomeLocation(NStoreType.CONF);
                return nutsHome.normalize();
            }
            if (s.startsWith("~~") && s.length() > 2 && (s.charAt(2) == '/' || s.charAt(2) == '\\')) {
                NWorkspace workspace = NWorkspace.of();
                NPath nutsHome = workspace.getHomeLocation(NStoreType.CONF);
                return nutsHome.resolve(s.substring(3)).normalize();
            }
            if (s.equals("~")) {
                return NPath.ofUserHome();
            }
            if (s.startsWith("~") && s.length() > 1 && (s.charAt(1) == '/' || s.charAt(1) == '\\')) {
                return NPath.ofUserHome().resolve(s.substring(2));
            }
            return NPath.of(s);
        }
        return NPath.of(s);
    }

    @Override
    public NPath mkParentDirs() {
        NPath p = this.getParent();
        if (p != null) {
            p.mkdir(true);
        }
        return this;
    }

    @Override
    public boolean isOther() {
        return this.base.getType(this) == NPathType.OTHER;
    }

    @Override
    public boolean isSymbolicLink() {
        return this.base.getType(this) == NPathType.SYMBOLIC_LINK;
    }

    @Override
    public boolean isDirectory() {
        return this.base.getType(this) == NPathType.DIRECTORY;
    }

    @Override
    public boolean isRegularFile() {
        return this.base.getType(this) == NPathType.FILE;
    }

    @Override
    public boolean isRemote() {
        return !this.base.isLocal(this);
    }

    @Override
    public boolean isLocal() {
        return this.base.isLocal(this);
    }

    @Override
    public boolean exists() {
        return this.base.exists(this);
    }

    @Override
    public long getContentLength() {
        return this.base.getContentLength(this);
    }

    @Override
    public Instant getLastModifiedInstant() {
        return this.base.getLastModifiedInstant(this);
    }

    @Override
    public Instant getLastAccessInstant() {
        return this.base.getLastAccessInstant(this);
    }

    @Override
    public Instant getCreationInstant() {
        return this.base.getCreationInstant(this);
    }

    @Override
    public NPath getParent() {
        NPath p = this.base.getParent(this);
        if (p != null) {
            return p;
        }
        if (this.isRoot()) {
            return this;
        }
        List<String> names = this.getNames();
        List<String> items = names.subList(0, names.size() - 1);
        NPath root = this.getRoot();
        for (String item : items) {
            root = root.resolve(item);
        }
        return root;
    }

    @Override
    public boolean isAbsolute() {
        return this.base.isAbsolute(this);
    }

    @Override
    public NPath normalize() {
        NPath p = this.base.normalize(this);
        if (p != null) {
            return p;
        }
        if (this.isRoot()) {
            return this;
        }
        List<String> names = this.getNames();
        NPath root = this.getRoot();
        List<String> newNames = NIOUtils.normalizePathNames(names);
        if (newNames.size() != names.size()) {
            for (String item : newNames) {
                root = root.resolve(item);
            }
            return root;
        }
        return this;
    }

    @Override
    public NPath toAbsolute() {
        return this.toAbsolute((NPath)null);
    }

    @Override
    public NPath toAbsolute(String rootPath) {
        return this.toAbsolute(rootPath == null ? null : NPath.of(rootPath));
    }

    @Override
    public NPath toAbsolute(NPath rootPath) {
        if (this.base.isAbsolute(this)) {
            return this;
        }
        NPath p = this.base.toAbsolute(this, rootPath);
        if (p != null) {
            return p;
        }
        if (rootPath == null) {
            return this.normalize();
        }
        return rootPath.toAbsolute().resolve(this);
    }

    @Override
    public String owner() {
        return this.base.getOwner(this);
    }

    @Override
    public String group() {
        return this.base.getGroup(this);
    }

    @Override
    public Set<NPathPermission> getPermissions() {
        return this.base.getPermissions(this);
    }

    @Override
    public NPath setPermissions(NPathPermission ... permissions) {
        this.base.setPermissions(this, permissions);
        return this;
    }

    @Override
    public NPath addPermissions(NPathPermission ... permissions) {
        this.base.addPermissions(this, permissions);
        return this;
    }

    @Override
    public NPath removePermissions(NPathPermission ... permissions) {
        this.base.removePermissions(this, permissions);
        return this;
    }

    @Override
    public boolean isName() {
        Boolean b = this.base.isName(this);
        if (b == null) {
            if (this.getNameCount() > 1) {
                return false;
            }
            String v = this.toString();
            switch (v) {
                case "/": 
                case "\\": 
                case ".": 
                case "..": {
                    return false;
                }
            }
            for (Object c : (String)v.toCharArray()) {
                switch (c) {
                    case 47: 
                    case 92: {
                        return false;
                    }
                }
            }
            return true;
        }
        return b;
    }

    @Override
    public int getNameCount() {
        Integer r = this.base.getNameCount(this);
        if (r != 0) {
            return r;
        }
        return this.getNames().size();
    }

    @Override
    public List<NPathChildDigestInfo> listDigestInfo() {
        return this.listDigestInfo(null);
    }

    @Override
    public List<NPathChildDigestInfo> listDigestInfo(String algo) {
        List<NPathChildDigestInfo> infos = this.base.listDigestInfo(this, algo);
        if (infos != null) {
            return infos;
        }
        return this.list().stream().map(x -> new NPathChildDigestInfo().setName(x.getName()).setDigest(x.getDigest(algo))).collect(Collectors.toList());
    }

    @Override
    public List<NPathChildStringDigestInfo> listStringDigestInfo() {
        return this.listStringDigestInfo(null);
    }

    @Override
    public List<NPathChildStringDigestInfo> listStringDigestInfo(String algo) {
        List<NPathChildDigestInfo> infos = this.base.listDigestInfo(this, algo);
        if (infos != null) {
            return infos.stream().map(x -> new NPathChildStringDigestInfo().setName(x.getName()).setDigest(NHex.fromBytes(x.getDigest()))).collect(Collectors.toList());
        }
        return this.list().stream().map(x -> new NPathChildStringDigestInfo().setName(x.getName()).setDigest(NHex.fromBytes(x.getDigest()))).collect(Collectors.toList());
    }

    @Override
    public boolean isRoot() {
        Boolean b = this.base.isRoot(this);
        if (b != null) {
            return b;
        }
        return this.getNameCount() == 0;
    }

    @Override
    public NStream<NPath> walk(int maxDepth, NPathOption[] options) {
        NPathOption[] options1;
        NPathOption[] nPathOptionArray = options1 = options == null ? new NPathOption[]{} : (NPathOption[])Arrays.stream(options).filter(Objects::isNull).distinct().toArray(NPathOption[]::new);
        if (maxDepth <= 0) {
            maxDepth = Integer.MAX_VALUE;
        }
        if (NUseDefaultUtils.isUseDefault(this.base.getClass(), "walk", NPath.class, Integer.TYPE, NPathOption[].class)) {
            return NPathSPIHelper.walk(this, maxDepth, options1);
        }
        NStream<NPath> walked = this.base.walk(this, maxDepth, options);
        if (walked != null) {
            return walked;
        }
        return NPathSPIHelper.walk(this, maxDepth, options1);
    }

    @Override
    public NPath subpath(int beginIndex, int endIndex) {
        NPath subpath = this.base.subpath(this, beginIndex, endIndex);
        if (subpath != null) {
            return subpath;
        }
        List<String> items = this.getNames().subList(beginIndex, endIndex);
        NPath root = this.getRoot();
        for (String item : items) {
            root = root.resolve(item);
        }
        return root;
    }

    @Override
    public String getName(int index) {
        List<String> names = this.getNames();
        if (index >= 0 && index < names.size()) {
            return names.get(index);
        }
        if (index < 0 && -index < names.size()) {
            return names.get(names.size() + index);
        }
        throw new ArrayIndexOutOfBoundsException("invalid index " + index + ". it must be >=0 and <" + names.size());
    }

    @Override
    public List<String> getNames() {
        if (this.items == null) {
            this.items = this.base.getNames(this);
            if (this.items == null) {
                String location = this.getLocation();
                this.items = NStringUtils.split(location, "/", true, true);
            }
        }
        return this.items;
    }

    @Override
    public void moveTo(NPath other, NPathOption ... options) {
        if (!this.base.moveTo(this, other, new NPathOption[0])) {
            this.copyTo(other, options);
            this.delete(true);
        }
    }

    @Override
    public void copyTo(NPath other, NPathOption ... options) {
        if (!this.base.copyTo(this, other, options)) {
            try (InputStream in = this.getInputStream(options);){
                NCp.of().from(in).to(other).addOptions(options).run();
            }
            catch (Exception e) {
                throw new NIOException(e);
            }
        }
    }

    @Override
    public NPath getRoot() {
        return this.base.getRoot(this);
    }

    @Override
    public NPath walkDfs(NTreeVisitor<NPath> visitor, NPathOption ... options) {
        return this.walkDfs(visitor, Integer.MAX_VALUE, options);
    }

    @Override
    public NPath walkDfs(NTreeVisitor<NPath> visitor, int maxDepth, NPathOption ... options) {
        if (maxDepth <= 0) {
            maxDepth = Integer.MAX_VALUE;
        }
        if (NUseDefaultUtils.isUseDefault(this.base.getClass(), "walkDfs", NPath.class, NTreeVisitor.class, Integer.TYPE, NPathOption[].class)) {
            NPathSPIHelper.walkDfs(this, visitor, maxDepth, options);
        } else {
            boolean r = this.base.walkDfs(this, visitor, maxDepth, options);
            if (!r) {
                Stack<NPath> stack = new Stack<NPath>();
                Stack<Boolean> visitedStack = new Stack<Boolean>();
                stack.push(this);
                visitedStack.push(false);
                while (!stack.isEmpty()) {
                    NPath currentPath = (NPath)stack.pop();
                    boolean visited = (Boolean)visitedStack.pop();
                    if (visited) {
                        visitor.postVisitDirectory(currentPath, null);
                        continue;
                    }
                    if (currentPath.isDirectory()) {
                        visitor.preVisitDirectory(currentPath);
                        stack.push(currentPath);
                        visitedStack.push(true);
                        try {
                            if (maxDepth <= 0) continue;
                            for (NPath nPath : currentPath.list()) {
                                stack.push(nPath);
                                visitedStack.push(false);
                            }
                            continue;
                        }
                        catch (RuntimeException e) {
                            visitor.postVisitDirectory(currentPath, e);
                            continue;
                        }
                    }
                    visitor.visitFile(currentPath);
                }
            }
        }
        return this;
    }

    @Override
    public NStream<NPath> walkGlob(NPathOption ... options) {
        return new DirectoryScanner(this).stream();
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.base);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NPathFromSPI that = (NPathFromSPI)o;
        return Objects.equals(this.base, that.base);
    }

    @Override
    public String toString() {
        return this.base.toString();
    }

    @Override
    public byte[] getDigest(String algo) {
        byte[] digest;
        if (NBlankable.isBlank(algo)) {
            algo = "SHA-1";
        }
        if ((digest = this.base.getDigest(this, algo)) == null) {
            return super.getDigest(algo);
        }
        return digest;
    }

    @Override
    public boolean isEqOrDeepChildOf(NPath other) {
        if (other == null) {
            return false;
        }
        return !this.toRelative(other).isPresent();
    }

    @Override
    public NPathType type() {
        return this.base.getType(this);
    }

    @Override
    public NOptional<String> toRelative(NPath parentPath) {
        NOptional<String> r = this.base.toRelative(this, NPathFromSPI.unwrapPath(parentPath));
        if (r != null) {
            return r;
        }
        String child = this.getLocation();
        String parent = parentPath.getLocation();
        return NOptional.ofNamed(NIOUtils.toRelativePath(child, parent), "relative path");
    }

    @Override
    public boolean startsWith(NPath other) {
        return this.toRelative(NPathFromSPI.unwrapPath(other)).orNull() != null;
    }

    @Override
    public int compareTo(NPath other) {
        if (other == null) {
            return 1;
        }
        Integer r = this.base.compareTo(this, NPathFromSPI.unwrapPath(other));
        if (r != null) {
            return r;
        }
        return this.toString().compareTo(other.toString());
    }

    @Override
    public boolean startsWith(String other) {
        return this.toRelative(NPath.of(other)).orNull() != null;
    }

    @Override
    public NPathInfo getInfo() {
        NPathInfo i = this.base.getInfo(this);
        if (i != null) {
            return i;
        }
        NPathType type = this.type();
        return new DefaultNPathInfo(this.getLocation(), type, null, null, this.getContentLength(), type == NPathType.SYMBOLIC_LINK, this.getLastModifiedInstant(), this.getLastAccessInstant(), this.getCreationInstant(), this.getPermissions(), this.owner(), this.group());
    }

    @Override
    public List<NPathInfo> listInfos() {
        List<NPathInfo> r = this.getBase().listInfos(this);
        if (r != null) {
            return r;
        }
        return this.list().stream().map(x -> x.getInfo()).collect(Collectors.toList());
    }

    private static class EffectiveResolver
    implements Function<String, String> {
        NWorkspaceVarExpansionFunction fallback;
        Function<String, String> resolver;

        public EffectiveResolver(Function<String, String> resolver) {
            this.resolver = resolver;
            this.fallback = NWorkspaceVarExpansionFunction.of();
        }

        @Override
        public String apply(String s) {
            String v;
            if (this.resolver != null && (v = this.resolver.apply(s)) != null) {
                return v;
            }
            return this.fallback.apply(s);
        }
    }
}

