/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.io.path;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.thevpc.nuts.artifact.NVersion;
import net.thevpc.nuts.cmdline.NCmdLine;
import net.thevpc.nuts.io.DefaultNPathMetadata;
import net.thevpc.nuts.io.NContentMetadata;
import net.thevpc.nuts.io.NDigest;
import net.thevpc.nuts.io.NIOException;
import net.thevpc.nuts.io.NInputStreamProvider;
import net.thevpc.nuts.io.NPath;
import net.thevpc.nuts.io.NPathExtensionType;
import net.thevpc.nuts.io.NPathNameParts;
import net.thevpc.nuts.io.NPathOption;
import net.thevpc.nuts.io.NPathRenameOptions;
import net.thevpc.nuts.io.NPathType;
import net.thevpc.nuts.io.NPrintStream;
import net.thevpc.nuts.runtime.standalone.format.DefaultFormatBase;
import net.thevpc.nuts.runtime.standalone.io.path.NCompressedPath;
import net.thevpc.nuts.runtime.standalone.io.path.NCompressedPathBase;
import net.thevpc.nuts.runtime.standalone.io.util.AbstractMultiReadNInputSource;
import net.thevpc.nuts.spi.NPathSPIAware;
import net.thevpc.nuts.text.NFormat;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.text.NText;
import net.thevpc.nuts.text.NTextStyle;
import net.thevpc.nuts.util.NAssert;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NIllegalArgumentException;
import net.thevpc.nuts.util.NLiteral;
import net.thevpc.nuts.util.NScorableContext;
import net.thevpc.nuts.util.NStream;
import net.thevpc.nuts.util.NUnexpectedException;

public abstract class NPathBase
extends AbstractMultiReadNInputSource
implements NPath,
NPathSPIAware {
    public static final int BUFFER_SIZE = 8192;
    private DefaultNPathMetadata omd = new DefaultNPathMetadata(this);
    private boolean deleteOnDispose;

    @Override
    public InputStream getInputStream() {
        return this.getInputStream(new NPathOption[0]);
    }

    @Override
    public OutputStream getOutputStream() {
        return this.getOutputStream(new NPathOption[0]);
    }

    protected NPath copyExtraFrom(NPath other) {
        this.deleteOnDispose = other.isDeleteOnDispose();
        if (other instanceof NPathBase) {
            this.omd.copyFrom(((NPathBase)other).omd);
        } else {
            this.omd.copyFrom(other.getMetaData());
            this.omd.copyFrom(other.getMetaData());
        }
        return this;
    }

    @Override
    public boolean isKnownContentLength() {
        return true;
    }

    @Override
    public PrintStream getPrintStream(Charset cs, NPathOption ... options) {
        OutputStream out = this.getOutputStream(options);
        if (out instanceof PrintStream) {
            return (PrintStream)out;
        }
        try {
            return new PrintStream(out, false, this.nonNullCharset(cs).name());
        }
        catch (UnsupportedEncodingException e) {
            throw new NIllegalArgumentException(NMsg.ofPlain("unsupported encoding"), (Throwable)e);
        }
    }

    @Override
    public PrintStream getPrintStream(NPathOption ... options) {
        OutputStream out = this.getOutputStream(options);
        if (out instanceof PrintStream) {
            return (PrintStream)out;
        }
        return new PrintStream(out);
    }

    @Override
    public NPrintStream getNPrintStream(NPathOption ... options) {
        OutputStream out = this.getOutputStream(options);
        if (out instanceof NPrintStream) {
            return (NPrintStream)((Object)out);
        }
        return NPrintStream.of(out);
    }

    @Override
    public PrintStream getPrintStream() {
        OutputStream out = this.getOutputStream();
        if (out instanceof PrintStream) {
            return (PrintStream)out;
        }
        return new PrintStream(out);
    }

    @Override
    public BufferedReader getBufferedReader(NPathOption ... options) {
        return this.getBufferedReader((Charset)null, options);
    }

    @Override
    public BufferedReader getBufferedReader(Charset cs, NPathOption ... options) {
        Reader r = this.getReader(cs, options);
        if (r instanceof BufferedReader) {
            return (BufferedReader)r;
        }
        return new BufferedReader(r);
    }

    @Override
    public void copyToPrintStream(PrintStream other, NPathOption ... options) {
        this.copyToPrintStream(other, (Charset)null, options);
    }

    @Override
    public void copyToPrintStream(PrintStream other, Charset cs, NPathOption ... options) {
        try (Reader reader = this.getReader(options);){
            int count;
            char[] buffer = new char[8192];
            while ((count = reader.read(buffer)) > 0) {
                other.print(Arrays.copyOf(buffer, count));
            }
        }
        catch (IOException ex) {
            throw new NIOException(ex);
        }
    }

    @Override
    public void copyToOutputStream(OutputStream other, NPathOption ... options) {
        try (InputStream reader = this.getInputStream();){
            int count;
            byte[] buffer = new byte[8192];
            while ((count = reader.read(buffer)) > 0) {
                other.write(buffer, 0, count);
            }
        }
        catch (IOException ex) {
            throw new NIOException(ex);
        }
    }

    @Override
    public void copyFromInputStream(InputStream other, NPathOption ... options) {
        try (OutputStream out = this.getOutputStream();){
            int count;
            byte[] buffer = new byte[8192];
            while ((count = other.read(buffer)) > 0) {
                out.write(buffer, 0, count);
            }
        }
        catch (IOException ex) {
            throw new NIOException(ex);
        }
    }

    @Override
    public void copyFromInputStreamProvider(NInputStreamProvider other, NPathOption ... options) {
        try (InputStream in = other.getInputStream();
             OutputStream out = this.getOutputStream(options);){
            int count;
            byte[] buffer = new byte[8192];
            while ((count = in.read(buffer)) > 0) {
                out.write(buffer, 0, count);
            }
        }
        catch (IOException ex) {
            throw new NIOException(ex);
        }
    }

    @Override
    public void copyFromReader(Reader other, NPathOption ... options) {
        try (Writer writer = this.getWriter();){
            int count;
            char[] buffer = new char[8192];
            while ((count = other.read(buffer)) > 0) {
                writer.write(buffer, 0, count);
            }
        }
        catch (IOException ex) {
            throw new NIOException(ex);
        }
    }

    @Override
    public void copyFromReader(Reader other, Charset charset, NPathOption ... options) {
        try (Writer writer = this.getWriter(charset, options);){
            int count;
            char[] buffer = new char[8192];
            while ((count = other.read(buffer)) > 0) {
                writer.write(buffer, 0, count);
            }
        }
        catch (IOException ex) {
            throw new NIOException(ex);
        }
    }

    @Override
    public void copyFrom(NPath other, NPathOption ... options) {
        NAssert.requireNonNull(other, "other");
        other.copyTo(this, options);
    }

    @Override
    public void copyToWriter(Writer other, NPathOption ... options) {
        this.copyToWriter(other, (Charset)null, options);
    }

    @Override
    public void copyToWriter(Writer other, Charset cs, NPathOption ... options) {
        try (Reader reader = this.getReader(cs);){
            int count;
            char[] buffer = new char[8192];
            while ((count = reader.read(buffer)) > 0) {
                other.write(buffer, 0, count);
            }
        }
        catch (IOException ex) {
            throw new NIOException(ex);
        }
    }

    @Override
    public boolean isUserCache() {
        return this.omd.isUserCache();
    }

    @Override
    public NPath setUserCache(boolean userCache) {
        this.omd.setUserCache(userCache);
        return this;
    }

    @Override
    public boolean isUserTemporary() {
        return this.omd.isUserTemporary();
    }

    @Override
    public NPath setUserTemporary(boolean temporary) {
        this.omd.setUserTemporary(temporary);
        return this;
    }

    @Override
    public NPathNameParts nameParts() {
        return this.nameParts(NPathExtensionType.SMART);
    }

    @Override
    public NPath resolveSibling(NPathRenameOptions renameOptions) {
        if (renameOptions == null) {
            return this;
        }
        NPathExtensionType t = renameOptions.type();
        if (t == null) {
            t = NPathExtensionType.SMART;
        }
        String template = renameOptions.template();
        String extension = renameOptions.extension();
        if (!NBlankable.isBlank(template)) {
            return this.resolveSibling(this.nameParts(t).toName(template));
        }
        if (!NBlankable.isBlank(extension)) {
            return this.resolveSibling(this.nameParts(t).toNameWithExtension(extension));
        }
        return this;
    }

    @Override
    public NPathNameParts nameParts(NPathExtensionType type) {
        if (type == null) {
            type = NPathExtensionType.SHORT;
        }
        switch (type) {
            case SMART: {
                return this.getSmartFileNameParts();
            }
            case LONG: {
                String n = this.getName();
                int i = n.indexOf(46);
                if (i < 0) {
                    return new NPathNameParts(n, "", "", NPathExtensionType.LONG);
                }
                return new NPathNameParts(n.substring(0, i), n.substring(i + 1), n.substring(i), NPathExtensionType.LONG);
            }
            case SHORT: {
                String n = this.getName();
                int i = n.lastIndexOf(46);
                if (i < 0) {
                    return new NPathNameParts(n, "", "", NPathExtensionType.SHORT);
                }
                return new NPathNameParts(n.substring(0, i), n.substring(i + 1), n.substring(i), NPathExtensionType.SHORT);
            }
        }
        throw new NUnexpectedException(NMsg.ofC("%s not supported", type));
    }

    public NPathNameParts getSmartFileNameParts() {
        String n = this.getName();
        int li = n.indexOf(46);
        if (li < 0) {
            return new NPathNameParts(n, "", "", NPathExtensionType.SMART);
        }
        NLiteral[] vals = NVersion.get(n).get().split();
        int lastDot = -1;
        for (int i = vals.length - 1; i >= 0; --i) {
            NLiteral v = vals[i];
            String u = v.asString().get();
            if (!u.equals(".")) continue;
            if (i == vals.length - 1) {
                return this.rebuildSmartParts(vals, i);
            }
            NLiteral v2 = vals[i + 1];
            if (v2.asNumber().isPresent() && i > 0 && vals[i - 1].asNumber().isPresent()) {
                if (i + 1 == vals.length - 1) {
                    return this.rebuildSmartParts(vals, i + 2);
                }
                if (vals[i + 1].asString().get().equals(".")) {
                    return this.rebuildSmartParts(vals, i + 1);
                }
            }
            if (lastDot != -1) break;
            lastDot = i;
        }
        if (lastDot < 0) {
            return new NPathNameParts(n, "", ".", NPathExtensionType.SMART);
        }
        return this.rebuildSmartParts(vals, lastDot);
    }

    private NPathNameParts rebuildSmartParts(NLiteral[] vals, int split) {
        String fe = this.concatSmartParts(vals, split, vals.length);
        String e = fe.startsWith(".") ? fe.substring(1) : fe;
        return new NPathNameParts(this.concatSmartParts(vals, 0, split), e, fe, NPathExtensionType.SMART);
    }

    private String concatSmartParts(NLiteral[] vals, int from, int to) {
        StringBuilder sb = new StringBuilder();
        for (int i = from; i < to; ++i) {
            sb.append(vals[i].asString().get());
        }
        return sb.toString();
    }

    @Override
    public boolean isURL() {
        return this.toURL().isPresent();
    }

    @Override
    public boolean isFile() {
        return this.toFile().orNull() != null;
    }

    @Override
    public NPath delete() {
        return this.delete(false);
    }

    public NText toNutsString() {
        return NText.ofPlain(this.toString());
    }

    public int hashCode() {
        return Objects.hash(this.toString());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NPathBase that = (NPathBase)o;
        return Objects.equals(this.toString(), that.toString());
    }

    @Override
    public NStream<NPath> walk() {
        return this.walk(Integer.MAX_VALUE, new NPathOption[0]);
    }

    @Override
    public NStream<NPath> walk(NPathOption ... options) {
        return this.walk(Integer.MAX_VALUE, options);
    }

    @Override
    public NStream<NPath> walk(int maxDepth) {
        return this.walk(maxDepth <= 0 ? Integer.MAX_VALUE : maxDepth, new NPathOption[0]);
    }

    @Override
    public Writer getWriter() {
        return this.getWriter((Charset)null, new NPathOption[0]);
    }

    @Override
    public BufferedWriter getBufferedWriter() {
        return this.getBufferedWriter((Charset)null, new NPathOption[0]);
    }

    @Override
    public Writer getWriter(NPathOption ... options) {
        return this.getWriter((Charset)null, options);
    }

    @Override
    public Writer getWriter(Charset charset, NPathOption ... options) {
        return new OutputStreamWriter(this.getOutputStream(options), this.nonNullCharset(charset));
    }

    @Override
    public BufferedWriter getBufferedWriter(NPathOption ... options) {
        Writer w = this.getWriter(options);
        if (w instanceof BufferedWriter) {
            return (BufferedWriter)w;
        }
        return new BufferedWriter(w);
    }

    @Override
    public BufferedWriter getBufferedWriter(Charset charset, NPathOption ... options) {
        Writer w = this.getWriter(charset, options);
        if (w instanceof BufferedWriter) {
            return (BufferedWriter)w;
        }
        return new BufferedWriter(w);
    }

    @Override
    public Reader getReader(NPathOption ... options) {
        return this.getReader((Charset)null);
    }

    @Override
    public Reader getReader(Charset cs, NPathOption ... options) {
        CharsetDecoder decoder = this.nonNullCharset(cs).newDecoder();
        InputStreamReader reader = new InputStreamReader(this.getInputStream(options), decoder);
        return new BufferedReader(reader);
    }

    @Override
    public boolean isHttp() {
        if (!this.isURL()) {
            return false;
        }
        String s = this.toString();
        return s.startsWith("http://") || s.startsWith("https://");
    }

    @Override
    public NContentMetadata getMetaData() {
        return this.omd.getMetaData();
    }

    @Override
    public boolean isMultiRead() {
        return true;
    }

    @Override
    public void dispose() {
        if (this.isDeleteOnDispose()) {
            this.deleteTree();
        }
    }

    @Override
    public NPath writeString(String string, Charset cs, NPathOption ... options) {
        return this.writeBytes(string == null ? new byte[]{} : string.getBytes(this.nonNullCharset(cs)), new NPathOption[0]);
    }

    @Override
    public NPath writeString(String string, NPathOption ... options) {
        return this.writeString(string, (Charset)null, options);
    }

    @Override
    public String readString(NPathOption ... options) {
        return this.readString((Charset)null, options);
    }

    @Override
    public String readString(Charset cs, NPathOption ... options) {
        StringBuilder sb = new StringBuilder();
        char[] buffer = new char[8192];
        try (Reader reader = this.getReader(cs, options);){
            int len;
            while ((len = reader.read(buffer)) > 0) {
                sb.append(buffer, 0, len);
            }
        }
        catch (IOException ex) {
            throw new NIOException(ex);
        }
        return sb.toString();
    }

    @Override
    public List<NPath> list() {
        return this.stream().toList();
    }

    @Override
    public void setDeleteOnDispose(boolean deleteOnDispose) {
        this.deleteOnDispose = deleteOnDispose;
    }

    @Override
    public boolean isDeleteOnDispose() {
        return this.deleteOnDispose;
    }

    protected static NPath unwrapPath(NPath other) {
        if (other instanceof NCompressedPathBase) {
            other = ((NCompressedPathBase)other).getBase();
        }
        if (other instanceof NCompressedPath) {
            other = ((NCompressedPath)other).getBase();
        }
        return other;
    }

    @Override
    public byte[] getDigest(String algo) {
        NPathType type = this.type();
        switch (type) {
            case NOT_FOUND: {
                return new byte[0];
            }
            case DIRECTORY: {
                NDigest d = NDigest.of();
                d.setAlgorithm(algo);
                d.addSource(this.type().name().getBytes());
                for (NPath nPath : this.list()) {
                    d.addSource(nPath.getName().getBytes());
                }
                return d.computeBytes();
            }
            case FILE: {
                NDigest d = NDigest.of();
                d.setAlgorithm(algo);
                d.addSource(this.type().name().getBytes());
                d.addSource(this);
                return d.computeBytes();
            }
        }
        NDigest d = NDigest.of();
        d.setAlgorithm(algo);
        d.addSource(this.type().name().getBytes());
        return d.computeBytes();
    }

    public static class PathFormat
    extends DefaultFormatBase<NFormat> {
        private final NPathBase p;

        public PathFormat(NPathBase p) {
            super("path");
            this.p = p;
        }

        @Override
        public void print(NPrintStream out) {
            out.print(NText.ofStyled(this.p.toNutsString(), NTextStyle.path()));
        }

        @Override
        public boolean configureFirst(NCmdLine cmdLine) {
            return false;
        }

        @Override
        public int getScore(NScorableContext context) {
            return 10;
        }
    }
}

