/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.io.path;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Path;
import java.time.Instant;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import net.thevpc.nuts.cmdline.NCmdLine;
import net.thevpc.nuts.io.NInputSourceBuilder;
import net.thevpc.nuts.io.NOutputStreamBuilder;
import net.thevpc.nuts.io.NPath;
import net.thevpc.nuts.io.NPathChildDigestInfo;
import net.thevpc.nuts.io.NPathChildStringDigestInfo;
import net.thevpc.nuts.io.NPathInfo;
import net.thevpc.nuts.io.NPathOption;
import net.thevpc.nuts.io.NPathPermission;
import net.thevpc.nuts.io.NPathType;
import net.thevpc.nuts.io.NPrintStream;
import net.thevpc.nuts.runtime.standalone.format.DefaultFormatBase;
import net.thevpc.nuts.runtime.standalone.io.path.NPathBase;
import net.thevpc.nuts.runtime.standalone.io.util.NPathParts;
import net.thevpc.nuts.spi.NPathSPI;
import net.thevpc.nuts.spi.NPathSPIAware;
import net.thevpc.nuts.text.NFormat;
import net.thevpc.nuts.text.NText;
import net.thevpc.nuts.text.NTextStyle;
import net.thevpc.nuts.text.NTreeVisitor;
import net.thevpc.nuts.util.NOptional;
import net.thevpc.nuts.util.NScorableContext;
import net.thevpc.nuts.util.NStream;

public class NCompressedPathBase
extends NPathBase {
    private final String compressedForm;
    private final NText formattedCompressedForm;
    private final NPath base;

    public NCompressedPathBase(NPath base) {
        this.base = base;
        this.compressedForm = NCompressedPathBase.compressUrl(base.toString());
        this.formattedCompressedForm = NText.ofStyled(this.compressedForm, NTextStyle.path());
    }

    public NPath getBase() {
        return this.base;
    }

    public NCompressedPathBase(NPath base, String compressedForm, NText formattedCompressedForm) {
        this.compressedForm = compressedForm;
        this.formattedCompressedForm = formattedCompressedForm;
        this.base = base;
    }

    @Override
    public NPathSPI spi() {
        return ((NPathSPIAware)((Object)this.base)).spi();
    }

    @Override
    public boolean startsWith(NPath other) {
        return this.base.startsWith(other);
    }

    @Override
    public boolean startsWith(String other) {
        return this.base.startsWith(other);
    }

    @Override
    public NPath copy() {
        return new NCompressedPathBase(this.base, this.compressedForm, this.formattedCompressedForm).copyExtraFrom(this);
    }

    @Override
    public NPath resolveChild(String other) {
        return this.base.resolveChild(other).toCompressedForm();
    }

    @Override
    public NPath resolveChild(NPath other) {
        return this.base.resolveChild(other).toCompressedForm();
    }

    public static String compressUrl(String path) {
        NPathParts p = new NPathParts(path);
        switch (p.getType()) {
            case FILE_URL: 
            case URL: {
                return new NPathParts(p.getType(), p.getProtocol(), p.getAuthority(), NPathParts.compressLocalPath(p.getFile(), 0, 2), p.getQuery().length() > 0 ? "..." : "", p.getRef().length() > 0 ? "..." : "").toString();
            }
            case REF: {
                return "#...";
            }
            case FILE: {
                return NPathParts.compressLocalPath(p.getFile());
            }
            case EMPTY: {
                return "";
            }
        }
        return path;
    }

    @Override
    public NPath ensureEmptyDirectory() {
        this.base.ensureEmptyDirectory();
        return this;
    }

    @Override
    public NPath ensureEmptyFile() {
        this.base.ensureEmptyFile();
        return this;
    }

    @Override
    public String contentEncoding() {
        return this.base.contentEncoding();
    }

    @Override
    public String getContentType() {
        return this.base.getContentType();
    }

    @Override
    public String getCharset() {
        return this.base.getCharset();
    }

    @Override
    public String getName() {
        return this.base.getName();
    }

    @Override
    public String getLocation() {
        return this.base.getLocation();
    }

    @Override
    public NPath resolve(String other) {
        return this.base.resolve(other).toCompressedForm();
    }

    @Override
    public NPath resolve(NPath other) {
        return this.base.resolve(other).toCompressedForm();
    }

    @Override
    public NPath resolveSibling(String other) {
        return this.base.resolveSibling(other).toCompressedForm();
    }

    @Override
    public NPath resolveSibling(NPath other) {
        return this.base.resolveSibling(other).toCompressedForm();
    }

    @Override
    public byte[] readBytes(NPathOption ... options) {
        return this.base.readBytes(options);
    }

    @Override
    public NPath writeBytes(byte[] bytes, NPathOption ... options) {
        return this.base.writeBytes(bytes, options);
    }

    @Override
    public String getProtocol() {
        return this.base.getProtocol();
    }

    @Override
    public NPath toCompressedForm() {
        return this;
    }

    @Override
    public NOptional<URL> toURL() {
        return this.base.toURL();
    }

    @Override
    public NOptional<Path> toPath() {
        return this.base.toPath();
    }

    @Override
    public NOptional<File> toFile() {
        return this.base.toFile();
    }

    @Override
    public NStream<NPath> stream() {
        return this.base.stream();
    }

    @Override
    public InputStream getInputStream(NPathOption ... options) {
        return NInputSourceBuilder.of(this.base.getInputStream(options)).setMetadata(this.getMetaData()).createInputStream();
    }

    @Override
    public OutputStream getOutputStream(NPathOption ... options) {
        return NOutputStreamBuilder.of(this.base.getOutputStream(options)).setMetadata(this.getMetaData()).createOutputStream();
    }

    @Override
    public NPath deleteTree() {
        return this.base.deleteTree();
    }

    @Override
    public NPath delete(boolean recurse) {
        return this.base.delete(recurse);
    }

    @Override
    public NPath mkdir(boolean parents) {
        return this.base.mkdir(parents);
    }

    @Override
    public NPath mkdirs() {
        return this.base.mkdirs();
    }

    @Override
    public NPath mkdir() {
        return this.base.mkdir();
    }

    @Override
    public NPath expandPath(Function<String, String> resolver) {
        return this.base.expandPath(resolver).toCompressedForm();
    }

    @Override
    public NPath mkParentDirs() {
        return this.base.mkParentDirs();
    }

    @Override
    public boolean isOther() {
        return this.base.isOther();
    }

    @Override
    public boolean isSymbolicLink() {
        return this.base.isSymbolicLink();
    }

    @Override
    public boolean isDirectory() {
        return this.base.isDirectory();
    }

    @Override
    public NPathType type() {
        return this.base.type();
    }

    @Override
    public boolean isRegularFile() {
        return this.base.isRegularFile();
    }

    @Override
    public boolean isRemote() {
        return this.base.isRemote();
    }

    @Override
    public boolean isLocal() {
        return this.base.isLocal();
    }

    @Override
    public boolean exists() {
        return this.base.exists();
    }

    @Override
    public long getContentLength() {
        return this.base.getContentLength();
    }

    @Override
    public Instant getLastModifiedInstant() {
        return this.base.getLastModifiedInstant();
    }

    @Override
    public Instant getLastAccessInstant() {
        return this.base.getLastAccessInstant();
    }

    @Override
    public Instant getCreationInstant() {
        return this.base.getCreationInstant();
    }

    @Override
    public NPath getParent() {
        return this.base.getParent();
    }

    @Override
    public boolean isAbsolute() {
        return this.base.isAbsolute();
    }

    @Override
    public NPath normalize() {
        return this.base.normalize();
    }

    @Override
    public NPath toAbsolute() {
        return this.toAbsolute((NPath)null);
    }

    @Override
    public NPath toAbsolute(String basePath) {
        return this.base.toAbsolute(basePath).toCompressedForm();
    }

    @Override
    public NPath toAbsolute(NPath basePath) {
        if (this.base.isAbsolute()) {
            return this;
        }
        return basePath.toAbsolute(basePath).toCompressedForm();
    }

    @Override
    public NOptional<String> toRelative(NPath basePath) {
        return this.base.toRelative(basePath);
    }

    @Override
    public String owner() {
        return this.base.owner();
    }

    @Override
    public String group() {
        return this.base.group();
    }

    @Override
    public Set<NPathPermission> getPermissions() {
        return this.base.getPermissions();
    }

    @Override
    public NPath setPermissions(NPathPermission ... permissions) {
        this.base.setPermissions(permissions);
        return this;
    }

    @Override
    public NPath addPermissions(NPathPermission ... permissions) {
        this.base.addPermissions(permissions);
        return this;
    }

    @Override
    public NPath removePermissions(NPathPermission ... permissions) {
        this.base.removePermissions(permissions);
        return this;
    }

    @Override
    public boolean isName() {
        return this.base.isName();
    }

    @Override
    public int getNameCount() {
        return this.base.getNameCount();
    }

    @Override
    public List<NPathChildDigestInfo> listDigestInfo() {
        return this.base.listDigestInfo();
    }

    @Override
    public boolean isRoot() {
        return this.base.isRoot();
    }

    @Override
    public NStream<NPath> walk(int maxDepth, NPathOption[] options) {
        return this.base.walk(maxDepth, options);
    }

    @Override
    public NPath subpath(int beginIndex, int endIndex) {
        return this.base.subpath(beginIndex, endIndex).toCompressedForm();
    }

    @Override
    public String getName(int index) {
        return this.base.getName(index);
    }

    @Override
    public List<String> getNames() {
        return this.base.getNames();
    }

    @Override
    public void moveTo(NPath other, NPathOption ... options) {
        this.base.moveTo(other, new NPathOption[0]);
    }

    @Override
    public void copyTo(NPath other, NPathOption ... options) {
        this.base.copyTo(other, new NPathOption[0]);
    }

    @Override
    public NPath getRoot() {
        return this.base.getRoot();
    }

    @Override
    public NPath walkDfs(NTreeVisitor<NPath> visitor, NPathOption ... options) {
        this.base.walkDfs(visitor, options);
        return this;
    }

    @Override
    public NPath walkDfs(NTreeVisitor<NPath> visitor, int maxDepth, NPathOption ... options) {
        this.base.walkDfs(visitor, maxDepth, options);
        return this;
    }

    @Override
    public NStream<NPath> walkGlob(NPathOption ... options) {
        return this.base.walkGlob(options);
    }

    @Override
    public String toString() {
        return String.valueOf(this.compressedForm);
    }

    @Override
    public boolean isEqOrDeepChildOf(NPath other) {
        if (other == null) {
            return false;
        }
        return this.base.isEqOrDeepChildOf(NCompressedPathBase.unwrapPath(other));
    }

    @Override
    public int compareTo(NPath other) {
        if (other == null) {
            return 1;
        }
        return this.base.compareTo(NCompressedPathBase.unwrapPath(other));
    }

    @Override
    public List<NPathChildDigestInfo> listDigestInfo(String algo) {
        return this.getBase().listDigestInfo(algo);
    }

    @Override
    public List<NPathChildStringDigestInfo> listStringDigestInfo() {
        return this.getBase().listStringDigestInfo();
    }

    @Override
    public List<NPathChildStringDigestInfo> listStringDigestInfo(String algo) {
        return this.getBase().listStringDigestInfo(algo);
    }

    @Override
    public NPathInfo getInfo() {
        return this.getBase().getInfo();
    }

    @Override
    public List<NPathInfo> listInfos() {
        return this.getBase().listInfos();
    }

    public static class MyPathFormat
    extends DefaultFormatBase<NFormat> {
        private final NCompressedPathBase p;

        public MyPathFormat(NCompressedPathBase p) {
            super("path");
            this.p = p;
        }

        public NText asFormattedString() {
            return NText.ofStyled(this.p.compressedForm, NTextStyle.path());
        }

        @Override
        public void print(NPrintStream out) {
            out.print(this.asFormattedString());
        }

        @Override
        public boolean configureFirst(NCmdLine cmdLine) {
            return false;
        }

        @Override
        public int getScore(NScorableContext context) {
            return 10;
        }
    }
}

