/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.io.path;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Stack;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import net.thevpc.nuts.elem.NElementDescribables;
import net.thevpc.nuts.io.NPath;
import net.thevpc.nuts.runtime.standalone.xtra.glob.GlobUtils;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.util.NFunction;
import net.thevpc.nuts.util.NIllegalArgumentException;
import net.thevpc.nuts.util.NStream;

public class DirectoryScanner {
    private NPath initialPattern;
    private PathPart[] parts;

    public DirectoryScanner(NPath pattern) {
        this.initialPattern = pattern.toAbsolute().normalize();
        this.parts = DirectoryScanner.buildParts(this.initialPattern);
    }

    public static String escape(String s) {
        StringBuilder sb = new StringBuilder();
        block3: for (char c : s.toCharArray()) {
            switch (c) {
                case '*': 
                case '?': 
                case '\\': {
                    sb.append('\\').append(c);
                    continue block3;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    private static boolean containsWildcard(String name) {
        char[] patternChars;
        for (char c : patternChars = name.toCharArray()) {
            if (c != '*' && c != '?') continue;
            return true;
        }
        return false;
    }

    private static PathPart[] buildParts(NPath initialPattern) {
        ArrayList<PathPart> parts = new ArrayList<PathPart>();
        NPath h = initialPattern;
        while (h != null) {
            String name = h.getName();
            if (DirectoryScanner.containsWildcard(name)) {
                if (name.contains("**")) {
                    parts.add(0, new SubPathWildCardPathPart(name));
                } else {
                    parts.add(0, new NameWildCardPathPart(name));
                }
            } else {
                parts.add(0, new PlainPathPart(name));
            }
            NPath p = h.getParent();
            if (p == h) {
                h = null;
                continue;
            }
            h = p;
        }
        return parts.toArray(new PathPart[0]);
    }

    public String toString() {
        return this.initialPattern.toString();
    }

    public NPath[] toArray() {
        return (NPath[])this.stream().toArray(NPath[]::new);
    }

    public NStream<NPath> stream() {
        return this.stream(null, this.parts, 0);
    }

    private NStream<NPath> stream(NPath r, PathPart[] parts, int from) {
        for (int i = from; i < parts.length; ++i) {
            if (parts[i] instanceof PlainPathPart) {
                if (r == null) {
                    r = this.initialPattern.getRoot();
                }
                if ((r = r == null ? NPath.of(((PlainPathPart)parts[i]).value) : r.resolve(((PlainPathPart)parts[i]).value)).exists()) continue;
                return NStream.ofEmpty();
            }
            if (parts[i] instanceof NameWildCardPathPart) {
                NameWildCardPathPart w = (NameWildCardPathPart)parts[i];
                if (r == null) {
                    r = this.initialPattern.getRoot();
                }
                if (r == null) {
                    return NStream.ofEmpty();
                }
                NStream t = (NStream)r.stream().filter(x -> w.matchesName(x.getName())).redescribe(NElementDescribables.ofDesc("getName"));
                if (parts.length - i - 1 == 0) {
                    return t;
                }
                int i0 = i;
                Object f = NFunction.of(x -> this.stream((NPath)x, parts, i0 + 1)).redescribe((Supplier)NElementDescribables.ofDesc("subStream"));
                return t.flatMapStream(f);
            }
            if (parts[i] instanceof SubPathWildCardPathPart) {
                SubPathWildCardPathPart w = (SubPathWildCardPathPart)parts[i];
                if (r == null) {
                    r = this.initialPattern.getRoot();
                }
                NStream<NPath> t = new SubPathWildCardPathPartIterator(w, r).stream();
                if (parts.length - i - 1 == 0) {
                    return t;
                }
                int i0 = i;
                Object f = NFunction.of(x -> this.stream((NPath)x, parts, i0 + 1)).redescribe((Supplier)NElementDescribables.ofDesc("subStream"));
                return t.flatMapStream(f).distinct();
            }
            throw new NIllegalArgumentException(NMsg.ofC("unsupported %s", parts[i]));
        }
        if (r == null) {
            return NStream.ofSingleton(this.initialPattern.getRoot());
        }
        return NStream.ofSingleton(r);
    }

    private static class PathPart {
        private PathPart() {
        }
    }

    private static class SubPathWildCardPathPart
    extends PathPart {
        String value;
        Pattern pattern;

        public SubPathWildCardPathPart(String value) {
            this.value = value;
            this.pattern = GlobUtils.glob(value, "/\\");
        }

        public boolean matchesSubPath(String subPath) {
            return this.pattern.matcher(subPath == null ? "" : subPath).matches();
        }

        public String toString() {
            return "Path{" + this.value + '}';
        }
    }

    private static class NameWildCardPathPart
    extends PathPart {
        String value;
        Pattern pattern;

        public NameWildCardPathPart(String value) {
            this.value = value;
            this.pattern = GlobUtils.glob(value, "/\\");
        }

        public boolean matchesName(String name) {
            return this.pattern.matcher(name).matches();
        }

        public String toString() {
            return "Name{" + this.value + '}';
        }
    }

    private static class PlainPathPart
    extends PathPart {
        String value;

        public PlainPathPart(String value) {
            this.value = value;
        }

        public String toString() {
            return "Plain{" + this.value + '}';
        }
    }

    private class SubPathWildCardPathPartIterator
    implements Iterator<NPath> {
        private final Stack<NPath> stack = new Stack();
        private final SubPathWildCardPathPart w;
        NPath last;
        NPath root;

        public SubPathWildCardPathPartIterator(SubPathWildCardPathPart w, NPath root) {
            this.stack.push(root);
            this.w = w;
            this.root = root;
        }

        @Override
        public boolean hasNext() {
            this.last = this.next0();
            return this.last != null;
        }

        @Override
        public NPath next() {
            return this.last;
        }

        public NPath next0() {
            while (!this.stack.isEmpty()) {
                NPath pop = this.stack.pop();
                NPath[] t = (NPath[])pop.stream().toArray(NPath[]::new);
                for (int i = t.length - 1; i >= 0; --i) {
                    this.stack.push(t[i]);
                }
                if (!this.w.matchesSubPath(pop.toRelative(this.root).orNull())) continue;
                return pop;
            }
            return null;
        }

        public NStream<NPath> stream() {
            return NStream.ofIterator(this);
        }
    }
}

