/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.io.inputstream;

import java.io.InputStream;
import java.io.OutputStream;
import net.thevpc.nuts.io.NContentMetadata;
import net.thevpc.nuts.io.NInputSource;
import net.thevpc.nuts.io.NInputSourceBuilder;
import net.thevpc.nuts.io.NInterruptible;
import net.thevpc.nuts.io.NNonBlockingInputStream;
import net.thevpc.nuts.io.NullInputStream;
import net.thevpc.nuts.runtime.standalone.io.util.InputStreamExt;
import net.thevpc.nuts.runtime.standalone.io.util.InputStreamTee;
import net.thevpc.nuts.runtime.standalone.io.util.NNonBlockingInputStreamAdapter;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.time.NProgressListener;

public class DefaultNInputSourceBuilder
implements NInputSourceBuilder {
    private InputStream baseInputStream;
    private boolean closeBase = true;
    private Runnable closeAction;
    private boolean interruptible;
    private NContentMetadata metadata;
    private Object source;
    private NMsg sourceName;
    private Long expectedLength;
    private NProgressListener monitoringListener;
    private boolean nonBlocking;
    private OutputStream tee;

    @Override
    public NInputSourceBuilder setBase(InputStream baseInputStream) {
        this.baseInputStream = baseInputStream;
        return this;
    }

    @Override
    public boolean isCloseBase() {
        return this.closeBase;
    }

    @Override
    public NInputSourceBuilder setCloseBase(boolean closeBase) {
        this.closeBase = closeBase;
        return this;
    }

    @Override
    public Runnable getCloseAction() {
        return this.closeAction;
    }

    @Override
    public NInputSourceBuilder setCloseAction(Runnable closeAction) {
        this.closeAction = closeAction;
        return this;
    }

    @Override
    public boolean isInterruptible() {
        return this.interruptible;
    }

    @Override
    public NInputSourceBuilder setInterruptible(boolean interruptible) {
        this.interruptible = interruptible;
        return this;
    }

    @Override
    public NContentMetadata getMetadata() {
        return this.metadata;
    }

    @Override
    public NInputSourceBuilder setMetadata(NContentMetadata metadata) {
        this.metadata = metadata;
        return this;
    }

    @Override
    public Object getSource() {
        return this.source;
    }

    @Override
    public NInputSourceBuilder setSource(Object source) {
        this.source = source;
        return this;
    }

    @Override
    public NMsg getSourceName() {
        return this.sourceName;
    }

    @Override
    public NInputSourceBuilder setSourceName(NMsg sourceName) {
        this.sourceName = sourceName;
        return this;
    }

    @Override
    public Long getExpectedLength() {
        return this.expectedLength;
    }

    @Override
    public NInputSourceBuilder setExpectedLength(Long expectedLength) {
        this.expectedLength = expectedLength;
        return this;
    }

    @Override
    public NProgressListener getMonitoringListener() {
        return this.monitoringListener;
    }

    @Override
    public NInputSourceBuilder setMonitoringListener(NProgressListener monitoringListener) {
        this.monitoringListener = monitoringListener;
        return this;
    }

    @Override
    public boolean isNonBlocking() {
        return this.nonBlocking;
    }

    @Override
    public NInputSourceBuilder setNonBlocking(boolean nonBlocking) {
        this.nonBlocking = nonBlocking;
        return this;
    }

    @Override
    public OutputStream getTee() {
        return this.tee;
    }

    @Override
    public NInputSourceBuilder setTee(OutputStream tee) {
        this.tee = tee;
        return this;
    }

    @Override
    public NNonBlockingInputStream createNonBlockingInputStream() {
        InputStream u = this.createInputStream();
        if (u instanceof NNonBlockingInputStream) {
            return (NNonBlockingInputStream)((Object)u);
        }
        return new NNonBlockingInputStreamAdapter(u, this.metadata, this.sourceName);
    }

    @Override
    public NInterruptible<InputStream> createInterruptibleInputStream() {
        InputStream u = this.createInputStream();
        return (NInterruptible)((Object)u);
    }

    @Override
    public InputStream createInputStream() {
        if (this.baseInputStream == null) {
            NullInputStream b = NullInputStream.INSTANCE;
            if (this.nonBlocking) {
                return new NNonBlockingInputStreamAdapter(b, this.metadata, this.sourceName);
            }
        }
        InputStream a = this.baseInputStream;
        Runnable currentOnClose = this.closeAction;
        if (this.tee != null) {
            a = new InputStreamTee(a, this.tee, currentOnClose, this.metadata);
            currentOnClose = null;
        }
        a = new InputStreamExt(a, this.metadata, this.closeBase, currentOnClose, this.monitoringListener, this.source, this.sourceName, this.expectedLength);
        currentOnClose = null;
        if (this.nonBlocking) {
            a = new NNonBlockingInputStreamAdapter(a, this.metadata, this.sourceName);
        }
        return a;
    }

    @Override
    public NInputSource createInputSource() {
        return NInputSource.of(this.createInputStream());
    }
}

