/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.io.inputstream;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.thevpc.nuts.command.NExecutionEntry;
import net.thevpc.nuts.core.NBootOptions;
import net.thevpc.nuts.core.NWorkspace;
import net.thevpc.nuts.internal.rpi.NIORPI;
import net.thevpc.nuts.io.DefaultNContentMetadata;
import net.thevpc.nuts.io.NAsk;
import net.thevpc.nuts.io.NContentMetadata;
import net.thevpc.nuts.io.NIOException;
import net.thevpc.nuts.io.NIOUtils;
import net.thevpc.nuts.io.NInputSource;
import net.thevpc.nuts.io.NInputSourceBuilder;
import net.thevpc.nuts.io.NInputStreamProvider;
import net.thevpc.nuts.io.NInterruptible;
import net.thevpc.nuts.io.NMemoryPrintStream;
import net.thevpc.nuts.io.NNonBlockingInputStream;
import net.thevpc.nuts.io.NOutputStreamBuilder;
import net.thevpc.nuts.io.NOutputTarget;
import net.thevpc.nuts.io.NPath;
import net.thevpc.nuts.io.NPrintStream;
import net.thevpc.nuts.io.NPrintStreamAdapter;
import net.thevpc.nuts.io.NReaderProvider;
import net.thevpc.nuts.io.NTerminal;
import net.thevpc.nuts.io.NTerminalMode;
import net.thevpc.nuts.io.NullInputStream;
import net.thevpc.nuts.io.ReaderInputStream;
import net.thevpc.nuts.io.WriterOutputStream;
import net.thevpc.nuts.runtime.standalone.boot.DefaultNBootModel;
import net.thevpc.nuts.runtime.standalone.io.ask.DefaultNAsk;
import net.thevpc.nuts.runtime.standalone.io.inputstream.DefaultNInputSourceBuilder;
import net.thevpc.nuts.runtime.standalone.io.inputstream.DefaultNOutputStreamBuilder;
import net.thevpc.nuts.runtime.standalone.io.printstream.NByteArrayPrintStream;
import net.thevpc.nuts.runtime.standalone.io.printstream.NPrintStreamBase;
import net.thevpc.nuts.runtime.standalone.io.printstream.NPrintStreamRaw;
import net.thevpc.nuts.runtime.standalone.io.printstream.OutputTargetExt;
import net.thevpc.nuts.runtime.standalone.io.terminal.DefaultNSessionTerminalFrom;
import net.thevpc.nuts.runtime.standalone.io.terminal.DefaultNTerminalFromSystem;
import net.thevpc.nuts.runtime.standalone.io.util.AbstractNInputSource;
import net.thevpc.nuts.runtime.standalone.io.util.NInputStreamSource;
import net.thevpc.nuts.runtime.standalone.text.SimpleWriterOutputStream;
import net.thevpc.nuts.runtime.standalone.util.jclass.JavaClassUtils;
import net.thevpc.nuts.runtime.standalone.util.jclass.JavaJarUtils;
import net.thevpc.nuts.runtime.standalone.workspace.NWorkspaceExt;
import net.thevpc.nuts.runtime.standalone.workspace.config.DefaultNWorkspaceConfigModel;
import net.thevpc.nuts.spi.NSystemTerminalBase;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.text.NText;
import net.thevpc.nuts.text.NTextStyle;
import net.thevpc.nuts.util.NIllegalArgumentException;
import net.thevpc.nuts.util.NScorableContext;

public class DefaultNIORPI
implements NIORPI {
    private final NWorkspace workspace;
    public DefaultNWorkspaceConfigModel cmodel;
    public DefaultNBootModel bootModel;

    public DefaultNIORPI(NWorkspace workspace) {
        this.workspace = workspace;
        this.cmodel = NWorkspaceExt.of().getConfigModel();
        this.bootModel = NWorkspaceExt.of().getModel().bootModel;
    }

    @Override
    public <T> NAsk<T> createQuestion() {
        return this.createQuestion(this.workspace.currentSession().getTerminal());
    }

    @Override
    public <T> NAsk<T> createQuestion(NTerminal terminal) {
        return new DefaultNAsk(terminal, terminal.out());
    }

    @Override
    public NMemoryPrintStream ofInMemoryPrintStream() {
        return this.ofInMemoryPrintStream(null);
    }

    @Override
    public NMemoryPrintStream ofInMemoryPrintStream(NTerminalMode mode) {
        return new NByteArrayPrintStream(mode, this.workspace);
    }

    @Override
    public NPrintStream ofPrintStream(OutputStream out, NTerminalMode expectedMode, NSystemTerminalBase term) {
        if (out == null) {
            return null;
        }
        NBootOptions woptions = NWorkspace.of().getBootOptions();
        NTerminalMode expectedMode0 = woptions.getTerminalMode().orElse(NTerminalMode.DEFAULT);
        if (expectedMode0 == NTerminalMode.DEFAULT) {
            expectedMode0 = woptions.getBot().orElse(false) != false ? NTerminalMode.FILTERED : NTerminalMode.FORMATTED;
        }
        if (expectedMode == null) {
            expectedMode = expectedMode0;
        }
        if (expectedMode == NTerminalMode.FORMATTED && expectedMode0 == NTerminalMode.FILTERED) {
            expectedMode = NTerminalMode.FILTERED;
        }
        if (out instanceof NPrintStreamAdapter) {
            return ((NPrintStreamAdapter)((Object)out)).getBasePrintStream().setTerminalMode(expectedMode);
        }
        switch (expectedMode) {
            case DEFAULT: 
            case ANSI: 
            case INHERITED: {
                return new NPrintStreamRaw(out, expectedMode, null, null, new NPrintStreamBase.Bindings(), term);
            }
            case FILTERED: 
            case FORMATTED: {
                return new NPrintStreamRaw(out, NTerminalMode.INHERITED, null, null, new NPrintStreamBase.Bindings(), term).setTerminalMode(expectedMode);
            }
        }
        throw new NIllegalArgumentException(NMsg.ofC("unsupported mode %s", expectedMode));
    }

    @Override
    public NPrintStream ofPrintStream(OutputStream out) {
        if (out instanceof NPrintStreamAdapter) {
            return ((NPrintStreamAdapter)((Object)out)).getBasePrintStream();
        }
        return new NPrintStreamRaw(out, null, null, new NPrintStreamBase.Bindings(), null);
    }

    @Override
    public NPrintStream ofPrintStream(Writer out, NTerminalMode mode) {
        return this.ofPrintStream(out, mode, null);
    }

    @Override
    public NPrintStream ofPrintStream(OutputStream out, NTerminalMode mode) {
        return this.ofPrintStream(out, mode, null);
    }

    @Override
    public NPrintStream ofPrintStream(Writer out, NTerminalMode mode, NSystemTerminalBase terminal) {
        if (mode == null) {
            mode = NTerminalMode.INHERITED;
        }
        if (out == null) {
            return null;
        }
        if (out instanceof NPrintStreamAdapter) {
            return ((NPrintStreamAdapter)((Object)out)).getBasePrintStream().setTerminalMode(mode);
        }
        SimpleWriterOutputStream w = new SimpleWriterOutputStream(out, terminal, this.workspace);
        return this.ofPrintStream(w, mode, terminal);
    }

    @Override
    public NPrintStream ofPrintStream(Writer out) {
        return this.ofPrintStream(out, NTerminalMode.INHERITED, null);
    }

    @Override
    public NPrintStream ofPrintStream(NPath out) {
        return this.ofPrintStream(out.getOutputStream());
    }

    @Override
    public NPrintStream ofNullPrintStream() {
        return this.bootModel.nullPrintStream();
    }

    @Override
    public NInputSource ofInputSource(InputStream inputStream) {
        return this.ofInputSource(inputStream, null);
    }

    @Override
    public NInputSource ofInputSource(Reader inputStream, NContentMetadata metadata) {
        if (inputStream == null) {
            return null;
        }
        if (inputStream instanceof NInputSource) {
            return (NInputSource)((Object)inputStream);
        }
        return this.ofInputSource(new ReaderInputStream(inputStream, null), metadata);
    }

    @Override
    public NInputSource ofInputSource(Reader inputStream) {
        return this.ofInputSource(inputStream, null);
    }

    @Override
    public NInputSource ofInputSource(NInputStreamProvider inputStream) {
        return this.ofInputSource(inputStream, null);
    }

    @Override
    public NInputSource ofInputSource(NInputStreamProvider inputStreamProvider, final NContentMetadata metadata) {
        if (inputStreamProvider == null) {
            return null;
        }
        if (inputStreamProvider instanceof NInputSource) {
            if (metadata == null) {
                return (NInputSource)inputStreamProvider;
            }
            final NInputSource o = (NInputSource)inputStreamProvider;
            return new AbstractNInputSource(){

                @Override
                public boolean isMultiRead() {
                    return o.isMultiRead();
                }

                @Override
                public boolean isKnownContentLength() {
                    return o.isKnownContentLength();
                }

                @Override
                public long getContentLength() {
                    return o.getContentLength();
                }

                @Override
                public NContentMetadata getMetaData() {
                    return metadata;
                }

                @Override
                public InputStream getInputStream() {
                    return o.getInputStream();
                }
            };
        }
        if (metadata == null) {
            DefaultNContentMetadata metadata2 = new DefaultNContentMetadata(NMsg.ofPlain("Provider"), null, null, null, null);
            return new InputStreamProviderToNInputSourceAdapter(metadata2, inputStreamProvider);
        }
        return new InputStreamProviderToNInputSourceAdapter(metadata, inputStreamProvider);
    }

    @Override
    public NInputSource ofInputSource(NReaderProvider readerProvider, final NContentMetadata metadata) {
        if (readerProvider == null) {
            return null;
        }
        if (readerProvider instanceof NInputSource) {
            if (metadata == null) {
                return (NInputSource)((Object)readerProvider);
            }
            final NInputSource o = (NInputSource)((Object)readerProvider);
            return new AbstractNInputSource(){

                @Override
                public boolean isMultiRead() {
                    return o.isMultiRead();
                }

                @Override
                public boolean isKnownContentLength() {
                    return o.isKnownContentLength();
                }

                @Override
                public long getContentLength() {
                    return o.getContentLength();
                }

                @Override
                public NContentMetadata getMetaData() {
                    return metadata;
                }

                @Override
                public InputStream getInputStream() {
                    return o.getInputStream();
                }
            };
        }
        if (metadata == null) {
            DefaultNContentMetadata metadata2 = new DefaultNContentMetadata(NMsg.ofPlain("Provider"), null, null, null, null);
            return new ReaderProviderToNInputSourceAdapter(metadata2, readerProvider);
        }
        return new ReaderProviderToNInputSourceAdapter(metadata, readerProvider);
    }

    @Override
    public NInputSource ofInputSource(InputStream inputStream, NContentMetadata metadata) {
        if (inputStream == null) {
            return null;
        }
        if (inputStream instanceof NInputSource) {
            return (NInputSource)((Object)inputStream);
        }
        if (metadata == null) {
            NText str = null;
            Long contentLength = null;
            try {
                contentLength = inputStream.available();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            str = inputStream instanceof ByteArrayInputStream ? NText.ofStyled("<memory-buffer>", NTextStyle.path()) : NText.ofStyled(inputStream.toString(), NTextStyle.path());
            metadata = new DefaultNContentMetadata(NMsg.ofNtf(str), contentLength, null, null, null);
        }
        InputStream inputStreamExt = this.ofInputSourceBuilder(inputStream).setMetadata(metadata).createInputStream();
        return new NInputStreamSource(inputStreamExt, null, this.workspace);
    }

    @Override
    public NInputSource ofMultiRead(NInputSource source) {
        if (source.isMultiRead()) {
            return source;
        }
        NPath tf = NPath.ofTempFile();
        try (InputStream in = source.getInputStream();
             OutputStream out = tf.getOutputStream();){
            NIOUtils.copy(in, out, 4096);
        }
        catch (IOException ex) {
            throw new NIOException(ex);
        }
        return tf;
    }

    @Override
    public NInputSource ofInputSource(byte[] bytes) {
        return this.ofInputSource(new ByteArrayInputStream(bytes));
    }

    @Override
    public NInputSource ofEmptyInputSource() {
        return this.ofInputSource(NullInputStream.INSTANCE);
    }

    @Override
    public NInputSource ofInputSource(byte[] inputStream, NContentMetadata metadata) {
        return this.ofInputSource(new ByteArrayInputStream(inputStream), metadata);
    }

    @Override
    public NOutputTarget ofOutputTarget(OutputStream outputStream) {
        return this.ofOutputTarget(outputStream, null);
    }

    @Override
    public NOutputTarget ofOutputTarget(OutputStream outputStream, NContentMetadata metadata) {
        return new OutputTargetExt(NOutputStreamBuilder.of(outputStream).setMetadata(metadata).createOutputStream(), null);
    }

    @Override
    public NOutputTarget ofOutputTarget(Writer writer, NContentMetadata metadata) {
        if (writer == null) {
            return null;
        }
        if (writer instanceof NOutputTarget) {
            return (NOutputTarget)((Object)writer);
        }
        return this.ofOutputTarget(new WriterOutputStream(writer), metadata);
    }

    @Override
    public NOutputTarget ofOutputTarget(Writer writer) {
        return this.ofOutputTarget(writer, null);
    }

    @Override
    public NOutputStreamBuilder ofOutputStreamBuilder(OutputStream base) {
        return new DefaultNOutputStreamBuilder().setBase(base);
    }

    @Override
    public NNonBlockingInputStream ofNonBlockingInputStream(InputStream base) {
        return this.ofInputSourceBuilder(base).createNonBlockingInputStream();
    }

    @Override
    public NInterruptible<InputStream> ofInterruptible(InputStream base) {
        return this.ofInputSourceBuilder(base).createInterruptibleInputStream();
    }

    @Override
    public NInputSourceBuilder ofInputSourceBuilder(InputStream inputStream) {
        return new DefaultNInputSourceBuilder().setBase(inputStream);
    }

    @Override
    public NTerminal createTerminal() {
        return this.cmodel.createTerminal();
    }

    @Override
    public NTerminal createTerminal(InputStream in, NPrintStream out, NPrintStream err) {
        return this.cmodel.createTerminal(in, out, err);
    }

    @Override
    public NTerminal createTerminal(NTerminal terminal) {
        if (terminal == null) {
            return this.createTerminal();
        }
        if (terminal instanceof DefaultNTerminalFromSystem) {
            DefaultNTerminalFromSystem t = (DefaultNTerminalFromSystem)terminal;
            return new DefaultNTerminalFromSystem(t);
        }
        if (terminal instanceof DefaultNSessionTerminalFrom) {
            DefaultNSessionTerminalFrom t = (DefaultNSessionTerminalFrom)terminal;
            return new DefaultNSessionTerminalFrom(t);
        }
        return new DefaultNSessionTerminalFrom(terminal);
    }

    @Override
    public NTerminal createInMemoryTerminal() {
        return this.createInMemoryTerminal(false);
    }

    @Override
    public NTerminal createInMemoryTerminal(boolean mergeErr) {
        ByteArrayInputStream in = new ByteArrayInputStream(new byte[0]);
        NMemoryPrintStream out = NMemoryPrintStream.of();
        NMemoryPrintStream err = mergeErr ? out : NMemoryPrintStream.of();
        return this.createTerminal(in, out, err);
    }

    @Override
    public void enableRichTerm() {
        this.bootModel.enableRichTerm();
    }

    @Override
    public List<NExecutionEntry> parseExecutionEntries(NPath file) {
        if (file.getName().toLowerCase().endsWith(".jar")) {
            List<NExecutionEntry> list;
            block18: {
                InputStream in = file.getInputStream();
                try {
                    list = this.parseExecutionEntries(in, "jar", file.toAbsolute().normalize().toString());
                    if (in == null) break block18;
                }
                catch (Throwable throwable) {
                    try {
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException ex) {
                        throw new NIOException(ex);
                    }
                }
                in.close();
            }
            return list;
        }
        if (file.getName().toLowerCase().endsWith(".class")) {
            List<NExecutionEntry> list;
            block19: {
                InputStream in = file.getInputStream();
                try {
                    list = this.parseExecutionEntries(in, "class", file.toAbsolute().normalize().toString());
                    if (in == null) break block19;
                }
                catch (Throwable throwable) {
                    try {
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException ex) {
                        throw new NIOException(ex);
                    }
                }
                in.close();
            }
            return list;
        }
        return Collections.emptyList();
    }

    @Override
    public List<NExecutionEntry> parseExecutionEntries(InputStream inputStream, String type, String sourceName) {
        if ("jar".equals(type)) {
            return JavaJarUtils.parseJarExecutionEntries(inputStream);
        }
        if ("class".equals(type)) {
            NExecutionEntry u = JavaClassUtils.parseClassExecutionEntry(inputStream, sourceName);
            return u == null ? Collections.emptyList() : Arrays.asList(u);
        }
        return Collections.emptyList();
    }

    @Override
    public int getScore(NScorableContext context) {
        return 10;
    }

    private class InputStreamProviderToNInputSourceAdapter
    extends AbstractNInputSource {
        private final NContentMetadata metadata2;
        private final NInputStreamProvider inputStreamProvider;

        public InputStreamProviderToNInputSourceAdapter(NContentMetadata metadata2, NInputStreamProvider inputStreamProvider) {
            this.metadata2 = metadata2;
            this.inputStreamProvider = inputStreamProvider;
        }

        @Override
        public boolean isMultiRead() {
            return false;
        }

        @Override
        public boolean isKnownContentLength() {
            return false;
        }

        @Override
        public long getContentLength() {
            return -1L;
        }

        @Override
        public NContentMetadata getMetaData() {
            return this.metadata2;
        }

        @Override
        public InputStream getInputStream() {
            return this.inputStreamProvider.getInputStream();
        }
    }

    private class ReaderProviderToNInputSourceAdapter
    extends AbstractNInputSource {
        private final NContentMetadata metadata2;
        private final NReaderProvider inputStreamProvider;

        public ReaderProviderToNInputSourceAdapter(NContentMetadata metadata2, NReaderProvider inputStreamProvider) {
            this.metadata2 = metadata2;
            this.inputStreamProvider = inputStreamProvider;
        }

        @Override
        public boolean isMultiRead() {
            return false;
        }

        @Override
        public boolean isKnownContentLength() {
            return false;
        }

        @Override
        public long getContentLength() {
            return -1L;
        }

        @Override
        public NContentMetadata getMetaData() {
            return this.metadata2;
        }

        @Override
        public InputStream getInputStream() {
            return new ReaderInputStream(this.inputStreamProvider.getReader(), null);
        }

        @Override
        public Reader getReader() {
            return this.inputStreamProvider.getReader();
        }

        @Override
        public Reader getReader(Charset cs) {
            return this.inputStreamProvider.getReader();
        }
    }
}

