/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.io.inputstream;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Collectors;
import net.thevpc.nuts.app.NApp;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.concurrent.NScoredCallable;
import net.thevpc.nuts.core.NRepository;
import net.thevpc.nuts.core.NWorkspace;
import net.thevpc.nuts.ext.NExtensions;
import net.thevpc.nuts.io.InputStreamDelegate;
import net.thevpc.nuts.io.NIO;
import net.thevpc.nuts.io.NIOException;
import net.thevpc.nuts.io.NIOUtils;
import net.thevpc.nuts.io.NPath;
import net.thevpc.nuts.io.NPrintStream;
import net.thevpc.nuts.io.NSystemTerminal;
import net.thevpc.nuts.io.NTempOutputStream;
import net.thevpc.nuts.io.NTerminal;
import net.thevpc.nuts.io.OutputStreamDelegate;
import net.thevpc.nuts.platform.NStoreType;
import net.thevpc.nuts.runtime.standalone.boot.DefaultNBootModel;
import net.thevpc.nuts.runtime.standalone.io.inputstream.NTempOutputStreamImpl;
import net.thevpc.nuts.runtime.standalone.io.path.NPathFromSPI;
import net.thevpc.nuts.runtime.standalone.io.path.spi.FilePath;
import net.thevpc.nuts.runtime.standalone.io.path.spi.URLPath;
import net.thevpc.nuts.runtime.standalone.io.printstream.NPrintStreamRendered;
import net.thevpc.nuts.runtime.standalone.io.printstream.NPrintStreamSystem;
import net.thevpc.nuts.runtime.standalone.workspace.NWorkspaceExt;
import net.thevpc.nuts.runtime.standalone.workspace.config.DefaultNWorkspaceConfigModel;
import net.thevpc.nuts.spi.NCharsetResolver;
import net.thevpc.nuts.spi.NComponentScope;
import net.thevpc.nuts.spi.NContentTypeResolver;
import net.thevpc.nuts.spi.NPathFactorySPI;
import net.thevpc.nuts.spi.NPathSPI;
import net.thevpc.nuts.spi.NScopeType;
import net.thevpc.nuts.spi.NSystemTerminalBase;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NIllegalArgumentException;
import net.thevpc.nuts.util.NScorable;
import net.thevpc.nuts.util.NScorableContext;
import net.thevpc.nuts.util.NStringBuilder;

@NComponentScope(value=NScopeType.WORKSPACE)
public class DefaultNIO
implements NIO {
    public DefaultNWorkspaceConfigModel cmodel = NWorkspaceExt.of().getConfigModel();
    public DefaultNBootModel bootModel;

    public DefaultNIO() {
        this.bootModel = NWorkspaceExt.of().getModel().bootModel;
    }

    @Override
    public InputStream stdin() {
        return this.getBootModel().getSystemTerminal().in();
    }

    @Override
    public int getScore(NScorableContext context) {
        return 10;
    }

    private DefaultNBootModel getBootModel() {
        return NWorkspaceExt.of().getModel().bootModel;
    }

    @Override
    public OutputStream unwrapOutputStream(OutputStream out) {
        while (out != null && out instanceof OutputStreamDelegate) {
            out = ((OutputStreamDelegate)((Object)out)).getDelegateOutputStream();
        }
        return out;
    }

    @Override
    public InputStream unwrapInputStream(InputStream in) {
        while (in != null && in instanceof InputStreamDelegate) {
            in = ((InputStreamDelegate)((Object)in)).getDelegateInputStream();
        }
        return in;
    }

    @Override
    public boolean isStdin(InputStream in) {
        InputStream sysin = this.unwrapInputStream(this.getBootModel().getSystemTerminal().in());
        return (in = this.unwrapInputStream(in)) == sysin;
    }

    @Override
    public boolean isStdout(OutputStream out) {
        OutputStream sysout = this.unwrapOutputStream(this.getBootModel().getSystemTerminal().out().asOutputStream());
        return (out = this.unwrapOutputStream(out)) == sysout;
    }

    @Override
    public boolean isStderr(OutputStream err) {
        OutputStream syserr = this.unwrapOutputStream(this.getBootModel().getSystemTerminal().err().asOutputStream());
        return (err = this.unwrapOutputStream(err)) == syserr;
    }

    @Override
    public boolean isStdout(NPrintStream out) {
        if (out == null) {
            return false;
        }
        NSystemTerminal st = this.getBootModel().getSystemTerminal();
        if (out == st.out()) {
            return true;
        }
        if (out instanceof NPrintStreamRendered) {
            return this.isStdout(((NPrintStreamRendered)out).getBase());
        }
        return out instanceof NPrintStreamSystem;
    }

    @Override
    public boolean isStderr(NPrintStream out) {
        if (out == null) {
            return false;
        }
        NSystemTerminal st = this.getBootModel().getSystemTerminal();
        if (out == st.err()) {
            return true;
        }
        if (out instanceof NPrintStreamRendered) {
            return this.isStderr(((NPrintStreamRendered)out).getBase());
        }
        return out instanceof NPrintStreamSystem;
    }

    @Override
    public NPrintStream stdout() {
        return this.getBootModel().getSystemTerminal().out();
    }

    @Override
    public NPrintStream stderr() {
        return this.getBootModel().getSystemTerminal().err();
    }

    private DefaultNWorkspaceConfigModel getConfigModel() {
        return NWorkspaceExt.of().getConfigModel();
    }

    @Override
    public NSystemTerminal getSystemTerminal() {
        return NWorkspaceExt.of().getModel().bootModel.getSystemTerminal();
    }

    @Override
    public NIO setSystemTerminal(NSystemTerminalBase terminal) {
        NWorkspaceExt.of().getModel().bootModel.setSystemTerminal(terminal);
        return this;
    }

    @Override
    public NTerminal getDefaultTerminal() {
        return this.cmodel.getTerminal();
    }

    @Override
    public NIO setDefaultTerminal(NTerminal terminal) {
        this.cmodel.setTerminal(terminal);
        return this;
    }

    @Override
    public NPath createPath(String path) {
        return this.createPath(path, null);
    }

    @Override
    public NPath createPath(File path) {
        if (path == null) {
            return null;
        }
        return this.createPath(new FilePath(path.toPath()));
    }

    @Override
    public NPath createPath(Path path) {
        if (path == null) {
            return null;
        }
        return this.createPath(new FilePath(path));
    }

    @Override
    public NPath createPath(URL path) {
        if (path == null) {
            return null;
        }
        return this.createPath(new URLPath(path));
    }

    @Override
    public NPath createPath(String path, ClassLoader classLoader) {
        if (path == null || path.trim().isEmpty()) {
            return null;
        }
        NPath p = this.getConfigModel().resolve(path, classLoader);
        if (p == null) {
            throw new NIllegalArgumentException(NMsg.ofC("unable to resolve path from %s", path));
        }
        return p;
    }

    @Override
    public NPath createPath(NPathSPI path) {
        if (path == null) {
            return null;
        }
        return new NPathFromSPI(path);
    }

    @Override
    public NIO addPathFactory(NPathFactorySPI pathFactory) {
        this.getConfigModel().addPathFactory(pathFactory);
        return this;
    }

    @Override
    public NIO removePathFactory(NPathFactorySPI pathFactory) {
        this.getConfigModel().removePathFactory(pathFactory);
        return this;
    }

    @Override
    public NPath ofTempFile(String name) {
        return this.createAnyTempFile(name, false, null);
    }

    @Override
    public NPath ofTempFolder(String name) {
        return this.createAnyTempFile(name, true, null);
    }

    @Override
    public NPath ofTempFile() {
        return this.createAnyTempFile(null, false, null);
    }

    @Override
    public NPath ofTempFolder() {
        return this.createAnyTempFile(null, true, null);
    }

    @Override
    public NPath ofTempRepositoryFile(String name, NRepository repository) {
        return this.createAnyTempFile(name, false, this.resolveRootPath(repository));
    }

    @Override
    public NPath ofTempRepositoryFolder(String name, NRepository repository) {
        return this.createAnyTempFile(name, true, this.resolveRootPath(repository));
    }

    @Override
    public NPath ofTempRepositoryFile(NRepository repository) {
        return this.createAnyTempFile(null, false, this.resolveRootPath(repository));
    }

    @Override
    public NPath ofTempRepositoryFolder(NRepository repository) {
        return this.createAnyTempFile(null, true, this.resolveRootPath(repository));
    }

    @Override
    public NPath ofTempIdFile(String name, NId repository) {
        return this.createAnyTempFile(name, false, this.resolveRootPath(repository));
    }

    @Override
    public NPath ofTempIdFolder(String name, NId repository) {
        return this.createAnyTempFile(name, true, this.resolveRootPath(repository));
    }

    @Override
    public NPath ofTempIdFile(NId repository) {
        return this.createAnyTempFile(null, false, this.resolveRootPath(repository));
    }

    @Override
    public NPath ofTempIdFolder(NId repository) {
        return this.createAnyTempFile(null, true, this.resolveRootPath(repository));
    }

    private NPath resolveRootPath(NRepository repositoryId) {
        if (repositoryId == null) {
            return NPath.ofWorkspaceStore(NStoreType.TEMP);
        }
        return repositoryId.config().getStoreLocation(NStoreType.TEMP);
    }

    private NPath resolveRootPath(NId nId) {
        if (nId == null) {
            return NPath.ofWorkspaceStore(NStoreType.TEMP);
        }
        return NPath.ofIdStore(nId, NStoreType.TEMP);
    }

    public NPath createAnyTempFile(String name, boolean folder, NPath rootFolder) {
        NId appId;
        if (rootFolder == null) {
            rootFolder = NPath.ofWorkspaceStore(NStoreType.TEMP);
        }
        if ((appId = NApp.of().getId().orElseGet(() -> NWorkspace.of().getRuntimeId())) != null) {
            rootFolder = rootFolder.resolve("id").resolve(NWorkspace.of().getDefaultIdBasedir(appId));
        }
        if (name == null) {
            name = "";
        }
        rootFolder.mkdirs();
        NStringBuilder ext = new NStringBuilder(NIOUtils.getFileExtension(name, false, true));
        NStringBuilder prefix = new NStringBuilder(ext.length() > 0 ? name.substring(0, name.length() - ext.length()) : name);
        if (ext.isEmpty() && prefix.isEmpty()) {
            prefix.append("nuts-");
            if (!folder) {
                ext.append(".tmp");
            }
        } else if (ext.isEmpty()) {
            if (!folder) {
                ext.append("-tmp");
            }
        } else if (prefix.isEmpty()) {
            prefix.append(ext);
            ext.clear();
            ext.append("-tmp");
        }
        if (!prefix.endsWith("-")) {
            prefix.append('-');
        }
        if (prefix.length() < 3 && prefix.length() < 3) {
            prefix.append('A');
            if (prefix.length() < 3) {
                prefix.append('B');
            }
        }
        if (folder) {
            for (int i = 0; i < 15; ++i) {
                File temp = null;
                try {
                    temp = File.createTempFile(prefix.toString(), ext.toString(), rootFolder.toFile().get());
                    if (!temp.delete() || !temp.mkdir()) continue;
                    return NPath.of(temp.toPath()).setUserTemporary(true);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            throw new NIOException(NMsg.ofC("could not create temp directory: %s*%s", rootFolder + File.separator + prefix, ext));
        }
        try {
            return NPath.of(File.createTempFile(prefix.toString(), ext.toString(), rootFolder.toFile().get()).toPath()).setUserTemporary(true);
        }
        catch (IOException e) {
            throw new NIOException(e);
        }
    }

    @Override
    public String probeContentType(Path path) {
        return this.probeContentType(path == null ? null : NPath.of(path));
    }

    @Override
    public String probeContentType(File path) {
        return this.probeContentType(path == null ? null : NPath.of(path));
    }

    @Override
    public String probeContentType(URL path) {
        return this.probeContentType(path == null ? null : NPath.of(path));
    }

    @Override
    public String probeContentType(NPath path) {
        List<NContentTypeResolver> allSupported = NExtensions.of().createComponents(NContentTypeResolver.class, path);
        NScoredCallable best = NScorable.query().fromStream(allSupported.stream().map(x -> x.probeContentType(path))).getBest().orNull();
        if (best == null) {
            return null;
        }
        return (String)best.call();
    }

    @Override
    public List<String> findExtensionsByContentType(String contentType) {
        List<NContentTypeResolver> allSupported = NExtensions.of().createComponents(NContentTypeResolver.class, null);
        LinkedHashSet all = new LinkedHashSet();
        for (NContentTypeResolver r : allSupported) {
            List<String> s = r.findExtensionsByContentType(contentType);
            if (s == null) continue;
            all.addAll(s.stream().filter(x -> !NBlankable.isBlank(x)).collect(Collectors.toList()));
        }
        return new ArrayList<String>(all);
    }

    @Override
    public List<String> findContentTypesByExtension(String extension) {
        List<NContentTypeResolver> allSupported = NExtensions.of().createComponents(NContentTypeResolver.class, null);
        LinkedHashSet all = new LinkedHashSet();
        for (NContentTypeResolver r : allSupported) {
            List<String> s = r.findContentTypesByExtension(extension);
            if (s == null) continue;
            all.addAll(s.stream().filter(NBlankable::isBlank).collect(Collectors.toList()));
        }
        return new ArrayList<String>(all);
    }

    @Override
    public String probeContentType(InputStream stream) {
        byte[] buffer = NIOUtils.readBestEffort(4096, stream);
        return this.probeContentType(buffer);
    }

    @Override
    public String probeContentType(byte[] bytes) {
        List<NContentTypeResolver> allSupported = NExtensions.of().createComponents(NContentTypeResolver.class, bytes);
        NScoredCallable best = NScorable.query().fromStream(allSupported.stream().map(x -> x.probeContentType(bytes))).getBest().orNull();
        if (best == null) {
            return null;
        }
        return (String)best.call();
    }

    @Override
    public String probeCharset(URL path) {
        return this.probeCharset(path == null ? null : NPath.of(path));
    }

    @Override
    public String probeCharset(File path) {
        return this.probeCharset(path == null ? null : NPath.of(path));
    }

    @Override
    public String probeCharset(Path path) {
        return this.probeCharset(path == null ? null : NPath.of(path));
    }

    @Override
    public String probeCharset(NPath path) {
        List<NCharsetResolver> allSupported = NExtensions.of().createComponents(NCharsetResolver.class, path);
        NScoredCallable best = NScorable.query().fromStream(allSupported.stream().map(x -> x.probeCharset(path))).getBest().orNull();
        if (best == null) {
            return null;
        }
        return (String)best.call();
    }

    @Override
    public String probeCharset(InputStream stream) {
        byte[] buffer = NIOUtils.readBestEffort(40960, stream);
        return this.probeCharset(buffer);
    }

    @Override
    public String probeCharset(byte[] bytes) {
        List<NCharsetResolver> allSupported = NExtensions.of().createComponents(NCharsetResolver.class, bytes);
        NScoredCallable best = NScorable.query().fromStream(allSupported.stream().map(x -> x.probeCharset(bytes))).getBest().orNull();
        if (best == null) {
            return null;
        }
        return (String)best.call();
    }

    @Override
    public NTempOutputStream ofTempOutputStream() {
        return new NTempOutputStreamImpl();
    }
}

