/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.io.ask;

import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.thevpc.nuts.app.NApp;
import net.thevpc.nuts.artifact.NDefinition;
import net.thevpc.nuts.cmdline.NArg;
import net.thevpc.nuts.cmdline.NCmdLine;
import net.thevpc.nuts.cmdline.NCmdLineConfigurable;
import net.thevpc.nuts.command.NExecutionException;
import net.thevpc.nuts.command.NSearchCmd;
import net.thevpc.nuts.core.NSession;
import net.thevpc.nuts.core.NWorkspace;
import net.thevpc.nuts.io.NAsk;
import net.thevpc.nuts.io.NAskFormat;
import net.thevpc.nuts.io.NAskParseContext;
import net.thevpc.nuts.io.NAskParser;
import net.thevpc.nuts.io.NAskValidator;
import net.thevpc.nuts.io.NMemoryPrintStream;
import net.thevpc.nuts.io.NOut;
import net.thevpc.nuts.io.NPrintStream;
import net.thevpc.nuts.io.NTerminal;
import net.thevpc.nuts.runtime.standalone.app.gui.CoreNUtilGui;
import net.thevpc.nuts.runtime.standalone.io.ask.DefaultNAskFormat;
import net.thevpc.nuts.runtime.standalone.io.ask.DefaultNResponseParser;
import net.thevpc.nuts.spi.NScopeType;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.text.NText;
import net.thevpc.nuts.text.NTextStyle;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NCancelException;

public class DefaultNAsk<T>
implements NAsk<T> {
    private final NTerminal terminal;
    private final NPrintStream out;
    private NMsg message;
    private NMsg cancelMessage;
    private List<Object> acceptedValues;
    private NMsg hintMessage;
    private T defaultValue;
    private String rememberMeKey;
    private boolean resetLine = true;
    private Class<T> valueType;
    private NAskFormat<T> format;
    private NAskParser<T> parser;
    private NAskValidator<T> validator;
    private boolean traceConfirmation = false;
    private boolean executed = false;
    private boolean password = false;
    private Object lastResult = null;

    public DefaultNAsk(NTerminal terminal, NPrintStream out) {
        this.terminal = terminal;
        this.out = out;
    }

    @Override
    public String getRememberMeKey() {
        return this.rememberMeKey;
    }

    @Override
    public NAsk<T> setRememberMeKey(String rememberMeKey) {
        this.rememberMeKey = rememberMeKey;
        return this;
    }

    private T execute() {
        List<Object> _acceptedValues;
        NAskFormat<T> ff;
        NMemoryPrintStream os;
        Object o;
        NSession session = NSession.of();
        NAskCache askCache = NApp.of().getOrComputeProperty(NAskCache.class.getName(), NScopeType.SESSION, () -> new NAskCache());
        if (this.rememberMeKey != null && (o = askCache.get(this.rememberMeKey)) != null) {
            try {
                return (T)o;
            }
            catch (Exception e) {
                askCache.remove(this.rememberMeKey);
            }
        }
        if (!this.traceConfirmation && this.isBooleanType()) {
            switch (session.getConfirm().orDefault()) {
                case YES: {
                    return (T)Boolean.TRUE;
                }
                case NO: {
                    return (T)Boolean.FALSE;
                }
                case ERROR: {
                    if (this.cancelMessage != null) {
                        os = NMemoryPrintStream.of();
                        os.print(this.cancelMessage);
                        os.flush();
                        throw new NCancelException(NMsg.ofNtf(os.toString()));
                    }
                    os = NMemoryPrintStream.of();
                    os.print(this.message);
                    os.flush();
                    throw new NCancelException(NMsg.ofC("cancelled : %s", NMsg.ofNtf(os.toString())));
                }
            }
        }
        if (!NOut.isPlain()) {
            os = NMemoryPrintStream.of();
            os.print(this.message);
            os.flush();
            throw new NExecutionException(NMsg.ofC("unable to switch to interactive mode for non plain text output format. You need to provide default response (-y|-n) for question : %s", os), 255);
        }
        boolean gui = session.isGui() && NWorkspace.of().isGraphicalDesktopEnvironment();
        NMsg message = this.getMessage();
        boolean extraInfo = false;
        NAskParser p = this.getParser();
        if (p == null) {
            p = new DefaultNResponseParser<T>(session, this.getValueType());
        }
        if ((ff = this.getFormat()) == null) {
            ff = new DefaultNAskFormat();
        }
        if ((_acceptedValues = this.getAcceptedValues()) == null) {
            _acceptedValues = ff.getDefaultValues(this.getValueType(), this);
        }
        if (_acceptedValues == null) {
            _acceptedValues = new ArrayList<Object>();
        }
        Object alwaysKey = null;
        while (true) {
            CoreNUtilGui.GuiResult v0;
            NPrintStream out = this.out;
            ByteArrayOutputStream bos = null;
            if (gui) {
                bos = new ByteArrayOutputStream();
                out = NPrintStream.of(bos);
            }
            if (this.resetLine) {
                out.resetLine();
            }
            out.print(message);
            boolean first = true;
            if (this.getDefaultValue() != null) {
                if (first) {
                    first = false;
                    out.print(" (");
                } else {
                    out.print(", ");
                }
                out.print(NMsg.ofC("default is %s", NText.ofStyled(ff.format(this.getDefaultValue(), this), NTextStyle.primary1())));
            }
            if (this.getHintMessage() != null) {
                out.print(" (");
                out.print(this.getHintMessage());
                out.print(")");
            } else {
                if (!_acceptedValues.isEmpty()) {
                    if (first) {
                        first = false;
                        out.print(" (");
                    } else {
                        out.print(", ");
                    }
                    StringBuilder sb = new StringBuilder();
                    for (int i = 0; i < _acceptedValues.size(); ++i) {
                        Object acceptedValue = _acceptedValues.get(i);
                        if (i > 0) {
                            sb.append(", ");
                        }
                        sb.append(ff.format(acceptedValue, this));
                    }
                    out.print(NMsg.ofC("accepts %s", NText.ofStyled(sb.toString(), NTextStyle.primary4())));
                }
                if (!first) {
                    out.print(")");
                }
            }
            out.flush();
            switch (session.getConfirm().orDefault()) {
                case ERROR: {
                    out.flush();
                    out.println(" : cancel");
                    throw new NCancelException();
                }
            }
            if (this.isBooleanType()) {
                switch (session.getConfirm().orDefault()) {
                    case YES: {
                        out.flush();
                        out.println(" : yes");
                        throw new NCancelException();
                    }
                    case NO: {
                        out.flush();
                        out.println(" : no");
                        throw new NCancelException();
                    }
                }
            }
            boolean always = false;
            if (this.password) {
                char[] v;
                if (extraInfo) {
                    out.print("?\n");
                    out.flush();
                    if (gui) {
                        out.print(NMsg.ofC("\t Please enter value or ```error %s``` to cancel : ", "cancel!"));
                        out.flush();
                        v0 = this.showGuiInput(bos.toString(), true, this.rememberMeKey != null);
                        v = v0 == null || v0.getValue() == null ? new char[]{} : ((String)v0.getValue()).toCharArray();
                        always = v0 != null && v0.isRememberMe();
                    } else {
                        v = this.terminal.readPassword(NMsg.ofC("\t Please enter value or ```error %s``` to cancel : ", "cancel!"));
                    }
                } else {
                    out.flush();
                    if (gui) {
                        out.print(" ");
                        out.flush();
                        v0 = this.showGuiInput(bos.toString(), true, this.rememberMeKey != null);
                        v = v0 == null || v0.getValue() == null ? new char[]{} : ((String)v0.getValue()).toCharArray();
                        always = v0 != null && v0.isRememberMe();
                    } else {
                        v = this.terminal.readPassword(NMsg.ofPlain(" "));
                    }
                }
                if (Arrays.equals("cancel!".toCharArray(), v)) {
                    throw new NCancelException();
                }
                try {
                    if (this.validator != null) {
                        v = this.validator.validate(v, this);
                    }
                    if (always && this.rememberMeKey != null) {
                        askCache.set(this.rememberMeKey, v);
                    }
                    return (T)v;
                }
                catch (NCancelException ex) {
                    throw ex;
                }
                catch (Exception ex) {
                    out.println(NMsg.ofC("```error ERROR``` : %s", ex));
                }
            } else {
                CoreNUtilGui.GuiResult n;
                String responseStr;
                if (extraInfo) {
                    out.print("?\n");
                    out.flush();
                    if (gui) {
                        out.print(NMsg.ofC("\t Please enter value or ```error %s``` to cancel : ", "cancel!"));
                        out.flush();
                        v0 = this.showGuiInput(bos.toString(), false, this.rememberMeKey != null);
                        responseStr = v0 == null || v0.getValue() == null ? "" : (String)v0.getValue();
                        always = v0 != null && v0.isRememberMe();
                    } else {
                        responseStr = this.terminal.readLine(NMsg.ofC("\t Please enter value or ```error %s``` to cancel : ", "cancel!"));
                        if (responseStr != null) {
                            n = this.parseGuiResult(responseStr);
                            responseStr = (String)n.getValue();
                            always = n.isRememberMe();
                        }
                    }
                } else {
                    out.flush();
                    if (gui) {
                        out.print(" ? : ");
                        out.flush();
                        v0 = this.showGuiInput(bos.toString(), false, this.rememberMeKey != null);
                        responseStr = v0 == null || v0.getValue() == null ? "" : (String)v0.getValue();
                    } else {
                        responseStr = this.terminal.readLine(NMsg.ofPlain(" ? : "));
                    }
                    if (responseStr != null) {
                        n = this.parseGuiResult(responseStr);
                        responseStr = (String)n.getValue();
                        always = n.isRememberMe();
                    }
                }
                try {
                    MyNAskParseContext cc = new MyNAskParseContext(responseStr, this);
                    T parsed = p.parse(cc);
                    if (this.validator != null) {
                        parsed = this.validator.validate(parsed, this);
                    }
                    if (always && this.rememberMeKey != null) {
                        askCache.set(this.rememberMeKey, parsed);
                    }
                    return parsed;
                }
                catch (NCancelException ex) {
                    throw ex;
                }
                catch (Exception ex) {
                    out.println(NMsg.ofC("```error ERROR``` : %s", ex));
                }
            }
            extraInfo = true;
        }
    }

    private CoreNUtilGui.GuiResult parseGuiResult(String responseStr) {
        if (responseStr != null) {
            if (this.isBooleanType()) {
                if (responseStr.equals("a")) {
                    return new CoreNUtilGui.GuiResult("true", true);
                }
                if (responseStr.startsWith("!!")) {
                    responseStr = responseStr.substring(2);
                    return new CoreNUtilGui.GuiResult(responseStr, true);
                }
                if (responseStr.equals(responseStr.toUpperCase())) {
                    return new CoreNUtilGui.GuiResult(responseStr, true);
                }
            } else if (responseStr.startsWith("!!")) {
                responseStr = responseStr.substring(2);
                return new CoreNUtilGui.GuiResult(responseStr, true);
            }
        }
        return new CoreNUtilGui.GuiResult(responseStr, false);
    }

    private CoreNUtilGui.GuiResult showGuiInput(String str, boolean pwd, boolean rememberMe) {
        NSession session = NSession.of();
        String ft = NText.of(str).filteredText();
        NMsg title = NMsg.ofC("Nuts Package Manager - %s", session.getWorkspace().getApiId().getVersion());
        if (NApp.of().getId().orNull() != null) {
            try {
                String n;
                NDefinition def = NSearchCmd.of().setId(NApp.of().getId().get()).setLatest(true).getResultDefinitions().findFirst().orNull();
                if (def != null && !NBlankable.isBlank(n = def.getEffectiveDescriptor().get().getName())) {
                    title = NMsg.ofC("%s - %s", n, def.getEffectiveDescriptor().get().getId().getVersion());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.password) {
            return CoreNUtilGui.inputPassword(NMsg.ofNtf(str), title, rememberMe);
        }
        return CoreNUtilGui.inputString(NMsg.ofNtf(str), title, rememberMe);
    }

    @Override
    public boolean isResetLine() {
        return this.resetLine;
    }

    @Override
    public NAsk<T> resetLine() {
        return this.resetLine(true);
    }

    @Override
    public NAsk<T> resetLine(boolean resetLine) {
        this.resetLine = resetLine;
        return this;
    }

    @Override
    public NAsk<Boolean> forBoolean(NMsg msg) {
        return this.setValueType(Boolean.class).setMessage(msg);
    }

    @Override
    public NAsk<char[]> forPassword(NMsg msg) {
        this.password = true;
        return this.setValueType(char[].class).setMessage(msg);
    }

    @Override
    public NAsk<String> forString(NMsg msg) {
        return this.setValueType(String.class).setMessage(msg);
    }

    @Override
    public NAsk<Integer> forInt(NMsg msg) {
        return this.setValueType(Integer.class).setMessage(msg);
    }

    @Override
    public NAsk<Long> forLong(NMsg msg) {
        return this.setValueType(Long.class).setMessage(msg);
    }

    @Override
    public NAsk<Float> forFloat(NMsg msg) {
        return this.setValueType(Float.class).setMessage(msg);
    }

    @Override
    public NAsk<Double> forDouble(NMsg msg) {
        return this.setValueType(Double.class).setMessage(msg);
    }

    @Override
    public <K extends Enum> NAsk<K> forEnum(Class<K> enumType, NMsg msg) {
        Enum[] values = (Enum[])enumType.getEnumConstants();
        return this.setValueType(enumType).setMessage(msg).setAcceptedValues(Arrays.asList((Object[])values));
    }

    @Override
    public NMsg getHintMessage() {
        return this.hintMessage;
    }

    @Override
    public NMsg getMessage() {
        return this.message;
    }

    @Override
    public NMsg getCancelMessage() {
        return this.cancelMessage;
    }

    @Override
    public NAsk<T> setMessage(NMsg message) {
        this.message = message;
        return this;
    }

    @Override
    public NAsk<T> setHintMessage(NMsg message) {
        this.hintMessage = message;
        return this;
    }

    @Override
    public List<Object> getAcceptedValues() {
        return this.acceptedValues;
    }

    @Override
    public NAsk<T> setAcceptedValues(List<Object> acceptedValues) {
        this.acceptedValues = acceptedValues;
        return this;
    }

    @Override
    public T getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public NAsk<T> setDefaultValue(T defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    @Override
    public Class<T> getValueType() {
        return this.valueType;
    }

    @Override
    public NAsk<T> setValueType(Class<T> valueType) {
        this.valueType = valueType;
        return this;
    }

    @Override
    public NAskFormat<T> getFormat() {
        return this.format;
    }

    @Override
    public NAsk<T> setFormat(NAskFormat<T> parser) {
        this.format = parser;
        return this;
    }

    @Override
    public NAskParser<T> getParser() {
        return this.parser;
    }

    @Override
    public NAsk<T> setParser(NAskParser<T> parser) {
        this.parser = parser;
        return this;
    }

    @Override
    public NAskValidator<T> getValidator() {
        return this.validator;
    }

    @Override
    public NAsk<T> setValidator(NAskValidator<T> validator) {
        this.validator = validator;
        return this;
    }

    @Override
    public NAsk<T> run() {
        this.lastResult = this.execute();
        this.executed = true;
        return this;
    }

    @Override
    public Boolean getBooleanValue() {
        return (Boolean)this.getValue();
    }

    @Override
    public T getValue() {
        if (!this.executed) {
            this.run();
        }
        return (T)this.lastResult;
    }

    @Override
    public final NAsk<T> configure(boolean skipUnsupported, String ... args) {
        return (NAsk)NCmdLineConfigurable.configure(this, skipUnsupported, args, "question");
    }

    @Override
    public NAsk<T> setCancelMessage(NMsg message) {
        this.cancelMessage = message;
        return this;
    }

    @Override
    public boolean configureFirst(NCmdLine cmdLine) {
        NArg aa = cmdLine.peek().get();
        if (aa == null) {
            return false;
        }
        switch (aa.key()) {
            case "trace-confirmation": {
                cmdLine.matcher().matchFlag(v -> {
                    this.traceConfirmation = v.booleanValue();
                }).anyMatch();
            }
        }
        return false;
    }

    private boolean isBooleanType() {
        return this.getValueType().equals(Boolean.class) || this.getValueType().equals(Boolean.TYPE);
    }

    public static class NAskCache {
        Map<String, Object> cachedResponses = new HashMap<String, Object>();

        public Object get(String id) {
            return this.cachedResponses.get(id);
        }

        public void remove(String id) {
            this.cachedResponses.remove(id);
        }

        public void set(String id, Object value) {
            if (value != null) {
                this.cachedResponses.put(id, value);
            } else {
                this.cachedResponses.remove(id);
            }
        }
    }

    private static class MyNAskParseContext<T>
    implements NAskParseContext<T> {
        private final Object response;
        private final NAsk<T> question;

        public MyNAskParseContext(String response, NAsk<T> question) {
            this.response = response;
            this.question = question;
        }

        @Override
        public Object response() {
            return this.response;
        }

        @Override
        public NAsk<T> question() {
            return this.question;
        }
    }
}

