/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.security.MessageDigest;
import java.time.Instant;
import java.util.Map;
import java.util.Properties;
import java.util.function.Function;
import java.util.logging.Level;
import net.thevpc.nuts.core.NBootOptions;
import net.thevpc.nuts.io.NIOUtils;
import net.thevpc.nuts.io.NullInputStream;
import net.thevpc.nuts.log.NLog;
import net.thevpc.nuts.log.NMsgIntent;
import net.thevpc.nuts.platform.NStoreType;
import net.thevpc.nuts.runtime.standalone.io.NReservedMonitoredURLInputStream;
import net.thevpc.nuts.runtime.standalone.io.util.CoreIOUtils;
import net.thevpc.nuts.runtime.standalone.io.util.InputStreamExt;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.time.NChronometer;
import net.thevpc.nuts.time.NDuration;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NHex;

public class NCoreIOUtils {
    public static String toRelativePath(String child, String parent) {
        if (child.startsWith(parent)) {
            if ((child = child.substring(parent.length())).startsWith("/") || child.startsWith("\\")) {
                child = child.substring(1);
            }
            if (child.isEmpty()) {
                return "/";
            }
            return child;
        }
        return null;
    }

    public static Long detectLength(InputStream is) {
        if (is == null) {
            return 0L;
        }
        if (is instanceof NullInputStream) {
            return 0L;
        }
        if (is instanceof ByteArrayInputStream) {
            try {
                return is.available();
            }
            catch (IOException e) {
                return null;
            }
        }
        if (is instanceof InputStreamExt) {
            return ((InputStreamExt)is).getLength();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getURLDigest(URL url, NLog bLog) {
        if (url != null) {
            File ff = NCoreIOUtils.toFile(url);
            if (ff != null) {
                return NCoreIOUtils.getFileOrDirectoryDigest(ff.toPath());
            }
            InputStream is = null;
            try {
                is = NCoreIOUtils.openStream(url, bLog);
                if (is != null) {
                    String string = NCoreIOUtils.getStreamDigest(is);
                    return string;
                }
            }
            catch (Exception exception) {
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return null;
    }

    public static String getFileOrDirectoryDigest(Path p) {
        if (Files.isDirectory(p, new LinkOption[0])) {
            return NCoreIOUtils.getDirectoryDigest(p);
        }
        if (Files.isRegularFile(p, new LinkOption[0])) {
            String string;
            block10: {
                InputStream is = Files.newInputStream(p, new OpenOption[0]);
                try {
                    string = NCoreIOUtils.getStreamDigest(is);
                    if (is == null) break block10;
                }
                catch (Throwable throwable) {
                    try {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException ex) {
                        return null;
                    }
                }
                is.close();
            }
            return string;
        }
        return null;
    }

    private static String getDirectoryDigest(Path p) {
        try {
            final MessageDigest md = MessageDigest.getInstance("MD5");
            Files.walkFileTree(p, (FileVisitor<? super Path>)new FileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    NCoreIOUtils.incrementalUpdateFileDigest(new ByteArrayInputStream(dir.toString().getBytes()), md);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    NCoreIOUtils.incrementalUpdateFileDigest(new ByteArrayInputStream(file.toString().getBytes()), md);
                    NCoreIOUtils.incrementalUpdateFileDigest(Files.newInputStream(file, new OpenOption[0]), md);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    return FileVisitResult.CONTINUE;
                }
            });
            byte[] digest = md.digest();
            return NHex.fromBytes(digest);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getStreamDigest(InputStream is) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            return NCoreIOUtils.getStreamDigest(is, md, 2048);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static String getStreamDigest(InputStream is, MessageDigest md, int byteArraySize) {
        try {
            int numBytes;
            md.reset();
            byte[] bytes = new byte[byteArraySize];
            while ((numBytes = is.read(bytes)) != -1) {
                md.update(bytes, 0, numBytes);
            }
            byte[] digest = md.digest();
            return NHex.fromBytes(digest);
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    private static void incrementalUpdateFileDigest(InputStream is, MessageDigest md) {
        try {
            int numBytes;
            byte[] bytes = new byte[4096];
            while ((numBytes = is.read(bytes)) != -1) {
                md.update(bytes, 0, numBytes);
            }
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    public static String formatURL(URL url) {
        if (url == null) {
            return "<EMPTY>";
        }
        File f = NCoreIOUtils.toFile(url);
        if (f != null) {
            return f.getPath();
        }
        return url.toString();
    }

    public static boolean isFileAccessible(Path path, Instant expireTime, NLog bLog) {
        boolean proceed = Files.isRegularFile(path, new LinkOption[0]);
        if (proceed) {
            try {
                FileTime lastModifiedTime;
                if (expireTime != null && (lastModifiedTime = Files.getLastModifiedTime(path, new LinkOption[0])).toInstant().compareTo(expireTime) < 0) {
                    return false;
                }
            }
            catch (Exception ex0) {
                bLog.log(NMsg.ofC("unable to get LastModifiedTime for file : %s", path.toString(), ex0.toString()).withLevel(Level.FINEST).withIntent(NMsgIntent.FAIL));
            }
        }
        return proceed;
    }

    public static InputStream resolveInputStream(String url, NLog bLog) {
        InputStream in;
        block11: {
            in = null;
            try {
                if (url.startsWith("http://") || url.startsWith("https://")) {
                    URL url1 = CoreIOUtils.urlOf(url);
                    try {
                        in = NCoreIOUtils.openStream(url1, bLog);
                        break block11;
                    }
                    catch (Exception ex) {
                        return null;
                    }
                }
                if (url.startsWith("file:")) {
                    URL url1 = CoreIOUtils.urlOf(url);
                    File file = NCoreIOUtils.toFile(url1);
                    if (file == null) {
                        try {
                            in = NCoreIOUtils.openStream(url1, bLog);
                            break block11;
                        }
                        catch (Exception ex) {
                            return null;
                        }
                    }
                    if (file.isFile()) {
                        in = Files.newInputStream(file.toPath(), new OpenOption[0]);
                        break block11;
                    }
                    return null;
                }
                File file = new File(url);
                if (file.isFile()) {
                    in = Files.newInputStream(file.toPath(), new OpenOption[0]);
                    break block11;
                }
                return null;
            }
            catch (IOException e) {
                bLog.log(NMsg.ofC("unable to resolveInputStream %s", url).asFine(e).withIntent(NMsgIntent.FAIL));
            }
        }
        return in;
    }

    public static String expandPath(String path, String base, Function<String, String> pathExpansionConverter) {
        if (NCoreIOUtils.isURL(path = NMsg.ofV(path.trim(), pathExpansionConverter).toString())) {
            return path;
        }
        if (path.startsWith("~/") || path.startsWith("~\\")) {
            path = System.getProperty("user.home") + path.substring(1);
        }
        if (base == null) {
            base = System.getProperty("user.dir");
        }
        if (new File(path).isAbsolute()) {
            return path;
        }
        return base + File.separator + path;
    }

    public static String getStoreLocationPath(NBootOptions bOptions, NStoreType value) {
        Map<NStoreType, String> storeLocations = bOptions.getStoreLocations().orNull();
        if (storeLocations != null) {
            return storeLocations.get(value);
        }
        return null;
    }

    public static File createFile(String parent, String child) {
        String userHome = System.getProperty("user.home");
        if (child.startsWith("~/") || child.startsWith("~\\")) {
            child = new File(userHome, child.substring(2)).getPath();
        }
        if (child.startsWith("/") || child.startsWith("\\") || new File(child).isAbsolute()) {
            return new File(child);
        }
        if (parent != null) {
            if (parent.startsWith("~/")) {
                parent = new File(userHome, parent.substring(2)).getPath();
            }
        } else {
            parent = ".";
        }
        return new File(parent, child);
    }

    public static String getAbsolutePath(String path) {
        return new File(path).toPath().toAbsolutePath().normalize().toString();
    }

    public static InputStream openStream(URL url, NLog bLog) {
        return NReservedMonitoredURLInputStream.of(url, bLog);
    }

    public static byte[] loadStream(InputStream stream, NLog bLog) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        NIOUtils.copy(stream, bos, true, true);
        return bos.toByteArray();
    }

    public static ByteArrayInputStream preloadStream(InputStream stream, NLog bLog) throws IOException {
        return new ByteArrayInputStream(NCoreIOUtils.loadStream(stream, bLog));
    }

    public static Properties loadURLProperties(Path path, NLog bLog) {
        Properties props = new Properties();
        if (Files.isRegularFile(path, new LinkOption[0])) {
            try (InputStream is = Files.newInputStream(path, new OpenOption[0]);){
                props.load(is);
            }
            catch (IOException ex) {
                return new Properties();
            }
        }
        return props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Properties loadURLProperties(URL url, File cacheFile, boolean useCache, NLog bLog) {
        NChronometer chrono = NChronometer.startNow();
        Properties props = new Properties();
        InputStream inputStream = null;
        File urlFile = NCoreIOUtils.toFile(url);
        try {
            if (useCache && cacheFile != null && cacheFile.isFile()) {
                try {
                    inputStream = new FileInputStream(cacheFile);
                    props.load(inputStream);
                    chrono.stop();
                    NDuration time = chrono.getDuration();
                    bLog.log(NMsg.ofC("load cached file from  %s" + (!time.isZero() ? " (time %s)" : ""), cacheFile.getPath(), chrono).withLevel(Level.CONFIG).withIntent(NMsgIntent.SUCCESS));
                    Properties properties = props;
                    return properties;
                }
                catch (IOException ex) {
                    bLog.log(NMsg.ofC("invalid cache. Ignored %s : %s", cacheFile.getPath(), ex.toString()).withLevel(Level.CONFIG).withIntent(NMsgIntent.FAIL));
                }
                finally {
                    block30: {
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Exception ex) {
                                if (bLog == null) break block30;
                                bLog.log(NMsg.ofPlain("unable to close stream").asFine(ex).withIntent(NMsgIntent.FAIL));
                            }
                        }
                    }
                }
            }
            inputStream = null;
            try {
                if (url == null) return props;
                String urlString = url.toString();
                inputStream = NCoreIOUtils.openStream(url, bLog);
                if (inputStream != null) {
                    props.load(inputStream);
                    if (cacheFile != null) {
                        boolean copy = true;
                        if (urlFile != null && NCoreIOUtils.getAbsolutePath(urlFile.getPath()).equals(NCoreIOUtils.getAbsolutePath(cacheFile.getPath()))) {
                            copy = false;
                        }
                        if (copy) {
                            File pp = cacheFile.getParentFile();
                            if (pp != null) {
                                pp.mkdirs();
                            }
                            boolean cachedRecovered = cacheFile.isFile();
                            if (urlFile != null) {
                                NCoreIOUtils.copy(urlFile, cacheFile, bLog);
                            } else {
                                NCoreIOUtils.copy(url, cacheFile, bLog);
                            }
                            NDuration time = chrono.getDuration();
                            if (cachedRecovered) {
                                bLog.log(NMsg.ofC("recover cached prp file %s (from %s)" + (!time.isZero() ? " (time %s)" : ""), cacheFile.getPath(), urlString, time).withLevel(Level.CONFIG).withIntent(NMsgIntent.CACHE));
                            } else {
                                bLog.log(NMsg.ofC("cache prp file %s (from %s)" + (!time.isZero() ? " (time %s)" : ""), cacheFile.getPath(), urlString, time).withLevel(Level.CONFIG).withIntent(NMsgIntent.CACHE));
                            }
                            Properties properties = props;
                            return properties;
                        }
                    }
                    NDuration time = chrono.getDuration();
                    bLog.log(NMsg.ofC("load props file from  %s" + (!time.isZero() ? " (time %s)" : ""), urlString, time).withLevel(Level.CONFIG).withIntent(NMsgIntent.SUCCESS));
                    return props;
                }
                NDuration time = chrono.getDuration();
                bLog.log(NMsg.ofC("load props file from  %s" + (!time.isZero() ? " (time %s)" : ""), urlString, time).withLevel(Level.CONFIG).withIntent(NMsgIntent.FAIL));
                return props;
            }
            finally {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
        }
        catch (Exception e) {
            NDuration time = chrono.getDuration();
            bLog.log(NMsg.ofC("load props file from  %s" + (!time.isZero() ? " (time %s)" : ""), String.valueOf(url), time).withLevel(Level.CONFIG).withIntent(NMsgIntent.FAIL));
        }
        return props;
    }

    public static boolean isURL(String url) {
        if (url != null) {
            try {
                CoreIOUtils.urlOf(url);
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public static File toFile(String url) {
        if (NBlankable.isBlank(url)) {
            return null;
        }
        URL u = null;
        try {
            u = CoreIOUtils.urlOf(url);
            return NCoreIOUtils.toFile(u);
        }
        catch (Exception e) {
            return new File(url);
        }
    }

    public static File toFile(URL url) {
        if (url == null) {
            return null;
        }
        if ("file".equals(url.getProtocol())) {
            try {
                return Paths.get(url.toURI()).toFile();
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return null;
    }

    public static void copy(File ff, File to, NLog bLog) throws IOException {
        if (to.getParentFile() != null) {
            to.getParentFile().mkdirs();
        }
        if (ff == null || !ff.exists()) {
            bLog.log(NMsg.ofC("not found %s", ff).withLevel(Level.CONFIG).withIntent(NMsgIntent.FAIL));
            throw new FileNotFoundException(ff == null ? "" : ff.getPath());
        }
        try {
            Files.copy(ff.toPath(), to.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException ex) {
            bLog.log(NMsg.ofC("error copying %s to %s : %s", ff, to, ex.toString()).withLevel(Level.CONFIG).withIntent(NMsgIntent.FAIL));
            throw ex;
        }
    }

    public static void copy(URL url, File to, NLog bLog) throws IOException {
        try {
            boolean mkdirs;
            InputStream in = NCoreIOUtils.openStream(url, bLog);
            if (in == null) {
                throw new IOException("empty Stream " + url);
            }
            if (to.getParentFile() != null && !to.getParentFile().isDirectory() && !(mkdirs = to.getParentFile().mkdirs())) {
                bLog.log(NMsg.ofC("error creating folder %s", url).withLevel(Level.CONFIG).withIntent(NMsgIntent.FAIL));
            }
            ReadableByteChannel rbc = Channels.newChannel(in);
            FileOutputStream fos = new FileOutputStream(to);
            fos.getChannel().transferFrom(rbc, 0L, Long.MAX_VALUE);
        }
        catch (FileNotFoundException | UncheckedIOException ex) {
            bLog.log(NMsg.ofC("not found %s", url).withLevel(Level.CONFIG).withIntent(NMsgIntent.FAIL));
            throw ex;
        }
        catch (IOException ex) {
            bLog.log(NMsg.ofC("error copying %s to %s : %s", url, to, ex.toString()).withLevel(Level.CONFIG).withIntent(NMsgIntent.FAIL));
            throw ex;
        }
    }
}

