/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.installer.svc;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.thevpc.nuts.cmdline.NCmdLine;
import net.thevpc.nuts.command.NExecutionException;
import net.thevpc.nuts.command.NInstallSvcCmd;
import net.thevpc.nuts.core.NSession;
import net.thevpc.nuts.core.NWorkspace;
import net.thevpc.nuts.io.NPath;
import net.thevpc.nuts.io.NPathPermission;
import net.thevpc.nuts.io.NTrace;
import net.thevpc.nuts.platform.NOsServiceType;
import net.thevpc.nuts.runtime.standalone.installer.svc.ScriptBuilder;
import net.thevpc.nuts.runtime.standalone.installer.svc.SvcHelper;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NScorableContext;
import net.thevpc.nuts.util.NStringUtils;

public class DefaultInstallSvcCommand
implements NInstallSvcCmd {
    private NOsServiceType systemServiceType;
    private NOsServiceType serviceType;
    private String serviceName;
    private NPath root;
    private NPath workingDirectory;
    private boolean verbose;
    private String[] startCommand;
    private String[] stopCommand;
    private String[] statusCommand;
    private DefaultMapper vars = new DefaultMapper(this);
    private Map<String, String> env;
    private String nutsApiVersion = "0.8.4";
    private String serviceDescription = "System service";

    @Override
    public DefaultInstallSvcCommand setServiceType(NOsServiceType serviceType) {
        this.serviceType = serviceType;
        return this;
    }

    public NOsServiceType getServiceType() {
        return this.serviceType;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    @Override
    public NInstallSvcCmd setServiceName(String serviceName) {
        this.serviceName = serviceName;
        return this;
    }

    public NPath getRoot() {
        return this.root;
    }

    @Override
    public NInstallSvcCmd setRootDirectory(NPath root) {
        this.root = root;
        return this;
    }

    @Override
    public NPath getWorkingDirectory() {
        return this.workingDirectory;
    }

    @Override
    public NInstallSvcCmd setWorkingDirectory(NPath workingDirectory) {
        this.workingDirectory = workingDirectory;
        return this;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public NInstallSvcCmd setVerbose(boolean verbose) {
        this.verbose = verbose;
        return this;
    }

    @Override
    public NInstallSvcCmd setControlCommand(String[] startCommand) {
        ArrayList<String> base0 = new ArrayList<String>(Arrays.asList(startCommand));
        ArrayList<String> base = new ArrayList<String>(base0);
        base.add("start");
        this.setStartCommand(base.toArray(new String[0]));
        base = new ArrayList<String>(base0);
        base.add("stop");
        this.setStopCommand(base.toArray(new String[0]));
        base = new ArrayList<String>(base0);
        base.add("status");
        this.setStatusCommand(base.toArray(new String[0]));
        return this;
    }

    @Override
    public Map<String, String> getEnv() {
        return this.env;
    }

    @Override
    public NInstallSvcCmd setEnv(Map<String, String> env) {
        this.env = env;
        return this;
    }

    @Override
    public String[] getStartCommand() {
        return this.startCommand;
    }

    @Override
    public DefaultInstallSvcCommand setStartCommand(String[] startCommand) {
        this.startCommand = startCommand;
        return this;
    }

    @Override
    public String[] getStopCommand() {
        return this.stopCommand;
    }

    @Override
    public DefaultInstallSvcCommand setStopCommand(String[] stopCommand) {
        this.stopCommand = stopCommand;
        return this;
    }

    @Override
    public String[] getStatusCommand() {
        return this.statusCommand;
    }

    @Override
    public DefaultInstallSvcCommand setStatusCommand(String[] statusCommand) {
        this.statusCommand = statusCommand;
        return this;
    }

    @Override
    public boolean uninstall() {
        switch (this.getActualServiceType()) {
            case SYSTEMD: {
                String serviceFilePath = "/etc/systemd/system/" + this.serviceName + ".service";
                String dir = this.getCurrentWorkingDir().toString();
                String javaHome = System.getProperty("java.home");
                this.logInfo("");
                this.logInfo("== UNINSTALLING SERVICE SCRIPT ==");
                this.logInfo("install service    : " + this.serviceName);
                this.logInfo("working-dir        : " + dir);
                this.logInfo("java-home          : " + javaHome);
                this.logInfo("service-file       : " + serviceFilePath);
                this.logInfo("trying to remove service file: " + serviceFilePath);
                this.logInfo("ATTENTION: please ensure that the service is not running (sudo systemctl status " + this.serviceName + ")");
                this.logInfo("We need root privileges to run de-installation script. Please enter your root password.");
                this.runAsRoot(new ScriptBuilder("uninstall-" + this.serviceName, "uninstall-" + this.serviceName).printlnEcho("systemctl stop " + this.serviceName).printlnEcho("rm -Rf " + serviceFilePath));
                this.logInfoSuccess(this.serviceName + " uninstalled successfully.");
                return true;
            }
            case INITD: {
                String serviceFilePath = "/etc/init.d/" + this.serviceName;
                String dir = this.getCurrentWorkingDir().toString();
                String javaHome = System.getProperty("java.home");
                this.logInfo("");
                this.logInfo("== UNINSTALLING SERVICE SCRIPT ==");
                this.logInfo("install service    : " + this.serviceName);
                this.logInfo("working-dir        : " + dir);
                this.logInfo("java-home          : " + javaHome);
                this.logInfo("service-file       : " + serviceFilePath);
                this.logInfo("trying to remove service file: " + serviceFilePath);
                this.logInfo("ATTENTION: please ensure that the service is not running (sudo " + serviceFilePath + " stop )");
                this.logInfo("We need root privileges to run de-installation script. Please enter your root password.");
                this.runAsRoot(new ScriptBuilder("uninstall-" + this.serviceName, "uninstall-" + this.serviceName).printlnEcho("sudo " + serviceFilePath + " stop").printlnEcho("rm -Rf " + serviceFilePath));
                this.logInfoSuccess(this.serviceName + " uninstalled successfully.");
                return true;
            }
        }
        this.logError("Install service " + this.serviceName + " Failed");
        this.logError("Services are not supported on this platform. systemctl command is not available. Ignoring service installation");
        return false;
    }

    @Override
    public boolean install() {
        this.logInfoStart("Installing System Service...");
        switch (this.getActualServiceType()) {
            case SYSTEMD: {
                return this.installServiceSystemD();
            }
            case INITD: {
                return this.installServiceInitd();
            }
        }
        this.logError("Services are not supported on this platform. systemctl command is not available. Ignoring service installation");
        this.logInfo("use:");
        this.logInfo(this.formatCommand(this.startCommand));
        this.logInfo("      to start the service");
        this.logInfo(this.formatCommand(this.stopCommand));
        this.logInfo("      to stop the service");
        this.logInfo(this.formatCommand(this.statusCommand));
        this.logInfo("      to check the service status");
        return false;
    }

    private NPath getCurrentWorkingDir() {
        if (this.workingDirectory == null) {
            return NPath.ofUserDirectory();
        }
        return this.workingDirectory;
    }

    private boolean installServiceSystemD() {
        String serviceFilePath = this.rootFile("/etc/systemd/system/" + this.serviceName + ".service").toString();
        String dir = this.getCurrentWorkingDir().toString();
        String javaHome = System.getProperty("java.home");
        this.logInfo("");
        this.logInfo("== INSTALLING SERVICE SCRIPT ==");
        this.logInfo("service type       : " + NOsServiceType.SYSTEMD.name().toLowerCase());
        this.logInfo("install service    : " + this.serviceName);
        this.logInfo("working-dir        : " + dir);
        this.logInfo("java-home          : " + javaHome);
        this.logInfo("service-file       : " + serviceFilePath);
        File tempFile = null;
        try {
            this.logInfoStart("Creating systemd service file : " + serviceFilePath);
            tempFile = File.createTempFile("srv-" + this.serviceName, ".service");
            this.createFileFromTemplate("service-systemd", tempFile.toString());
            ScriptBuilder script = new ScriptBuilder(this.serviceName, "systemctl enable/start " + this.serviceName + " script").printlnEcho("cp " + tempFile.getPath() + " " + serviceFilePath);
            if (!this.isRootOverridden()) {
                script.printlnEcho("systemctl daemon-reload").printlnEcho("systemctl enable " + this.serviceName).printlnEcho("systemctl stop " + this.serviceName).printlnEcho("systemctl start " + this.serviceName).printlnEcho("systemctl status " + this.serviceName);
            }
            if (NSession.of().isDry()) {
                new File(serviceFilePath).getParentFile().mkdirs();
                Files.copy(tempFile.toPath(), new File(serviceFilePath).toPath(), StandardCopyOption.REPLACE_EXISTING);
                this.logInfo("[DRY] run script: ");
                this.logInfo(script.toString());
            } else {
                this.logInfo("We need root privileges to run installation script. Please enter your root password.");
                this.runAsRoot(script);
            }
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
        finally {
            if (tempFile != null) {
                tempFile.delete();
            }
        }
        this.logInfo("system controller service installed successfully.");
        this.logInfo("use:");
        this.logInfo("sudo systemctl start " + this.serviceName);
        this.logInfo("      to start the service");
        this.logInfo("sudo systemctl stop " + this.serviceName);
        this.logInfo("      to stop the service");
        this.logInfo("sudo systemctl status " + this.serviceName);
        this.logInfo("      to check the service status");
        this.logInfoSuccess("Service installed");
        return true;
    }

    private boolean installServiceInitd() {
        NPath serviceFilePath = this.rootFile("/etc/init.d/" + this.serviceName);
        String dir = this.getCurrentWorkingDir().toString();
        String javaHome = System.getProperty("java.home");
        this.logInfo("");
        this.logInfo("== INSTALLING SERVICE SCRIPT ==");
        this.logInfo("service type       : " + NOsServiceType.INITD.name().toLowerCase());
        this.logInfo("install service    : " + this.serviceName);
        this.logInfo("working-dir        : " + dir);
        this.logInfo("java-home          : " + javaHome);
        this.logInfo("service-file       : " + serviceFilePath);
        File tempFile = null;
        try {
            this.logInfoStart("Creating initd service file : " + serviceFilePath);
            tempFile = File.createTempFile("srv-" + this.serviceName, ".service");
            this.createFileFromTemplate("service-initd", tempFile.toString());
            NPath rcFile = this.rootFile("/etc/rc.d/S99z_" + this.serviceName);
            ScriptBuilder script = new ScriptBuilder(this.serviceName, "initd service enable/start " + this.serviceName + " script").printlnEcho("mkdir -p " + rcFile.getParent()).printlnEcho("mkdir -p " + serviceFilePath.getParent()).printlnEcho("cp " + tempFile.getPath() + " " + serviceFilePath).printlnEcho("rm -Rf " + rcFile).printlnEcho("ln -s " + serviceFilePath + " " + rcFile);
            if (!this.isRootOverridden()) {
                script.printlnEcho(serviceFilePath + " stop ");
            }
            script.printlnEcho("echo 'end of script'");
            if (NSession.of().isDry()) {
                serviceFilePath.getParent().mkdirs();
                Files.copy(tempFile.toPath(), serviceFilePath.toPath().get(), StandardCopyOption.REPLACE_EXISTING);
                this.logInfo("[DRY] run script: ");
                this.logInfo(script.toString());
            } else {
                this.logInfo("We need root privileges to run installation script. Please enter your root password.");
                this.runAsRoot(script);
            }
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
        finally {
            if (tempFile != null) {
                tempFile.delete();
            }
        }
        this.logInfo("system controller service installed successfully.");
        this.logInfo("use:");
        this.logInfo("sudo " + serviceFilePath + " start ");
        this.logInfo("      to start the service");
        this.logInfo("sudo " + serviceFilePath + " stop ");
        this.logInfo("      to stop the service");
        this.logInfo("sudo " + serviceFilePath + " status ");
        this.logInfo("      to check the service status");
        this.logInfoSuccess("Service installed");
        return true;
    }

    private void logVerbose(NMsg msg) {
        if (this.verbose) {
            NTrace.println(NMsg.ofC("[DEBUG] %s", msg));
        }
    }

    private void logInfoStart(String msg) {
        for (String line : SvcHelper.splitLines(msg)) {
            this.logInfo("[START  ] " + line);
        }
    }

    private void logInfoSuccess(String msg) {
        for (String line : SvcHelper.splitLines(msg)) {
            this.logInfo("[SUCCESS] " + line);
        }
    }

    private void logInfo(String msg) {
        for (String line : SvcHelper.splitLines(msg)) {
            NTrace.println(NMsg.ofC("[INFO ] %s", line));
        }
    }

    private void logWarn(String msg) {
        for (String line : SvcHelper.splitLines(msg)) {
            NTrace.println(NMsg.ofC("[WARN ] %s", line));
        }
    }

    private void logError(String msg) {
        for (String line : SvcHelper.splitLines(msg)) {
            NTrace.println(NMsg.ofC("[ERROR ] %s", line));
        }
    }

    public NOsServiceType getActualServiceType() {
        if (this.serviceType != null) {
            return this.serviceType;
        }
        return this.getSystemServiceType();
    }

    @Override
    public NOsServiceType getSystemServiceType() {
        if (this.systemServiceType == null) {
            this.logVerbose(NMsg.ofC("Checking if systemctl is available..."));
            try {
                this.runSystemCommand("systemctl", "--version");
                this.logVerbose(NMsg.ofC("[SUCCESS] found valid systemctl..."));
                this.systemServiceType = NOsServiceType.SYSTEMD;
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.logVerbose(NMsg.ofC("[FAIL   ] systemctl not found..."));
            if (this.systemServiceType == null) {
                this.logVerbose(NMsg.ofC("Checking if initd is available..."));
                try {
                    if (new File("/etc/init.d/").isDirectory()) {
                        this.logVerbose(NMsg.ofC("[SUCCESS] found valid initd..."));
                        this.systemServiceType = NOsServiceType.INITD;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.logVerbose(NMsg.ofC("[FAIL   ] initd not found..."));
            }
            if (this.systemServiceType == null) {
                this.systemServiceType = NOsServiceType.UNSUPPORTED;
            }
        }
        return this.systemServiceType;
    }

    private void runSystemCommand(String ... cmd) {
        this.logVerbose(NMsg.ofC("[RUNNING COMMAND] %s", NCmdLine.of(cmd)));
        ProcessBuilder processBuilder = new ProcessBuilder(cmd);
        processBuilder.inheritIO();
        Process p = null;
        int ret = -1;
        try {
            p = processBuilder.start();
            ret = p.waitFor();
            if (ret == 0) {
                this.logVerbose(NMsg.ofC("[RUNNING COMMAND] COMMAND SUCCEEDED : code %s", ret));
                return;
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        catch (InterruptedException e) {
            throw new UncheckedIOException(new IOException(e));
        }
        this.logVerbose(NMsg.ofC("[RUNNING COMMAND] COMMAND FAILED : code %s", ret));
        throw new NExecutionException(NMsg.ofC("run command returned %s", ret), ret);
    }

    private String formatCommand(String[] cmd) {
        return String.join((CharSequence)" ", cmd);
    }

    private void createFileFromTemplate(String resource0, String file) {
        String resource = "/net/thevpc/nuts/runtime/svc/" + resource0;
        this.logVerbose(NMsg.ofC("[FILE] CREATE FILE %s", NMsg.ofStyledPath(resource)));
        String lineSeparator = System.getProperty("line.separator");
        if (this.getClass().getResource(resource) == null) {
            throw new RuntimeException("resource not found " + resource);
        }
        try (BufferedReader br = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream(resource)));){
            String line = null;
            try (BufferedWriter bw = new BufferedWriter(new FileWriter(file));){
                while ((line = br.readLine()) != null) {
                    for (String line2 : SvcHelper.splitLines(this.vars.replaceVars(line))) {
                        bw.write(line2);
                        bw.write(lineSeparator);
                        this.logVerbose(NMsg.ofC("[FILE] %s", NMsg.ofStyledPath(line2)));
                    }
                }
            }
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
        this.file(file).setPermissions(NPathPermission.CAN_EXECUTE);
    }

    private String getInstallDir() {
        return this.getCurrentWorkingDir().toString();
    }

    private NPath file(String parent, String child) {
        return this.file(parent).resolve(child);
    }

    private boolean isRootOverridden() {
        if (NBlankable.isBlank(this.root)) {
            return false;
        }
        return !this.root.toString().equals("/");
    }

    private NPath rootFile(String path) {
        NPath rootFolder = this.isRootOverridden() ? this.root : NPath.of("/");
        rootFolder = rootFolder.toAbsolute().normalize();
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        return rootFolder.resolve(path);
    }

    private NPath file(String path) {
        NPath file = NPath.of(path);
        if (!file.isAbsolute()) {
            file = this.getCurrentWorkingDir().resolve(path);
        }
        return file.normalize();
    }

    private String getLibDir() {
        String t = this.env.get("target");
        if (t == null) {
            t = "lib";
        }
        t = DefaultInstallSvcCommand.replaceDollarString(t, this.env);
        return this.file(t).toString();
    }

    private static String replaceDollarString(String text, Map<String, String> m) {
        return DefaultInstallSvcCommand.replaceDollarString(text, m, true, 1000);
    }

    private static String replaceDollarString(String text, final Map<String, String> m, final boolean err, final int max) {
        return NStringUtils.replaceDollarPlaceHolder(text, new Function<String, String>(){

            @Override
            public String apply(String s) {
                return DefaultInstallSvcCommand.getProp(s, "${" + s + "}", m, err, max - 1);
            }
        });
    }

    private boolean isRoot() {
        return "root".equals(System.getProperty("user.name"));
    }

    private void runAsRoot(ScriptBuilder script) {
        this.logVerbose(NMsg.ofC("[ROOT-SCRIPT] %s (%s)", NMsg.ofStyledPrimary1(script.name), script.description));
        File tempFile = null;
        try {
            tempFile = File.createTempFile("script-", ".root");
            try (PrintStream out = new PrintStream(tempFile);){
                for (String s : script.lines()) {
                    out.println(s);
                    this.logVerbose(NMsg.ofC("[ROOT-SCRIPT] %s", s));
                }
            }
            tempFile.setExecutable(true);
            this.logVerbose(NMsg.ofC("[ROOT-SCRIPT] start "));
            this.runSystemCommandAsRoot(tempFile.getPath());
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
        finally {
            if (tempFile != null) {
                tempFile.delete();
            }
        }
    }

    private void runSystemCommandAsRoot(String cmd) {
        boolean sudo = false;
        List<String> suCommand = sudo ? Arrays.asList("sudo", "-S", cmd) : Arrays.asList("su", "-s", "/bin/sh", "root", "-c", cmd);
        this.runSystemCommand(suCommand.toArray(new String[0]));
    }

    private static String getProp(String n, String image, Map<String, String> m, boolean err, int max) {
        String x = m.get(n);
        if (x == null) {
            try {
                x = System.getProperty(n);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (x == null) {
            try {
                x = NWorkspace.of().getSysEnv(n).orNull();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (x == null) {
            if (err) {
                throw new IllegalArgumentException("var not found " + n);
            }
            x = image;
        } else if (x.indexOf(36) >= 0) {
            x = DefaultInstallSvcCommand.replaceDollarString(x, m, false, max);
        }
        return x;
    }

    @Override
    public int getScore(NScorableContext context) {
        return 10;
    }

    @Override
    public boolean configureFirst(NCmdLine cmdLine) {
        return false;
    }

    private static class DefaultMapper
    implements Function<String, String> {
        private Pattern PATTERN = Pattern.compile("[$][$](?<name>([^$]+))[$][$]");
        private DefaultInstallSvcCommand base;

        public DefaultMapper(DefaultInstallSvcCommand base) {
            this.base = base;
        }

        @Override
        public String apply(String s) {
            switch (s) {
                case "APP_INSTALL_DIR": {
                    return this.base.getInstallDir();
                }
                case "JAVA": {
                    return System.getProperty("java.home") + "/bin/java";
                }
                case "NUTS_APP_JAR": {
                    return this.base.getLibDir() + "/net/thevpc/nuts/nuts-app/" + this.base.nutsApiVersion + "/nuts-app-" + this.base.nutsApiVersion + ".jar";
                }
                case "USER": {
                    return System.getProperty("user.name");
                }
                case "START_COMMANDLINE": {
                    return this.base.formatCommand(this.base.startCommand);
                }
                case "STOP_COMMANDLINE": {
                    return this.base.formatCommand(this.base.stopCommand);
                }
                case "VAR_RUN": {
                    return this.base.rootFile("/var/run").toString();
                }
                case "VAR_LOG": {
                    return this.base.rootFile("/var/log").toString();
                }
                case "SERVICE_NAME": {
                    return this.base.serviceName;
                }
                case "SERVICE_DESCRIPTION": {
                    return this.base.serviceDescription;
                }
                case "PID_FILE": {
                    return this.base.getCurrentWorkingDir() + "/" + this.base.serviceName + ".pid";
                }
            }
            return "$$" + s + "$$";
        }

        public String replaceVars(String line) {
            Matcher matcher = this.PATTERN.matcher(line);
            StringBuffer sb = new StringBuffer();
            while (matcher.find()) {
                String name = matcher.group("name");
                String x = this.apply(name);
                if (x == null) {
                    x = "$$" + name + "$$";
                }
                matcher.appendReplacement(sb, Matcher.quoteReplacement(x));
            }
            matcher.appendTail(sb);
            return sb.toString();
        }
    }
}

