/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.installer;

import java.io.IOException;
import net.thevpc.nuts.artifact.NDefinition;
import net.thevpc.nuts.cmdline.NCmdLine;
import net.thevpc.nuts.command.NExecCmd;
import net.thevpc.nuts.command.NExecutionContext;
import net.thevpc.nuts.io.NIOException;
import net.thevpc.nuts.io.NPath;
import net.thevpc.nuts.platform.NStoreType;
import net.thevpc.nuts.runtime.standalone.io.util.UnzipOptions;
import net.thevpc.nuts.runtime.standalone.io.util.ZipUtils;
import net.thevpc.nuts.spi.NComponentScope;
import net.thevpc.nuts.spi.NInstallerComponent;
import net.thevpc.nuts.spi.NScopeType;
import net.thevpc.nuts.util.NScorableContext;

@NComponentScope(value=NScopeType.WORKSPACE)
public class ZipInstallerComponent
implements NInstallerComponent {
    @Override
    public int getScore(NScorableContext ctx) {
        NDefinition def = ctx.getCriteria(NDefinition.class);
        if (def != null && def.getDescriptor() != null && "zip".equals(def.getDescriptor().getPackaging())) {
            return 10;
        }
        return -1;
    }

    @Override
    public void install(NExecutionContext executionContext) {
        NDefinition nutsDefinition = executionContext.getDefinition();
        NPath installFolder = NPath.ofIdStore(nutsDefinition.getId(), NStoreType.BIN);
        NCmdLine cmd = NCmdLine.of(executionContext.getArguments());
        UnzipOptions unzipOptions = new UnzipOptions();
        while (cmd.hasNext()) {
            if (cmd.matcher().with("--unzip-skip-root").matchFlag(v -> unzipOptions.setSkipRoot(v.booleanValue())).anyMatch()) continue;
            cmd.skip();
        }
        try {
            ZipUtils.unzip(nutsDefinition.getContent().map(Object::toString).get(), installFolder.toString(), unzipOptions);
        }
        catch (IOException ex) {
            throw new NIOException(ex);
        }
        if (!executionContext.getExecutorOptions().isEmpty()) {
            NExecCmd.of().addCommand(executionContext.getExecutorOptions()).addExecutorOptions(executionContext.getExecutorOptions()).setEnv(executionContext.getEnv()).setDirectory(installFolder).getResultCode();
        }
    }

    @Override
    public void update(NExecutionContext executionContext) {
    }

    @Override
    public void uninstall(NExecutionContext executionContext, boolean deleteData) {
    }
}

