/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.id.format;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import net.thevpc.nuts.artifact.NEnvCondition;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.artifact.NIdBuilder;
import net.thevpc.nuts.artifact.NIdFormat;
import net.thevpc.nuts.cmdline.NArg;
import net.thevpc.nuts.cmdline.NCmdLine;
import net.thevpc.nuts.core.NWorkspace;
import net.thevpc.nuts.io.NPrintStream;
import net.thevpc.nuts.runtime.standalone.dependency.NDependencyScopes;
import net.thevpc.nuts.runtime.standalone.format.DefaultFormatBase;
import net.thevpc.nuts.runtime.standalone.util.filters.CoreFilterUtils;
import net.thevpc.nuts.text.NText;
import net.thevpc.nuts.text.NTextBuilder;
import net.thevpc.nuts.text.NTextStyle;
import net.thevpc.nuts.text.NTextStyleType;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NScorableContext;
import net.thevpc.nuts.util.NStringMapFormat;

public class DefaultNIdFormat
extends DefaultFormatBase<NIdFormat>
implements NIdFormat {
    private boolean omitRepository;
    private boolean omitGroup;
    private boolean omitImportedGroup;
    private boolean omitProperties;
    private boolean omitCondition;
    private boolean omitExclusion;
    private boolean highlightImportedGroup;
    private Set<String> omittedProperties = new HashSet<String>();
    private NId id;

    public DefaultNIdFormat() {
        super("id-format");
    }

    @Override
    public boolean isOmitCondition() {
        return this.omitCondition;
    }

    @Override
    public NIdFormat setOmitCondition(boolean omitCondition) {
        this.omitCondition = omitCondition;
        return this;
    }

    @Override
    public boolean isOmitExclusion() {
        return this.omitExclusion;
    }

    @Override
    public NIdFormat setOmitExclusion(boolean omitExclusion) {
        this.omitExclusion = omitExclusion;
        return this;
    }

    @Override
    public NIdFormat setNtf(boolean ntf) {
        super.setNtf(ntf);
        return this;
    }

    @Override
    public boolean isOmitRepository() {
        return this.omitRepository;
    }

    @Override
    public NIdFormat setOmitRepository(boolean value) {
        this.omitRepository = value;
        return this;
    }

    @Override
    public boolean isOmitGroupId() {
        return this.omitGroup;
    }

    @Override
    public NIdFormat setOmitGroupId(boolean value) {
        this.omitGroup = value;
        return this;
    }

    @Override
    public boolean isOmitImportedGroupId() {
        return this.omitImportedGroup;
    }

    @Override
    public NIdFormat setOmitImportedGroupId(boolean value) {
        this.omitImportedGroup = value;
        return this;
    }

    @Override
    public boolean isOmitOtherProperties() {
        return this.omitProperties;
    }

    @Override
    public NIdFormat setOmitOtherProperties(boolean value) {
        this.omitProperties = value;
        return this;
    }

    @Override
    public boolean isOmitFace() {
        return this.isOmitProperty("face");
    }

    @Override
    public NIdFormat setOmitFace(boolean value) {
        return this.setOmitProperty("face", value);
    }

    @Override
    public boolean isHighlightImportedGroupId() {
        return this.highlightImportedGroup;
    }

    @Override
    public NIdFormat setHighlightImportedGroupId(boolean value) {
        this.highlightImportedGroup = value;
        return this;
    }

    @Override
    public List<String> getOmitProperties() {
        return new ArrayList<String>(this.omittedProperties);
    }

    @Override
    public boolean isOmitProperty(String name) {
        return this.omittedProperties.contains(name);
    }

    @Override
    public NIdFormat setOmitProperty(String name, boolean value) {
        if (value) {
            this.omittedProperties.add(name);
        } else {
            this.omittedProperties.remove(name);
        }
        return this;
    }

    @Override
    public NId getValue() {
        return this.id;
    }

    @Override
    public NIdFormat setValue(NId id) {
        this.id = id;
        return this;
    }

    @Override
    public NText format() {
        boolean importedGroup;
        boolean importedGroup2;
        if (this.id == null) {
            return this.isNtf() ? NText.ofStyled("<null>", NTextStyle.of(NTextStyleType.BOOLEAN)) : NText.ofPlain("<null>");
        }
        Map<String, String> queryMap = this.id.getProperties();
        String scope = queryMap.remove("scope");
        String optional = queryMap.remove("optional");
        String classifier = this.id.getClassifier();
        NEnvCondition condition = this.id.getCondition();
        String exclusions = queryMap.remove("exclusions");
        String repo = queryMap.remove("repo");
        NIdBuilder idBuilder = this.id.builder();
        if (this.isOmitOtherProperties()) {
            idBuilder.clearProperties();
            idBuilder.setCondition(NEnvCondition.BLANK);
        } else if (this.isOmitFace()) {
            idBuilder.setProperty("face", null);
        }
        this.id = idBuilder.build();
        NTextBuilder sb = NTextBuilder.of();
        if (NBlankable.isBlank(classifier)) {
            if (!this.isOmitGroupId() && !NBlankable.isBlank(this.id.getGroupId())) {
                importedGroup2 = "net.thevpc.nuts".equals(this.id.getGroupId());
                importedGroup = NWorkspace.of().getAllImports().contains(this.id.getGroupId());
                if (!importedGroup || !this.isOmitImportedGroupId()) {
                    if (importedGroup || importedGroup2) {
                        sb.append((Object)this.id.getGroupId(), NTextStyle.pale());
                    } else {
                        sb.append(this.id.getGroupId());
                    }
                    sb.append((Object)":", NTextStyle.separator());
                }
            }
            sb.append((Object)this.id.getArtifactId(), NTextStyle.primary1());
        } else {
            if (!this.isOmitGroupId() && !NBlankable.isBlank(this.id.getGroupId())) {
                importedGroup2 = "net.thevpc.nuts".equals(this.id.getGroupId());
                importedGroup = NWorkspace.of().getAllImports().contains(this.id.getGroupId());
                if (!importedGroup || !this.isOmitImportedGroupId()) {
                    if (importedGroup || importedGroup2) {
                        sb.append((Object)this.id.getGroupId(), NTextStyle.pale());
                    } else {
                        sb.append(this.id.getGroupId());
                    }
                }
            }
            sb.append((Object)":", NTextStyle.separator());
            sb.append((Object)this.id.getArtifactId(), NTextStyle.primary1());
            sb.append((Object)":", NTextStyle.separator());
            sb.append((Object)this.id.getClassifier(), NTextStyle.primary2());
        }
        if (!NBlankable.isBlank(this.id.getVersion().getValue())) {
            sb.append((Object)"#", NTextStyle.separator());
            sb.append(this.id.getVersion());
        }
        boolean firstQ = true;
        if (!NDependencyScopes.isDefaultScope(scope)) {
            if (firstQ) {
                sb.append((Object)"?", NTextStyle.separator());
                firstQ = false;
            } else {
                sb.append((Object)"&", NTextStyle.separator());
            }
            sb.append((Object)"scope", NTextStyle.keyword(2)).append((Object)"=", NTextStyle.separator());
            sb.append(this._encodeKey(scope));
        }
        if (!NBlankable.isBlank(optional) && !"false".equalsIgnoreCase(optional)) {
            if (firstQ) {
                sb.append((Object)"?", NTextStyle.separator());
                firstQ = false;
            } else {
                sb.append((Object)"&", NTextStyle.separator());
            }
            sb.append((Object)"optional", NTextStyle.keyword(2)).append((Object)"=", NTextStyle.separator());
            sb.append(this._encodeKey(optional));
        }
        if (!this.isOmitRepository() && !NBlankable.isBlank(this.id.getRepository())) {
            if (firstQ) {
                sb.append((Object)"?", NTextStyle.separator());
                firstQ = false;
            } else {
                sb.append((Object)"&", NTextStyle.separator());
            }
            sb.append((Object)"repo", NTextStyle.keyword(2)).append((Object)"=", NTextStyle.separator());
            sb.append((Object)this._encodeKey(this.id.getRepository()), NTextStyle.pale());
        }
        if (!this.isOmitCondition()) {
            for (Map.Entry<String, String> e : CoreFilterUtils.toMap(condition).entrySet()) {
                String kk = e.getKey();
                String kv = e.getValue();
                if (firstQ) {
                    sb.append((Object)"?", NTextStyle.separator());
                    firstQ = false;
                } else {
                    sb.append((Object)"&", NTextStyle.separator());
                }
                sb.append((Object)this._encodeKey(kk), NTextStyle.keyword(2)).append((Object)"=", NTextStyle.separator());
                sb.append(this._encodeValue(kv));
            }
        }
        if (!this.isOmitExclusion() && !NBlankable.isBlank(exclusions)) {
            if (firstQ) {
                sb.append((Object)"?", NTextStyle.separator());
                firstQ = false;
            } else {
                sb.append((Object)"&", NTextStyle.separator());
            }
            sb.append((Object)"exclusions", NTextStyle.keyword(2)).append((Object)"=", NTextStyle.separator());
            sb.append((Object)this._encodeKey(exclusions), NTextStyle.warn());
        }
        if (!NBlankable.isBlank(this.id.getPropertiesQuery())) {
            TreeSet<String> otherKeys = new TreeSet<String>(queryMap.keySet());
            for (String k : otherKeys) {
                String v2 = queryMap.get(k);
                if (v2 == null) continue;
                if (firstQ) {
                    sb.append((Object)"?", NTextStyle.separator());
                    firstQ = false;
                } else {
                    sb.append((Object)"&", NTextStyle.separator());
                }
                sb.append((Object)this._encodeKey(k), NTextStyle.pale());
                sb.append((Object)"=", NTextStyle.separator());
                sb.append(this._encodeValue(v2));
            }
        }
        if (this.isNtf()) {
            return sb.immutable();
        }
        return NText.ofPlain(sb.filteredText());
    }

    private String _encodeValue(String s) {
        return NStringMapFormat.URL_ENCODER.apply(s);
    }

    private String _encodeKey(String s) {
        return NStringMapFormat.URL_ENCODER.apply(s);
    }

    @Override
    public void print(NPrintStream out) {
        out.print(this.format());
    }

    @Override
    public String toString() {
        return "NutsIdFormat{omitRepository=" + this.omitRepository + ", omitGroup=" + this.omitGroup + ", omitImportedGroup=" + this.omitImportedGroup + ", omitProperties=" + this.omitProperties + ", highlightImportedGroup=" + this.highlightImportedGroup + ", omittedProperties=" + this.omittedProperties + ", id=" + this.id + '}';
    }

    @Override
    public boolean configureFirst(NCmdLine cmdLine) {
        NArg aa = cmdLine.peek().get();
        if (aa == null) {
            return false;
        }
        switch (aa.key()) {
            case "--omit-env": {
                return cmdLine.matcher().matchFlag(v -> this.setOmitOtherProperties(v.booleanValue())).anyMatch();
            }
            case "--omit-face": {
                return cmdLine.matcher().matchFlag(v -> this.setOmitFace(v.booleanValue())).anyMatch();
            }
            case "--omit-group": {
                return cmdLine.matcher().matchFlag(v -> this.setOmitGroupId(v.booleanValue())).anyMatch();
            }
            case "--omit-imported-group": {
                return cmdLine.matcher().matchFlag(v -> this.setOmitImportedGroupId(v.booleanValue())).anyMatch();
            }
            case "--omit-repo": {
                return cmdLine.matcher().matchFlag(v -> this.setOmitRepository(v.booleanValue())).anyMatch();
            }
            case "--highlight-imported-group": {
                return cmdLine.matcher().matchFlag(v -> this.setHighlightImportedGroupId(v.booleanValue())).anyMatch();
            }
        }
        return false;
    }

    @Override
    public int getScore(NScorableContext context) {
        return 10;
    }
}

