/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.id.filter;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import net.thevpc.nuts.artifact.NDependencyFilters;
import net.thevpc.nuts.artifact.NEnvCondition;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.artifact.NIdFilter;
import net.thevpc.nuts.artifact.NVersion;
import net.thevpc.nuts.artifact.NVersionFilter;
import net.thevpc.nuts.command.NFetchCmd;
import net.thevpc.nuts.runtime.standalone.util.filters.CoreFilterUtils;
import net.thevpc.nuts.runtime.standalone.xtra.glob.GlobUtils;
import net.thevpc.nuts.spi.base.AbstractIdFilter;
import net.thevpc.nuts.spi.base.AbstractNPredicate;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NFilterOp;
import net.thevpc.nuts.util.NStringUtils;

public class NPatternIdFilter
extends AbstractIdFilter
implements NIdFilter {
    private NId id;
    private Pattern g;
    private Pattern n;
    private boolean wildcard;
    private NVersionFilter v;
    private Map<String, String> qm;
    private List<Predicate<Map<String, String>>> q = new ArrayList<Predicate<Map<String, String>>>();

    public NPatternIdFilter(NId id) {
        super(NFilterOp.CUSTOM);
        this.id = id;
        this.wildcard = NPatternIdFilter.containsWildcard(id.toString());
        this.g = GlobUtils.ofExact(id.getGroupId());
        this.n = GlobUtils.ofExact(id.getArtifactId());
        this.v = id.getVersion().filter();
        this.qm = id.getProperties();
        for (Map.Entry<String, String> entry : id.getProperties().entrySet()) {
            String key = entry.getKey();
            String val = entry.getValue();
            if (!key.contains("*")) {
                this.q.add(new PredicateStaticKey(key, val));
                continue;
            }
            if (!val.contains("*")) {
                // empty if block
            }
            this.q.add(new PredicateWildKey(key, val));
        }
    }

    public boolean isWildcard() {
        return this.wildcard;
    }

    public NId getId() {
        return this.id;
    }

    @Override
    public boolean acceptId(NId other) {
        if (!this.g.matcher(other.getGroupId()).matches()) {
            return false;
        }
        if (!this.n.matcher(other.getArtifactId()).matches()) {
            return false;
        }
        if (!this.v.acceptVersion(other.getVersion())) {
            return false;
        }
        Map<String, String> oqm = null;
        for (Predicate<Map<String, String>> pp : this.q) {
            if (oqm == null) {
                oqm = other.getProperties();
            }
            if (pp.test(oqm)) continue;
            return false;
        }
        NEnvCondition condition = this.id.getCondition();
        if (condition != null && !condition.isBlank()) {
            NBlankable otherCondition = null;
            try {
                otherCondition = NFetchCmd.of(other).setDependencyFilter(NDependencyFilters.of().byRunnable()).getResultDescriptor().getCondition();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (otherCondition != null && !otherCondition.isBlank() && !CoreFilterUtils.acceptCondition(condition, (NEnvCondition)otherCondition)) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int hash = 3;
        hash = 97 * hash + Objects.hashCode(this.id);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NPatternIdFilter other = (NPatternIdFilter)obj;
        return Objects.equals(this.id, other.id);
    }

    public String toString() {
        return this.id.toString();
    }

    public static boolean containsWildcard(NVersion version) {
        if (NBlankable.isBlank(version)) {
            return false;
        }
        return NPatternIdFilter.containsWildcardString(version.toString());
    }

    public static boolean containsWildcard(String id) {
        if (NBlankable.isBlank(id)) {
            return false;
        }
        NId nId = NId.of(id);
        if (NPatternIdFilter.containsWildcardString(nId.getArtifactId())) {
            return true;
        }
        if (NPatternIdFilter.containsWildcardString(nId.getGroupId())) {
            return true;
        }
        if (NPatternIdFilter.containsWildcard(nId.getVersion())) {
            return true;
        }
        return id.indexOf(42) >= 0;
    }

    private static boolean containsWildcardString(String id) {
        return !NBlankable.isBlank(id) && id.indexOf(42) >= 0;
    }

    @Override
    public NIdFilter simplify() {
        return this;
    }

    private static class PredicateStaticKey
    extends AbstractNPredicate<Map<String, String>> {
        private final String key;
        private final String val;
        private Pattern valPattern;

        public PredicateStaticKey(String key, String val) {
            this.key = key;
            this.val = val;
            this.valPattern = GlobUtils.ofExact(val);
        }

        @Override
        public boolean test(Map<String, String> x) {
            String sv = NStringUtils.trim(x.get(this.key));
            return this.valPattern.matcher(sv).matches();
        }

        public String toString() {
            return "EntryMatches[key='" + this.key + "',val='" + (NBlankable.isBlank(this.val) ? "*" : this.val) + "']";
        }
    }

    private static class PredicateWildKey
    extends AbstractNPredicate<Map<String, String>> {
        private Pattern keyPattern;
        private Pattern valPattern;
        private String skey;
        private String sval;

        public PredicateWildKey(String key, String val) {
            this.keyPattern = GlobUtils.ofExact(key);
            this.valPattern = GlobUtils.ofExact(val);
            this.skey = NBlankable.isBlank(key) ? "*" : key;
            this.sval = NBlankable.isBlank(val) ? "*" : val;
        }

        @Override
        public boolean test(Map<String, String> x) {
            for (Map.Entry<String, String> entry : x.entrySet()) {
                if (!this.keyPattern.matcher(entry.getKey()).matches()) continue;
                String sv = NStringUtils.trim(entry.getValue());
                return this.valPattern.matcher(sv).matches();
            }
            return false;
        }

        public String toString() {
            return "EntryMatches[key='" + this.skey + "',val='" + this.sval + "']";
        }
    }
}

