/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.id.filter;

import java.util.Objects;
import java.util.logging.Level;
import net.thevpc.nuts.artifact.NDefinition;
import net.thevpc.nuts.artifact.NDefinitionFilter;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.artifact.NIdFilter;
import net.thevpc.nuts.command.NFetchCmd;
import net.thevpc.nuts.log.NLog;
import net.thevpc.nuts.runtime.standalone.definition.NDefinitionDelegate;
import net.thevpc.nuts.runtime.standalone.repository.impl.maven.util.MavenRepositoryFolderHelper;
import net.thevpc.nuts.runtime.standalone.util.filters.CoreFilterUtils;
import net.thevpc.nuts.spi.base.AbstractIdFilter;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.util.NFilterOp;
import net.thevpc.nuts.util.NSimplifiable;
import net.thevpc.nuts.util.UncheckedException;

public class NDefinitionIdFilter
extends AbstractIdFilter
implements NIdFilter,
NSimplifiable<NIdFilter> {
    private final NDefinitionFilter filter;

    public NDefinitionIdFilter(NDefinitionFilter filter) {
        super(NFilterOp.CONVERT);
        this.filter = filter;
    }

    @Override
    public boolean acceptId(NId id) {
        if (this.filter == null) {
            return true;
        }
        MyNDefinition d = new MyNDefinition(id);
        return this.filter.acceptDefinition(d);
    }

    public int hashCode() {
        int hash = 3;
        hash = 97 * hash + Objects.hashCode(this.filter);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NDefinitionIdFilter other = (NDefinitionIdFilter)obj;
        return Objects.equals(this.filter, other.filter);
    }

    @Override
    public NIdFilter simplify() {
        NDefinitionFilter f2 = CoreFilterUtils.simplify(this.filter);
        if (f2 == null) {
            return null;
        }
        if (f2 == this.filter) {
            return this;
        }
        return new NDefinitionIdFilter(f2);
    }

    public String toString() {
        return String.valueOf(this.filter);
    }

    private static class MyNDefinition
    extends NDefinitionDelegate {
        NLog LOG = NLog.of(MavenRepositoryFolderHelper.class);
        NDefinition definition;
        private final NId id;
        boolean loaded;
        RuntimeException replayException;

        public MyNDefinition(NId id) {
            this.id = id;
        }

        @Override
        public NId getId() {
            return this.id;
        }

        @Override
        protected NDefinition getBase() {
            if (!this.loaded) {
                if (this.LOG == null) {
                    this.LOG = NLog.of(MavenRepositoryFolderHelper.class);
                }
                this.loaded = true;
                try {
                    this.definition = NFetchCmd.of(this.id).getResultDefinition();
                }
                catch (Exception ex2) {
                    UncheckedException ex2;
                    if (this.LOG.isLoggable(Level.FINER)) {
                        this.LOG.log(NMsg.ofC("unable to fetch descriptor for %s : %s", this.id, ex2).asFinestFail());
                    }
                    if (!(ex2 instanceof RuntimeException)) {
                        ex2 = new UncheckedException(ex2);
                    }
                    this.replayException = ex2;
                }
            }
            if (this.replayException != null) {
                throw this.replayException;
            }
            return this.definition;
        }
    }
}

