/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.id.filter;

import java.util.Objects;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.artifact.NIdFilter;
import net.thevpc.nuts.runtime.standalone.workspace.NWorkspaceExt;
import net.thevpc.nuts.spi.base.AbstractIdFilter;
import net.thevpc.nuts.util.NFilterOp;
import net.thevpc.nuts.util.NSimplifiable;

public class NDefaultVersionIdFilter
extends AbstractIdFilter
implements NIdFilter,
NSimplifiable<NIdFilter> {
    private final Boolean defaultVersion;

    public NDefaultVersionIdFilter(Boolean defaultVersion) {
        super(NFilterOp.CUSTOM);
        this.defaultVersion = defaultVersion;
    }

    @Override
    public boolean acceptId(NId other) {
        if (this.defaultVersion == null) {
            return true;
        }
        return NWorkspaceExt.of().getInstalledRepository().isDefaultVersion(other) == this.defaultVersion.booleanValue();
    }

    public int hashCode() {
        int hash = 3;
        hash = 97 * hash + Objects.hashCode(this.defaultVersion);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NDefaultVersionIdFilter other = (NDefaultVersionIdFilter)obj;
        return Objects.equals(this.defaultVersion, other.defaultVersion);
    }

    @Override
    public NIdFilter simplify() {
        if (this.defaultVersion == null) {
            return null;
        }
        return this;
    }

    public String toString() {
        return "defaultVersion(" + this.defaultVersion + ")";
    }
}

