/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.format.yaml;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import net.thevpc.nuts.runtime.standalone.format.json.ReaderLocation;
import net.thevpc.nuts.runtime.standalone.format.yaml.YamlToken;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NStringBuilder;
import net.thevpc.nuts.util.NStringUtils;

public class YamlTokenizer {
    private BufferedReader reader;
    private List<YamlToken> buffer = new ArrayList<YamlToken>();
    private YamlToken last;
    private Step stored = new Step();
    private Step curr = new Step();
    private boolean pushedBack;
    private Stack<String> flowMode = new Stack();

    public YamlTokenizer(Reader reader) {
        this.reader = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
    }

    void pushBack(YamlToken token) {
        this.buffer.add(0, token);
    }

    YamlToken next() {
        YamlToken u;
        if (!this.buffer.isEmpty()) {
            return this.buffer.remove(0);
        }
        this.last = u = this.next0();
        return u;
    }

    YamlToken next0() {
        try {
            int icurr;
            boolean wasNewline = false;
            int indentation = 0;
            while ((icurr = this.read()) != -1) {
                char ccurr = (char)icurr;
                if (icurr == 10 || icurr == 13) {
                    indentation = this.readIndents();
                    wasNewline = true;
                    continue;
                }
                boolean wasNewLinePrevious = wasNewline;
                int seenIndentation = wasNewline ? indentation : -1;
                wasNewline = false;
                switch (icurr) {
                    case 9: 
                    case 32: {
                        break;
                    }
                    case 34: {
                        return this.continueReadDoubleQuotedString(seenIndentation);
                    }
                    case 39: {
                        return this.continueReadSingleQuotedString(seenIndentation);
                    }
                    case 35: {
                        this.continueSkipComments();
                        break;
                    }
                    case 91: {
                        this.flowMode.push("[");
                        return new YamlToken("[", "[", YamlToken.Type.OPEN_BRACKET, seenIndentation);
                    }
                    case 123: {
                        this.flowMode.push("{");
                        return new YamlToken("{", "{", YamlToken.Type.OPEN_BRACE, seenIndentation);
                    }
                    case 125: {
                        if (!this.flowMode.isEmpty()) {
                            String s = this.flowMode.peek();
                            if (s.equals("[")) {
                                throw this.expected("']'");
                            }
                            this.flowMode.pop();
                            return new YamlToken("}", "}", YamlToken.Type.CLOSE_BRACE, seenIndentation);
                        }
                        return this.continueReadOpenString('}', seenIndentation, wasNewLinePrevious);
                    }
                    case 93: {
                        if (!this.flowMode.isEmpty()) {
                            String s = this.flowMode.peek();
                            if (s.equals("{")) {
                                throw this.expected("'}'");
                            }
                            this.flowMode.pop();
                            return new YamlToken("]", "]", YamlToken.Type.CLOSE_BRACKET, seenIndentation);
                        }
                        return this.continueReadOpenString(']', seenIndentation, wasNewLinePrevious);
                    }
                    case 44: {
                        if (!this.flowMode.isEmpty()) {
                            return new YamlToken(",", ",", YamlToken.Type.COMMA, seenIndentation);
                        }
                        return this.continueReadOpenString(',', seenIndentation, wasNewLinePrevious);
                    }
                    case 58: {
                        return new YamlToken(":", ":", YamlToken.Type.COLON, seenIndentation);
                    }
                    case 45: {
                        if (!this.flowMode.isEmpty()) {
                            throw this.error("invalid character " + (char)icurr);
                        }
                        if (wasNewLinePrevious) {
                            int n = this.read();
                            if (n == 9 || n == 32) {
                                return new YamlToken("-", "-", YamlToken.Type.DASH, seenIndentation);
                            }
                            return this.continueReadOpenString('-', seenIndentation, wasNewLinePrevious);
                        }
                        return this.continueReadOpenString('-', seenIndentation, wasNewLinePrevious);
                    }
                    case 62: 
                    case 124: {
                        String scalarType = String.valueOf((char)icurr);
                        int indent = seenIndentation;
                        this.reader.mark(1);
                        int n = this.reader.read();
                        if (n != -1) {
                            if (n == 43 || n == 45) {
                                scalarType = scalarType + String.valueOf((char)n);
                            } else {
                                this.reader.reset();
                            }
                        }
                        String value = this.readBlockScalar(scalarType, indent);
                        return new YamlToken(value, value, YamlToken.Type.BLOCK_SCALAR, indent);
                    }
                    default: {
                        if (icurr < 32) {
                            throw this.error("invalid character " + (char)icurr);
                        }
                        return this.continueReadOpenString((char)icurr, seenIndentation, wasNewLinePrevious);
                    }
                }
            }
            return null;
        }
        catch (IOException ex) {
            return null;
        }
    }

    private String readBlockScalar(String type, int parentIndent) throws IOException {
        NStringBuilder sb = new NStringBuilder();
        int scalarIndent = -1;
        ArrayList<String> lines = new ArrayList<String>();
        ArrayList<Integer> indents = new ArrayList<Integer>();
        while (true) {
            this.reader.mark(1024);
            int currLineLength = 0;
            int c = this.reader.read();
            if (c == -1) break;
            int lineIndent = 0;
            while (c == 32 || c == 9) {
                lineIndent += c == 32 ? 1 : 2;
                ++currLineLength;
                c = this.reader.read();
            }
            if (scalarIndent >= 0 && lineIndent < scalarIndent) {
                this.reader.reset();
                break;
            }
            StringBuilder line = new StringBuilder();
            while (c != -1 && c != 10 && c != 13) {
                line.append((char)c);
                ++currLineLength;
                c = this.reader.read();
            }
            while (c == 10 || c == 13) {
                ++currLineLength;
                c = this.reader.read();
            }
            String lineContent = line.toString();
            boolean isBlankLine = NBlankable.isBlank(lineContent);
            if (scalarIndent == -1 && !isBlankLine) {
                scalarIndent = lineIndent;
            }
            if (c != -1) {
                this.reader.reset();
                this.reader.skip(currLineLength);
            }
            if (scalarIndent == -1 && isBlankLine) continue;
            lines.add(lineContent);
            indents.add(lineIndent);
        }
        for (int i = 0; i < lines.size(); ++i) {
            String lineContent = (String)lines.get(i);
            boolean isBlankLine = NBlankable.isBlank(lineContent);
            if (type.startsWith(">")) {
                if (i > 0 && !sb.toString().isEmpty() && !isBlankLine) {
                    sb.append(' ');
                }
                if (isBlankLine) continue;
                sb.append(NStringUtils.trim(lineContent));
                continue;
            }
            if (i > 0) {
                sb.append('\n');
            }
            sb.append(lineContent);
        }
        String result = sb.toString();
        switch (type) {
            case "|-": 
            case ">-": {
                return result;
            }
            case "|+": 
            case ">+": {
                return result + "\n";
            }
        }
        return result + "\n";
    }

    private YamlToken continueReadOpenString(char current, int indentation, boolean wasNewLinePrevious) throws IOException {
        StringBuilder image = new StringBuilder();
        image.append(current);
        StringBuilder value = new StringBuilder();
        value.append(current);
        block23: while (true) {
            int next = this.read();
            switch (next) {
                case 10: 
                case 13: 
                case 35: {
                    this.unread();
                    break block23;
                }
                case 58: {
                    if (!wasNewLinePrevious && this.last != null && this.last.type == YamlToken.Type.COLON) {
                        image.append((char)next);
                        value.append((char)next);
                        continue block23;
                    }
                    this.unread();
                    break block23;
                }
                case 44: 
                case 93: 
                case 125: {
                    if (!this.flowMode.isEmpty()) {
                        this.unread();
                        break block23;
                    }
                    image.append((char)next);
                    value.append((char)next);
                    continue block23;
                }
                case -1: {
                    break block23;
                }
                default: {
                    image.append((char)next);
                    value.append((char)next);
                    continue block23;
                }
            }
            break;
        }
        String trimmed = value.toString().trim();
        if (trimmed.isEmpty()) {
            return new YamlToken(image.toString(), "", YamlToken.Type.NAME, indentation);
        }
        if (trimmed.length() > 0) {
            boolean digit = true;
            boolean dec = false;
            char[] charArray = trimmed.toCharArray();
            for (int i = 0; i < charArray.length; ++i) {
                char c = charArray[i];
                if (c == 'e' || c == 'E' || c == '.') {
                    dec = true;
                    continue;
                }
                if (c >= '0' && c <= '9' || i == 0 && (c == '-' || c == '+')) continue;
                digit = false;
            }
            if (digit) {
                if (dec) {
                    try {
                        return new YamlToken(image.toString(), Double.parseDouble(trimmed), YamlToken.Type.DECIMAL, indentation);
                    }
                    catch (Exception ex) {
                        try {
                            return new YamlToken(image.toString(), Long.parseLong(trimmed), YamlToken.Type.INTEGER, indentation);
                        }
                        catch (Exception ex2) {
                            return new YamlToken(image.toString(), trimmed, this.isName(trimmed) ? YamlToken.Type.NAME : YamlToken.Type.OPEN_STRING, indentation);
                        }
                    }
                }
                try {
                    return new YamlToken(image.toString(), Long.parseLong(trimmed), YamlToken.Type.INTEGER, indentation);
                }
                catch (Exception ex2) {
                    return new YamlToken(image.toString(), trimmed, this.isName(trimmed) ? YamlToken.Type.NAME : YamlToken.Type.OPEN_STRING, indentation);
                }
            }
            switch (trimmed) {
                case "true": {
                    return new YamlToken(image.toString(), true, YamlToken.Type.TRUE, indentation);
                }
                case "false": {
                    return new YamlToken(image.toString(), false, YamlToken.Type.FALSE, indentation);
                }
                case "~": 
                case "null": {
                    return new YamlToken(image.toString(), false, YamlToken.Type.NULL, indentation);
                }
            }
            return new YamlToken(image.toString(), trimmed, this.isName(trimmed) ? YamlToken.Type.NAME : YamlToken.Type.OPEN_STRING, indentation);
        }
        return new YamlToken(image.toString(), trimmed, this.isName(trimmed) ? YamlToken.Type.NAME : YamlToken.Type.OPEN_STRING, indentation);
    }

    private boolean isName(String a) {
        if (a.length() == 0) {
            return false;
        }
        return a.matches("[a-zA-Z_]([a-zA-Z0-9_-])*");
    }

    private void continueSkipComments() throws IOException {
        int c;
        do {
            if ((c = this.read()) != 10 && c != 13) continue;
            this.unread();
            return;
        } while (c != -1);
    }

    private RuntimeException expected(String expected) {
        return this.error("expected " + expected);
    }

    private RuntimeException error(String message) {
        return new RuntimeException(message + ":" + this.getLocation());
    }

    ReaderLocation getLocation() {
        return new ReaderLocation(this.curr.fileOffset, this.curr.lineNumber, this.curr.lineOffset);
    }

    private boolean isHexDigit(int current) {
        return current >= 48 && current <= 57 || current >= 97 && current <= 102 || current >= 65 && current <= 70;
    }

    private YamlToken continueReadSingleQuotedString(int indentation) throws IOException {
        StringBuilder image = new StringBuilder();
        StringBuilder value = new StringBuilder();
        image.append("'");
        while (true) {
            int current;
            if ((current = this.read()) == -1) {
                throw this.expected("\"'\"");
            }
            if (current == 39) {
                current = this.read();
                if (current == 39) {
                    value.append((char)current);
                    image.append((char)current);
                    continue;
                }
                if (current == -1) break;
                this.unread();
                break;
            }
            if (current < 32) {
                throw this.expected("valid string character");
            }
            image.append((char)current);
            value.append((char)current);
        }
        return new YamlToken(image.toString(), value.toString(), YamlToken.Type.SINGLE_STRING, indentation);
    }

    private YamlToken continueReadDoubleQuotedString(int indentation) throws IOException {
        StringBuilder image = new StringBuilder();
        StringBuilder value = new StringBuilder();
        image.append("\"");
        block9: while (true) {
            int current;
            if ((current = this.read()) == -1) {
                throw this.expected("'\"'");
            }
            if (current == 34) break;
            image.append((char)current);
            if (current == 92) {
                switch (current) {
                    case 34: 
                    case 47: 
                    case 92: {
                        value.append((char)current);
                        continue block9;
                    }
                    case 98: {
                        value.append('\b');
                        continue block9;
                    }
                    case 102: {
                        value.append('\f');
                        continue block9;
                    }
                    case 110: {
                        value.append('\n');
                        continue block9;
                    }
                    case 114: {
                        value.append('\r');
                        continue block9;
                    }
                    case 116: {
                        value.append('\t');
                        continue block9;
                    }
                    case 117: {
                        char[] hexChars = new char[4];
                        for (int i = 0; i < 4; ++i) {
                            current = this.read();
                            if (!this.isHexDigit(current)) {
                                throw this.expected("hexadecimal digit");
                            }
                            hexChars[i] = (char)current;
                        }
                        value.append((char)Integer.parseInt(new String(hexChars), 16));
                        continue block9;
                    }
                }
                throw this.expected("valid escape sequence");
            }
            if (current < 32) {
                throw this.expected("valid string character");
            }
            value.append((char)current);
        }
        return new YamlToken(image.toString(), value.toString(), YamlToken.Type.DOUBLE_STRING, indentation);
    }

    private int readIndents() throws IOException {
        int indent;
        block2: {
            int c;
            indent = 0;
            while (true) {
                if ((c = this.read()) == 32) {
                    ++indent;
                    continue;
                }
                if (c != 9) break;
                indent += 2;
            }
            if (c == -1) break block2;
            this.unread();
        }
        return indent;
    }

    private void unread() throws IOException {
        if (this.pushedBack) {
            throw new IllegalArgumentException("cannot pushback");
        }
        this.stored = this.curr.clone();
        this.pushedBack = true;
    }

    private int read() throws IOException {
        if (this.pushedBack) {
            this.curr = this.stored;
            this.pushedBack = false;
            return this.curr.current;
        }
        this.curr.current = this.reader.read();
        if (this.curr.current == -1) {
            return -1;
        }
        this.curr.fileOffset++;
        if (this.curr.current == 10) {
            this.curr.lineNumber++;
            this.curr.lineOffset = 0;
            return this.curr.current;
        }
        if (this.curr.current == 13) {
            this.curr.lineNumber++;
            this.curr.lineOffset = 0;
            this.reader.mark(1);
            int n = this.reader.read();
            if (n == -1) {
                return this.curr.current;
            }
            if (n == 10) {
                this.curr.fileOffset++;
                return this.curr.current;
            }
            this.reader.reset();
            return this.curr.current;
        }
        this.curr.lineOffset++;
        return this.curr.current;
    }

    private static class Step
    implements Cloneable {
        private int fileOffset;
        private int lineNumber;
        private int lineOffset;
        private int current;

        private Step() {
        }

        public Step clone() {
            try {
                return (Step)super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException(e);
            }
        }

        public String toString() {
            return "Step{fileOffset=" + this.fileOffset + ", lineNumber=" + this.lineNumber + ", lineOffset=" + this.lineOffset + ", current=" + (this.current == -1 ? "-1" : "'" + (char)this.current + "'") + '}';
        }
    }
}

