/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.format.xml;

import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.function.Predicate;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.thevpc.nuts.io.NIOException;
import net.thevpc.nuts.log.NLog;
import net.thevpc.nuts.text.NMsg;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XmlUtils {
    public static String createElementName(String name) {
        if (name == null) {
            name = "";
        }
        if ((name = name.trim()).isEmpty()) {
            name = "node";
        }
        if (Character.isDigit(name.charAt(0))) {
            name = "_" + name;
        }
        if (name.toLowerCase().startsWith("xml")) {
            name = "_" + name;
        }
        char[] r = name.toCharArray();
        for (int i = 0; i < r.length; ++i) {
            char c = r[i];
            if (Character.isDigit(c) || Character.isLetter(c) || c == '_' || c == '-' || c == '.') continue;
            r[i] = 95;
        }
        return new String(r);
    }

    public static Document createDocument() {
        return XmlUtils.createDocumentBuilder(false).newDocument();
    }

    public static DocumentBuilder createDocumentBuilder(boolean safe) {
        DocumentBuilder b;
        DocumentBuilderFactory documentFactory = DocumentBuilderFactory.newInstance();
        if (safe) {
            documentFactory.setExpandEntityReferences(false);
            XmlUtils.setLenientFeature(documentFactory, "http://xerces.apache.org/xerces-j/features.html#external-general-entities", false);
            XmlUtils.setLenientFeature(documentFactory, "http://xerces.apache.org/xerces2-j/features.html#external-general-entities", false);
            XmlUtils.setLenientFeature(documentFactory, "http://xml.org/sax/features/external-general-entities", false);
            XmlUtils.setLenientFeature(documentFactory, "http://xerces.apache.org/xerces-j/features.html#external-parameter-entities", false);
            XmlUtils.setLenientFeature(documentFactory, "http://xml.org/sax/features/external-parameter-entities", false);
            XmlUtils.setLenientFeature(documentFactory, "http://xerces.apache.org/xerces2-j/features.html#external-parameter-entities", false);
            XmlUtils.setLenientFeature(documentFactory, "http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            documentFactory.setXIncludeAware(false);
            documentFactory.setValidating(false);
        }
        try {
            b = documentFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException ex) {
            throw new NIOException(ex);
        }
        b.setErrorHandler(new ErrorHandler(){

            @Override
            public void warning(SAXParseException exception) throws SAXException {
                NLog.of(XmlUtils.class).log(NMsg.ofC("%s", exception).asFinestAlert());
            }

            @Override
            public void error(SAXParseException exception) throws SAXException {
                NLog.of(XmlUtils.class).log(NMsg.ofC("%s", exception).asFinestAlert());
            }

            @Override
            public void fatalError(SAXParseException exception) throws SAXException {
                NLog.of(XmlUtils.class).log(NMsg.ofC("%s", exception).asFinestAlert());
            }
        });
        return b;
    }

    private static void setLenientFeature(DocumentBuilderFactory dbFactory, String s, boolean b) {
        try {
            dbFactory.setFeature(s, b);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static String documentToString(Document document) {
        ByteArrayOutputStream b = new ByteArrayOutputStream();
        XmlUtils.writeDocument(document, new StreamResult(b), true, true);
        return new String(b.toByteArray());
    }

    public static String elementToString(Element elem) {
        try {
            ByteArrayOutputStream b = new ByteArrayOutputStream();
            Document d = XmlUtils.createDocument();
            elem = (Element)d.importNode(elem, true);
            d.appendChild(elem);
            XmlUtils.writeDocument(d, new StreamResult(b), true, false);
            return new String(b.toByteArray());
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static Element asElement(Node n) {
        if (n instanceof Element) {
            return (Element)n;
        }
        return null;
    }

    public static Iterable<Node> iterable(final Node n) {
        return new Iterable<Node>(){

            @Override
            public Iterator<Node> iterator() {
                final NodeList nl = n.getChildNodes();
                return new Iterator<Node>(){
                    int i = 0;

                    @Override
                    public boolean hasNext() {
                        return this.i < nl.getLength();
                    }

                    @Override
                    public Node next() {
                        int i0 = this.i++;
                        return nl.item(i0);
                    }
                };
            }
        };
    }

    public static void writeDocument(Document document, StreamResult writer, boolean compact, boolean headerDeclaration) {
        Transformer transformer;
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        try {
            transformer = transformerFactory.newTransformer();
        }
        catch (TransformerConfigurationException ex) {
            throw new NIOException(ex);
        }
        transformer.setOutputProperty("encoding", "UTF-8");
        if (!compact) {
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        }
        document.setXmlStandalone(false);
        transformer.setOutputProperty("standalone", "no");
        if (!headerDeclaration) {
            transformer.setOutputProperty("omit-xml-declaration", "yes");
        }
        DOMSource domSource = new DOMSource(document);
        try {
            transformer.transform(domSource, writer);
        }
        catch (TransformerException ex) {
            throw new NIOException(ex);
        }
    }

    public static boolean visitNode(Node n, Predicate<Node> tst) {
        if (!tst.test(n)) {
            return false;
        }
        if (n instanceof Element) {
            Element e = (Element)n;
            NodeList nl = e.getChildNodes();
            int len = nl.getLength();
            for (int i = 0; i < len; ++i) {
                if (XmlUtils.visitNode(nl.item(i), tst)) continue;
                return false;
            }
        }
        return true;
    }

    public static String nodePath(Node n) {
        ArrayList<String> a = new ArrayList<String>();
        while (n != null && !(n instanceof Document)) {
            String nn = n.getNodeName();
            if (nn != null) {
                a.add(nn);
            }
            n = n.getParentNode();
        }
        Collections.reverse(a);
        return String.join((CharSequence)"/", a);
    }

    public static boolean isNode(Element n, String ... names) {
        Node nn = n;
        for (int i = names.length - 1; i >= 0; --i) {
            if (nn == null) {
                return false;
            }
            if (nn instanceof Element) {
                Element e = nn;
                String s = names[i];
                if (s.length() > 0 && !e.getNodeName().equals(s)) {
                    return false;
                }
            } else {
                return false;
            }
            nn = nn.getParentNode();
        }
        return true;
    }

    public static boolean testNode(Node n, Predicate<Node> tst) {
        if (tst.test(n)) {
            return true;
        }
        if (n instanceof Element) {
            Element e = (Element)n;
            NodeList nl = e.getChildNodes();
            int len = nl.getLength();
            for (int i = 0; i < len; ++i) {
                if (!XmlUtils.testNode(nl.item(i), tst)) continue;
                return true;
            }
        }
        return false;
    }
}

