/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.format.xml;

import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import javax.xml.transform.stream.StreamResult;
import net.thevpc.nuts.elem.NElement;
import net.thevpc.nuts.elem.NElementFactoryContext;
import net.thevpc.nuts.io.NIOException;
import net.thevpc.nuts.io.NMemoryPrintStream;
import net.thevpc.nuts.io.NPrintStream;
import net.thevpc.nuts.runtime.standalone.elem.NElementStreamFormat;
import net.thevpc.nuts.runtime.standalone.format.xml.XmlUtils;
import net.thevpc.nuts.text.NText;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DefaultXmlNElementStreamFormat
implements NElementStreamFormat {
    @Override
    public NElement parseElement(Reader reader, NElementFactoryContext context, Object readerSource) {
        Document doc = null;
        try {
            doc = XmlUtils.createDocumentBuilder(false).parse(new InputSource(reader));
        }
        catch (SAXException ex) {
            throw new NIOException(new IOException(ex));
        }
        catch (IOException ex) {
            throw new NIOException(ex);
        }
        return context.createElement(doc, (Type)((Object)Document.class));
    }

    @Override
    public NElement normalize(NElement e) {
        return e;
    }

    @Override
    public void printElement(NElement value, NPrintStream out, boolean compact, NElementFactoryContext context) {
        Document doc = context.createObject(value, Document.class);
        if (out.isNtf()) {
            NMemoryPrintStream bos = NMemoryPrintStream.of();
            XmlUtils.writeDocument(doc, new StreamResult(bos.asPrintStream()), compact, true);
            out.print(NText.ofCode("xml", bos.toString()));
        } else {
            XmlUtils.writeDocument(doc, new StreamResult(out.asPrintStream()), compact, true);
        }
    }
}

