/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.format.xml;

import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import javax.xml.transform.stream.StreamResult;
import net.thevpc.nuts.cmdline.NArg;
import net.thevpc.nuts.cmdline.NCmdLine;
import net.thevpc.nuts.elem.NElements;
import net.thevpc.nuts.io.NPrintStream;
import net.thevpc.nuts.runtime.standalone.format.DefaultSearchFormatBase;
import net.thevpc.nuts.runtime.standalone.format.NFetchDisplayOptions;
import net.thevpc.nuts.runtime.standalone.format.xml.XmlUtils;
import net.thevpc.nuts.spi.NCodeHighlighter;
import net.thevpc.nuts.text.NContentType;
import net.thevpc.nuts.text.NTextBuilder;
import net.thevpc.nuts.text.NTexts;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DefaultSearchFormatXml
extends DefaultSearchFormatBase {
    private boolean compact;
    private String rootName = "root";
    private NCodeHighlighter codeFormat;
    NTexts txt = NTexts.of();

    public DefaultSearchFormatXml(NPrintStream writer, NFetchDisplayOptions options) {
        super(writer, NContentType.XML, options);
        this.codeFormat = NTexts.of().getCodeHighlighter("xml");
    }

    public String getRootName() {
        return this.rootName;
    }

    @Override
    public void start() {
        NTextBuilder builder = NTextBuilder.of();
        builder.append(this.codeFormat.tokenToText("<?", "separator", this.txt));
        builder.append(this.codeFormat.tokenToText("xml", "name", this.txt));
        builder.append(" ");
        builder.append(this.codeFormat.tokenToText("version", "attribute", this.txt));
        builder.append(this.codeFormat.tokenToText("=", "separator", this.txt));
        builder.append(this.codeFormat.tokenToText("\"1.0\"", "string", this.txt));
        builder.append(" ");
        builder.append(this.codeFormat.tokenToText("encoding", "attribute", this.txt));
        builder.append(this.codeFormat.tokenToText("=", "separator", this.txt));
        builder.append(this.codeFormat.tokenToText("?>", "separator", this.txt));
        builder.append("\n");
        builder.append(this.codeFormat.tokenToText("<", "separator", this.txt));
        builder.append(this.codeFormat.tokenToText(this.rootName, "name", this.txt));
        builder.append(this.codeFormat.tokenToText(">", "separator", this.txt));
        this.getWriter().println(builder.toString());
    }

    @Override
    public void next(Object object, long index) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        PrintWriter pw = new PrintWriter(bos);
        Element xmlElement = NElements.of().convert(object, Element.class);
        Document doc = XmlUtils.createDocument();
        doc.adoptNode(xmlElement);
        doc.appendChild(xmlElement);
        XmlUtils.writeDocument(doc, new StreamResult(pw), this.compact, false);
        pw.flush();
        this.getWriter().print(this.codeFormat.stringToText(bos.toString(), this.txt));
    }

    @Override
    public void complete(long count) {
        NTextBuilder builder = NTextBuilder.of();
        builder.append(this.codeFormat.tokenToText("</", "separator", this.txt));
        builder.append(this.codeFormat.tokenToText(this.rootName, "name", this.txt));
        builder.append(this.codeFormat.tokenToText(">", "separator", this.txt));
        this.getWriter().println(builder.toString());
        this.getWriter().flush();
    }

    @Override
    public boolean configureFirst(NCmdLine cmdLine) {
        NArg a = cmdLine.peek().get();
        if (a == null) {
            return false;
        }
        if (this.getDisplayOptions().configureFirst(cmdLine)) {
            return true;
        }
        switch (a.key()) {
            case "--compact": {
                return cmdLine.matcher().matchFlag(v -> {
                    this.compact = v.booleanValue();
                }).anyMatch();
            }
            case "--root-name": {
                return cmdLine.matcher().matchEntry(v -> {
                    this.rootName = v.stringValue();
                }).anyMatch();
            }
        }
        return false;
    }
}

