/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.format.tson.bundled.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UncheckedIOException;
import java.util.Arrays;

public class Base64DecoderAdapter
extends InputStream {
    private static final char[] TO_BASE64_CHARS = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
    private static final int[] FROM_BASE64_BYTES = new int[256];
    private Reader in;
    private byte[] outBuffer;
    private int outBufferWriteIndex = 0;
    private int outBufferReadIndex = 0;
    private char[] inBuffer = new char[4];
    private int inBufferIndex = 0;
    private char[] tempBuffer;

    public Base64DecoderAdapter(Reader in) {
        this(in, -1);
    }

    public Base64DecoderAdapter(Reader in, int outBufferSize) {
        this.in = in;
        if (outBufferSize < 10) {
            outBufferSize = 10;
        }
        this.outBuffer = new byte[outBufferSize + 4];
        this.tempBuffer = new char[outBufferSize];
    }

    public static byte[] fromBase64(String bytes) {
        Base64DecoderAdapter r = new Base64DecoderAdapter(new StringReader(bytes));
        byte[] buffer = new byte[1024];
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            int i;
            while ((i = r.read(buffer)) != 0) {
                out.write(buffer, 0, i);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return out.toByteArray();
    }

    private boolean pushChar(char cc) {
        if (cc <= ' ') {
            return false;
        }
        this.inBuffer[this.inBufferIndex++] = cc;
        if (this.inBufferIndex == 4) {
            this.pushCharLast();
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void pushCharLast() {
        int b0 = FROM_BASE64_BYTES[this.inBuffer[0] & 0xFF];
        if (b0 < 0) {
            throw new IllegalArgumentException("Illegal base64 character " + Integer.toString(b0, 16));
        }
        int b1 = FROM_BASE64_BYTES[this.inBuffer[1] & 0xFF];
        if (b1 < 0) {
            if (b1 != -2) throw new IllegalArgumentException("Illegal base64 character " + Integer.toString(b1, 16));
            this.pushByte((byte)(b0 << 18));
        } else {
            int b2 = FROM_BASE64_BYTES[this.inBuffer[2] & 0xFF];
            if (b2 < 0) {
                if (b2 != -2) throw new IllegalArgumentException("Illegal base64 character " + Integer.toString(b2, 16));
                int i = b0 << 18 | b1 << 12;
                this.pushByte((byte)(i >> 16));
            } else {
                int b3 = FROM_BASE64_BYTES[this.inBuffer[3] & 0xFF];
                if (b3 < 0) {
                    if (b3 != -2) throw new IllegalArgumentException("Illegal base64 character " + Integer.toString(b3, 16));
                    int i = b0 << 18 | b1 << 12 | b2 << 6;
                    this.pushByte((byte)(i >> 16));
                    this.pushByte((byte)(i >> 8));
                } else {
                    int i = b0 << 18 | b1 << 12 | b2 << 6 | b3;
                    this.pushByte((byte)(i >> 16));
                    this.pushByte((byte)(i >> 8));
                    this.pushByte((byte)i);
                }
            }
        }
        this.inBufferIndex = 0;
    }

    private void pushByte(byte c) {
        if (this.outBufferWriteIndex >= this.outBuffer.length - 3) {
            if (this.outBufferReadIndex > 0) {
                int len = this.outBufferWriteIndex - this.outBufferReadIndex;
                System.arraycopy(this.outBuffer, this.outBufferReadIndex, this.outBuffer, 0, len);
                this.outBufferReadIndex = 0;
                this.outBufferWriteIndex = len;
            } else {
                throw new IllegalArgumentException("Buffer overflow");
            }
        }
        this.outBuffer[this.outBufferWriteIndex++] = c;
    }

    private void finish() {
        switch (this.inBufferIndex) {
            case 0: {
                return;
            }
            case 1: {
                this.inBuffer[this.inBufferIndex++] = 61;
                this.inBuffer[this.inBufferIndex++] = 61;
                this.inBuffer[this.inBufferIndex++] = 61;
                this.pushCharLast();
                break;
            }
            case 2: {
                this.inBuffer[this.inBufferIndex++] = 61;
                this.inBuffer[this.inBufferIndex++] = 61;
                this.pushCharLast();
                break;
            }
            case 3: {
                this.inBuffer[this.inBufferIndex++] = 61;
                this.pushCharLast();
            }
        }
    }

    private int dataReady() {
        if (this.outBufferReadIndex >= this.outBufferWriteIndex) {
            try {
                do {
                    int c;
                    if ((c = this.in.read(this.tempBuffer)) <= 0) {
                        this.finish();
                        break;
                    }
                    for (int i = 0; i < c; ++i) {
                        this.pushChar(this.tempBuffer[i]);
                    }
                } while (this.outBufferWriteIndex - this.outBufferReadIndex <= 0);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        return this.outBufferWriteIndex - this.outBufferReadIndex;
    }

    @Override
    public int read() {
        int r = this.dataReady();
        if (r > 0) {
            byte b = this.outBuffer[this.outBufferReadIndex++];
            return b;
        }
        return -1;
    }

    @Override
    public int read(byte[] cbuf, int off, int len) {
        int r;
        if (len > 0 && (r = this.dataReady()) > 0) {
            if (r <= len) {
                len = r;
            }
            System.arraycopy(this.outBuffer, this.outBufferReadIndex, cbuf, off, len);
            this.outBufferReadIndex += len;
            return len;
        }
        return 0;
    }

    @Override
    public void close() {
        try {
            this.in.close();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    static {
        Arrays.fill(FROM_BASE64_BYTES, -1);
        for (int i = 0; i < TO_BASE64_CHARS.length; ++i) {
            Base64DecoderAdapter.FROM_BASE64_BYTES[Base64DecoderAdapter.TO_BASE64_CHARS[i]] = i;
        }
        Base64DecoderAdapter.FROM_BASE64_BYTES[61] = -2;
    }
}

