/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.sql.Date;
import java.sql.Time;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonAnnotation;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonArray;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonComments;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonElement;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonElementBase;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonElementList;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.elements.TsonArrayImpl;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.elements.TsonElementDecorator;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.elements.TsonElementListImpl;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.util.UnmodifiableArrayList;

public class TsonUtils {
    public static final TsonAnnotation[] TSON_ANNOTATIONS_EMPTY_ARRAY = new TsonAnnotation[0];
    public static final TsonElement[] TSON_ELEMENTS_EMPTY_ARRAY = new TsonElement[0];
    public static final char[] hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static <T extends Comparable<T>> int compareArrays(T[] a1, T[] a2) {
        for (int j = 0; j < Math.max(a1.length, a2.length); ++j) {
            if (j >= a1.length) {
                return -1;
            }
            if (j >= a2.length) {
                return 1;
            }
            int i = a1[j].compareTo(a2[j]);
            if (i == 0) continue;
            return i;
        }
        return 0;
    }

    public static <T extends Comparable<T>> int compareLists(List<T> a1, List<T> a2) {
        for (int j = 0; j < Math.max(a1.size(), a2.size()); ++j) {
            if (j >= a1.size()) {
                return -1;
            }
            if (j >= a2.size()) {
                return 1;
            }
            int i = ((Comparable)a1.get(j)).compareTo((Comparable)a2.get(j));
            if (i == 0) continue;
            return i;
        }
        return 0;
    }

    public static TsonElement decorate(TsonElement element, TsonComments comments, List<TsonAnnotation> annotations) {
        TsonComments c2 = comments;
        ArrayList<TsonAnnotation> a2 = annotations == null ? new ArrayList<TsonAnnotation>() : annotations;
        TsonComments c = element.comments();
        List<TsonAnnotation> a = element.annotations();
        if (!Objects.equals(c, c2) || !a.equals(a2)) {
            return TsonElementDecorator.of(element, c2, a2);
        }
        return element;
    }

    public static TsonElement setComments(TsonElement e, TsonComments comments) {
        TsonComments c = e.comments();
        if (Objects.equals(c, comments)) {
            return e;
        }
        return TsonElementDecorator.of(e, comments, e.annotations());
    }

    public static TsonElement setAnnotations(TsonElement e, TsonAnnotation[] annotations) {
        List<TsonAnnotation> c = e.annotations();
        if (c.equals(annotations)) {
            return e;
        }
        return TsonElementDecorator.of(e, e.comments(), e.annotations());
    }

    public static String indent(String anyText, String indent) {
        return TsonUtils.lines(anyText).stream().map(x -> (indent == null ? "" : indent) + x).collect(Collectors.joining("\n"));
    }

    public static String formatMultiLineComments(String str, boolean compact) {
        if (str != null) {
            if (compact) {
                List<String> lines = TsonUtils.lines(str);
                if (lines.isEmpty()) {
                    return "/* */";
                }
                if (lines.size() == 1) {
                    return "/* " + lines.get(0) + " */";
                }
                return "/*\n" + TsonUtils.indent(str, "* ") + "*/\n";
            }
            return "/*\n" + TsonUtils.indent(str, "* ") + "*/\n";
        }
        return "";
    }

    public static String formatSingleLineComments(String str) {
        if (str != null) {
            return TsonUtils.indent(str, "// ") + "\n";
        }
        return "";
    }

    public static String toRegex(String str) {
        return TsonUtils.escapeString(str, '/');
    }

    public static String toSmpStr(String str) {
        return TsonUtils.escapeString(str, '\'');
    }

    public static String toSmpStr(char str) {
        return TsonUtils.escapeString("" + str, '\'');
    }

    public static String escapeString(String str, char escape) {
        char[] chars = str.toCharArray();
        int len = chars.length;
        int bestLen = len * 2 + 2;
        if (bestLen < 0) {
            bestLen = Integer.MAX_VALUE;
        }
        StringBuilder sb = new StringBuilder(bestLen + 2);
        sb.append(escape);
        block9: for (int x = 0; x < len; ++x) {
            char c = chars[x];
            if (c > '=' && c < '\u007f') {
                if (c == '\\') {
                    sb.append('\\');
                    sb.append('\\');
                    continue;
                }
                sb.append(c);
                continue;
            }
            switch (c) {
                case '\t': {
                    sb.append('\\').append('t');
                    continue block9;
                }
                case '\n': {
                    sb.append('\\').append('n');
                    continue block9;
                }
                case '\r': {
                    sb.append('\\').append('r');
                    continue block9;
                }
                case '\f': {
                    sb.append('\\').append('f');
                    continue block9;
                }
                case '\"': {
                    if (escape == '\"') {
                        sb.append('\\').append(c);
                        continue block9;
                    }
                    sb.append(c);
                    continue block9;
                }
                case '\'': {
                    if (escape == '\'') {
                        sb.append('\\').append(c);
                        continue block9;
                    }
                    sb.append(c);
                    continue block9;
                }
                case '/': {
                    if (escape == '/') {
                        sb.append('\\').append(c);
                        continue block9;
                    }
                    sb.append(c);
                    continue block9;
                }
                default: {
                    if (c < ' ' || c > '~') {
                        sb.append('\\');
                        sb.append('u');
                        sb.append(TsonUtils.toHex(c >> 12 & 0xF));
                        sb.append(TsonUtils.toHex(c >> 8 & 0xF));
                        sb.append(TsonUtils.toHex(c >> 4 & 0xF));
                        sb.append(TsonUtils.toHex(c & 0xF));
                        continue block9;
                    }
                    sb.append(c);
                }
            }
        }
        sb.append(escape);
        return sb.toString();
    }

    public static String toDblStr(String str) {
        char[] chars = str.toCharArray();
        int len = chars.length;
        int bestLen = len * 2 + 2;
        if (bestLen < 0) {
            bestLen = Integer.MAX_VALUE;
        }
        StringBuilder sb = new StringBuilder(bestLen + 2);
        sb.append('\"');
        block10: for (int x = 0; x < len; ++x) {
            char c = chars[x];
            switch (c) {
                case '\t': {
                    sb.append('\\').append('t');
                    continue block10;
                }
                case '\n': {
                    sb.append('\\').append('n');
                    continue block10;
                }
                case '\r': {
                    sb.append('\\').append('r');
                    continue block10;
                }
                case '\f': {
                    sb.append('\\').append('f');
                    continue block10;
                }
                case '\"': {
                    sb.append('\\').append(c);
                    continue block10;
                }
                case '\'': {
                    sb.append(c);
                    continue block10;
                }
                case '/': {
                    sb.append(c);
                    continue block10;
                }
                case '\\': {
                    sb.append('\\');
                    sb.append('\\');
                    continue block10;
                }
                default: {
                    if (c < ' ' || c > '~') {
                        sb.append('\\');
                        sb.append('u');
                        sb.append(hexDigit[c >> 12 & 0xF]);
                        sb.append(hexDigit[c >> 8 & 0xF]);
                        sb.append(hexDigit[c >> 4 & 0xF]);
                        sb.append(hexDigit[c & 0xF]);
                        continue block10;
                    }
                    sb.append(c);
                }
            }
        }
        sb.append('\"');
        return sb.toString();
    }

    public static void toDblStr(String str, Writer sb) {
        try {
            char[] chars = str.toCharArray();
            int len = chars.length;
            sb.append('\"');
            block10: for (int x = 0; x < len; ++x) {
                char c = chars[x];
                switch (c) {
                    case '\t': {
                        sb.append('\\').append('t');
                        continue block10;
                    }
                    case '\n': {
                        sb.append('\\').append('n');
                        continue block10;
                    }
                    case '\r': {
                        sb.append('\\').append('r');
                        continue block10;
                    }
                    case '\f': {
                        sb.append('\\').append('f');
                        continue block10;
                    }
                    case '\"': {
                        sb.append('\\').append(c);
                        continue block10;
                    }
                    case '\\': {
                        sb.append('\\');
                        sb.append('\\');
                        continue block10;
                    }
                    default: {
                        if (c < ' ' || c > '~') {
                            sb.append('\\');
                            sb.append('u');
                            sb.append(hexDigit[c >> 12 & 0xF]);
                            sb.append(hexDigit[c >> 8 & 0xF]);
                            sb.append(hexDigit[c >> 4 & 0xF]);
                            sb.append(hexDigit[c & 0xF]);
                            continue block10;
                        }
                        sb.append(c);
                    }
                }
            }
            sb.append('\"');
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static boolean isValidIdentifier(String id) {
        if (id == null) {
            return false;
        }
        if (id.isEmpty()) {
            return false;
        }
        for (String s : id.split("\\.")) {
            if (s.isEmpty()) {
                return false;
            }
            if (!Character.isJavaIdentifierStart(s.charAt(0))) {
                return false;
            }
            for (int i = 1; i < s.length(); ++i) {
                if (Character.isJavaIdentifierPart(s.charAt(0))) continue;
                return false;
            }
        }
        return true;
    }

    private static char toHex(int nibble) {
        return hexDigit[nibble & 0xF];
    }

    public static boolean isBlank(String string) {
        return string == null || string.trim().isEmpty();
    }

    public static String trim(String string) {
        return string == null ? "" : string.trim();
    }

    public static String trimToNull(String string) {
        if (string == null) {
            return null;
        }
        String y = string.trim();
        if (y.isEmpty()) {
            return null;
        }
        return y;
    }

    public static <T extends Comparable<T>> int compare(T a1, T a2) {
        if (a1 == null && a2 == null) {
            return 0;
        }
        if (a1 == null) {
            return -1;
        }
        if (a2 == null) {
            return 1;
        }
        return a1.compareTo(a2);
    }

    public static int compareElementsArray(TsonElement[] a1, TsonElement[] a2) {
        if (a1 == null && a2 == null) {
            return 0;
        }
        if (a1 == null) {
            return -1;
        }
        if (a2 == null) {
            return 1;
        }
        int i = 0;
        int max = Math.max(a1.length, a2.length);
        for (int j = 0; j < max; ++j) {
            if (j >= a1.length) {
                return -1;
            }
            if (j >= a2.length) {
                return 1;
            }
            i = a1[j].compareTo(a2[j]);
            if (i == 0) continue;
            return i;
        }
        return i;
    }

    public static int compareElementsArray(TsonArray[] a1, TsonArray[] a2) {
        if (a1 == null && a2 == null) {
            return 0;
        }
        if (a1 == null) {
            return -1;
        }
        if (a2 == null) {
            return 1;
        }
        int i = 0;
        int max = Math.max(a1.length, a2.length);
        for (int j = 0; j < max; ++j) {
            if (j >= a1.length) {
                return -1;
            }
            if (j >= a2.length) {
                return 1;
            }
            i = a1[j].compareTo(a2[j]);
            if (i == 0) continue;
            return i;
        }
        return i;
    }

    public static int compareElementsArray(TsonElementList a1, TsonElementList a2) {
        if (a1 == null && a2 == null) {
            return 0;
        }
        if (a1 == null) {
            return -1;
        }
        if (a2 == null) {
            return 1;
        }
        int i = 0;
        int size1 = a1.size();
        int size2 = a2.size();
        int max = Math.max(size1, size2);
        for (int j = 0; j < max; ++j) {
            if (j >= size1) {
                return -1;
            }
            if (j >= size2) {
                return 1;
            }
            i = a1.getAt(j).compareTo(a2.getAt(j));
            if (i == 0) continue;
            return i;
        }
        return i;
    }

    public static int compareElementsArray(List<TsonElement> a1, List<TsonElement> a2) {
        int i = 0;
        int size1 = a1.size();
        int size2 = a2.size();
        int max = Math.max(size1, size2);
        for (int j = 0; j < max; ++j) {
            if (j >= size1) {
                return -1;
            }
            if (j >= size2) {
                return 1;
            }
            i = a1.get(j).compareTo(a2.get(j));
            if (i == 0) continue;
            return i;
        }
        return i;
    }

    public static java.util.Date convertToDate(LocalDate dateToConvert) {
        return java.util.Date.from(dateToConvert.atStartOfDay().atZone(ZoneId.systemDefault()).toInstant());
    }

    public static Date convertToSqlDate(LocalDate dateToConvert) {
        return Date.valueOf(dateToConvert);
    }

    public static Time convertToSqlTime(LocalTime dateToConvert) {
        return Time.valueOf(dateToConvert);
    }

    public static java.util.Date convertToDate(LocalDateTime dateToConvert) {
        return java.util.Date.from(dateToConvert.atZone(ZoneId.systemDefault()).toInstant());
    }

    public static java.util.Date convertToDate(Instant dateToConvert) {
        return java.util.Date.from(dateToConvert);
    }

    public static String nullIfBlank(String name) {
        if (name == null) {
            return null;
        }
        int len = name.length();
        for (int st = 0; st < len; ++st) {
            if (name.charAt(st) <= ' ') continue;
            return name;
        }
        return null;
    }

    public static TsonElementList elementsListBaseOrNull(List<TsonElementBase> all) {
        return all == null ? null : new TsonElementListImpl(new ArrayList<TsonElementBase>(all));
    }

    public static TsonElementList elementsListOrNull(List<TsonElement> all) {
        return all == null ? null : new TsonElementListImpl(new ArrayList<TsonElementBase>(all));
    }

    public static UnmodifiableArrayList<TsonElement> unmodifiableElements(List<TsonElement> all) {
        return UnmodifiableArrayList.ofRef(all.toArray(new TsonElement[0]));
    }

    public static UnmodifiableArrayList<TsonArray> unmodifiableArrays(List<TsonArray> all) {
        return UnmodifiableArrayList.ofRef(all.toArray(new TsonArray[0]));
    }

    public static TsonArray toArray(List<TsonElement> elements) {
        return new TsonArrayImpl(null, null, TsonUtils.unmodifiableElements(elements));
    }

    public static List<String> lines(String any) {
        List<String> list;
        BufferedReader br = new BufferedReader(new StringReader(any == null ? "" : any));
        try {
            list = br.lines().collect(Collectors.toList());
        }
        catch (Throwable throwable) {
            try {
                try {
                    br.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException iOException) {
                return new ArrayList<String>();
            }
        }
        br.close();
        return list;
    }

    public static TsonArray toArray(TsonElementList elements) {
        return new TsonArrayImpl(null, null, TsonUtils.unmodifiableElements(elements.toList()));
    }
}

