/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.parser;

import java.math.BigInteger;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.Tson;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonAnnotation;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonComment;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonDocument;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonElement;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonElementType;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.elements.TsonLocalDateImpl;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.elements.TsonLocalDateTimeImpl;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.elements.TsonLocalTimeImpl;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.elements.TsonRegexImpl;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.elements.TsonStringImpl;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.parser.TsonNumberHelper;

public class TsonParserUtils {
    public static TsonElement parseDateTimeElem(String s) {
        return new TsonLocalDateTimeImpl(Instant.parse(s).atZone(ZoneId.systemDefault()).toLocalDateTime());
    }

    public static TsonElement parseDateElem(String s) {
        return new TsonLocalDateImpl(LocalDate.parse(s));
    }

    public static TsonElement parseTimeElem(String s) {
        return new TsonLocalTimeImpl(LocalTime.parse(s));
    }

    public static TsonElement parseRegexElem(String s) {
        String p = s.substring(1, s.length() - 1);
        return new TsonRegexImpl(Pattern.compile(p));
    }

    public static TsonElement parseNumber(String s) {
        return TsonNumberHelper.parse(s).toTson();
    }

    public static Instant parseDateTime(String s) {
        return Instant.parse(s);
    }

    public static LocalDate parseDate(String s) {
        return LocalDate.parse(s);
    }

    public static LocalTime parseTime(String s) {
        return LocalTime.parse(s);
    }

    public static Pattern parseRegex(String s) {
        return Pattern.compile(s.substring(1, s.length() - 1));
    }

    public static byte parseByte(String s) {
        if (s.endsWith("b") || s.endsWith("B")) {
            s = s.substring(0, s.length() - 1);
        }
        return Byte.parseByte(s);
    }

    public static short parseShort(String s) {
        if (s.endsWith("s") || s.endsWith("S")) {
            s = s.substring(0, s.length() - 1);
        }
        return Short.parseShort(s);
    }

    public static long parseLong(String s) {
        if (s.endsWith("l") || s.endsWith("L")) {
            s = s.substring(0, s.length() - 1);
        }
        return Long.parseLong(s);
    }

    public static int parseInt(String s) {
        if (s.endsWith("i") || s.endsWith("I")) {
            s = s.substring(0, s.length() - 1);
        }
        return Integer.parseInt(s);
    }

    public static float parseFloat(String s) {
        if (s.endsWith("f") || s.endsWith("F")) {
            s = s.substring(0, s.length() - 1);
        }
        return Float.parseFloat(s);
    }

    public static double parseDouble(String s) {
        return Double.parseDouble(s);
    }

    public static char parseChar(String s) {
        return TsonParserUtils.parseRawString(s, TsonElementType.SINGLE_QUOTED_STRING).charAt(0);
    }

    public static String parseRawString(String s, TsonElementType layout) {
        char[] chars = s.toCharArray();
        int len = chars.length;
        int prefixLen = 0;
        int suffixLen = 0;
        String sborder = "";
        String eborder = "";
        switch (layout) {
            case DOUBLE_QUOTED_STRING: {
                sborder = "\"";
                eborder = "\"";
                break;
            }
            case SINGLE_QUOTED_STRING: {
                sborder = "'";
                eborder = "'";
                break;
            }
            case ANTI_QUOTED_STRING: {
                sborder = "`";
                eborder = "`";
                break;
            }
            case TRIPLE_ANTI_QUOTED_STRING: {
                sborder = "```";
                eborder = "```";
                break;
            }
            case TRIPLE_DOUBLE_QUOTED_STRING: {
                sborder = "\"\"\"";
                eborder = "\"\"\"";
                break;
            }
            case TRIPLE_SINGLE_QUOTED_STRING: {
                sborder = "'''";
                eborder = "'''";
                break;
            }
            case LINE_STRING: {
                sborder = "\u00b6";
                eborder = "";
            }
        }
        prefixLen = sborder.length();
        suffixLen = eborder.length();
        if (s.length() < prefixLen + suffixLen) {
            throw new IllegalArgumentException("unsupported: " + s);
        }
        if (!s.startsWith(sborder) || !s.endsWith(eborder)) {
            throw new IllegalArgumentException("unsupported: " + s);
        }
        switch (layout) {
            case DOUBLE_QUOTED_STRING: 
            case SINGLE_QUOTED_STRING: 
            case ANTI_QUOTED_STRING: {
                int beforeLen = len - suffixLen;
                StringBuilder sb = new StringBuilder();
                block27: for (int i = suffixLen; i < beforeLen; ++i) {
                    char c = s.charAt(i);
                    switch (c) {
                        case '\\': {
                            int ip = i + 1;
                            boolean processed = false;
                            if (ip < beforeLen) {
                                switch (s.charAt(ip)) {
                                    case 'n': {
                                        sb.append('\n');
                                        ++i;
                                        processed = true;
                                        break;
                                    }
                                    case 't': {
                                        sb.append('\t');
                                        ++i;
                                        processed = true;
                                        break;
                                    }
                                    case 'f': {
                                        sb.append('\f');
                                        ++i;
                                        processed = true;
                                        break;
                                    }
                                    case 'b': {
                                        sb.append('\b');
                                        ++i;
                                        processed = true;
                                        break;
                                    }
                                    case '\\': {
                                        sb.append('\\');
                                        ++i;
                                        processed = true;
                                    }
                                }
                            }
                            if (processed) continue block27;
                            sb.append(c);
                            continue block27;
                        }
                        default: {
                            sb.append(c);
                        }
                    }
                }
                return sb.toString();
            }
            case TRIPLE_ANTI_QUOTED_STRING: 
            case TRIPLE_DOUBLE_QUOTED_STRING: 
            case TRIPLE_SINGLE_QUOTED_STRING: {
                int beforeLen = len - prefixLen;
                StringBuilder sb = new StringBuilder(s.length());
                block28: for (int i = prefixLen; i < beforeLen; ++i) {
                    char c = s.charAt(i);
                    switch (c) {
                        case '\\': {
                            String substring;
                            boolean processed = false;
                            if (i + 3 < len && (substring = s.substring(i + 1, i + 1 + suffixLen)).equals(sborder)) {
                                sb.append(substring);
                                i += suffixLen;
                                processed = true;
                            }
                            if (processed) continue block28;
                            sb.append(c);
                            continue block28;
                        }
                        default: {
                            sb.append(c);
                        }
                    }
                }
                return sb.toString();
            }
            case LINE_STRING: {
                return s.substring(1).trim();
            }
        }
        throw new IllegalArgumentException("unsupported: " + s);
    }

    public static TsonStringImpl parseRawString(String s) {
        char[] chars = s.toCharArray();
        int len = chars.length;
        int prefixLen = 1;
        int suffixLen = 1;
        if (len > 0 && chars[0] == '\u00b6') {
            for (int i = 0; i < chars.length; ++i) {
                if (chars[i] != '\n' && chars[i] != '\r') continue;
                throw new IllegalArgumentException("invalid raw line string " + s);
            }
            return new TsonStringImpl(TsonElementType.LINE_STRING, new String(Arrays.copyOfRange(chars, 1, chars.length)).trim(), new String(Arrays.copyOfRange(chars, 1, chars.length)));
        }
        if (len < 2) {
            throw new IllegalArgumentException("invalid raw string " + s);
        }
        if (chars[0] != chars[len - 1]) {
            throw new IllegalArgumentException("unbalanced string " + s);
        }
        String border = null;
        TsonElementType layout = null;
        switch (chars[0]) {
            case '\"': {
                border = "\"";
                layout = TsonElementType.DOUBLE_QUOTED_STRING;
                break;
            }
            case '\'': {
                border = "'";
                layout = TsonElementType.SINGLE_QUOTED_STRING;
                break;
            }
            case '`': {
                border = "`";
                layout = TsonElementType.ANTI_QUOTED_STRING;
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid string boundaries" + s);
            }
        }
        if (len >= 6 && chars[0] == chars[1] && chars[1] == chars[2] && chars[len - 1] == chars[len - 2] && chars[len - 2] == chars[len - 3]) {
            prefixLen = 3;
            suffixLen = 3;
            switch (layout) {
                case DOUBLE_QUOTED_STRING: {
                    border = "\"\"\"";
                    layout = TsonElementType.TRIPLE_DOUBLE_QUOTED_STRING;
                    break;
                }
                case SINGLE_QUOTED_STRING: {
                    border = "'''";
                    layout = TsonElementType.TRIPLE_SINGLE_QUOTED_STRING;
                    break;
                }
                case ANTI_QUOTED_STRING: {
                    border = "```";
                    layout = TsonElementType.TRIPLE_ANTI_QUOTED_STRING;
                }
            }
        }
        switch (layout) {
            case DOUBLE_QUOTED_STRING: 
            case SINGLE_QUOTED_STRING: 
            case ANTI_QUOTED_STRING: {
                int beforeLen = len - suffixLen;
                StringBuilder sb = new StringBuilder();
                block30: for (int i = suffixLen; i < beforeLen; ++i) {
                    char c = s.charAt(i);
                    switch (c) {
                        case '\\': {
                            int ip = i + 1;
                            boolean processed = false;
                            if (ip < beforeLen) {
                                char c2 = s.charAt(ip);
                                switch (c2) {
                                    case '\\': {
                                        sb.append('\\');
                                        ++i;
                                        processed = true;
                                        break;
                                    }
                                    case '\'': {
                                        if (layout != TsonElementType.SINGLE_QUOTED_STRING) break;
                                        sb.append(c2);
                                        ++i;
                                        processed = true;
                                        break;
                                    }
                                    case '`': {
                                        if (layout != TsonElementType.ANTI_QUOTED_STRING) break;
                                        sb.append(c2);
                                        ++i;
                                        processed = true;
                                        break;
                                    }
                                    case '\"': {
                                        if (layout != TsonElementType.DOUBLE_QUOTED_STRING) break;
                                        sb.append(c2);
                                        ++i;
                                        processed = true;
                                    }
                                }
                            }
                            if (processed) continue block30;
                            sb.append(c);
                            continue block30;
                        }
                        case '\'': {
                            if (layout == TsonElementType.SINGLE_QUOTED_STRING) {
                                sb.append('\\');
                                sb.append(c);
                                continue block30;
                            }
                            sb.append(c);
                            continue block30;
                        }
                        case '`': {
                            if (layout != TsonElementType.ANTI_QUOTED_STRING) continue block30;
                            sb.append('\\');
                            sb.append(c);
                            ++i;
                            continue block30;
                        }
                        case '\"': {
                            if (layout == TsonElementType.DOUBLE_QUOTED_STRING) {
                                sb.append('\\');
                                sb.append(c);
                                continue block30;
                            }
                            sb.append(c);
                            continue block30;
                        }
                        default: {
                            sb.append(c);
                        }
                    }
                }
                return new TsonStringImpl(layout, sb.toString(), s.substring(prefixLen, len - prefixLen));
            }
            case TRIPLE_ANTI_QUOTED_STRING: 
            case TRIPLE_DOUBLE_QUOTED_STRING: 
            case TRIPLE_SINGLE_QUOTED_STRING: {
                int beforeLen = len - prefixLen;
                StringBuilder sb = new StringBuilder(s.length());
                block31: for (int i = prefixLen; i < beforeLen; ++i) {
                    char c = s.charAt(i);
                    switch (c) {
                        case '\\': {
                            String substring;
                            boolean processed = false;
                            if (i + 3 < len && (substring = s.substring(i + 1, i + 1 + suffixLen)).equals(border)) {
                                sb.append(substring);
                                i += suffixLen;
                                processed = true;
                            }
                            if (processed) continue block31;
                            sb.append(c);
                            continue block31;
                        }
                        default: {
                            sb.append(c);
                        }
                    }
                }
                return new TsonStringImpl(layout, sb.toString(), s.substring(prefixLen, len - prefixLen));
            }
        }
        throw new IllegalArgumentException("unsupported: " + s);
    }

    public static String parseStringOld(String s) {
        char[] chars = s.toCharArray();
        int len = chars.length;
        StringBuilder sb = new StringBuilder(len - 2);
        int beforeLen = len - 1;
        block10: for (int i = 1; i < beforeLen; ++i) {
            switch (s.charAt(i)) {
                case '\\': {
                    switch (s.charAt(++i)) {
                        case 'n': {
                            sb.append('\n');
                            continue block10;
                        }
                        case 't': {
                            sb.append('\t');
                            continue block10;
                        }
                        case 'f': {
                            sb.append('\f');
                            continue block10;
                        }
                        case 'b': {
                            sb.append('\b');
                            continue block10;
                        }
                        case '\\': {
                            sb.append('\\');
                            continue block10;
                        }
                    }
                    sb.append(chars[i]);
                    continue block10;
                }
                default: {
                    sb.append(chars[i]);
                }
            }
        }
        return sb.toString();
    }

    public static TsonDocument elementsToDocument(TsonElement[] roots) {
        Object c = null;
        if (roots.length == 0) {
            return Tson.ofDocument().header(null).content(Tson.ofObjectBuilder().build()).build();
        }
        if (roots.length == 1) {
            return TsonParserUtils.elementToDocument(roots[0]);
        }
        List<TsonAnnotation> annotations = roots[0].annotations();
        if (annotations != null && annotations.size() > 0 && "tson".equals(annotations.get(0).name().orNull())) {
            ArrayList<TsonAnnotation> newAnn = new ArrayList<TsonAnnotation>(annotations);
            newAnn.remove(0);
            ArrayList<TsonElement> newList = new ArrayList<TsonElement>(Arrays.asList(roots));
            TsonElement c0 = roots[0].builder().setAnnotations(newAnn.toArray(new TsonAnnotation[0])).build();
            newList.set(0, c0);
            roots = newList.toArray(new TsonElement[0]);
        }
        return Tson.ofDocument().content(Tson.ofObjectBuilder(roots).build()).build();
    }

    public static TsonDocument elementToDocument(TsonElement root) {
        List<TsonAnnotation> annotations = root.annotations();
        if (annotations != null && annotations.size() > 0 && "tson".equals(annotations.get(0).name().orNull())) {
            ArrayList<TsonAnnotation> newAnn = new ArrayList<TsonAnnotation>(annotations);
            newAnn.remove(0);
            return Tson.ofDocument().header(Tson.ofDocumentHeader().addParams(annotations.get(0).params()).build()).content(root.builder().setAnnotations(newAnn.toArray(new TsonAnnotation[0])).build()).build();
        }
        return Tson.ofDocument().header(null).content(root).build();
    }

    public static TsonComment parseComments(String c) {
        if (c == null) {
            return null;
        }
        if (c.startsWith("/*")) {
            return TsonComment.ofMultiLine(TsonParserUtils.escapeMultiLineComments(c));
        }
        if (c.startsWith("//")) {
            return TsonComment.ofSingleLine(TsonParserUtils.escapeSingleLineComments(c));
        }
        throw new IllegalArgumentException("unsupported comments " + c);
    }

    public static String escapeSingleLineComments(String c) {
        if (c == null) {
            return null;
        }
        if (c.startsWith("//")) {
            return c.substring(2);
        }
        throw new IllegalArgumentException("unsupported comments " + c);
    }

    public static String escapeMultiLineComments(String c) {
        if (c == null) {
            return null;
        }
        int line = 0;
        String[] lines = c.trim().split("\n");
        StringBuilder sb = new StringBuilder();
        for (String s : lines) {
            s = s.trim();
            if (line == 0 && s.startsWith("/*")) {
                s = s.substring(2);
            }
            if (line == lines.length - 1 && s.endsWith("*/")) {
                s = s.substring(0, s.length() - 2);
            }
            if (s.equals("*")) {
                s = s.substring(1);
            } else if (s.equals("**")) {
                s = s.substring(1);
            } else if (s.startsWith("*") && s.length() > 1 && Character.isWhitespace(s.charAt(1))) {
                s = s.substring(2).trim();
            } else if (s.startsWith("**") && s.length() > 2 && Character.isWhitespace(s.charAt(1))) {
                s = s.substring(2).trim();
            }
            if (s.length() > 1 && s.charAt(0) == '*' && s.charAt(1) == ' ') {
                s = s.substring(2);
            }
            s = s.trim();
            if (line == lines.length - 1) {
                if (s.length() > 0) {
                    if (line > 0) {
                        sb.append("\n");
                    }
                    sb.append(s.trim());
                }
            } else {
                if (line > 0) {
                    sb.append("\n");
                }
                sb.append(s.trim());
            }
            ++line;
        }
        return sb.toString().trim();
    }

    private static int fastDecodeIntOctal(String nm) throws NumberFormatException {
        int index = 0;
        boolean negative = false;
        char firstChar = nm.charAt(0);
        if (firstChar == '-') {
            negative = true;
            ++index;
        } else if (firstChar == '+') {
            ++index;
        }
        ++index;
        try {
            int result = Integer.valueOf(nm.substring(index), 8);
            if (negative) {
                return -result;
            }
            return result;
        }
        catch (NumberFormatException e) {
            String constant = negative ? "-" + nm.substring(index) : nm.substring(index);
            return Integer.parseInt(constant, 8);
        }
    }

    private static short fastDecodeShortOctal(String nm) throws NumberFormatException {
        int index = 0;
        boolean negative = false;
        char firstChar = nm.charAt(0);
        if (firstChar == '-') {
            negative = true;
            ++index;
        } else if (firstChar == '+') {
            ++index;
        }
        ++index;
        try {
            short result = Short.parseShort(nm.substring(index, nm.length() - 1), 8);
            if (negative) {
                return -result;
            }
            return result;
        }
        catch (NumberFormatException e) {
            String constant = negative ? "-" + nm.substring(index, nm.length() - 1) : nm.substring(index, nm.length() - 1);
            return Short.parseShort(constant, 8);
        }
    }

    private static long fastDecodeLongOctal(String nm) throws NumberFormatException {
        int index = 0;
        boolean negative = false;
        char firstChar = nm.charAt(0);
        if (firstChar == '-') {
            negative = true;
            ++index;
        } else if (firstChar == '+') {
            ++index;
        }
        ++index;
        try {
            long result = Long.parseLong(nm.substring(index, nm.length() - 1), 8);
            if (negative) {
                return -result;
            }
            return result;
        }
        catch (NumberFormatException e) {
            String constant = negative ? "-" + nm.substring(index, nm.length() - 1) : nm.substring(index, nm.length() - 1);
            return Long.parseLong(constant, 8);
        }
    }

    private static BigInteger fastDecodeBigIntOctal(String nm) throws NumberFormatException {
        int index = 0;
        boolean negative = false;
        char firstChar = nm.charAt(0);
        if (firstChar == '-') {
            negative = true;
            ++index;
        } else if (firstChar == '+') {
            ++index;
        }
        ++index;
        try {
            BigInteger result = new BigInteger(nm.substring(index, nm.length() - 1), 8);
            if (negative) {
                return result.negate();
            }
            return result;
        }
        catch (NumberFormatException e) {
            String constant = negative ? "-" + nm.substring(index, nm.length() - 1) : nm.substring(index, nm.length() - 1);
            return new BigInteger(constant, 8);
        }
    }

    private static int fastDecodeIntHex(String nm) throws NumberFormatException {
        int index = 0;
        boolean negative = false;
        char firstChar = nm.charAt(0);
        if (firstChar == '-') {
            negative = true;
            ++index;
        } else if (firstChar == '+') {
            ++index;
        }
        index += 2;
        try {
            int result = Integer.parseInt(nm.substring(index), 16);
            if (negative) {
                return -result;
            }
            return result;
        }
        catch (NumberFormatException e) {
            String constant = negative ? "-" + nm.substring(index) : nm.substring(index);
            int result = Integer.parseInt(constant, 16);
            return result;
        }
    }

    private static int fastDecodeIntBin(String nm) throws NumberFormatException {
        int index = 0;
        boolean negative = false;
        char firstChar = nm.charAt(0);
        if (firstChar == '-') {
            negative = true;
            ++index;
        } else if (firstChar == '+') {
            ++index;
        }
        index += 2;
        try {
            int result = Integer.parseInt(nm.substring(index), 2);
            if (negative) {
                return -result;
            }
            return result;
        }
        catch (NumberFormatException e) {
            String constant = negative ? "-" + nm.substring(index) : nm.substring(index);
            int result = Integer.parseInt(constant, 2);
            return result;
        }
    }

    private static short fastDecodeShortHex(String nm) throws NumberFormatException {
        int index = 0;
        boolean negative = false;
        char firstChar = nm.charAt(0);
        if (firstChar == '-') {
            negative = true;
            ++index;
        } else if (firstChar == '+') {
            ++index;
        }
        index += 2;
        try {
            short result = Short.parseShort(nm.substring(index), 16);
            if (negative) {
                return -result;
            }
            return result;
        }
        catch (NumberFormatException e) {
            String constant = negative ? "-" + nm.substring(index) : nm.substring(index);
            short result = Short.parseShort(constant, 16);
            return result;
        }
    }

    private static short fastDecodeShortBin(String nm) throws NumberFormatException {
        int index = 0;
        boolean negative = false;
        char firstChar = nm.charAt(0);
        if (firstChar == '-') {
            negative = true;
            ++index;
        } else if (firstChar == '+') {
            ++index;
        }
        index += 2;
        try {
            short result = Short.parseShort(nm.substring(index), 2);
            if (negative) {
                return -result;
            }
            return result;
        }
        catch (NumberFormatException e) {
            String constant = negative ? "-" + nm.substring(index) : nm.substring(index);
            short result = Short.parseShort(constant, 2);
            return result;
        }
    }

    private static long fastDecodeLongHex(String nm) throws NumberFormatException {
        int index = 0;
        boolean negative = false;
        char firstChar = nm.charAt(0);
        if (firstChar == '-') {
            negative = true;
            ++index;
        } else if (firstChar == '+') {
            ++index;
        }
        index += 2;
        try {
            long result = Long.parseLong(nm.substring(index), 16);
            if (negative) {
                return -result;
            }
            return result;
        }
        catch (NumberFormatException e) {
            String constant = negative ? "-" + nm.substring(index) : nm.substring(index);
            long result = Long.parseLong(constant, 16);
            return result;
        }
    }

    private static BigInteger fastDecodeBigIntHex(String nm) throws NumberFormatException {
        int index = 0;
        boolean negative = false;
        char firstChar = nm.charAt(0);
        if (firstChar == '-') {
            negative = true;
            ++index;
        } else if (firstChar == '+') {
            ++index;
        }
        index += 2;
        try {
            BigInteger result = new BigInteger(nm.substring(index), 16);
            if (negative) {
                return result.negate();
            }
            return result;
        }
        catch (NumberFormatException e) {
            String constant = negative ? "-" + nm.substring(index) : nm.substring(index);
            BigInteger result = new BigInteger(constant, 16);
            return result;
        }
    }

    private static long fastDecodeLongBin(String nm) throws NumberFormatException {
        int index = 0;
        boolean negative = false;
        char firstChar = nm.charAt(0);
        if (firstChar == '-') {
            negative = true;
            ++index;
        } else if (firstChar == '+') {
            ++index;
        }
        index += 2;
        try {
            long result = Long.parseLong(nm.substring(index), 2);
            if (negative) {
                return -result;
            }
            return result;
        }
        catch (NumberFormatException e) {
            String constant = negative ? "-" + nm.substring(index) : nm.substring(index);
            long result = Long.parseLong(constant, 2);
            return result;
        }
    }

    private static BigInteger fastDecodeBigIntBin(String nm) throws NumberFormatException {
        int index = 0;
        boolean negative = false;
        char firstChar = nm.charAt(0);
        if (firstChar == '-') {
            negative = true;
            ++index;
        } else if (firstChar == '+') {
            ++index;
        }
        index += 2;
        try {
            BigInteger result = new BigInteger(nm.substring(index), 2);
            if (negative) {
                return result.negate();
            }
            return result;
        }
        catch (NumberFormatException e) {
            String constant = negative ? "-" + nm.substring(index) : nm.substring(index);
            BigInteger result = new BigInteger(constant, 2);
            return result;
        }
    }

    public static TsonElement parseNaNElem(String s) {
        if (s == null) {
            return Tson.of(Double.NaN);
        }
        switch (s) {
            case "double": {
                return Tson.of(Double.NaN);
            }
            case "float": {
                return Tson.of(Float.NaN);
            }
        }
        throw new IllegalArgumentException("Unsupported NaN(" + s + ")");
    }

    public static TsonElement parsePosInfElem(String s) {
        if (s == null) {
            return Tson.of(Double.POSITIVE_INFINITY);
        }
        switch (s) {
            case "double": {
                return Tson.of(Double.POSITIVE_INFINITY);
            }
            case "float": {
                return Tson.of(Float.POSITIVE_INFINITY);
            }
        }
        throw new IllegalArgumentException("Unsupported +Bound(" + s + ")");
    }

    public static TsonElement parseNegInfElem(String s) {
        if (s == null) {
            return Tson.of(Double.NEGATIVE_INFINITY);
        }
        switch (s) {
            case "double": {
                return Tson.of(Double.NEGATIVE_INFINITY);
            }
            case "float": {
                return Tson.of(Float.NEGATIVE_INFINITY);
            }
        }
        throw new IllegalArgumentException("Unsupported -Bound(" + s + ")");
    }

    public static TsonElement parsePosBoundElem(String s) {
        if (s == null) {
            return Tson.of(Double.MAX_VALUE);
        }
        switch (s) {
            case "double": {
                return Tson.of(Double.MAX_VALUE);
            }
            case "float": {
                return Tson.of(Float.MAX_VALUE);
            }
            case "byte": {
                return Tson.of((byte)127);
            }
            case "short": {
                return Tson.of((short)Short.MAX_VALUE);
            }
            case "int": {
                return Tson.of(Integer.MAX_VALUE);
            }
            case "long": {
                return Tson.of(Long.MAX_VALUE);
            }
        }
        throw new IllegalArgumentException("Unsupported +Inf(" + s + ")");
    }

    public static TsonElement parseNegBoundElem(String s) {
        if (s == null) {
            return Tson.of(Double.MIN_VALUE);
        }
        switch (s) {
            case "double": {
                return Tson.of(Double.MIN_VALUE);
            }
            case "float": {
                return Tson.of(Float.MIN_VALUE);
            }
            case "byte": {
                return Tson.of((byte)-128);
            }
            case "short": {
                return Tson.of((short)Short.MIN_VALUE);
            }
            case "int": {
                return Tson.of(Integer.MIN_VALUE);
            }
            case "long": {
                return Tson.of(Long.MIN_VALUE);
            }
        }
        throw new IllegalArgumentException("Unsupported +Inf(" + s + ")");
    }
}

