/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.parser;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.regex.Pattern;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.Tson;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonBigComplex;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonDoubleComplex;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonElement;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonFloatComplex;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonNumber;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonNumberLayout;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.parser.NumberType;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.parser.StrFastReader;

public class TsonNumberHelper {
    public static final Pattern ANY_NUMBER_PATTERN_0 = Pattern.compile("^[-]?[0-9_E.+-Llf]+$");
    public static final Pattern ANY_NUMBER_PATTERN_1XU = Pattern.compile("^(?<sign>[-]?)(?<a>0u[1248][x])(?<n>[^L%]+)?(?<l>[lL]?)(?<c>([%][a-zA-Z]*)?)$");
    public static final Pattern ANY_NUMBER_PATTERN_2XU = Pattern.compile("^(?<sign>[-]?)(?<a>0u[1248][x])(?<n>[^a-fA-F0-9]+)?(?<l>[lL]?)(?<c>([_][a-zA-Z]+)?)$");
    public static final Pattern ANY_NUMBER_PATTERN_1U = Pattern.compile("^(?<sign>[-]?)(?<a>0u[1248][xbo_])(?<n>[^L%]+)?(?<l>[lL]?)(?<c>([%][a-zA-Z]*)?)$");
    public static final Pattern ANY_NUMBER_PATTERN_2U = Pattern.compile("^(?<sign>[-]?)(?<a>0u[1248][xbo_])(?<n>[^L%]+)?(?<l>[lL]?)(?<c>([_][a-zA-Z]+)?)$");
    private Number real;
    private Number imag;
    private boolean complex;
    private NumberType type;
    private String unit;
    private TsonNumberLayout layout;

    public static TsonNumberHelper of(Number real) {
        return real == null ? null : new TsonNumberHelper(real, NumberType.of(real.getClass()), TsonNumberLayout.DECIMAL, null);
    }

    public TsonNumberHelper(TsonNumber te) {
        this.unit = te.numberSuffix();
        this.layout = te.numberLayout();
        switch (te.type()) {
            case BIG_COMPLEX: {
                this.complex = true;
                TsonBigComplex bigComplex = te.toBigComplex();
                this.real = bigComplex.real();
                this.imag = bigComplex.imag();
                this.type = NumberType.BIG_INTEGER;
                break;
            }
            case DOUBLE_COMPLEX: {
                this.complex = true;
                TsonDoubleComplex bigComplex = te.toDoubleComplex();
                this.real = bigComplex.real();
                this.imag = bigComplex.imag();
                this.type = NumberType.DOUBLE;
                break;
            }
            case FLOAT_COMPLEX: {
                this.complex = true;
                TsonFloatComplex bigComplex = te.toFloatComplex();
                this.real = Float.valueOf(bigComplex.real());
                this.imag = Float.valueOf(bigComplex.imag());
                this.type = NumberType.FLOAT;
                break;
            }
            case BYTE: {
                this.real = te.byteValue();
                this.type = NumberType.BYTE;
                break;
            }
            case SHORT: {
                this.real = te.shortValue();
                this.type = NumberType.SHORT;
                break;
            }
            case INTEGER: {
                this.real = te.intValue();
                this.type = NumberType.INT;
                break;
            }
            case LONG: {
                this.real = te.longValue();
                this.type = NumberType.LONG;
                break;
            }
            case FLOAT: {
                this.real = Float.valueOf(te.floatValue());
                this.type = NumberType.FLOAT;
                break;
            }
            case DOUBLE: {
                this.real = te.doubleValue();
                this.type = NumberType.DOUBLE;
                break;
            }
            case BIG_INTEGER: {
                this.real = te.bigIntegerValue();
                this.type = NumberType.BIG_INTEGER;
                break;
            }
            case BIG_DECIMAL: {
                this.real = te.bigDecimalValue();
                this.type = NumberType.BIG_DECIMAL;
                break;
            }
            default: {
                throw new IllegalArgumentException("not supported number type " + (Object)((Object)te.type()));
            }
        }
    }

    private TsonNumberHelper(Number real, Number imag, NumberType type, TsonNumberLayout layout, String unit) {
        this.real = real;
        this.imag = imag;
        this.complex = imag != null;
        this.type = type;
        this.unit = unit;
        this.layout = layout;
    }

    private TsonNumberHelper(Number real, NumberType type, TsonNumberLayout layout, String unit) {
        this.real = real;
        this.complex = false;
        this.type = type;
        this.layout = layout;
        this.unit = unit;
    }

    public TsonNumberHelper to(NumberType type) {
        if (type == this.type) {
            return this;
        }
        if (this.complex) {
            switch (type) {
                case BYTE: 
                case SHORT: 
                case INT: {
                    return this.to(NumberType.FLOAT);
                }
                case LONG: {
                    return this.to(NumberType.DOUBLE);
                }
                case FLOAT: {
                    return new TsonNumberHelper((Number)Float.valueOf(this.real.floatValue()), Float.valueOf(this.imag.floatValue()), NumberType.FLOAT, this.layout, this.unit);
                }
                case DOUBLE: {
                    return new TsonNumberHelper((Number)this.real.doubleValue(), this.imag.doubleValue(), NumberType.DOUBLE, this.layout, this.unit);
                }
                case BIG_INTEGER: {
                    return this.to(NumberType.BIG_DECIMAL);
                }
                case BIG_DECIMAL: {
                    switch (this.type) {
                        case BIG_INTEGER: {
                            return new TsonNumberHelper(new BigDecimal((BigInteger)this.real), NumberType.BIG_DECIMAL, this.layout, this.unit);
                        }
                        case BYTE: 
                        case SHORT: 
                        case INT: 
                        case LONG: {
                            return new TsonNumberHelper(new BigDecimal(BigInteger.valueOf(this.real.longValue())), NumberType.BIG_DECIMAL, this.layout, this.unit);
                        }
                        case FLOAT: 
                        case DOUBLE: {
                            return new TsonNumberHelper(BigDecimal.valueOf(this.real.doubleValue()), NumberType.BIG_INTEGER, this.layout, this.unit);
                        }
                    }
                }
            }
        } else {
            switch (type) {
                case BYTE: {
                    return new TsonNumberHelper(this.real.byteValue(), NumberType.BYTE, this.layout, this.unit);
                }
                case SHORT: {
                    return new TsonNumberHelper(this.real.shortValue(), NumberType.SHORT, this.layout, this.unit);
                }
                case INT: {
                    return new TsonNumberHelper(this.real.intValue(), NumberType.INT, this.layout, this.unit);
                }
                case LONG: {
                    return new TsonNumberHelper(this.real.longValue(), NumberType.LONG, this.layout, this.unit);
                }
                case FLOAT: {
                    return new TsonNumberHelper(Float.valueOf(this.real.floatValue()), NumberType.FLOAT, this.layout, this.unit);
                }
                case DOUBLE: {
                    return new TsonNumberHelper(this.real.doubleValue(), NumberType.DOUBLE, this.layout, this.unit);
                }
                case BIG_INTEGER: {
                    switch (this.type) {
                        case BIG_DECIMAL: {
                            return new TsonNumberHelper(((BigDecimal)this.real).toBigInteger(), NumberType.BIG_INTEGER, this.layout, this.unit);
                        }
                        case BYTE: 
                        case SHORT: 
                        case INT: 
                        case LONG: {
                            return new TsonNumberHelper(BigInteger.valueOf(this.real.longValue()), NumberType.BIG_INTEGER, this.layout, this.unit);
                        }
                        case FLOAT: 
                        case DOUBLE: {
                            return new TsonNumberHelper(BigDecimal.valueOf(this.real.doubleValue()).toBigInteger(), NumberType.BIG_INTEGER, this.layout, this.unit);
                        }
                    }
                    break;
                }
                case BIG_DECIMAL: {
                    switch (this.type) {
                        case BIG_INTEGER: {
                            return new TsonNumberHelper(new BigDecimal((BigInteger)this.real), NumberType.BIG_DECIMAL, this.layout, this.unit);
                        }
                        case BYTE: 
                        case SHORT: 
                        case INT: 
                        case LONG: {
                            return new TsonNumberHelper(new BigDecimal(BigInteger.valueOf(this.real.longValue())), NumberType.BIG_DECIMAL, this.layout, this.unit);
                        }
                        case FLOAT: 
                        case DOUBLE: {
                            return new TsonNumberHelper(BigDecimal.valueOf(this.real.doubleValue()), NumberType.BIG_INTEGER, this.layout, this.unit);
                        }
                    }
                }
            }
        }
        throw new IllegalArgumentException("unsupported conversion : " + (Object)((Object)this.type) + "->" + (Object)((Object)type));
    }

    private static TsonNumberLayout detectRadix(String nbr) {
        int i = 0;
        if (nbr.charAt(0) == '-' || nbr.charAt(0) == '+') {
            ++i;
        }
        int len = nbr.length();
        while (i < len) {
            char c = nbr.charAt(i);
            if (Character.isWhitespace(c) || c == '+' || c == '-') {
                ++i;
                continue;
            }
            if (c == '0') {
                if (i + 1 < len) {
                    c = nbr.charAt(i + 1);
                    if (c == 'b') {
                        return TsonNumberLayout.BINARY;
                    }
                    if (c == 'x') {
                        return TsonNumberLayout.HEXADECIMAL;
                    }
                    return TsonNumberLayout.OCTAL;
                }
                return TsonNumberLayout.DECIMAL;
            }
            return TsonNumberLayout.DECIMAL;
        }
        return TsonNumberLayout.DECIMAL;
    }

    private static TsonNumberHelper parseReal(String a, String unit, NumberType[] numberType) {
        TsonNumberLayout r = TsonNumberHelper.detectRadix(a);
        for (NumberType type : numberType) {
            TsonNumberHelper v = TsonNumberHelper.parseReal0(a, type, r, unit);
            if (v == null) continue;
            return v;
        }
        throw new IllegalArgumentException("unable to parse number " + a);
    }

    private static TsonNumberHelper parseReal(String a, TsonNumberLayout layout, String unit, NumberType[] numberType) {
        for (NumberType type : numberType) {
            TsonNumberHelper v = TsonNumberHelper.parseReal0(a, type, layout, unit);
            if (v == null) continue;
            return v;
        }
        throw new IllegalArgumentException("unable to parse number " + a);
    }

    private static TsonNumberHelper parseReal0(String a, NumberType numberType, TsonNumberLayout radix, String unit) {
        try {
            switch (numberType) {
                case BYTE: {
                    return new TsonNumberHelper(Byte.parseByte(a, radix.radix()), NumberType.BYTE, radix, unit);
                }
                case SHORT: {
                    return new TsonNumberHelper(Short.parseShort(a, radix.radix()), NumberType.SHORT, radix, unit);
                }
                case INT: {
                    return new TsonNumberHelper(Integer.parseInt(a, radix.radix()), NumberType.INT, radix, unit);
                }
                case LONG: {
                    return new TsonNumberHelper(Long.parseLong(a, radix.radix()), NumberType.LONG, radix, unit);
                }
                case FLOAT: {
                    return new TsonNumberHelper(Float.valueOf(Float.parseFloat(a)), NumberType.FLOAT, radix, unit);
                }
                case DOUBLE: {
                    return new TsonNumberHelper(Double.parseDouble(a), NumberType.DOUBLE, radix, unit);
                }
                case BIG_DECIMAL: {
                    return new TsonNumberHelper(new BigDecimal(a), NumberType.BIG_DECIMAL, radix, unit);
                }
                case BIG_INTEGER: {
                    return new TsonNumberHelper(new BigInteger(a, radix.radix()), NumberType.BIG_INTEGER, radix, unit);
                }
            }
        }
        catch (Exception ex) {
            return null;
        }
        throw new IllegalArgumentException("unexpected precision: " + (Object)((Object)numberType));
    }

    public static TsonNumberHelper parse(String s) {
        if (s == null) {
            throw new IllegalArgumentException("null string cannot be parse as number");
        }
        if ((s = s.trim()).isEmpty()) {
            throw new IllegalArgumentException("empty string cannot be parse as number");
        }
        StrFastReader br = new StrFastReader(s);
        Nbr realStr = TsonNumberHelper.readOneDouble(br);
        Nbr imagStr = null;
        if (realStr.getNh().unit == null && br.peekAny('+', '-') != null) {
            imagStr = TsonNumberHelper.readOneDouble(br);
            if (br.hasNext()) {
                throw new IllegalArgumentException("invalid number " + s + ". unable to read " + br);
            }
        } else if (br.hasNext()) {
            throw new IllegalArgumentException("invalid number " + s + ". unable to read " + br);
        }
        if (imagStr != null) {
            NumberType newType = realStr.type.combine(imagStr.type);
            switch (newType) {
                case BYTE: 
                case SHORT: 
                case INT: {
                    newType = NumberType.FLOAT;
                    break;
                }
                case BIG_INTEGER: {
                    newType = NumberType.BIG_DECIMAL;
                }
            }
            realStr.setNh(realStr.getNh().to(newType));
            imagStr.setNh(imagStr.getNh().to(newType));
            return new TsonNumberHelper(realStr.getNh().real, imagStr.getNh().imag, newType, realStr.getNh().layout, imagStr.getNh().unit);
        }
        return realStr.getNh();
    }

    private String lpj() {
        switch (this.layout) {
            case BINARY: {
                return "0b";
            }
            case OCTAL: {
                return "0";
            }
            case HEXADECIMAL: {
                return "0x";
            }
        }
        return "";
    }

    private String lp() {
        switch (this.layout) {
            case DECIMAL: {
                return "_";
            }
            case HEXADECIMAL: {
                return "x";
            }
            case OCTAL: {
                return "o";
            }
            case BINARY: {
                return "b";
            }
        }
        throw new IllegalArgumentException("unexpected");
    }

    private String toStringPart(Number value, boolean compactMax) {
        StringBuilder sb = new StringBuilder();
        block0 : switch (this.type) {
            case BYTE: {
                byte t = value.byteValue();
                sb.append("0u1");
                sb.append(this.lp());
                sb.append(Long.toString(t, this.layout.radix()));
                break;
            }
            case SHORT: {
                short t = value.shortValue();
                sb.append("0u2");
                sb.append(this.lp());
                if (compactMax) {
                    switch (t) {
                        case -32768: {
                            sb.append("Min");
                            break block0;
                        }
                        case 32767: {
                            sb.append("Max");
                            break block0;
                        }
                    }
                    sb.append(Long.toString(t, this.layout.radix()));
                    break;
                }
                sb.append(Long.toString(t, this.layout.radix()));
                break;
            }
            case INT: {
                int t = value.intValue();
                if (compactMax) {
                    switch (t) {
                        case -2147483648: {
                            sb.append("0u4Min");
                            break block0;
                        }
                        case 0x7FFFFFFF: {
                            sb.append("0u4Max");
                            break block0;
                        }
                    }
                    sb.append(this.lpj());
                    sb.append(Long.toString(t, this.layout.radix()));
                    break;
                }
                sb.append(this.lpj());
                sb.append(Long.toString(t, this.layout.radix()));
                break;
            }
            case LONG: {
                long t = value.longValue();
                if (compactMax) {
                    if (t == Long.MIN_VALUE) {
                        sb.append("0MinL");
                        break;
                    }
                    if (t == Long.MAX_VALUE) {
                        sb.append("0MaxL");
                        break;
                    }
                    sb.append(this.lpj());
                    sb.append(Long.toString(t, this.layout.radix()));
                    sb.append("L");
                    break;
                }
                sb.append(this.lpj());
                sb.append(Long.toString(t, this.layout.radix()));
                sb.append("L");
                break;
            }
            case BIG_INTEGER: {
                sb.append(this.lpj());
                sb.append(((BigInteger)value).toString(this.layout.radix()));
                sb.append("LL");
                break;
            }
            case FLOAT: {
                float t = value.floatValue();
                if (Float.isNaN(t)) {
                    sb.append("NaNf");
                    break;
                }
                if (t == Float.NEGATIVE_INFINITY) {
                    sb.append("NInff");
                    break;
                }
                if (t == Float.POSITIVE_INFINITY) {
                    sb.append("PInff");
                    break;
                }
                sb.append(t);
                sb.append("f");
                break;
            }
            case DOUBLE: {
                double t = value.doubleValue();
                if (Double.isNaN(t)) {
                    sb.append("NaN");
                    break;
                }
                if (t == Double.NEGATIVE_INFINITY) {
                    sb.append("NInf");
                    break;
                }
                if (t == Double.POSITIVE_INFINITY) {
                    sb.append("PInf");
                    break;
                }
                sb.append(t);
                break;
            }
            case BIG_DECIMAL: {
                sb.append(value);
                sb.append("LL");
            }
        }
        return sb.toString();
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean compactMax) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.toStringPart(this.real, compactMax));
        if (this.complex) {
            String i = this.toStringPart(this.imag, compactMax);
            if (!i.startsWith("+") && i.startsWith("-")) {
                sb.append("+");
            }
            sb.append(i);
        }
        if (this.unit != null && !this.unit.isEmpty()) {
            if (!this.unit.startsWith("%") && !this.unit.startsWith("_")) {
                sb.append("_");
            }
            sb.append(this.unit);
        }
        return sb.toString();
    }

    public Number getReal() {
        return this.real;
    }

    public Number getImag() {
        return this.imag;
    }

    public boolean isComplex() {
        return this.complex;
    }

    public NumberType getType() {
        return this.type;
    }

    public String getUnit() {
        return this.unit;
    }

    public TsonNumberLayout getRadix() {
        return this.layout;
    }

    private static Nbr readOneDouble(StrFastReader br) {
        Nbr n = new Nbr();
        if (br.read('+')) {
            n.sign = "+";
            n.sb.append("+");
        } else if (br.read('-')) {
            n.sign = "-";
            n.sb.append("-");
        }
        if (br.read("0u")) {
            n.sb.append("0u");
            String u = br.peek(2);
            switch ("0u" + u) {
                case "0u1_": {
                    n.type = NumberType.BYTE;
                    br.read(2);
                    n.sb.append(u);
                    n.parse(TsonNumberLayout.DECIMAL, NumberType.BYTE, br);
                    if (n.special != null) {
                        switch (n.special.ordinal()) {
                            case 0: {
                                n.fillTsonNumberHelperValue((byte)-128);
                                break;
                            }
                            case 1: {
                                n.fillTsonNumberHelperValue((byte)127);
                            }
                        }
                    } else {
                        n.fillTsonNumberHelper();
                    }
                    return n;
                }
                case "0u1b": {
                    n.type = NumberType.BYTE;
                    br.read(2);
                    n.sb.append(u);
                    n.parse(TsonNumberLayout.BINARY, NumberType.BYTE, br);
                    if (n.special != null) {
                        switch (n.special.ordinal()) {
                            case 0: {
                                n.fillTsonNumberHelperValue((byte)-128);
                                break;
                            }
                            case 1: {
                                n.fillTsonNumberHelperValue((byte)127);
                            }
                        }
                    } else {
                        n.type = NumberType.BYTE;
                        n.fillTsonNumberHelper();
                        n.setNh(new TsonNumberHelper(Byte.parseByte(n.nbr, n.layout.radix()), n.type, n.layout, n.unit));
                    }
                    return n;
                }
                case "0u1o": {
                    n.type = NumberType.BYTE;
                    br.read(2);
                    n.sb.append(u);
                    n.parse(TsonNumberLayout.OCTAL, NumberType.BYTE, br);
                    if (n.special != null) {
                        switch (n.special.ordinal()) {
                            case 0: {
                                n.setNh(new TsonNumberHelper((byte)-128, n.type, n.layout, n.unit));
                                break;
                            }
                            case 1: {
                                n.setNh(new TsonNumberHelper((byte)127, n.type, n.layout, n.unit));
                            }
                        }
                    } else {
                        n.setNh(new TsonNumberHelper(Byte.parseByte(n.nbr, n.layout.radix()), n.type, n.layout, n.unit));
                    }
                    return n;
                }
                case "0u1x": {
                    n.type = NumberType.BYTE;
                    br.read(2);
                    n.sb.append(u);
                    n.parse(TsonNumberLayout.HEXADECIMAL, NumberType.BYTE, br);
                    if (n.special != null) {
                        switch (n.special.ordinal()) {
                            case 0: {
                                n.setNh(new TsonNumberHelper((byte)-128, n.type, n.layout, n.unit));
                                break;
                            }
                            case 1: {
                                n.setNh(new TsonNumberHelper((byte)127, n.type, n.layout, n.unit));
                            }
                        }
                    } else {
                        n.setNh(new TsonNumberHelper(Byte.parseByte(n.nbr, n.layout.radix()), n.type, n.layout, n.unit));
                    }
                    return n;
                }
                case "0u2_": {
                    n.type = NumberType.SHORT;
                    br.read(2);
                    n.sb.append(u);
                    n.parse(TsonNumberLayout.DECIMAL, NumberType.SHORT, br);
                    if (n.special != null) {
                        switch (n.special.ordinal()) {
                            case 0: {
                                n.setNh(new TsonNumberHelper((short)Short.MIN_VALUE, n.type, n.layout, n.unit));
                                break;
                            }
                            case 1: {
                                n.setNh(new TsonNumberHelper((short)Short.MAX_VALUE, n.type, n.layout, n.unit));
                            }
                        }
                    } else {
                        n.setNh(new TsonNumberHelper(Short.parseShort(n.nbr, n.layout.radix()), n.type, n.layout, n.unit));
                    }
                    return n;
                }
                case "0u2b": {
                    n.type = NumberType.SHORT;
                    br.read(2);
                    n.sb.append(u);
                    n.parse(TsonNumberLayout.BINARY, NumberType.SHORT, br);
                    if (n.special != null) {
                        switch (n.special.ordinal()) {
                            case 0: {
                                n.setNh(new TsonNumberHelper((short)Short.MIN_VALUE, n.type, n.layout, n.unit));
                                break;
                            }
                            case 1: {
                                n.setNh(new TsonNumberHelper((short)Short.MAX_VALUE, n.type, n.layout, n.unit));
                            }
                        }
                    } else {
                        n.setNh(new TsonNumberHelper(Short.parseShort(n.nbr, n.layout.radix()), n.type, n.layout, n.unit));
                    }
                    return n;
                }
                case "0u2o": {
                    n.type = NumberType.SHORT;
                    br.read(2);
                    n.sb.append(u);
                    n.parse(TsonNumberLayout.OCTAL, NumberType.SHORT, br);
                    if (n.special != null) {
                        switch (n.special.ordinal()) {
                            case 0: {
                                n.setNh(new TsonNumberHelper((short)Short.MIN_VALUE, n.type, n.layout, n.unit));
                                break;
                            }
                            case 1: {
                                n.setNh(new TsonNumberHelper((short)Short.MAX_VALUE, n.type, n.layout, n.unit));
                            }
                        }
                    } else {
                        n.setNh(new TsonNumberHelper(Short.parseShort(n.nbr, n.layout.radix()), n.type, n.layout, n.unit));
                    }
                    return n;
                }
                case "0u2x": {
                    n.type = NumberType.SHORT;
                    br.read(2);
                    n.sb.append(u);
                    n.parse(TsonNumberLayout.HEXADECIMAL, NumberType.SHORT, br);
                    if (n.special != null) {
                        switch (n.special.ordinal()) {
                            case 0: {
                                n.setNh(new TsonNumberHelper((short)Short.MIN_VALUE, n.type, n.layout, n.unit));
                                break;
                            }
                            case 1: {
                                n.setNh(new TsonNumberHelper((short)Short.MAX_VALUE, n.type, n.layout, n.unit));
                            }
                        }
                    } else {
                        n.setNh(new TsonNumberHelper(Short.parseShort(n.nbr, n.layout.radix()), n.type, n.layout, n.unit));
                    }
                    return n;
                }
                case "0u4_": {
                    n.type = NumberType.INT;
                    br.read(2);
                    n.sb.append(u);
                    n.parse(TsonNumberLayout.DECIMAL, NumberType.INT, br);
                    if (n.special != null) {
                        switch (n.special.ordinal()) {
                            case 0: {
                                n.setNh(new TsonNumberHelper(Integer.MIN_VALUE, n.type, n.layout, n.unit));
                                break;
                            }
                            case 1: {
                                n.setNh(new TsonNumberHelper(Integer.MAX_VALUE, n.type, n.layout, n.unit));
                            }
                        }
                    } else {
                        n.setNh(new TsonNumberHelper(Integer.parseInt(n.nbr, n.layout.radix()), n.type, n.layout, n.unit));
                    }
                    return n;
                }
                case "0u4b": {
                    n.type = NumberType.INT;
                    br.read(2);
                    n.sb.append(u);
                    n.parse(TsonNumberLayout.BINARY, NumberType.INT, br);
                    if (n.special != null) {
                        switch (n.special.ordinal()) {
                            case 0: {
                                n.setNh(new TsonNumberHelper(Integer.MIN_VALUE, n.type, n.layout, n.unit));
                                break;
                            }
                            case 1: {
                                n.setNh(new TsonNumberHelper(Integer.MAX_VALUE, n.type, n.layout, n.unit));
                            }
                        }
                    } else {
                        n.setNh(new TsonNumberHelper(Integer.parseInt(n.nbr, n.layout.radix()), n.type, n.layout, n.unit));
                    }
                    return n;
                }
                case "0u4o": {
                    n.type = NumberType.INT;
                    br.read(2);
                    n.sb.append(u);
                    n.parse(TsonNumberLayout.OCTAL, NumberType.INT, br);
                    if (n.special != null) {
                        switch (n.special.ordinal()) {
                            case 0: {
                                n.setNh(new TsonNumberHelper(Integer.MIN_VALUE, n.type, n.layout, n.unit));
                                break;
                            }
                            case 1: {
                                n.setNh(new TsonNumberHelper(Integer.MAX_VALUE, n.type, n.layout, n.unit));
                            }
                        }
                    } else {
                        n.setNh(new TsonNumberHelper(Integer.parseInt(n.nbr, n.layout.radix()), n.type, n.layout, n.unit));
                    }
                    return n;
                }
                case "0u4x": {
                    n.type = NumberType.INT;
                    br.read(2);
                    n.sb.append(u);
                    n.parse(TsonNumberLayout.HEXADECIMAL, NumberType.INT, br);
                    if (n.special != null) {
                        switch (n.special.ordinal()) {
                            case 0: {
                                n.setNh(new TsonNumberHelper(Integer.MIN_VALUE, n.type, n.layout, n.unit));
                                break;
                            }
                            case 1: {
                                n.setNh(new TsonNumberHelper(Integer.MAX_VALUE, n.type, n.layout, n.unit));
                            }
                        }
                    } else {
                        n.setNh(new TsonNumberHelper(Integer.parseInt(n.nbr, n.layout.radix()), n.type, n.layout, n.unit));
                    }
                    return n;
                }
                case "0u8_": {
                    n.type = NumberType.LONG;
                    br.read(2);
                    n.sb.append(u);
                    n.parse(TsonNumberLayout.DECIMAL, NumberType.LONG, br);
                    if (n.special != null) {
                        switch (n.special.ordinal()) {
                            case 0: {
                                n.setNh(new TsonNumberHelper(Long.MIN_VALUE, n.type, n.layout, n.unit));
                                break;
                            }
                            case 1: {
                                n.setNh(new TsonNumberHelper(Long.MAX_VALUE, n.type, n.layout, n.unit));
                            }
                        }
                    } else {
                        n.setNh(new TsonNumberHelper(Long.parseLong(n.nbr, n.layout.radix()), n.type, n.layout, n.unit));
                    }
                    return n;
                }
                case "0u8b": {
                    n.type = NumberType.LONG;
                    br.read(2);
                    n.sb.append(u);
                    n.parse(TsonNumberLayout.BINARY, NumberType.LONG, br);
                    if (n.special != null) {
                        switch (n.special.ordinal()) {
                            case 0: {
                                n.setNh(new TsonNumberHelper(Long.MIN_VALUE, n.type, n.layout, n.unit));
                                break;
                            }
                            case 1: {
                                n.setNh(new TsonNumberHelper(Long.MAX_VALUE, n.type, n.layout, n.unit));
                            }
                        }
                    } else {
                        n.setNh(new TsonNumberHelper(Long.parseLong(n.nbr, n.layout.radix()), n.type, n.layout, n.unit));
                    }
                    return n;
                }
                case "0u8o": {
                    n.type = NumberType.LONG;
                    br.read(2);
                    n.sb.append(u);
                    n.parse(TsonNumberLayout.OCTAL, NumberType.LONG, br);
                    if (n.special != null) {
                        switch (n.special.ordinal()) {
                            case 0: {
                                n.setNh(new TsonNumberHelper(Long.MIN_VALUE, n.type, n.layout, n.unit));
                                break;
                            }
                            case 1: {
                                n.setNh(new TsonNumberHelper(Long.MAX_VALUE, n.type, n.layout, n.unit));
                            }
                        }
                    } else {
                        n.setNh(new TsonNumberHelper(Long.parseLong(n.nbr, n.layout.radix()), n.type, n.layout, n.unit));
                    }
                    return n;
                }
                case "0u8x": {
                    n.type = NumberType.LONG;
                    br.read(2);
                    n.sb.append(u);
                    n.parse(TsonNumberLayout.HEXADECIMAL, NumberType.LONG, br);
                    if (n.special != null) {
                        switch (n.special.ordinal()) {
                            case 0: {
                                n.setNh(new TsonNumberHelper(Long.MIN_VALUE, n.type, n.layout, n.unit));
                                break;
                            }
                            case 1: {
                                n.setNh(new TsonNumberHelper(Long.MAX_VALUE, n.type, n.layout, n.unit));
                            }
                        }
                    } else {
                        n.setNh(new TsonNumberHelper(Long.parseLong(n.nbr, n.layout.radix()), n.type, n.layout, n.unit));
                    }
                    return n;
                }
            }
            throw new IllegalArgumentException("unexpected ");
        }
        if (br.read("0x")) {
            n.sb.append("0x");
            n.layout = TsonNumberLayout.HEXADECIMAL;
            n.type = NumberType.INT;
            if (br.read("Min")) {
                n.sb.append("Min");
                n.special = NbrSpecial.MIN;
            } else if (br.read("Max")) {
                n.sb.append("Max");
                n.special = NbrSpecial.MAX;
            } else {
                n.nbr = br.readWhile(c -> c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F' || c == '_');
                String wasL = br.readAny('l', 'L');
                if (wasL != null) {
                    String wasL2 = br.readAny('l', 'L');
                    if (wasL2 != null) {
                        n.suffix = wasL + wasL2;
                        n.type = NumberType.BIG_INTEGER;
                    } else {
                        n.suffix = wasL;
                        n.type = NumberType.LONG;
                    }
                }
            }
            n.sb.append(n.nbr);
            n.unit = br.readWhile(c -> true);
            n.sb.append(n.unit);
            n.balanceHex();
            n.trimNbr();
            if (n.special != null) {
                block101 : switch (n.type) {
                    case INT: {
                        switch (n.special.ordinal()) {
                            case 0: {
                                n.fillTsonNumberHelperValue(Integer.MIN_VALUE);
                                break block101;
                            }
                            case 1: {
                                n.fillTsonNumberHelperValue(Integer.MAX_VALUE);
                            }
                        }
                        break;
                    }
                    case LONG: {
                        switch (n.special.ordinal()) {
                            case 0: {
                                n.fillTsonNumberHelperValue(Long.MIN_VALUE);
                                break block101;
                            }
                            case 1: {
                                n.fillTsonNumberHelperValue(Long.MAX_VALUE);
                            }
                        }
                    }
                }
            } else {
                switch (n.type) {
                    case INT: {
                        n.fillTsonNumberHelperTryAll(NumberType.INT, NumberType.LONG, NumberType.BIG_INTEGER);
                        return n;
                    }
                    case BIG_INTEGER: 
                    case LONG: {
                        n.fillTsonNumberHelper();
                    }
                }
            }
            return n;
        }
        if (br.read("0b")) {
            n.sb.append("0b");
            n.layout = TsonNumberLayout.BINARY;
            n.type = NumberType.INT;
            if (br.read("Min")) {
                n.sb.append("Min");
                n.special = NbrSpecial.MIN;
            } else if (br.read("Max")) {
                n.sb.append("Max");
                n.special = NbrSpecial.MAX;
            } else {
                n.nbr = br.readWhile(c -> c >= '0' && c <= '1' || c == '_');
                String wasL = br.readAny('l', 'L');
                if (wasL != null) {
                    String wasL2 = br.readAny('l', 'L');
                    if (wasL2 != null) {
                        n.suffix = wasL + wasL2;
                        n.type = NumberType.BIG_INTEGER;
                    } else {
                        n.suffix = wasL;
                        n.type = NumberType.LONG;
                    }
                }
            }
            n.sb.append(n.nbr);
            n.unit = br.readWhile(c -> true);
            n.sb.append(n.unit);
            n.balanceHex();
            n.trimNbr();
            if (n.special != null) {
                block117 : switch (n.type) {
                    case INT: {
                        switch (n.special.ordinal()) {
                            case 0: {
                                n.setNh(new TsonNumberHelper(Integer.MIN_VALUE, n.type, n.layout, n.unit));
                                break block117;
                            }
                            case 1: {
                                n.setNh(new TsonNumberHelper(Integer.MAX_VALUE, n.type, n.layout, n.unit));
                            }
                        }
                        break;
                    }
                    case LONG: {
                        switch (n.special.ordinal()) {
                            case 0: {
                                n.setNh(new TsonNumberHelper(Long.MIN_VALUE, n.type, n.layout, n.unit));
                                break block117;
                            }
                            case 1: {
                                n.setNh(new TsonNumberHelper(Long.MAX_VALUE, n.type, n.layout, n.unit));
                            }
                        }
                    }
                }
            } else {
                switch (n.type) {
                    case INT: {
                        for (NumberType tt : new NumberType[]{NumberType.INT, NumberType.LONG, NumberType.BIG_INTEGER}) {
                            try {
                                n.type = tt;
                                n.fillTsonNumberHelper();
                                return n;
                            }
                            catch (Exception exception) {
                            }
                        }
                        n.type = NumberType.INT;
                        n.fillTsonNumberHelper((s, radix) -> Integer.parseInt(s, radix));
                        return n;
                    }
                    case BIG_INTEGER: 
                    case LONG: {
                        n.fillTsonNumberHelper();
                        return n;
                    }
                }
            }
            return n;
        }
        if (br.read("0")) {
            n.sb.append("0");
            n.layout = TsonNumberLayout.OCTAL;
            n.type = NumberType.INT;
            if (br.read("Min")) {
                n.sb.append("Min");
                n.special = NbrSpecial.MIN;
            } else if (br.read("Max")) {
                n.sb.append("Max");
                n.special = NbrSpecial.MAX;
            } else {
                n.sb.append("0");
                TsonNumberHelper.readDblIEEE(br, n, "0");
            }
            n.unit = br.readWhile(c -> true);
            n.sb.append(n.unit);
            n.trimNbr();
            if (n.special != null) {
                block133 : switch (n.type) {
                    case INT: {
                        switch (n.special.ordinal()) {
                            case 0: {
                                n.setNh(new TsonNumberHelper(Integer.MIN_VALUE, n.type, n.layout, n.unit));
                                break block133;
                            }
                            case 1: {
                                n.setNh(new TsonNumberHelper(Integer.MAX_VALUE, n.type, n.layout, n.unit));
                            }
                        }
                        break;
                    }
                    case LONG: {
                        switch (n.special.ordinal()) {
                            case 0: {
                                n.setNh(new TsonNumberHelper(Long.MIN_VALUE, n.type, n.layout, n.unit));
                                break block133;
                            }
                            case 1: {
                                n.setNh(new TsonNumberHelper(Long.MAX_VALUE, n.type, n.layout, n.unit));
                            }
                        }
                    }
                }
            } else {
                switch (n.type) {
                    case INT: {
                        n.fillTsonNumberHelperTryAll(NumberType.INT, NumberType.LONG, NumberType.BIG_INTEGER);
                        return n;
                    }
                    case BIG_INTEGER: 
                    case LONG: 
                    case FLOAT: 
                    case DOUBLE: 
                    case BIG_DECIMAL: {
                        n.fillTsonNumberHelper();
                    }
                }
            }
            return n;
        }
        if (br.read("NaNf")) {
            n.decimal = true;
            n.special = NbrSpecial.NAN;
            n.type = NumberType.FLOAT;
        } else if (br.read("Inff")) {
            n.decimal = true;
            n.special = NbrSpecial.INF;
            n.type = NumberType.FLOAT;
        } else if (br.read("NaN")) {
            n.decimal = true;
            n.special = NbrSpecial.NAN;
            n.type = NumberType.DOUBLE;
        } else if (br.read("Inf")) {
            n.decimal = true;
            n.special = NbrSpecial.INF;
            n.type = NumberType.DOUBLE;
        } else {
            TsonNumberHelper.readDblIEEE(br, n, "");
        }
        if (br.read('_')) {
            n.sb.append('_');
            n.unit = br.readWhile(c -> Character.isLetter(c));
            n.sb.append(n.unit);
        } else if (br.read('%')) {
            n.unit = "%" + br.readWhile(c -> Character.isLetter(c));
            n.sb.append(n.unit);
        }
        n.layout = TsonNumberLayout.DECIMAL;
        if (!n.decimal) {
            if (n.suffix != null) {
                switch (n.suffix.toUpperCase()) {
                    case "LL": {
                        n.type = NumberType.BIG_INTEGER;
                        n.fillTsonNumberHelper();
                        return n;
                    }
                    case "L": {
                        n.type = NumberType.LONG;
                        n.fillTsonNumberHelper();
                        return n;
                    }
                    case "F": {
                        n.type = NumberType.FLOAT;
                        n.fillTsonNumberHelper();
                        return n;
                    }
                }
            } else {
                n.fillTsonNumberHelperTryAll(NumberType.INT, NumberType.LONG, NumberType.BIG_INTEGER);
            }
        } else {
            if (n.special != null) {
                switch (n.special.ordinal()) {
                    case 3: {
                        switch (n.type) {
                            case DOUBLE: {
                                if ("-".equals(n.sign)) {
                                    n.setNh(new TsonNumberHelper(Double.NEGATIVE_INFINITY, n.type, n.layout, n.unit));
                                } else {
                                    n.setNh(new TsonNumberHelper(Double.POSITIVE_INFINITY, n.type, n.layout, n.unit));
                                }
                                return n;
                            }
                            case FLOAT: {
                                if ("-".equals(n.sign)) {
                                    n.setNh(new TsonNumberHelper(Float.valueOf(Float.NEGATIVE_INFINITY), n.type, n.layout, n.unit));
                                } else {
                                    n.setNh(new TsonNumberHelper(Float.valueOf(Float.POSITIVE_INFINITY), n.type, n.layout, n.unit));
                                }
                                return n;
                            }
                        }
                        return n;
                    }
                    case 2: {
                        switch (n.type) {
                            case DOUBLE: {
                                n.setNh(new TsonNumberHelper(Double.NaN, n.type, n.layout, n.unit));
                                return n;
                            }
                            case FLOAT: {
                                n.setNh(new TsonNumberHelper(Float.valueOf(Float.NaN), n.type, n.layout, n.unit));
                                return n;
                            }
                        }
                    }
                }
            }
            if (n.suffix != null) {
                switch (n.suffix.toUpperCase()) {
                    case "LL": {
                        n.type = NumberType.BIG_DECIMAL;
                        n.fillTsonNumberHelper();
                        return n;
                    }
                    case "L": {
                        n.type = NumberType.DOUBLE;
                        n.fillTsonNumberHelper();
                        return n;
                    }
                    case "F": {
                        n.type = NumberType.FLOAT;
                        n.fillTsonNumberHelper();
                        return n;
                    }
                }
            } else {
                n.fillTsonNumberHelperTryAll(NumberType.DOUBLE, NumberType.BIG_DECIMAL);
                return n;
            }
        }
        return n;
    }

    private static void readDblIEEE(StrFastReader br, Nbr n, String prefix) {
        StringBuilder nbr = new StringBuilder();
        nbr.append(prefix);
        String beforeDot = br.readWhile(c -> c >= '0' && c <= '9' || c == '_');
        if (beforeDot != null) {
            if (beforeDot.endsWith("_")) {
                beforeDot = beforeDot.substring(0, beforeDot.length() - 1);
                br.unread();
            }
            n.sb.append(beforeDot);
            nbr.append(beforeDot);
        }
        String afterDot = null;
        String expSign = null;
        String exp = null;
        String expNbr = null;
        if (br.read('.')) {
            n.decimal = true;
            n.sb.append(".");
            nbr.append(".");
            afterDot = br.readWhile(c -> c >= '0' && c <= '9' || c == '_');
            if (afterDot != null) {
                if (afterDot.endsWith("_")) {
                    afterDot = afterDot.substring(0, afterDot.length() - 1);
                    br.unread();
                }
                n.sb.append(afterDot);
                nbr.append(afterDot);
            }
        }
        if ((exp = br.readAny('e', 'E')) != null) {
            n.decimal = true;
            n.sb.append(exp);
            nbr.append(exp);
            expSign = br.readAny('+', '-');
            if (expSign != null) {
                n.sb.append(expSign);
                nbr.append(expSign);
            }
            expNbr = br.readWhile(c -> c >= '0' && c <= '9');
            n.sb.append(expNbr);
        }
        n.nbr = nbr.toString();
        if (n.decimal) {
            n.layout = TsonNumberLayout.DECIMAL;
            n.suffix = br.readAnyIgnoreCase("LL", "L", "F");
            switch (n.suffix == null ? "" : n.suffix.toUpperCase()) {
                case "": 
                case "L": {
                    n.type = NumberType.DOUBLE;
                    break;
                }
                case "LL": {
                    n.type = NumberType.BIG_DECIMAL;
                    break;
                }
                case "F": {
                    n.type = NumberType.FLOAT;
                }
            }
        } else {
            n.suffix = br.readAnyIgnoreCase("LL", "L", "F");
            switch (n.suffix == null ? "" : n.suffix.toUpperCase()) {
                case "": {
                    n.type = NumberType.INT;
                    break;
                }
                case "L": {
                    n.type = NumberType.LONG;
                    break;
                }
                case "LL": {
                    n.type = NumberType.BIG_INTEGER;
                    break;
                }
                case "F": {
                    n.type = NumberType.FLOAT;
                }
            }
        }
    }

    public TsonElement toTson() {
        if (this.isComplex()) {
            switch (this.getType()) {
                case BYTE: 
                case SHORT: 
                case INT: 
                case FLOAT: {
                    return Tson.ofFloatComplex(this.getReal().floatValue(), this.getImag().floatValue(), this.getUnit());
                }
                case LONG: 
                case DOUBLE: {
                    return Tson.ofDoubleComplex(this.getReal().doubleValue(), this.getImag().doubleValue(), this.getUnit());
                }
                case BIG_INTEGER: {
                    return Tson.ofBigComplex(new BigDecimal((BigInteger)this.getReal()), new BigDecimal((BigInteger)this.getImag()), this.getUnit());
                }
                case BIG_DECIMAL: {
                    return Tson.ofBigComplex((BigDecimal)this.getReal(), (BigDecimal)this.getImag(), this.getUnit());
                }
            }
        } else {
            switch (this.getType()) {
                case BYTE: {
                    return Tson.ofByte(this.getReal().byteValue(), this.getRadix(), this.getUnit());
                }
                case SHORT: {
                    return Tson.ofShort(this.getReal().shortValue(), this.getRadix(), this.getUnit());
                }
                case INT: {
                    return Tson.ofInt(this.getReal().intValue(), this.getRadix(), this.getUnit());
                }
                case LONG: {
                    return Tson.ofLong(this.getReal().longValue(), this.getRadix(), this.getUnit());
                }
                case FLOAT: {
                    return Tson.ofFloat(this.getReal().floatValue(), this.getUnit());
                }
                case DOUBLE: {
                    return Tson.ofDouble(this.getReal().floatValue(), this.getUnit());
                }
                case BIG_INTEGER: {
                    return Tson.ofBigInt((BigInteger)this.getReal(), this.getRadix(), this.getUnit());
                }
                case BIG_DECIMAL: {
                    return Tson.ofBigDecimal((BigDecimal)this.getReal(), this.getUnit());
                }
            }
        }
        throw new IllegalArgumentException("Unable to parse number " + this.toString());
    }

    private static class Nbr {
        String sign;
        TsonNumberLayout layout;
        NumberType type;
        String nbr;
        String unit;
        StringBuilder sb = new StringBuilder();
        boolean decimal;
        String suffix;
        private TsonNumberHelper nh;
        NbrSpecial special;

        private Nbr() {
        }

        public void trimNbr() {
            StringBuilder sb = new StringBuilder();
            for (char c : this.nbr.toCharArray()) {
                if (c == '_') continue;
                sb.append(c);
            }
            this.nbr = sb.toString();
        }

        public void balanceHex() {
            int i;
            if (this.unit.length() > 0 && !this.nbr.endsWith("_") && (i = this.nbr.lastIndexOf(95)) > 0) {
                this.unit = this.nbr.substring(i + 1) + this.unit;
                this.nbr = this.nbr.substring(0, i);
            }
        }

        public TsonNumberHelper getNh() {
            return this.nh;
        }

        public Nbr setNh(TsonNumberHelper nh) {
            this.nh = nh;
            return this;
        }

        public void fillTsonNumberHelperAsInt() {
            this.fillTsonNumberHelper((s, radix) -> Integer.parseInt(s, radix));
        }

        public void fillTsonNumberHelperAsLong() {
            this.fillTsonNumberHelper((s, radix) -> Long.parseLong(s, radix));
        }

        public void fillTsonNumberHelperAsByte() {
            this.fillTsonNumberHelper((s, radix) -> Byte.parseByte(s, radix));
        }

        public void fillTsonNumberHelperAsShort() {
            this.fillTsonNumberHelper((s, radix) -> Short.parseShort(s, radix));
        }

        public void fillTsonNumberHelperTryAll(NumberType ... all) {
            for (NumberType numberType : all) {
                try {
                    this.type = numberType;
                    this.fillTsonNumberHelper();
                    return;
                }
                catch (Exception exception) {
                }
            }
            this.type = all[0];
            this.fillTsonNumberHelper();
        }

        public void fillTsonNumberHelper() {
            switch (this.type) {
                case BYTE: {
                    this.fillTsonNumberHelper((s, radix) -> Byte.parseByte(s, radix));
                    break;
                }
                case SHORT: {
                    this.fillTsonNumberHelper((s, radix) -> Short.parseShort(s, radix));
                    break;
                }
                case INT: {
                    this.fillTsonNumberHelper((s, radix) -> Integer.parseInt(s, radix));
                    break;
                }
                case LONG: {
                    this.fillTsonNumberHelper((s, radix) -> Long.parseLong(s, radix));
                    break;
                }
                case BIG_INTEGER: {
                    this.fillTsonNumberHelper((val, radix) -> new BigInteger(val, radix));
                    break;
                }
                case FLOAT: {
                    this.fillTsonNumberHelper((s, r) -> Float.valueOf(Float.parseFloat(s)));
                    break;
                }
                case DOUBLE: {
                    this.fillTsonNumberHelper((s, r) -> Double.parseDouble(s));
                    break;
                }
                case BIG_DECIMAL: {
                    this.fillTsonNumberHelper((s, r) -> new BigDecimal(s));
                }
            }
        }

        public void fillTsonNumberHelperValue(Number pp) {
            this.setNh(new TsonNumberHelper(pp, this.type, this.layout, this.unit));
        }

        public void fillTsonNumberHelper(NbrParse pp) {
            this.setNh(new TsonNumberHelper(pp.parse(("-".equals(this.sign) ? "-" : "") + this.nbr, this.layout.radix()), this.type, this.layout, this.unit));
        }

        public void parse(TsonNumberLayout tsonNumberLayout, NumberType numberType, StrFastReader br) {
            this.layout = tsonNumberLayout;
            this.type = numberType;
            switch (tsonNumberLayout) {
                case DECIMAL: {
                    if (br.read("Min")) {
                        this.sb.append("Min");
                        this.special = NbrSpecial.MIN;
                    } else if (br.read("Max")) {
                        this.sb.append("Max");
                        this.special = NbrSpecial.MAX;
                    } else {
                        this.nbr = br.readWhile(c -> c >= '0' && c <= '9' || c == '_');
                        this.sb.append(this.nbr);
                    }
                    this.unit = br.readWhile(c -> true);
                    this.sb.append(this.unit);
                    this.trimNbr();
                    break;
                }
                case BINARY: {
                    if (br.read("Min")) {
                        this.sb.append("Min");
                        this.special = NbrSpecial.MIN;
                    } else if (br.read("Max")) {
                        this.sb.append("Max");
                        this.special = NbrSpecial.MAX;
                    } else {
                        this.nbr = br.readWhile(c -> c >= '0' && c <= '1' || c == '_');
                    }
                    this.sb.append(this.nbr);
                    this.unit = br.readWhile(c -> true);
                    this.sb.append(this.unit);
                    this.trimNbr();
                    break;
                }
                case OCTAL: {
                    if (br.read("Min")) {
                        this.sb.append("Min");
                        this.special = NbrSpecial.MIN;
                    } else if (br.read("Max")) {
                        this.sb.append("Max");
                        this.special = NbrSpecial.MAX;
                    } else {
                        this.nbr = br.readWhile(c -> c >= '0' && c <= '7' || c == '_');
                    }
                    this.sb.append(this.nbr);
                    this.unit = br.readWhile(c -> true);
                    this.sb.append(this.unit);
                    this.trimNbr();
                    break;
                }
                case HEXADECIMAL: {
                    if (br.read("Min")) {
                        this.sb.append("Min");
                        this.special = NbrSpecial.MIN;
                    } else if (br.read("Max")) {
                        this.sb.append("Max");
                        this.special = NbrSpecial.MAX;
                    } else {
                        this.nbr = br.readWhile(c -> c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F' || c == '_');
                    }
                    this.sb.append(this.nbr);
                    this.unit = br.readWhile(c -> true);
                    this.sb.append(this.unit);
                    this.balanceHex();
                    this.trimNbr();
                }
            }
        }

        static interface NbrParse {
            public Number parse(String var1, int var2);
        }
    }

    private static enum NbrSpecial {
        MIN,
        MAX,
        NAN,
        INF;

    }
}

