/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.parser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.Tson;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonAnnotation;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonComment;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonComments;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonDocument;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonElement;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonElementBase;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonParserVisitor;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.elements.TsonAnnotationImpl;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.elements.TsonArrayImpl;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.elements.TsonElementDecorator;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.elements.TsonElementListImpl;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.elements.TsonObjectImpl;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.elements.TsonUpletImpl;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.parser.TsonParserUtils;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.util.TsonUtils;

public class SimpleTsonParserVisitor
implements TsonParserVisitor {
    private StackContext[] stack = new StackContext[10];
    private StackContext rootContext = new StackContext();
    private int stackSize = 0;

    public TsonElement getElement() {
        if (this.stackSize == 0) {
            return null;
        }
        if (this.stackSize != 1) {
            throw new IllegalArgumentException("Invalid stack state");
        }
        ElementContext u = (ElementContext)this.peek();
        return u.value;
    }

    public TsonDocument getDocument() {
        if (this.stackSize == 0) {
            return null;
        }
        if (this.stackSize != 1) {
            throw new IllegalArgumentException("Invalid stack state");
        }
        DocumentContext u = (DocumentContext)this.peek();
        return u.value;
    }

    public <T> Set<T> getMergedSetsContextValues(String name, int index) {
        HashSet s = new HashSet();
        List<T> contextValues = this.getContextValues(name, index);
        for (Collection contextValue : contextValues) {
            s.addAll(contextValue);
        }
        return s;
    }

    public <K, T> Map<K, T> getMergedMapsContextValues(String name, int index) {
        LinkedHashMap s = new LinkedHashMap();
        List<T> contextValues = this.getContextValues(name, index);
        for (Map contextValue : contextValues) {
            for (Map.Entry e : contextValue.entrySet()) {
                if (s.containsKey(e.getKey())) continue;
                s.put(e.getKey(), e.getValue());
            }
        }
        return s;
    }

    public <T> List<T> getContextValues(String name, int index) {
        ArrayList<Object> a = new ArrayList<Object>();
        for (int i = this.stackSize - 1 - index; i >= 0; --i) {
            Object u = this.stack[i].map.get(name);
            if (u == null) continue;
            a.add(u);
        }
        Object uu = this.rootContext.map.get(name);
        if (uu != null) {
            a.add(uu);
        }
        return a;
    }

    @Override
    public void visitKeyValueEnd() {
        ElementContext b = (ElementContext)this.pop();
        ElementContext a = (ElementContext)this.peek();
        this.repush(new ElementContext(Tson.ofPair(a.value, (TsonElementBase)b.value)));
    }

    @Override
    public void visitBinOpEnd(String op) {
        ElementContext b = (ElementContext)this.pop();
        ElementContext a = (ElementContext)this.peek();
        if (":".equals(op)) {
            this.repush(new ElementContext(Tson.ofPair(a.value, (TsonElementBase)b.value)));
        } else {
            this.repush(new ElementContext(Tson.binOp(op, a.value, b.value)));
        }
    }

    @Override
    public void visitElementStart() {
        this.push(new PartialElementContext());
    }

    @Override
    public void visitNamedStart(String id) {
        PartialElementContext a = (PartialElementContext)this.peek();
        a.name = id;
    }

    @Override
    public void visitNamedArrayStart() {
        PartialElementContext a = (PartialElementContext)this.peek();
        a.array = new ArrayList();
    }

    @Override
    public void visitArrayStart() {
        PartialElementContext a = (PartialElementContext)this.peek();
        a.array = new ArrayList();
    }

    @Override
    public void visitObjectStart() {
        PartialElementContext a = (PartialElementContext)this.peek();
        a.object = new ArrayList();
    }

    @Override
    public void visitNamedObjectStart() {
        PartialElementContext a = (PartialElementContext)this.peek();
        a.object = new ArrayList();
    }

    @Override
    public void visitParamsStart() {
        PartialElementContext a = (PartialElementContext)this.peek();
        a.params = new ArrayList();
    }

    @Override
    public void visitParamElementStart() {
    }

    @Override
    public void visitParamElementEnd() {
        ElementContext o = (ElementContext)this.pop();
        PartialElementContext a = (PartialElementContext)this.peek();
        a.params.add(o.value);
    }

    @Override
    public void visitObjectElementEnd() {
        ElementContext o = (ElementContext)this.pop();
        PartialElementContext a = (PartialElementContext)this.peek();
        a.object.add(o.value);
    }

    @Override
    public void visitArrayElementEnd() {
        ElementContext o = (ElementContext)this.pop();
        PartialElementContext a = (PartialElementContext)this.peek();
        a.array.add(o.value);
    }

    @Override
    public void visitComments(TsonComment comments) {
        PartialElementContext a = (PartialElementContext)this.peek();
        a.comments = TsonComments.concat(a.comments, new TsonComments(new TsonComment[]{comments}, null));
    }

    @Override
    public void visitObjectEnd() {
        PartialElementContext a = (PartialElementContext)this.peek();
        this.repush(new ElementContext(TsonElementDecorator.of((TsonElement)new TsonObjectImpl(a.name, a.hasParams ? new TsonElementListImpl(a.params()) : null, TsonUtils.unmodifiableElements(a.object)), a.comments, a.annotations), a.map));
    }

    @Override
    public void visitUpletEnd() {
        PartialElementContext a = (PartialElementContext)this.peek();
        this.repush(new ElementContext(TsonElementDecorator.of((TsonElement)new TsonUpletImpl(a.name, TsonUtils.unmodifiableElements(a.params())), a.comments, a.annotations), a.map));
    }

    @Override
    public void visitArrayEnd() {
        PartialElementContext a = (PartialElementContext)this.peek();
        this.repush(new ElementContext(TsonElementDecorator.of((TsonElement)new TsonArrayImpl(a.name, a.hasParams ? new TsonElementListImpl(a.params()) : null, TsonUtils.unmodifiableElements(a.array)), a.comments, a.annotations), a.map));
    }

    @Override
    public void visitNamedObjectEnd() {
        PartialElementContext a = (PartialElementContext)this.peek();
        this.repush(new ElementContext(TsonElementDecorator.of((TsonElement)new TsonObjectImpl(a.name, a.hasParams ? new TsonElementListImpl(a.params()) : null, TsonUtils.unmodifiableElements(a.object)), a.comments, a.annotations), a.map));
    }

    @Override
    public void visitNamedArrayEnd() {
        PartialElementContext a = (PartialElementContext)this.peek();
        this.repush(new ElementContext(TsonElementDecorator.of((TsonElement)new TsonArrayImpl(a.name, a.hasParams ? new TsonElementListImpl(a.params()) : null, TsonUtils.unmodifiableElements(a.array)), a.comments, a.annotations), a.map));
    }

    @Override
    public void visitPrimitiveEnd(TsonElement primitiveElement) {
        PartialElementContext a = (PartialElementContext)this.peek();
        this.repush(new ElementContext(TsonElementDecorator.of(primitiveElement, a.comments, a.annotations), a.map));
    }

    @Override
    public void visitAnnotationStart(String annotationName) {
        this.push(new AnnotationContext(annotationName));
    }

    @Override
    public void visitAnnotationEnd() {
        AnnotationContext a = (AnnotationContext)this.pop();
        PartialElementContext n = (PartialElementContext)this.peek();
        if (n.annotations == null) {
            n.annotations = new ArrayList<TsonAnnotation>();
        }
        TsonAnnotation e = new TsonAnnotationImpl(a.id, TsonUtils.unmodifiableElements(a.elements));
        if ((e = this.onAddAnnotation(e)) != null) {
            n.annotations.add(e);
        }
    }

    protected TsonAnnotation onAddAnnotation(TsonAnnotation a) {
        return a;
    }

    @Override
    public void visitAnnotationParamEnd() {
        ElementContext e = (ElementContext)this.pop();
        AnnotationContext n = (AnnotationContext)this.peek();
        n.elements.add(e.value);
    }

    @Override
    public void visitDocumentEnd() {
        ElementContext e = (ElementContext)this.peek();
        this.repush(new DocumentContext(TsonParserUtils.elementToDocument(e.value)));
    }

    protected <T extends StackContext> T peek() {
        return (T)this.stack[this.stackSize - 1];
    }

    public StackContext getRootContext() {
        return this.rootContext;
    }

    protected <T extends StackContext> T peekOrRoot(int index) {
        T p = this.peek(index);
        if (p == null) {
            return (T)this.rootContext;
        }
        return p;
    }

    protected <T extends StackContext> T peek(int index) {
        int i = this.stackSize - 1 - index;
        if (i >= 0) {
            return (T)this.stack[i];
        }
        return null;
    }

    protected <T extends StackContext> T pop() {
        StackContext t = this.stack[--this.stackSize];
        this.stack[this.stackSize + 1] = null;
        return (T)t;
    }

    protected void repush(StackContext n) {
        this.stack[this.stackSize - 1] = n;
    }

    protected void push(StackContext n) {
        try {
            this.stack[this.stackSize] = n;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            StackContext[] stack2 = new StackContext[this.stackSize + 20];
            System.arraycopy(this.stack, 0, stack2, 0, this.stack.length);
            this.stack = stack2;
        }
        ++this.stackSize;
    }

    protected static class StackContext {
        Map<String, Object> map = new HashMap<String, Object>();

        protected StackContext() {
        }

        public void setContextValue(String name, Object o) {
            this.map.put(name, o);
        }

        public <T> T getContextValue(String name) {
            return (T)this.map.get(name);
        }

        public <T> void addToSetContextValue(String name, T v) {
            HashSet<T> a = (HashSet<T>)this.getContextValue(name);
            if (a == null) {
                a = new HashSet<T>();
                this.setContextValue(name, a);
            }
            a.add(v);
        }

        public <T> void addToListContextValue(String name, T v) {
            ArrayList<T> a = (ArrayList<T>)this.getContextValue(name);
            if (a == null) {
                a = new ArrayList<T>();
                this.setContextValue(name, a);
            }
            a.add(v);
        }

        public <K, T> void addToMapContextValue(String name, K varName, T v) {
            LinkedHashMap<K, T> a = (LinkedHashMap<K, T>)this.getContextValue(name);
            if (a == null) {
                a = new LinkedHashMap<K, T>();
                this.setContextValue(name, a);
            }
            a.put(varName, v);
        }
    }

    protected static class ElementContext
    extends StackContext {
        public TsonElement value;

        public ElementContext(TsonElement value) {
            this(value, null);
        }

        public ElementContext(TsonElement value, Map<String, Object> map) {
            this.value = value;
            if (map != null) {
                this.map.putAll(map);
            }
        }
    }

    protected static class DocumentContext
    extends StackContext {
        TsonDocument value;

        public DocumentContext(TsonDocument value) {
            this.value = value;
        }
    }

    protected static class PartialElementContext
    extends StackContext {
        public TsonElement element;
        public String name;
        public boolean hasParams;
        public ArrayList<TsonElement> params;
        public ArrayList<TsonElement> array;
        public ArrayList<TsonElement> object;
        public TsonComments comments;
        public List<TsonAnnotation> annotations;

        protected PartialElementContext() {
        }

        public boolean paramsEmpty() {
            return this.params == null || this.params.isEmpty();
        }

        public ArrayList<TsonElement> params() {
            return this.params == null ? new ArrayList<TsonElement>() : this.params;
        }
    }

    protected static class AnnotationContext
    extends StackContext {
        public String id;
        public List<TsonElement> elements = new ArrayList<TsonElement>();

        public AnnotationContext(String id) {
            this.id = id;
        }
    }
}

