/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.parser;

import java.util.ArrayList;
import java.util.List;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.Tson;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonAnnotation;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonComment;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonComments;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonDocument;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonElement;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonElementBase;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonParserVisitor;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.elements.TsonAnnotationImpl;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.elements.TsonArrayImpl;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.elements.TsonElementDecorator;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.elements.TsonObjectImpl;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.elements.TsonUpletImpl;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.parser.TsonParserUtils;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.util.TsonUtils;

public final class ElementBuilderTsonParserVisitor
implements TsonParserVisitor {
    private Object[] stack = new Object[1000];
    private List<TsonComment> comments = new ArrayList<TsonComment>();
    private int stackSize = 0;

    public TsonElement getElement() {
        if (this.stackSize == 0) {
            return null;
        }
        if (this.stackSize != 1) {
            throw new IllegalArgumentException("Invalid stack state");
        }
        TsonElement u = (TsonElement)this.peek();
        return u;
    }

    public TsonDocument getDocument() {
        if (this.stackSize == 0) {
            return null;
        }
        if (this.stackSize != 1) {
            throw new IllegalArgumentException("Invalid stack state");
        }
        TsonDocument u = (TsonDocument)this.peek();
        return u;
    }

    @Override
    public void visitKeyValueEnd() {
        TsonElement b = (TsonElement)this.pop();
        TsonElement a = (TsonElement)this.peek();
        this.repush(Tson.ofPair(a, (TsonElementBase)b));
    }

    @Override
    public void visitBinOpEnd(String op) {
        TsonElement b = (TsonElement)this.pop();
        TsonElement a = (TsonElement)this.peek();
        if (":".equals(op)) {
            this.repush(Tson.ofPair(a, (TsonElementBase)b));
        } else {
            this.repush(Tson.binOp(op, a, b));
        }
    }

    @Override
    public void visitElementStart() {
        PartialElemNode n = new PartialElemNode();
        n.comments = this.popAllComments(true);
        if (n.comments != null) {
            n.decorated = true;
        }
        this.push(n);
    }

    @Override
    public void visitNamedStart(String id) {
        PartialElemNode a = (PartialElemNode)this.peek();
        a.name = id;
    }

    @Override
    public void visitNamedArrayStart() {
        PartialElemNode a = (PartialElemNode)this.peek();
        a.array = new ArrayList();
    }

    @Override
    public void visitArrayStart() {
        PartialElemNode a = (PartialElemNode)this.peek();
        a.array = new ArrayList();
    }

    @Override
    public void visitObjectStart() {
        PartialElemNode a = (PartialElemNode)this.peek();
        a.object = new ArrayList();
    }

    @Override
    public void visitNamedObjectStart() {
        PartialElemNode a = (PartialElemNode)this.peek();
        a.object = new ArrayList();
    }

    @Override
    public void visitParamsStart() {
        PartialElemNode a = (PartialElemNode)this.peek();
        a.params = new ArrayList();
    }

    @Override
    public void visitParamElementStart() {
    }

    @Override
    public void visitParamElementEnd() {
        TsonElement o = (TsonElement)this.pop();
        PartialElemNode a = (PartialElemNode)this.peek();
        a.params.add(o);
    }

    @Override
    public void visitObjectElementEnd() {
        TsonElement o = (TsonElement)this.pop();
        PartialElemNode a = (PartialElemNode)this.peek();
        a.object.add(o);
    }

    @Override
    public void visitArrayElementEnd() {
        TsonElement o = (TsonElement)this.pop();
        PartialElemNode a = (PartialElemNode)this.peek();
        a.array.add(o);
    }

    @Override
    public void visitComments(TsonComment comments) {
        this.comments.add(comments);
    }

    private void repushDecorated(TsonElement base, PartialElemNode a) {
        a.comments = TsonComments.concat(a.comments, this.popAllComments(false));
        if (a.comments != null) {
            a.decorated = true;
        }
        if (a.decorated || a.comments != null) {
            this.repush(TsonElementDecorator.of(base, a.comments, a.annotations));
        } else {
            this.repush(base);
        }
    }

    @Override
    public void visitObjectEnd() {
        PartialElemNode a = (PartialElemNode)this.peek();
        this.repushDecorated(new TsonObjectImpl(null, null, TsonUtils.unmodifiableElements(a.object())), a);
    }

    @Override
    public void visitUpletEnd() {
        PartialElemNode a = (PartialElemNode)this.peek();
        this.repushDecorated(new TsonUpletImpl(a.name, TsonUtils.unmodifiableElements(a.params())), a);
    }

    @Override
    public void visitArrayEnd() {
        PartialElemNode a = (PartialElemNode)this.peek();
        this.repushDecorated(TsonUtils.toArray(a.array()), a);
    }

    @Override
    public void visitNamedObjectEnd() {
        PartialElemNode a = (PartialElemNode)this.peek();
        this.repushDecorated(new TsonObjectImpl(a.name, a.params == null ? null : TsonUtils.elementsListOrNull(a.params), TsonUtils.unmodifiableElements(a.object())), a);
    }

    @Override
    public void visitNamedArrayEnd() {
        PartialElemNode a = (PartialElemNode)this.peek();
        this.repushDecorated(new TsonArrayImpl(a.name, a.params == null ? null : TsonUtils.elementsListOrNull(a.params), TsonUtils.unmodifiableElements(a.array())), a);
    }

    @Override
    public void visitPrimitiveEnd(TsonElement primitiveElement) {
        int index = this.stackSize - 1;
        PartialElemNode a = (PartialElemNode)this.stack[index];
        this.stack[index] = a.decorated ? TsonElementDecorator.of(primitiveElement, a.comments, a.annotations) : primitiveElement;
    }

    @Override
    public void visitAnnotationStart(String annotationName) {
        this.push(new AnnotationNode(annotationName));
    }

    @Override
    public void visitAnnotationEnd() {
        AnnotationNode a = (AnnotationNode)this.pop();
        PartialElemNode n = (PartialElemNode)this.peek();
        if (n.annotations == null) {
            n.annotations = new ArrayList<TsonAnnotation>();
            n.decorated = true;
        }
        n.annotations.add(new TsonAnnotationImpl(a.id, a.elements == null ? null : TsonUtils.unmodifiableElements(a.elements)));
    }

    @Override
    public void visitAnnotationParamsStart() {
        AnnotationNode n = (AnnotationNode)this.peek();
        n.elements = new ArrayList<TsonElement>();
    }

    @Override
    public void visitAnnotationParamEnd() {
        TsonElement e = (TsonElement)this.pop();
        AnnotationNode n = (AnnotationNode)this.peek();
        n.elements.add(e);
    }

    @Override
    public void visitDocumentEnd() {
        ArrayList<TsonElement> allChildren = new ArrayList<TsonElement>();
        while (this.stackSize > 0) {
            allChildren.add(0, (TsonElement)this.pop());
        }
        TsonComments remainingComments = this.popAllComments(false);
        if (remainingComments != null && !remainingComments.isEmpty() && !allChildren.isEmpty()) {
            TsonElement s = (TsonElement)allChildren.get(allChildren.size() - 1);
            allChildren.set(allChildren.size() - 1, s.builder().setComments(TsonComments.concat(s.comments(), remainingComments)).build());
        }
        this.push(TsonParserUtils.elementsToDocument(allChildren.toArray(new TsonElement[0])));
    }

    private <T> T peek() {
        return (T)this.stack[this.stackSize - 1];
    }

    private <T> T pop() {
        Object t = this.stack[--this.stackSize];
        this.stack[this.stackSize + 1] = null;
        return (T)t;
    }

    private void repush(Object n) {
        this.stack[this.stackSize - 1] = n;
    }

    private void push(Object n) {
        try {
            this.stack[this.stackSize] = n;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            Object[] stack2 = new Object[this.stackSize + 20];
            System.arraycopy(this.stack, 0, stack2, 0, this.stack.length);
            this.stack = stack2;
        }
        ++this.stackSize;
    }

    private TsonComments popAllComments(boolean leading) {
        TsonComments s = leading ? new TsonComments(this.comments.toArray(new TsonComment[0]), null) : new TsonComments(null, this.comments.toArray(new TsonComment[0]));
        this.comments.clear();
        return s;
    }

    private static class PartialElemNode {
        public TsonElement element;
        public String name;
        public ArrayList<TsonElement> params;
        public ArrayList<TsonElement> array;
        public ArrayList<TsonElement> object;
        boolean decorated;
        boolean hasParams;
        TsonComments comments;
        List<TsonAnnotation> annotations;

        private PartialElemNode() {
        }

        public boolean paramsEmpty() {
            return this.params == null || this.params.isEmpty();
        }

        public ArrayList<TsonElement> params() {
            return this.params == null ? new ArrayList<TsonElement>() : this.params;
        }

        public ArrayList<TsonElement> object() {
            return this.object == null ? new ArrayList<TsonElement>() : this.object;
        }

        public ArrayList<TsonElement> array() {
            return this.array == null ? new ArrayList<TsonElement>() : this.array;
        }
    }

    private static class AnnotationNode {
        String id;
        List<TsonElement> elements;

        public AnnotationNode(String id) {
            this.id = id;
        }
    }
}

