/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.format;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonAnnotation;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonAnnotationBuilder;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonArray;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonBinaryStream;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonCharStream;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonComment;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonComments;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonDocument;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonDocumentHeader;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonElement;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonElementList;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonElementType;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonFormat;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonFormatBuilder;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonMatrix;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonNumber;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonNumberLayout;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonObject;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonOp;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonPair;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonUplet;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.format.DefaultTsonFormatConfig;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.format.TsonFormatImplBuilder;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.parser.CharStreamCodeSupports;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.parser.TsonNumberHelper;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.util.AppendableWriter;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.util.TsonUtils;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.util.Kmp;

public class TsonFormatImpl
implements TsonFormat,
Cloneable {
    public static final HashSet<String> FORMAT_NUMBER_TYPES = new HashSet<String>(Arrays.asList("hex", "dec", "bin", "oct"));
    private DefaultTsonFormatConfig config;

    public TsonFormatImpl(DefaultTsonFormatConfig config) {
        this.config = config == null ? new DefaultTsonFormatConfig().setCompact(false) : config.copy();
    }

    @Override
    public String format(TsonElement element) {
        StringBuilder sb = new StringBuilder();
        try (AppendableWriter w = AppendableWriter.of(sb);){
            this.formatElement(element, this.config.isShowComments(), this.config.isShowAnnotations(), w);
        }
        return sb.toString();
    }

    public void format(TsonElement element, Writer sb) {
        this.formatElement(element, this.config.isShowComments(), this.config.isShowAnnotations(), sb);
    }

    @Override
    public String format(TsonDocument document) {
        StringBuilder sb = new StringBuilder();
        try (AppendableWriter w = AppendableWriter.of(sb);){
            this.formatDocument(document, w);
        }
        return sb.toString();
    }

    public void formatDocument(TsonDocument document, Writer sb) {
        TsonDocumentHeader h = document.getHeader();
        TsonElement elem = document.getContent();
        this.formatAnnotation(h.builder().toAnnotation(), this.config.isShowComments(), this.config.isShowAnnotations(), sb);
        try {
            if (this.config.compact) {
                sb.append(' ');
            } else {
                sb.append('\n');
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        this.formatElement(elem, this.config.isShowComments(), this.config.isShowAnnotations(), sb);
    }

    public void formatAnnotation(TsonAnnotation a, boolean showComments, boolean showAnnotations, Writer sb) {
        List<TsonElement> params = a.params();
        try {
            sb.append('@');
            if (a.name().isPresent()) {
                sb.append(a.name().get());
            }
            if (params != null) {
                sb.append('(');
                int i = 0;
                for (TsonElement p : params) {
                    if (i > 0) {
                        sb.append(',');
                        sb.append(this.config.afterComma);
                    }
                    this.formatElement(p, showComments, showAnnotations, sb);
                    ++i;
                }
                sb.append(')');
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void formatElement(TsonElement element, boolean showComments, boolean showAnnotations, Writer sb) {
        try {
            TsonComment[] trailingComments;
            TsonComments c;
            TsonComment[] leadingComments;
            TsonComments c2;
            if (showComments && (c2 = element.comments()) != null && !c2.isEmpty() && (leadingComments = c2.leadingComments()).length > 0) {
                boolean wasSLC = false;
                block10: for (TsonComment lc : leadingComments) {
                    switch (lc.type()) {
                        case MULTI_LINE: {
                            sb.append(TsonUtils.formatMultiLineComments(lc.text(), !this.config.isIndentBraces()));
                            sb.append(this.config.afterMultiLineComments);
                            wasSLC = false;
                            continue block10;
                        }
                        case SINGLE_LINE: {
                            if (!wasSLC) {
                                sb.append("\n");
                            }
                            sb.append(TsonUtils.formatSingleLineComments(lc.text()));
                            wasSLC = true;
                        }
                    }
                }
            }
            List<TsonAnnotation> ann = element.annotations();
            TsonAnnotation formatAnnotation = null;
            if (ann != null && !ann.isEmpty()) {
                for (TsonAnnotation a : ann) {
                    if ("format".equals(a.name().orNull())) {
                        formatAnnotation = a;
                        if (!showAnnotations) continue;
                        if (!this.config.showFormatNumber) {
                            TsonAnnotationBuilder ab = a.builder();
                            List<TsonElement> params = ab.params();
                            for (int i = params.size() - 1; i >= 0; --i) {
                                TsonElement o = params.get(i);
                                if (o.type() != TsonElementType.NAME && (!o.type().isString() || !FORMAT_NUMBER_TYPES.contains(o.stringValue()))) continue;
                                ab.removeAt(i);
                            }
                            if (ab.size() == 0) continue;
                            this.formatAnnotation(a, showComments, true, sb);
                            sb.append(this.config.afterAnnotation);
                            continue;
                        }
                        this.formatAnnotation(a, showComments, true, sb);
                        sb.append(this.config.afterAnnotation);
                        continue;
                    }
                    if (!showAnnotations) continue;
                    this.formatAnnotation(a, showComments, true, sb);
                    sb.append(this.config.afterAnnotation);
                }
                sb.append(this.config.afterAnnotations);
            }
            this.formatElementCore(element, formatAnnotation, sb);
            if (showComments && (c = element.comments()) != null && !c.isEmpty() && (trailingComments = c.trailingComments()).length > 0) {
                boolean wasSLC = false;
                block13: for (TsonComment lc : trailingComments) {
                    switch (lc.type()) {
                        case MULTI_LINE: {
                            sb.append(TsonUtils.formatMultiLineComments(lc.text(), false));
                            sb.append(this.config.afterMultiLineComments);
                            wasSLC = false;
                            continue block13;
                        }
                        case SINGLE_LINE: {
                            if (!wasSLC) {
                                sb.append("\n");
                            }
                            sb.append(TsonUtils.formatSingleLineComments(lc.text()));
                            wasSLC = true;
                        }
                    }
                }
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void formatElementCore(TsonElement element, TsonAnnotation format, Writer writer) {
        try {
            switch (element.type()) {
                case NULL: {
                    writer.append("null");
                    return;
                }
                case BYTE: 
                case SHORT: 
                case INTEGER: 
                case LONG: 
                case BIG_INTEGER: 
                case FLOAT: 
                case DOUBLE: 
                case BIG_DECIMAL: 
                case BIG_COMPLEX: 
                case FLOAT_COMPLEX: 
                case DOUBLE_COMPLEX: {
                    writer.append(new TsonNumberHelper((TsonNumber)element).toString());
                    return;
                }
                case BOOLEAN: {
                    writer.append(String.valueOf(element.booleanValue()));
                    return;
                }
                case LOCAL_DATETIME: {
                    writer.append(String.valueOf(element.localDateTimeValue()));
                    return;
                }
                case LOCAL_DATE: {
                    writer.append(String.valueOf(element.localDateValue()));
                    return;
                }
                case INSTANT: {
                    writer.append(String.valueOf(element.instantValue()));
                    return;
                }
                case LOCAL_TIME: {
                    writer.append(String.valueOf(element.localTimeValue()));
                    return;
                }
                case REGEX: {
                    writer.append(TsonUtils.toRegex(element.regexValue().toString()));
                    return;
                }
                case CHAR: {
                    writer.append(TsonUtils.toSmpStr(element.charValue()));
                    return;
                }
                case DOUBLE_QUOTED_STRING: 
                case SINGLE_QUOTED_STRING: 
                case ANTI_QUOTED_STRING: 
                case TRIPLE_DOUBLE_QUOTED_STRING: 
                case TRIPLE_SINGLE_QUOTED_STRING: 
                case TRIPLE_ANTI_QUOTED_STRING: 
                case LINE_STRING: {
                    writer.append(element.toStr().literalString());
                    return;
                }
                case NAME: {
                    writer.append(element.stringValue());
                    return;
                }
                case ALIAS: {
                    writer.append("&").append(element.stringValue());
                    return;
                }
                case PAIR: {
                    TsonPair t = element.toPair();
                    this.format(t.key(), writer);
                    String vs = this.format(t.value());
                    writer.append(this.config.afterKey);
                    if (this.config.indent.length() > 0 && vs.indexOf("\n") > 0) {
                        writer.append(":\n").append(TsonUtils.indent(vs, this.config.indent));
                    } else {
                        writer.append(':').append(this.config.beforeValue).append(vs);
                    }
                    return;
                }
                case OP: {
                    TsonOp t = element.toOp();
                    String op = t.opName();
                    this.format(t.first(), writer);
                    String vs = this.format(t.second());
                    writer.append(this.config.afterKey);
                    if (this.config.indent.length() > 0 && vs.indexOf("\n") > 0) {
                        writer.append(op).append("\n").append(TsonUtils.indent(vs, this.config.indent));
                    } else {
                        writer.append(op).append(this.config.beforeValue).append(vs);
                    }
                    return;
                }
                case UPLET: 
                case NAMED_UPLET: {
                    TsonUplet list = element.toUplet();
                    if (list.isNamed()) {
                        writer.append(list.name());
                    }
                    this.listToString(this.config.indentList, (Iterable<TsonElement>)list.params(), '(', ')', writer, ListType.PARAMS);
                    return;
                }
                case ARRAY: 
                case NAMED_PARAMETRIZED_ARRAY: 
                case PARAMETRIZED_ARRAY: 
                case NAMED_ARRAY: {
                    TsonElementList params;
                    TsonArray list = element.toArray();
                    String n = TsonUtils.nullIfBlank(list.name());
                    boolean hasName = false;
                    if (n != null) {
                        writer.append(n);
                        boolean bl = hasName = n.length() > 0;
                    }
                    if (!((params = list.params()) == null || hasName && params.size() <= 0)) {
                        this.listToString(this.config.indentList, (Iterable<TsonElement>)params, '(', ')', writer, ListType.PARAMS);
                    }
                    this.listToString(this.config.indentBrackets ? IndentMode.ALWAYS : IndentMode.NEVER, (Iterable<TsonElement>)list, '[', ']', writer, ListType.PARAMS);
                    return;
                }
                case MATRIX: 
                case NAMED_MATRIX: 
                case PARAMETRIZED_MATRIX: 
                case NAMED_PARAMETRIZED_MATRIX: {
                    TsonElementList params;
                    TsonMatrix list = element.toMatrix();
                    String n = TsonUtils.nullIfBlank(list.name());
                    boolean hasName = false;
                    if (n != null) {
                        writer.append(n);
                        boolean bl = hasName = n.length() > 0;
                    }
                    if (!((params = list.params()) == null || hasName && params.size() <= 0)) {
                        this.listToString(this.config.indentList, (Iterable<TsonElement>)params, '(', ')', writer, ListType.PARAMS);
                    }
                    this.listToString(this.config.indentBrackets ? IndentMode.ALWAYS : IndentMode.NEVER, list.rows(), '[', ']', writer, ListType.MATRIX);
                    return;
                }
                case OBJECT: 
                case NAMED_PARAMETRIZED_OBJECT: 
                case NAMED_OBJECT: 
                case PARAMETRIZED_OBJECT: {
                    TsonElementList params;
                    TsonObject list = element.toObject();
                    String n = TsonUtils.nullIfBlank(list.name());
                    boolean hasName = false;
                    if (n != null) {
                        writer.append(n);
                        boolean bl = hasName = n.length() > 0;
                    }
                    if (!((params = list.params()) == null || hasName && params.size() <= 0)) {
                        this.listToString(this.config.indentList, (Iterable<TsonElement>)params, '(', ')', writer, ListType.PARAMS);
                    }
                    this.listToString(this.config.indentBraces ? IndentMode.ALWAYS : IndentMode.NEVER, (Iterable<TsonElement>)list, '{', '}', writer, ListType.OBJECT);
                    return;
                }
                case BINARY_STREAM: {
                    TsonBinaryStream list = element.toBinaryStream();
                    writer.write("^[");
                    char[] c = new char[1024];
                    try (Reader r = list.getBase64Value();){
                        int x;
                        while ((x = r.read(c)) > 0) {
                            writer.write(c, 0, x);
                        }
                    }
                    writer.write("]");
                    return;
                }
                case CHAR_STREAM: {
                    TsonCharStream list = element.toCharStream();
                    switch (list.getStreamType()) {
                        case "": {
                            writer.write("^{");
                            char[] c = new char[1024];
                            Object cscs = CharStreamCodeSupports.of("");
                            try (Reader r = list.value();){
                                int x;
                                while ((x = r.read(c)) > 0) {
                                    writer.write(c, 0, x);
                                    cscs.next(c, 0, x);
                                }
                            }
                            if (!cscs.isValid()) {
                                throw new IllegalArgumentException("Invalid Code CharStream : " + cscs.getErrorMessage());
                            }
                            writer.write("}");
                        }
                    }
                    String n = list.getStreamType();
                    for (char c : n.toCharArray()) {
                        switch (c) {
                            case '{': 
                            case '}': {
                                throw new IllegalArgumentException("Invalid StopWord CharStream : " + n);
                            }
                        }
                    }
                    writer.write("^" + n + "{");
                    String stop = "^" + n + "}";
                    Kmp kmp = Kmp.compile(stop);
                    char[] c = new char[1024];
                    try (Reader r = list.value();){
                        int x;
                        while ((x = r.read(c)) > 0) {
                            for (int i = 0; i < x; ++i) {
                                if (!kmp.next(c[i])) continue;
                                throw new IllegalArgumentException("Invalid StopWord CharStream StopWord detected in content : " + n);
                            }
                            writer.write(c, 0, x);
                        }
                    }
                    return;
                }
            }
            throw new IllegalArgumentException("Format Tson : Unexpected type " + (Object)((Object)element.type()));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void formatAppendUnit(String ll, TsonNumber element, Writer writer) throws IOException {
        writer.append(ll);
        String unit = TsonUtils.trimToNull(element.numberSuffix());
        if (unit != null) {
            if (unit.charAt(0) != '%' && unit.charAt(0) != '_') {
                writer.append('_');
            }
            writer.append(unit);
        }
    }

    private String decodeRadixPrefix(TsonNumberLayout l) {
        switch (l) {
            case BINARY: {
                return "0b";
            }
            case OCTAL: {
                return "0";
            }
            case HEXADECIMAL: {
                return "0x";
            }
            case DECIMAL: {
                return "";
            }
        }
        return "";
    }

    private void listToString(boolean indent, Iterable<TsonElement> it, char start, char end, Writer out, ListType listType) throws IOException {
        IndentMode indentMode = indent ? IndentMode.OPTIMIZE : IndentMode.NEVER;
        this.listToString(indentMode, it, start, end, out, listType);
    }

    private void listToString(IndentMode indent, Iterable<TsonElement> it, char start, char end, Writer out, ListType listType) throws IOException {
        if (it == null) {
            return;
        }
        if (indent == null) {
            indent = IndentMode.OPTIMIZE;
        }
        switch (indent.ordinal()) {
            case 0: {
                this.listToStringIndented(it, start, end, out, listType);
                break;
            }
            case 1: {
                this.listToStringNotIndented(it, start, end, out, listType);
                break;
            }
            case 2: {
                this.listToStringIndentOptimized(it, start, end, out, listType);
            }
        }
    }

    private void listToStringIndentOptimized(Iterable<TsonElement> it, char start, char end, Writer out, ListType listType) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        PrintWriter w2 = new PrintWriter(os);
        this.listToStringNotIndented(it, start, end, w2, listType);
        ((Writer)w2).flush();
        String s = os.toString();
        if (s.indexOf(10) >= 0 || s.indexOf(13) >= 0 || this.config.getLineLength() >= 0 && s.length() > this.config.getLineLength()) {
            this.listToStringIndented(it, start, end, out, listType);
        } else {
            out.append(s);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void listToStringIndented(Iterable<TsonElement> it, char start, char end, Writer out, ListType listType) throws IOException {
        ArrayList<TsonElement> a = new ArrayList<TsonElement>();
        for (TsonElement e : it) {
            a.add(e);
        }
        if (a.isEmpty()) {
            out.append(start).append(end);
            return;
        }
        out.append(start).append('\n');
        StringBuilder sb2 = new StringBuilder();
        try (AppendableWriter w = AppendableWriter.of(sb2);){
            int i = 0;
            switch (listType.ordinal()) {
                case 3: {
                    for (TsonElement tsonElement : a) {
                        if (!this.acceptObjectElement(tsonElement)) continue;
                        if (i > 0) {
                            sb2.append(",\n");
                        }
                        this.format(tsonElement, w);
                        ++i;
                    }
                    break;
                }
                case 2: {
                    for (TsonElement tsonElement : a) {
                        if (!this.acceptArrayElement(tsonElement)) continue;
                        if (i > 0) {
                            sb2.append(",\n");
                        }
                        this.format(tsonElement, w);
                        ++i;
                    }
                    break;
                }
                case 1: {
                    for (TsonElement tsonElement : a) {
                        if (!this.acceptParamElement(tsonElement)) continue;
                        if (i > 0) {
                            sb2.append(",\n");
                        }
                        this.format(tsonElement, w);
                        ++i;
                    }
                    break;
                }
                case 0: {
                    for (TsonElement tsonElement : a) {
                        if (i > 0) {
                            sb2.append(";\n");
                        }
                        this.format(tsonElement, w);
                        ++i;
                    }
                    if (i >= 2) break;
                    sb2.append(";\n");
                    break;
                }
            }
        }
        out.append(TsonUtils.indent(sb2.toString(), this.config.indent));
        out.append('\n').append(end);
    }

    private boolean acceptObjectElement(TsonElement tsonElement) {
        if (this.config.ignoreObjectNullFields) {
            if (tsonElement.isNull()) {
                return false;
            }
            if (tsonElement.type() == TsonElementType.PAIR && tsonElement.toPair().value().isNull()) {
                return false;
            }
        }
        return !this.config.ignoreObjectEmptyArrayFields || tsonElement.type() != TsonElementType.ARRAY || !tsonElement.toArray().isEmpty();
    }

    private void listToStringNotIndented(Iterable<TsonElement> it, char start, char end, Writer out, ListType type) throws IOException {
        out.append(start);
        int i = 0;
        switch (type.ordinal()) {
            case 3: {
                for (TsonElement tsonElement : it) {
                    if (!this.acceptObjectElement(tsonElement)) continue;
                    if (i > 0) {
                        out.append(',').append(this.config.afterComma);
                    }
                    this.format(tsonElement, out);
                    ++i;
                }
                break;
            }
            case 1: {
                for (TsonElement tsonElement : it) {
                    if (!this.acceptParamElement(tsonElement)) continue;
                    if (i > 0) {
                        out.append(',').append(this.config.afterComma);
                    }
                    this.format(tsonElement, out);
                    ++i;
                }
                break;
            }
            case 2: {
                for (TsonElement tsonElement : it) {
                    if (!this.acceptArrayElement(tsonElement)) continue;
                    if (i > 0) {
                        out.append(',').append(this.config.afterComma);
                    }
                    this.format(tsonElement, out);
                    ++i;
                }
                break;
            }
            case 0: {
                for (TsonElement tsonElement : it) {
                    if (i > 0) {
                        out.append(';').append(this.config.afterComma);
                    }
                    this.format(tsonElement, out);
                    ++i;
                }
                if (i >= 2) break;
                out.append(';').append(this.config.afterComma);
            }
        }
        out.append(end);
    }

    private boolean acceptParamElement(TsonElement tsonElement) {
        return true;
    }

    private boolean acceptArrayElement(TsonElement tsonElement) {
        return true;
    }

    @Override
    public TsonFormatBuilder builder() {
        return new TsonFormatImplBuilder().setConfig(this.config);
    }

    private static enum ListType {
        MATRIX,
        PARAMS,
        ARRAY,
        OBJECT;

    }

    private static enum IndentMode {
        ALWAYS,
        NEVER,
        OPTIMIZE;

    }
}

