/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.format;

public class DefaultTsonFormatConfig
implements Cloneable {
    boolean ignoreObjectEmptyArrayFields;
    boolean ignoreObjectNullFields;
    String indent0 = " ";
    String afterMultiLineComments = " ";
    String afterAnnotation = " ";
    String afterAnnotations = " ";
    String afterComma = " ";
    String afterKey = " ";
    String beforeValue = " ";
    String indent = this.indent0;
    boolean showFormatNumber = true;
    boolean indentList = false;
    boolean indentBraces = true;
    boolean indentBrackets = true;
    boolean showComments = true;
    boolean showAnnotations = true;
    boolean compact = false;
    int lineLength = 80;

    public Object get(String optionName) {
        if (optionName != null) {
            switch (optionName) {
                case "compact": {
                    return this.compact;
                }
                case "indent": {
                    return this.indent0;
                }
                case "ignoreObjectNullFields": {
                    return this.ignoreObjectNullFields;
                }
                case "ignoreObjectEmptyArrayFields": {
                    return this.ignoreObjectEmptyArrayFields;
                }
                case "lineLength": {
                    return this.lineLength;
                }
            }
        }
        return null;
    }

    public DefaultTsonFormatConfig set(String optionName, Object configValue) {
        if (optionName != null) {
            switch (optionName) {
                case "compact": {
                    this.setCompact(Boolean.valueOf(String.valueOf(configValue)));
                    break;
                }
                case "ignoreObjectNullFields": {
                    this.setIgnoreObjectNullFields(Boolean.valueOf(String.valueOf(configValue)));
                    break;
                }
                case "ignoreObjectEmptyArrayFields": {
                    this.setIgnoreObjectEmptyArrayFields(Boolean.valueOf(String.valueOf(configValue)));
                    break;
                }
                case "lineLength": {
                    this.setLineLength(((Number)configValue).intValue());
                    break;
                }
                case "indent": {
                    if (configValue instanceof Integer) {
                        StringBuilder sb = new StringBuilder();
                        for (int i = 0; i < (Integer)configValue; ++i) {
                            sb.append(" ");
                        }
                        this.indent0 = sb.toString();
                        break;
                    }
                    if (configValue instanceof String) {
                        String s = configValue.toString();
                        if (s.length() > 0 && s.charAt(0) >= '0' && s.charAt(0) <= '9') {
                            this.set("indent", Integer.parseInt(s));
                            break;
                        }
                        this.indent0 = s;
                        break;
                    }
                    throw new IllegalArgumentException("Unaccepted indent " + configValue);
                }
            }
        }
        return this;
    }

    public boolean isIgnoreObjectEmptyArrayFields() {
        return this.ignoreObjectEmptyArrayFields;
    }

    public DefaultTsonFormatConfig setIgnoreObjectEmptyArrayFields(boolean ignoreObjectEmptyArrayFields) {
        this.ignoreObjectEmptyArrayFields = ignoreObjectEmptyArrayFields;
        return this;
    }

    public boolean isIgnoreObjectNullFields() {
        return this.ignoreObjectNullFields;
    }

    public DefaultTsonFormatConfig setIgnoreObjectNullFields(boolean ignoreObjectNullFields) {
        this.ignoreObjectNullFields = ignoreObjectNullFields;
        return this;
    }

    public DefaultTsonFormatConfig setCompact(boolean compact) {
        this.compact = compact;
        if (compact) {
            this.setBeforeValue("").setAfterComma("").setAfterKey("").setIndent("").setIndentBraces(false).setIndentBrackets(false).setIndentList(false).setShowComments(false).setShowAnnotations(true).setAfterComments(" ").setAfterAnnotation(" ").setAfterAnnotations(" ");
        } else {
            this.setBeforeValue(" ").setAfterComma(" ").setAfterKey(" ").setIndent(this.indent0).setIndentBraces(true).setIndentBrackets(true).setIndentList(false).setShowComments(true).setShowAnnotations(true).setAfterComments("\n").setAfterAnnotation("\n").setAfterAnnotations("\n");
        }
        return this;
    }

    public boolean isCompact() {
        return this.compact;
    }

    public String getAfterComments() {
        return this.afterMultiLineComments;
    }

    public DefaultTsonFormatConfig setAfterComments(String afterComments) {
        this.afterMultiLineComments = afterComments;
        return this;
    }

    public String getAfterAnnotation() {
        return this.afterAnnotation;
    }

    public DefaultTsonFormatConfig setAfterAnnotation(String afterAnnotation) {
        this.afterAnnotation = afterAnnotation;
        return this;
    }

    public String getAfterAnnotations() {
        return this.afterAnnotations;
    }

    public DefaultTsonFormatConfig setAfterAnnotations(String afterAnnotations) {
        this.afterAnnotations = afterAnnotations;
        return this;
    }

    public boolean isShowAnnotations() {
        return this.showAnnotations;
    }

    public DefaultTsonFormatConfig setShowAnnotations(boolean showAnnotations) {
        this.showAnnotations = showAnnotations;
        return this;
    }

    public boolean isShowComments() {
        return this.showComments;
    }

    public DefaultTsonFormatConfig setShowComments(boolean showComments) {
        this.showComments = showComments;
        return this;
    }

    public String getAfterComma() {
        return this.afterComma;
    }

    public DefaultTsonFormatConfig setAfterComma(String afterComma) {
        this.afterComma = afterComma;
        return this;
    }

    public String getAfterKey() {
        return this.afterKey;
    }

    public DefaultTsonFormatConfig setAfterKey(String afterKey) {
        this.afterKey = afterKey;
        return this;
    }

    public String getBeforeValue() {
        return this.beforeValue;
    }

    public DefaultTsonFormatConfig setBeforeValue(String beforeValue) {
        this.beforeValue = beforeValue;
        return this;
    }

    public String getIndent() {
        return this.indent;
    }

    public DefaultTsonFormatConfig setIndent(String indent) {
        this.indent = indent;
        return this;
    }

    public boolean isIndentList() {
        return this.indentList;
    }

    public DefaultTsonFormatConfig setIndentList(boolean indentList) {
        this.indentList = indentList;
        return this;
    }

    public boolean isIndentBraces() {
        return this.indentBraces;
    }

    public DefaultTsonFormatConfig setIndentBraces(boolean indentBraces) {
        this.indentBraces = indentBraces;
        return this;
    }

    public boolean isIndentBrackets() {
        return this.indentBrackets;
    }

    public DefaultTsonFormatConfig setIndentBrackets(boolean indentBrackets) {
        this.indentBrackets = indentBrackets;
        return this;
    }

    public int getLineLength() {
        return this.lineLength;
    }

    public DefaultTsonFormatConfig setLineLength(int lineLength) {
        this.lineLength = lineLength;
        return this;
    }

    public DefaultTsonFormatConfig copy() {
        try {
            return (DefaultTsonFormatConfig)this.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalArgumentException("Cannot clone");
        }
    }
}

