/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.elements;

import java.util.Iterator;
import java.util.Objects;
import java.util.stream.Collectors;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonDocumentVisitor;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonElement;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonElementList;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonElementType;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonListContainer;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonParserVisitor;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonUplet;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonUpletBuilder;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.builders.TsonUpletBuilderImpl;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.elements.AbstractNonPrimitiveTsonElement;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.elements.TsonElementListImpl;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.util.TsonUtils;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.util.UnmodifiableArrayList;

public class TsonUpletImpl
extends AbstractNonPrimitiveTsonElement
implements TsonUplet {
    private String name;
    private TsonElementList elements;

    public TsonUpletImpl(String name, UnmodifiableArrayList<TsonElement> elements) {
        super(name == null ? TsonElementType.UPLET : TsonElementType.NAMED_UPLET);
        this.name = name;
        this.elements = new TsonElementListImpl(elements.stream().map(x -> x).collect(Collectors.toList()));
    }

    @Override
    public boolean isParametrized() {
        return true;
    }

    @Override
    public TsonElement param(int index) {
        return this.elements.getAt(index);
    }

    @Override
    public boolean isNamed() {
        return this.name != null;
    }

    @Override
    public int paramsCount() {
        return this.elements.size();
    }

    @Override
    public TsonElementList body() {
        return this.elements;
    }

    @Override
    public TsonElementList params() {
        return this.elements;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public TsonUplet toUplet() {
        return this;
    }

    @Override
    public boolean isBlank() {
        return this.elements.isEmpty();
    }

    @Override
    public int size() {
        return this.elements.size();
    }

    @Override
    public Iterator<TsonElement> iterator() {
        return this.params().iterator();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TsonUpletImpl that = (TsonUpletImpl)o;
        return Objects.equals(this.elements, that.elements);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this.elements);
        return result;
    }

    @Override
    public TsonListContainer toListContainer() {
        return this;
    }

    @Override
    public TsonUpletBuilder builder() {
        return new TsonUpletBuilderImpl().merge(this);
    }

    @Override
    public boolean visit(TsonDocumentVisitor visitor) {
        if (!visitor.visit(this)) {
            return false;
        }
        for (TsonElement element : this.elements) {
            if (element.visit(visitor)) continue;
            return false;
        }
        return true;
    }

    @Override
    protected int compareCore(TsonElement o) {
        return TsonUtils.compareElementsArray(this.params(), o.toUplet().params());
    }

    @Override
    public void visit(TsonParserVisitor visitor) {
        visitor.visitElementStart();
        if (this.name != null) {
            visitor.visitNamedStart(this.name());
        }
        visitor.visitParamsStart();
        for (TsonElement param : this.params()) {
            visitor.visitParamElementStart();
            param.visit(visitor);
            visitor.visitParamElementEnd();
        }
        visitor.visitParamsEnd();
        visitor.visitUpletEnd();
    }
}

