/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.elements;

import java.util.Objects;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.Tson;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonByte;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonDouble;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonElement;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonElementType;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonFloat;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonInt;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonLong;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonNumberLayout;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonPrimitiveBuilder;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonShort;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.builders.TsonPrimitiveElementBuilderImpl;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.elements.AbstractNumberTsonElement;

public class TsonShortImpl
extends AbstractNumberTsonElement
implements TsonShort {
    private short value;

    public TsonShortImpl(short value, TsonNumberLayout layout, String unit) {
        super(TsonElementType.SHORT, layout, unit);
        this.value = value;
    }

    @Override
    public Number numberValue() {
        return this.value();
    }

    @Override
    public TsonShort toShort() {
        return this;
    }

    @Override
    public short value() {
        return this.value;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TsonShortImpl tsonShort = (TsonShortImpl)o;
        return this.value == tsonShort.value;
    }

    @Override
    public TsonByte toByte() {
        return Tson.of((byte)this.value()).toByte();
    }

    @Override
    public TsonInt toInt() {
        return Tson.of((int)this.value()).toInt();
    }

    @Override
    public TsonLong toLong() {
        return Tson.of((long)this.value()).toLong();
    }

    @Override
    public TsonFloat toFloat() {
        return Tson.of((float)this.value()).toFloat();
    }

    @Override
    public TsonDouble toDouble() {
        return Tson.of((double)this.value()).toDouble();
    }

    @Override
    public Byte byteObject() {
        return (byte)this.value();
    }

    @Override
    public Long longObject() {
        return this.value();
    }

    @Override
    public Integer intObject() {
        return this.value();
    }

    @Override
    public Short shortObject() {
        return this.value();
    }

    @Override
    public Float floatObject() {
        return Float.valueOf(this.value());
    }

    @Override
    public Double doubleObject() {
        return this.value();
    }

    @Override
    public byte byteValue() {
        return (byte)this.value();
    }

    @Override
    public short shortValue() {
        return this.value();
    }

    @Override
    public int intValue() {
        return this.value();
    }

    @Override
    public long longValue() {
        return this.value();
    }

    @Override
    public float floatValue() {
        return this.value();
    }

    @Override
    public double doubleValue() {
        return this.value();
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.value);
    }

    @Override
    public TsonPrimitiveBuilder builder() {
        return new TsonPrimitiveElementBuilderImpl().copyFrom(this);
    }

    @Override
    protected int compareCore(TsonElement o) {
        return Short.compare(this.value, o.toShort().value());
    }

    @Override
    public int compareTo(TsonElement o) {
        if (o.type().isNumber()) {
            switch (o.type()) {
                case BYTE: 
                case SHORT: {
                    int i = Short.compare(this.value(), o.shortValue());
                    return i == 0 ? this.type().compareTo(o.type()) : i;
                }
                case INTEGER: {
                    int i = Integer.compare(this.value(), o.intValue());
                    return i == 0 ? this.type().compareTo(o.type()) : i;
                }
                case LONG: {
                    int i = Long.compare(this.value(), o.longValue());
                    return i == 0 ? this.type().compareTo(o.type()) : i;
                }
                case FLOAT: {
                    int i = Float.compare(this.value(), o.floatValue());
                    return i == 0 ? this.type().compareTo(o.type()) : i;
                }
                case DOUBLE: {
                    int i = Double.compare(this.value(), o.doubleValue());
                    return i == 0 ? this.type().compareTo(o.type()) : i;
                }
            }
        }
        return super.compareTo(o);
    }
}

