/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.elements;

import java.util.Objects;
import java.util.regex.Pattern;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.Tson;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonElement;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonElementType;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonPrimitiveBuilder;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonRegex;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonString;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.builders.TsonPrimitiveElementBuilderImpl;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.elements.AbstractPrimitiveTsonElement;

public class TsonRegexImpl
extends AbstractPrimitiveTsonElement
implements TsonRegex {
    private Pattern value;

    public TsonRegexImpl(Pattern value) {
        super(TsonElementType.REGEX);
        this.value = value;
    }

    public TsonRegexImpl(String value) {
        super(TsonElementType.LOCAL_DATE);
        this.value = Pattern.compile(value);
    }

    @Override
    public TsonString toStr() {
        return (TsonString)Tson.of(this.value.toString());
    }

    @Override
    public TsonRegex toRegex() {
        return this;
    }

    @Override
    public Pattern value() {
        return this.value;
    }

    @Override
    public Pattern regexValue() {
        return this.value();
    }

    @Override
    public String stringValue() {
        return this.value().toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TsonRegexImpl tsonRegex = (TsonRegexImpl)o;
        return Objects.equals(this.value.toString(), tsonRegex.value.toString());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.value.toString());
    }

    @Override
    public TsonPrimitiveBuilder builder() {
        return new TsonPrimitiveElementBuilderImpl().copyFrom(this);
    }

    @Override
    protected int compareCore(TsonElement o) {
        return this.value.toString().compareTo(o.toRegex().value().toString());
    }
}

