/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.elements;

import java.util.Iterator;
import java.util.Objects;
import java.util.stream.Collectors;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.Tson;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonDocumentVisitor;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonElement;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonElementList;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonElementType;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonListContainer;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonObject;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonObjectBuilder;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonPair;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonParserVisitor;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.builders.TsonObjectBuilderImpl;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.elements.AbstractNonPrimitiveTsonElement;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.elements.TsonElementListImpl;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.util.TsonUtils;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.util.UnmodifiableArrayList;

public class TsonObjectImpl
extends AbstractNonPrimitiveTsonElement
implements TsonObject {
    private TsonElementList elements;
    private String name;
    private TsonElementList args;

    public TsonObjectImpl(String name, TsonElementList params, UnmodifiableArrayList<TsonElement> elements) {
        super(name == null && params == null ? TsonElementType.OBJECT : (name == null && params != null ? TsonElementType.PARAMETRIZED_OBJECT : (name != null && params == null ? TsonElementType.NAMED_OBJECT : TsonElementType.NAMED_PARAMETRIZED_OBJECT)));
        this.elements = new TsonElementListImpl(elements.stream().map(x -> x).collect(Collectors.toList()));
        this.name = name;
        this.args = params;
    }

    @Override
    public boolean isNamed() {
        return this.name != null;
    }

    @Override
    public TsonElementList params() {
        return this.args;
    }

    @Override
    public boolean isParametrized() {
        return this.args != null;
    }

    @Override
    public int paramsCount() {
        return this.args == null ? 0 : this.args.size();
    }

    @Override
    public TsonListContainer toListContainer() {
        return this;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public TsonObject toObject() {
        return this;
    }

    @Override
    public TsonElement get(String name) {
        TsonElement tsonElementAsName = Tson.ofName(name);
        TsonElement tsonElementAsString = Tson.ofString(name);
        for (TsonElement element : this.elements) {
            if (element instanceof TsonPair) {
                TsonPair element1 = (TsonPair)element;
                TsonElement key = element1.key();
                if (this.eqKey(key, tsonElementAsName)) {
                    return element1.value();
                }
                if (!this.eqKey(key, tsonElementAsString)) continue;
                return element1.value();
            }
            if (this.eqKey(element, tsonElementAsName)) {
                return element;
            }
            if (!this.eqKey(element, tsonElementAsString)) continue;
            return element;
        }
        return null;
    }

    @Override
    public TsonElementList body() {
        return this.elements;
    }

    @Override
    public TsonElement get(TsonElement element) {
        for (TsonElement element2 : this.elements) {
            if (element2 instanceof TsonPair) {
                TsonPair element1 = (TsonPair)element2;
                TsonElement key = element1.key();
                if (!this.eqKey(key, element)) continue;
                return element1.value();
            }
            if (!this.eqKey(element2, element)) continue;
            return element2;
        }
        return null;
    }

    private boolean eqKey(TsonElement a, TsonElement b) {
        return Objects.equals(a, b);
    }

    @Override
    public int size() {
        return this.elements.size();
    }

    @Override
    public Iterator<TsonElement> iterator() {
        return this.elements.iterator();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TsonObjectImpl that = (TsonObjectImpl)o;
        return Objects.equals(this.elements, that.elements) && Objects.equals(this.name, that.name) && Objects.equals(this.args, that.args);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.elements, this.name, this.args);
    }

    @Override
    public TsonObjectBuilder builder() {
        return new TsonObjectBuilderImpl().merge(this);
    }

    @Override
    public boolean visit(TsonDocumentVisitor visitor) {
        if (this.args != null) {
            for (TsonElement element : this.args) {
                if (visitor.visit(element)) continue;
                return false;
            }
        }
        for (TsonElement element : this.elements) {
            if (element.visit(visitor)) continue;
            return false;
        }
        return true;
    }

    @Override
    protected int compareCore(TsonElement o) {
        TsonObject no = o.toObject();
        int i = this.name().compareTo(no.name());
        if (i != 0) {
            return i;
        }
        i = TsonUtils.compareElementsArray(this.params(), no.params());
        if (i != 0) {
            return i;
        }
        return TsonUtils.compareElementsArray(this.body(), no.body());
    }

    @Override
    public void visit(TsonParserVisitor visitor) {
        visitor.visitElementStart();
        if (this.name != null) {
            visitor.visitNamedStart(this.name());
        }
        if (this.args != null) {
            visitor.visitParamsStart();
            for (TsonElement param : this.params()) {
                visitor.visitParamElementStart();
                param.visit(visitor);
                visitor.visitParamElementEnd();
            }
            visitor.visitParamsEnd();
        }
        visitor.visitNamedObjectStart();
        for (TsonElement element : this.body()) {
            visitor.visitObjectElementStart();
            element.visit(visitor);
            visitor.visitObjectElementEnd();
        }
        visitor.visitObjectEnd();
    }
}

