/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.elements;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonArray;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonArrayBuilder;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonDocumentVisitor;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonElement;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonElementList;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonElementType;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonMatrix;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonParserVisitor;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.builders.TsonArrayBuilderImpl;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.elements.AbstractNonPrimitiveTsonElement;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.util.TsonUtils;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.util.UnmodifiableArrayList;

public class TsonMatrixImpl
extends AbstractNonPrimitiveTsonElement
implements TsonMatrix {
    private final UnmodifiableArrayList<TsonArray> rows;
    private final String name;
    private TsonElementList params;

    public TsonMatrixImpl(String name, TsonElementList params, UnmodifiableArrayList<TsonArray> rows) {
        super(name == null && params == null ? TsonElementType.MATRIX : (name == null && params != null ? TsonElementType.PARAMETRIZED_MATRIX : (name != null && params == null ? TsonElementType.NAMED_MATRIX : TsonElementType.NAMED_PARAMETRIZED_MATRIX)));
        this.name = name;
        this.params = params;
        this.rows = rows;
    }

    @Override
    public TsonMatrix toMatrix() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return this.rows.isEmpty();
    }

    @Override
    public int rowSize() {
        return this.rows.size();
    }

    @Override
    public int columnSize() {
        return this.rows.size() == 0 ? 0 : this.rows.get(0).size();
    }

    @Override
    public List<TsonArray> rows() {
        return this.rows();
    }

    @Override
    public TsonElement cell(int col, int row) {
        TsonArray a = this.rows.get(row);
        return a.get(col);
    }

    @Override
    public TsonArray row(int row) {
        return this.rows.get(row);
    }

    @Override
    public TsonArray column(int column) {
        ArrayList<TsonElement> c = new ArrayList<TsonElement>(this.rowSize());
        for (int row = 0; row < this.rowSize(); ++row) {
            c.add(this.cell(column, row));
        }
        return TsonUtils.toArray(c);
    }

    @Override
    public List<TsonArray> columns() {
        return new AbstractList<TsonArray>(){

            @Override
            public TsonArray get(int column) {
                return TsonMatrixImpl.this.column(column);
            }

            @Override
            public int size() {
                return TsonMatrixImpl.this.columnSize();
            }
        };
    }

    @Override
    public Iterator<TsonArray> iterator() {
        return this.rows().iterator();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TsonMatrixImpl that = (TsonMatrixImpl)o;
        return Objects.equals(this.rows, that.rows) && Objects.equals(this.name, that.name()) && Objects.equals(this.params, that.params());
    }

    @Override
    public int hashCode() {
        int result = Objects.hash(super.hashCode(), this.name, this.params, this.rows);
        result = 31 * result + Objects.hashCode(this.rows);
        return result;
    }

    @Override
    public TsonArrayBuilder builder() {
        return new TsonArrayBuilderImpl().merge(this);
    }

    @Override
    public boolean visit(TsonDocumentVisitor visitor) {
        if (this.params != null) {
            for (TsonElement tsonElement : this.params) {
                if (visitor.visit(tsonElement)) continue;
                return false;
            }
        }
        for (TsonElement tsonElement : this.rows) {
            if (visitor.visit(tsonElement)) continue;
            return false;
        }
        return true;
    }

    @Override
    protected int compareCore(TsonElement o) {
        TsonMatrix na = o.toMatrix();
        int i = this.name().compareTo(na.name());
        if (i != 0) {
            return i;
        }
        i = TsonUtils.compareElementsArray(this.params(), na.params());
        if (i != 0) {
            return i;
        }
        return TsonUtils.compareElementsArray(this.rows(), na.rows());
    }

    @Override
    public void visit(TsonParserVisitor visitor) {
        visitor.visitElementStart();
        if (this.name != null) {
            visitor.visitNamedStart(this.name());
        }
        if (this.params != null) {
            visitor.visitParamsStart();
            for (TsonElement param : this.params()) {
                visitor.visitParamElementStart();
                param.visit(visitor);
                visitor.visitParamElementEnd();
            }
            visitor.visitParamsEnd();
        }
        visitor.visitNamedArrayStart();
        for (TsonArray element : this.rows()) {
            visitor.visitArrayElementStart();
            element.visit(visitor);
            visitor.visitArrayElementEnd();
        }
        visitor.visitArrayEnd();
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public boolean isParametrized() {
        return this.params != null;
    }

    @Override
    public TsonElementList params() {
        return this.params;
    }

    @Override
    public boolean isNamed() {
        return this.name != null;
    }

    @Override
    public int paramsCount() {
        return this.params == null ? 0 : this.params.size();
    }
}

